#macro Text(Font,String,Depth,Align,Color,Texture)
#declare Left=0;
#declare Center=1;
#declare Right =2;
#declare MyText = 
text {ttf             
Font,  
String,
Depth,0}
#declare Start = <20, .5, 0>; 
#declare Inter= 
trace ( MyText, Start,<-1,0,0>); 
#declare Arm = union {
cylinder { <0,.5,0>,Inter,.025} 
sphere {<0,.5,0>,.025}
sphere {Inter,.025}}
#declare Vert = union { 
cylinder {<0,0,0>,<0,.75,0>,.025}  
sphere {<0,0,0>,.025}
sphere {<0,.75,0>,.025}}
#declare Strut = union { 
cylinder {<0,0,0>,<0,0,Depth>,.025}
sphere {<0,0,0>,.025}
sphere {<0,0,Depth>,.025}}
#declare Frame = union {
object {Arm translate <0,-.5,0>}
object {Arm translate y*.25} 
object {Vert}
object {Vert translate Inter+y*-.5}}
#declare L = vlength(Inter-<0,0,0>);
#declare T_Outline =union {
cylinder {<-L*.02,-.3,0>,<L*.02,-.3,0>,.02}
cylinder {<-L*.02,-.3,0>,<-L*.02,.1,0>,.02}
cylinder {<L*.02,-.3,0>,<L*.02,.1,0>,.02}
cylinder {<-L*.02,.1,0>,<-L*.06,.1,0>,.02}
cylinder {<L*.02,.1,0>,<L*.06,.1,0>,.02}
cylinder {<-L*.06,.1,0>,<-L*.06,.3,0>,.02}
cylinder {<L*.06,.1,0>,<L*.06,.3,0>,.02}
cylinder {<-L*.06,.3,0>,<L*.06,.3,0>,.02}}
#declare T = union {
object {T_Outline}
object {T_Outline translate z*Depth}
cylinder {<-L*.02,-.3,0>,<-L*.02,-.3,Depth>,.02}
cylinder {<L*.02,-.3,0>,<L*.02,-.3,Depth>,.02}
cylinder {<-L*.02,.1,0>,<-L*.02,.1,Depth>,.02}
cylinder {<L*.02,.1,0>,<L*.02,.1,Depth>,.02}
cylinder {<-L*.06,.1,0>,<-L*.06,.1,Depth>,.02}
cylinder {<L*.06,.1,0>,<L*.06,.1,Depth>,.02}
cylinder {<-L*.06,.3,0>,<-L*.06,.3,Depth>,.02}
cylinder {<L*.06,.3,0>,<L*.06,.3,Depth>,.02}}

#declare E_Outline = union { 
cylinder{<-L*.06,-.3,0>,<-L*.06,.3,0>,.02}
cylinder{<-L*.06,-.3,0>,<L*.06,-.3,0>,.02}
cylinder{<-L*.06,.3,0>,<L*.06,.3,0>,.02}
cylinder{<L*.06,-.3,0>,<L*.06,-.15,0>,.02}
cylinder{<L*.06,.3,0>,<L*.06,.15,0>,.02}
cylinder{<-L*.01,-.15,0>,<L*.06,-.15,0>,.02}
cylinder{<-L*.01,.15,0>,<L*.06,.15,0>,.02}
cylinder{<-L*.01,-.05,0>,<L*.05,-.05,0>,.02}
cylinder{<-L*.01,.05,0>,<L*.05,.05,0>,.02}
cylinder{<L*.05,-.05,0>,<L*.05,.05,0>,.02}
cylinder{<-L*.01,.05,0>,<-L*.01,.15,0>,.02}
cylinder{<-L*.01,-.05,0>,<-L*.01,-.15,0>,.02}}
#declare E= union {
object {E_Outline}
object {E_Outline translate z*Depth}
cylinder{<-L*.06,-.3,0>,<-L*.06,-.3,Depth>,.02}
cylinder{<L*.06,-.3,0>,<L*.06,-.3,Depth>,.02}
cylinder{<-L*.06,.3,0>,<-L*.06,.3,Depth>,.02}
cylinder{<L*.06,.3,0>,<L*.06,.3,Depth>,.02}
cylinder{<L*.06,.15,0>,<L*.06,.15,Depth>,.02}
cylinder{<L*.06,-.15,0>,<L*.06,-.15,Depth>,.02}
cylinder{<-L*.01,.15,0>,<-L*.01,.15,Depth>,.02}
cylinder{<-L*.01,-.15,0>,<-L*.01,-.15,Depth>,.02}
cylinder{<-L*.01,.05,0>,<-L*.01,.05,Depth>,.02}
cylinder{<-L*.01,-.05,0>,<-L*.01,-.05,Depth>,.02}
cylinder{<L*.05,-.05,0>,<L*.05,-.05,Depth>,.02}
cylinder{<L*.05,.05,0>,<L*.05,.05,Depth>,.02}}

#declare X_Outline = union {
cylinder {<-L*.06,-.3,0>,<-L*.02,0,0>,.02}
cylinder {<-L*.06,.3,0>,<-L*.02,0,0>,.02}
cylinder {<L*.06,-.3,0>,<L*.02,0,0>,.02}
cylinder {<L*.06,.3,0>,<L*.02,0,0>,.02}
cylinder {<-L*.025,-.3,0>,<0,-.1,0>,.02}
cylinder {<L*.025,-.3,0>,<0,-.1,0>,.02}
cylinder {<-L*.025,.3,0>,<0,.1,0>,.02}
cylinder {<L*.025,.3,0>,<0,.1,0>,.02}
cylinder {<-L*.06,-.3,0>,<-L*.025,-.3,0>,.02}
cylinder {<L*.06,-.3,0>,<L*.025,-.3,0>,.02}
cylinder {<-L*.06,.3,0>,<-L*.025,.3,0>,.02}
cylinder {<L*.06,.3,0>,<L*.025,.3,0>,.02}}
#declare X = union {
object {X_Outline}
object {X_Outline translate z*Depth}
cylinder {<-L*.06,-.3,0>,<-L*.06,-.3,Depth>,.02}
cylinder {<-L*.025,-.3,0>,<-L*.025,-.3,Depth>,.02}
cylinder {<L*.06,-.3,0>,<L*.06,-.3,Depth>,.02}
cylinder {<L*.025,-.3,0>,<L*.025,-.3,Depth>,.02}
cylinder {<-L*.02,0,0>,<-L*.02,0,Depth>,.02}
cylinder {<L*.02,0,0>,<L*.02,0,Depth>,.02}
cylinder {<-L*.06,.3,0>,<-L*.06,.3,Depth>,.02}
cylinder {<-L*.025,.3,0>,<-L*.025,.3,Depth>,.02}
cylinder {<L*.06,.3,0>,<L*.06,.3,Depth>,.02}
cylinder {<L*.025,.3,0>,<L*.025,.3,Depth>,.02}}
#if(View<5)
union {
object {Frame}
object {Frame translate z*Depth}
object {Strut}
object {Strut translate y*.75}
object {Strut translate Inter+y*-.5}
object {Strut translate Inter+y*.25}
object {T translate <vlength(Inter-<0,0,0>)*.125,.375,0>}
object {E translate <vlength(Inter-<0,0,0>)*.375,.375,0>}
object {X translate <vlength(Inter-<0,0,0>)*.625,.375,0>}
object {T translate <vlength(Inter-<0,0,0>)*.875,.375,0>}
object {MyText
pigment {Clear}finish {ambient 0 diffuse 0}no_shadow}
pigment {Color}
finish {Luminous}
no_shadow
#switch(Align)
#case(0)
#break
#case(1)
translate x*-L/2
#break
#case(2)
translate x*-L
#end}  
#else
object {
MyText 
texture {Texture}
#switch(Align)
#case(0)
#break
#case(1)
translate x*-L/2
#break
#case(2)
translate x*-L
#end} 
#end
#end
