//#version unofficial MegaPOV 0.7;
 
#macro Light(Location,Color)
light_source {
Location
Color}
#if(Light_Proxy=on)
#if(View<5)
union {
sphere {
0,.1}
#declare Star = union {
cylinder{<0,-.5,0>,<0,.5,0>,.01}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*90}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*45}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*-45}}
object {Star}
object {Star rotate x*90}
object {Star rotate z*90}
pigment {Color}
finish {Luminous}
no_shadow
translate Location}
#end
#end
#end

#macro AreaLight(Location,Color,Vector1,Vector2,Dim1,Dim2,Adaptive)
light_source {
Location
Color
area_light
Vector1,Vector2,Dim1,Dim2
adaptive Adaptive
jitter}
#if(Light_Proxy=on)
#if(View<5)
union {
sphere {
0,.1}
#declare Star = union {
cylinder{<0,-.5,0>,<0,.5,0>,.01}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*90}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*45}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*-45}}
object {Star}
object {Star rotate x*90}
object {Star rotate z*90}
pigment {Color}
finish {Luminous}
no_shadow
translate Location}
#end
#end
#end

#macro SpotLight(Location,Color,PointAt,Radius,Falloff,Tightness)
light_source {
Location
Color
spotlight
point_at PointAt
radius Radius
falloff Falloff
tightness Tightness}
#if(Light_Proxy=on)
#if(View<5)
union {
sphere {
0,.1}
#declare Star = union {
cylinder{<0,-.5,0>,<0,.5,0>,.01}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*90}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*45}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*-45}}
object {Star}
object {Star rotate x*90}
object {Star rotate z*90}
pigment {Color}
finish {Luminous}
no_shadow
translate Location}
union {
cylinder {Location,PointAt,.025}
sphere{PointAt,.05}
//ReorienMatrix macro copyright 2001 Tor Olav Kristensen; used by permission. 
#macro ReorientMatrix(vAxis1, vAxis2)
  #local v1 = vnormalize(vAxis1);
  #local v2 = vnormalize(vAxis2);
  #local vU = vcross(v1, v2);
  #local Dot = vdot(v1, v2);
  #local v0 = vnormalize(vU);
  #local vW = (1 - Dot)*v0;
  #local vA = v0.x*vW;
  #local vB = v0.y*vW;
  #local vC = v0.z*vW;
  matrix <
    vA.x + Dot,  vA.y + vU.z, vA.z - vU.y,
    vB.x - vU.z, vB.y + Dot,  vB.z + vU.x,
    vC.x + vU.y, vC.y - vU.x, vC.z + Dot,
    0,                0,                0
#end 
#declare vRemoteAxisDirection = PointAt - Location;
#declare vRemoteAxisOrigin = (Location + PointAt)/2;
#declare ObjectToBeRotated1 =
cylinder{<0,-vlength(Location-PointAt)/2.,0>,<0,vlength(Location-PointAt),0>,.03 
translate y*vlength(Location-PointAt)/2 rotate z*Radius/2 }
#declare ObjectToBeRotated2 =
cylinder{<0,-vlength(Location-PointAt)/2.,0>,<0,vlength(Location-PointAt),0>,.03 
translate y*vlength(Location-PointAt)/2 rotate z*Falloff/2 
pigment {Color*.5 filter.5}finish {Luminous}no_shadow }
#declare ObjectToBeTilted =
union {
  #declare Angle = 0;
  #while (Angle < 360)
    object { ObjectToBeRotated1 rotate Angle*y }
    #declare Angle = Angle + 45;
  #end
  #declare Angle = 0;
  #while (Angle < 360)
    object { ObjectToBeRotated2 rotate Angle*y }
    #declare Angle = Angle + 22.5;
  #end
translate y*-vlength(Location-PointAt)/2}  
#declare ObjectToBeTranslated =
object {
  ObjectToBeTilted
  ReorientMatrix(y, vRemoteAxisDirection)>}
object {
  ObjectToBeTranslated
  translate vRemoteAxisOrigin}
pigment {Color}
finish {Luminous}
no_shadow}
#end
#end
#end

#macro AreaSpot(Location,Color,PointAt,Radius,Falloff,Tightness,
Vector1,Vector2,Dim1,Dim2,Adaptive)
light_source {
Location
Color
spotlight
point_at PointAt
radius Radius
falloff Falloff
tightness Tightness
area_light
Vector1,Vector2,Dim1,Dim2
adaptive Adaptive
jitter}
#if(Light_Proxy=on)
#if(View<5)
union {
sphere {
0,.1}
#declare Star = union {
cylinder{<0,-.5,0>,<0,.5,0>,.01}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*90}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*45}
cylinder{<0,-.5,0>,<0,.5,0>,.01
rotate z*-45}}
object {Star}
object {Star rotate x*90}
object {Star rotate z*90}
pigment {Color}
finish {Luminous}
no_shadow
translate Location}
union {
cylinder {Location,PointAt,.025}
sphere{PointAt,.05}
//ReorienMatrix macro copyright 2001 Tor Olav Kristensen; used by permission.
#macro ReorientMatrix(vAxis1, vAxis2)
  #local v1 = vnormalize(vAxis1);
  #local v2 = vnormalize(vAxis2);
  #local vU = vcross(v1, v2);
  #local Dot = vdot(v1, v2);
  #local v0 = vnormalize(vU);
  #local vW = (1 - Dot)*v0;
  #local vA = v0.x*vW;
  #local vB = v0.y*vW;
  #local vC = v0.z*vW;
  matrix <
    vA.x + Dot,  vA.y + vU.z, vA.z - vU.y,
    vB.x - vU.z, vB.y + Dot,  vB.z + vU.x,
    vC.x + vU.y, vC.y - vU.x, vC.z + Dot,
    0,                0,                0
#end 
#declare vRemoteAxisDirection = PointAt - Location;
#declare vRemoteAxisOrigin = (Location + PointAt)/2;
#declare ObjectToBeRotated1 =
cylinder{<0,-vlength(Location-PointAt)/2.,0>,<0,vlength(Location-PointAt),0>,.03 
translate y*vlength(Location-PointAt)/2 rotate z*Radius/2 }
#declare ObjectToBeRotated2 =
cylinder{<0,-vlength(Location-PointAt)/2.,0>,<0,vlength(Location-PointAt),0>,.03 
translate y*vlength(Location-PointAt)/2 rotate z*Falloff/2 
pigment {Color*.5 filter.5}finish {Luminous}no_shadow }
#declare ObjectToBeTilted =
union {
  #declare Angle = 0;
  #while (Angle < 360)
    object { ObjectToBeRotated1 rotate Angle*y }
    #declare Angle = Angle + 45;
  #end
  #declare Angle = 0;
  #while (Angle < 360)
    object { ObjectToBeRotated2 rotate Angle*y }
    #declare Angle = Angle + 22.5;
  #end
translate y*-vlength(Location-PointAt)/2}  
#declare ObjectToBeTranslated =
object {
  ObjectToBeTilted
  ReorientMatrix(y, vRemoteAxisDirection)>}
object {
  ObjectToBeTranslated
  translate vRemoteAxisOrigin}
pigment {Color}
finish {Luminous}
no_shadow}
#end
#end
#end