#version 3.5;

#macro HFFunction(Dim1,Dim2,Pattern,PatScale,PatRot,PatTrans,Turb,Color,Texture)
#declare MyHF = height_field { 
function Dim1,Dim2 {
pattern {
#switch(Pattern)
#case(1)
bozo
#break
#case(2)
bumps
#break
#case(3)
crackle
#break
#case(4)
dents
#break
#case(5)
leopard
#break
#case(6)
quilted
#break
#case(7)
ripples
#break
#case(8)
spotted
#break
#case(9)
waves
#break
#case(10)
#wrinkles
#end
scale PatScale
rotate PatRot
translate PatTrans
turbulence Turb}}
translate <-.5,0,-.5>
scale 2}
#declare Dim = 20;
#macro Horiz(ZPos)
sphere_sweep {
linear_spline
Dim,
#declare Count = 0;
#while(Count < Dim)
#declare Start = <2*Count/(Dim-1)- 1,10,ZPos>;
#declare Normal = y;
#declare HFPoint = trace(MyHF, Start,-y,Normal);
HFPoint+Normal*.01,.01
#declare Count = Count + 1;
#end
pigment {Color}}
#end
#macro Deep(XPos)
sphere_sweep {
linear_spline
Dim,
#declare Count = 0;
#while(Count < Dim)
#declare Start = <XPos,10,2*Count/(Dim-1)- 1>;
#declare Normal = y;
#declare HFPoint = trace(MyHF, Start,-y,Normal);
#if (Normal.x != 0 | Normal.y != 0 | Normal.z != 0) 
HFPoint+Normal*.01,.01
#end 
#declare Count = Count + 1;
#end
pigment {Color}
finish {Luminous}
no_shadow}
#end
#if(View<5)
union {
Horiz(-1)
Horiz(-.8)
Horiz(-.6)
Horiz(-.4)
Horiz(-.2)
Horiz(0)
Horiz(.2)
Horiz(.4)
Horiz(.6)
Horiz(.8)
Horiz(1)
Deep(-1)
Deep(-.8)
Deep(-.6)
Deep(-.4)
Deep(-.2)
Deep(-0)
Deep(.2)
Deep(.4)
Deep(.6)
Deep(.8)
Deep(1) 
scale .5}
#else
object {MyHF
scale .5
texture {Texture}}
#end
#end 



