//#version unofficial MegaPOV 0.7;
#include "primitives.inc"
#include "lights.inc"

global_settings {
max_trace_level 10
radiosity{}}


//Views: 1(Front) 2(Top) 3(Side) 4(Wireframe Camera) 5(Render)
#declare View = 5;

//Color_Schemes: 1(Gray/Black) 2(Black/Green) 3(Blue/White)
#declare Color_Scheme = 2;

//Other Declares
#declare Grid_Spacing = 1;
#declare Grid = on;
#declare Axes = on;
#declare Zoom_Factor = 30;
#declare Zoom_Amount = 1;
#declare Pan_X = 0;
#declare Pan_Y = 0;
#declare Pan_Z = 0;
#declare Camera = <5,8.5,-10>;
#declare Target = <0,3,0>;
#declare Light_Proxy = off;
#include "views.inc"

//Lights
Light(<10,20,-30>,White*.5)
AreaLight(<5,30,-50>,Tan,<0,10,0>,<0,0,10>,4,4,1)
SpotLight(<0,25,-50>,Wheat,<2,3,15>,5,10,30)
AreaSpot(<5,25,-50>,Wheat,<0,3.5,0>,5,10,30,<10,0,0>,<0,10,0>,3,3,2)

//Objects (See Primitives.inc for wireframe definitions)

//Sphere
object {Sphere(0,1,Silver,Polished_Chrome) translate y*3.5}


//Texture for Plane
#declare Plane_Tex = texture {
pigment {checker Black,White}
finish {specular.5}}
//Plane
object {Plane(Y,0,Gray50,Plane_Tex)}


//Texture for Text Object
#declare Concrete = texture {
pigment { granite scale .125
color_map {
[0 Gray60]
[1 Gray80]}}
normal {granite scale .125}}
//Text Object
object {Text("arial.ttf","POVGUI 1.5",.5,1,Gray80,Concrete)
scale 1.5 rotate y*-45 rotate x*22.5 translate <-7,5,2>} 

//Cylinder Object
object {Cylinder(<2,3,0>,<6,3,0>,.5,Blue,Vicks_Bottle_Glass)}

//Cone Object
object {Cone(<0,3,4>,.75,<0,3,8>,.25,Yellow,Gold_Metal) rotate x*-45}


//Torus Object
object {Torus(2,.5,Pink,PinkAlabaster) translate y*1.5}  



//Box Object
object {Box(3,2,3,White,White_Marble) rotate y*45 translate <3,3,6>}   



//Lathe Object
object {Lathe (1,15,
<0,-.25>,<.5,0>,<.5,.75>,<1.25,1.5>,<1,2>,
<.5,2.5>,<.75,2.75>,<1,3>,<.5,3.5>,<1.5,4>,
<1,4.5>,<.5,4.5>,<.5,5>,<1,5.5>,<0,6>
MediumWood,DMFWood6) rotate z*90 translate <-5,3,0>} 

 
//Prism Object
object {Prism(2,-.5,.5,7,
<0,0>,<.5,1.5>,<1,2>,<1.5,2.5>,
<-1,2>,<-1,.5>,<0,0>,0,
0,0,0,0,
Brown,Brown_Agate) translate <5,.5,-2>}

//Blob
#declare Threshold = .3;
#if(View<5)
union {
#else
blob {
threshold Threshold
#end
BlobS(0,1,1,Water,1)
BlobS(<.5,.5,0>,.75,-1,Water,1)
BlobS(<-1,-1,0>,1,1,Water,<1,1.25,1>)
BlobS(<1,-1.5,0>,1.5,1,Water,1)
BlobS(<2,-3,3>,1.5,1,Water,1)
BlobC(<1,-1.5,0>,<2,-3,3>,.5,1,Water,1)
rotate x*-90 rotate y*45 rotate z*-22.5 translate <0,6,12>}



//Superquadratic Ellipsoid Box
object {SuperQBox(.5,White,Aluminum) scale 1.5 translate <-9,6,12>}  

//Superquadratic Ellipsoid Cylinder
object {SuperQCyl(.5,Green,Jade) translate <-4,2,-4>}



//Texture for Height Field
#declare Earth = texture {
pigment {crackle offset 0.5 scale .0675
color_map {
[0 Wheat]
[.5 Tan]
[1 Sienna]}
translate <-.5,0,-.5>
turbulence .8}
normal {crackle .2 offset 0.5 scale .0675
translate <-.5,0,-.5>
turbulence .85} scale .25}

//Height Field from Image
object {HFImage("field.tga",<6,2,6>,Tan,Earth)} 


//Height Field from Pattern
object {HFFunction(200,200,3,.25,0,0,0,Red,Red_Marble)scale <5,2,5> translate <-8,0,8>} 