#macro Cylinder(Vector1,Vector2,Rad,Color,Texture)
//ReorienMatrix macro copyright 2001 Tor Olav Kristensen; used by permission.
#macro ReorientMatrix(vAxis1, vAxis2)
  #local v1 = vnormalize(vAxis1);
  #local v2 = vnormalize(vAxis2);
  #local vU = vcross(v1, v2);
  #local Dot = vdot(v1, v2);
  #local v0 = vnormalize(vU);
  #local vW = (1 - Dot)*v0;
  #local vA = v0.x*vW;
  #local vB = v0.y*vW;
  #local vC = v0.z*vW;
  matrix <
    vA.x + Dot,  vA.y + vU.z, vA.z - vU.y,
    vB.x - vU.z, vB.y + Dot,  vB.z + vU.x,
    vC.x + vU.y, vC.y - vU.x, vC.z + Dot,
    0,                0,                0
#end 
#declare vRemoteAxisDirection = Vector2 - Vector1;
#declare vRemoteAxisOrigin = (Vector1 + Vector2)/2;
#declare ObjectToBeRotated =
cylinder{<0,-vlength(Vector1-Vector2)/2.,0>,<0,vlength(Vector1-Vector2)/2,0>,.025 translate Rad*x}
#declare ObjectToBeTilted =
union {
#declare Angle = 0;
#while (Angle < 360)
object { ObjectToBeRotated rotate Angle*y }
#declare Angle = Angle + 45;
#end 
torus {Rad,.025}
torus{Rad,.025 translate y*-vlength(Vector1-Vector2)/2}
torus{Rad,.025 translate y*vlength(Vector1-Vector2)/2}
cylinder {Vector1,Vector2,Rad
pigment {Clear}finish {ambient 0 diffuse 0}}}
#declare ObjectToBeTranslated =
object {
ObjectToBeTilted
ReorientMatrix(y, vRemoteAxisDirection)>}
#if(View<5)
object {
ObjectToBeTranslated
translate vRemoteAxisOrigin
pigment {Color}
finish {Luminous}
no_shadow}
#else
cylinder {Vector1,Vector2,Rad texture {Texture}}
#end
#end
