#macro Cone(Vector1,Rad1,Vector2,Rad2,Color,Texture)
//ReorientMatrix macro copyright 2001 Tor Olav Kristensen; used by permission.
#macro ReorientMatrix(vAxis1, vAxis2)
  #local v1 = vnormalize(vAxis1);
  #local v2 = vnormalize(vAxis2);
  #local vU = vcross(v1, v2);
  #local Dot = vdot(v1, v2);
  #local v0 = vnormalize(vU);
  #local vW = (1 - Dot)*v0;
  #local vA = v0.x*vW;
  #local vB = v0.y*vW;
  #local vC = v0.z*vW;
  matrix <
    vA.x + Dot,  vA.y + vU.z, vA.z - vU.y,
    vB.x - vU.z, vB.y + Dot,  vB.z + vU.x,
    vC.x + vU.y, vC.y - vU.x, vC.z + Dot,
    0,                0,                0
#end 
#declare vRemoteAxisDirection = Vector2 - Vector1;
#declare vRemoteAxisOrigin = (Vector1 + Vector2)/2;
#declare ObjectToBeRotated =
cylinder{<Rad1,-vlength(Vector1-Vector2)/2.,0>,<Rad2,vlength(Vector1-Vector2)/2,0>,.025}
#declare ObjectToBeTilted =
union {
#declare Angle = 0;
#while (Angle < 360)
object { ObjectToBeRotated rotate Angle*y }
#declare Angle = Angle + 45;
#end
torus{(Rad1+Rad2)/2,.025}
torus{Rad1,.025 translate y*-vlength(Vector1-Vector2)/2}
torus{Rad2,.025 translate y*vlength(Vector1-Vector2)/2}
cone {Vector1,Rad1,Vector2,Rad2
pigment {Clear}finish {ambient 0 diffuse 0}}}  
#declare ObjectToBeTranslated =
object {
ObjectToBeTilted
ReorientMatrix(y, vRemoteAxisDirection)>}
#if(View<5)
object {
ObjectToBeTranslated
translate vRemoteAxisOrigin
pigment {Color}
finish {Luminous}
no_shadow}
#else
cone {Vector1,Rad1,Vector2,Rad2 texture {Texture}}
#end
#end

