#macro BlobC(Position1,Position2,Radius,Strength,Texture,Scale)
#declare T=1-Threshold;
//ReorientMatrix macro copyright 2001 Tor Olav Kristensen; used by permission.
#macro ReorientMatrix(vAxis1, vAxis2)
  #local v1 = vnormalize(vAxis1);
  #local v2 = vnormalize(vAxis2);
  #local vU = vcross(v1, v2);
  #local Dot = vdot(v1, v2);
  #local v0 = vnormalize(vU);
  #local vW = (1 - Dot)*v0;
  #local vA = v0.x*vW;
  #local vB = v0.y*vW;
  #local vC = v0.z*vW;
  matrix <
    vA.x + Dot,  vA.y + vU.z, vA.z - vU.y,
    vB.x - vU.z, vB.y + Dot,  vB.z + vU.x,
    vC.x + vU.y, vC.y - vU.x, vC.z + Dot,
    0,                0,                0
#end 
#declare vRemoteAxisDirection = Position2 - Position1;
#declare vRemoteAxisOrigin = (Position1 + Position2)/2;
#declare ObjectToBeRotated1 =
cylinder{<0,-vlength(Position1-Position2)/2.,0>,<0,vlength(Position1-Position2)/2,0>,.025
translate (Radius*(1-Threshold)*Strength)*x}
#declare ObjectToBeRotated2 =
cylinder{<0,-vlength(Position1-Position2)/2.,0>,<0,vlength(Position1-Position2)/2,0>,.025
translate Radius*Strength*x}
#declare ObjectToBeTilted =
union {
union {
#declare Angle = 0;
#while (Angle < 360)
object { ObjectToBeRotated1 rotate Angle*y }
#declare Angle = Angle + 45;
#end 
torus {(Radius*(1-Threshold)*Strength),.025}
torus{(Radius*(1-Threshold)*Strength),.025 translate y*-vlength(Position1-Position2)/2}
torus{(Radius*(1-Threshold)*Strength),.025 translate y*vlength(Position1-Position2)/2}}
union {
#declare Angle = 0;
#while (Angle < 360)
object { ObjectToBeRotated2 rotate Angle*y }
#declare Angle = Angle + 45;
#end 
torus {Radius*Strength,.025}
torus{Radius*Strength,.025 translate y*-vlength(Position1-Position2)/2}
torus{Radius*Strength,.025 translate y*vlength(Position1-Position2)/2}
pigment {Yellow} finish {Luminous} no_shadow}
cylinder {Position1,Position2,Radius
pigment {Clear}finish {ambient 0 diffuse 0}}}
#declare ObjectToBeTranslated =
object {
ObjectToBeTilted
ReorientMatrix(y, vRemoteAxisDirection)>}
#if(View<5)
object {
ObjectToBeTranslated
translate vRemoteAxisOrigin
pigment {Red}
finish {Luminous}
no_shadow}
#else
cylinder {Position1,Position2,Radius,Strength texture {Texture} scale Scale}
#end
#end


