VERSION 5.00
Begin VB.Form Form1 
   Caption         =   "POV-Ray Matrix Calculator"
   ClientHeight    =   3735
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   3750
   Icon            =   "POVMatrixCalc.frx":0000
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   3735
   ScaleWidth      =   3750
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton Paste 
      Caption         =   "Paste"
      Height          =   255
      Left            =   120
      TabIndex        =   30
      Top             =   3360
      Width           =   1095
   End
   Begin VB.CommandButton Copy 
      Caption         =   "Copy"
      Height          =   255
      Left            =   120
      TabIndex        =   29
      Top             =   3000
      Width           =   1095
   End
   Begin VB.CommandButton Undo 
      Caption         =   "Undo"
      Height          =   255
      Left            =   1320
      TabIndex        =   24
      ToolTipText     =   "Undoes the last operation"
      Top             =   3360
      Width           =   1095
   End
   Begin VB.CommandButton Redo 
      Caption         =   "Redo"
      Height          =   255
      Left            =   1320
      TabIndex        =   23
      ToolTipText     =   "Redoes the last undone operation"
      Top             =   3000
      Width           =   1095
   End
   Begin VB.CommandButton aScale 
      Caption         =   "AScale"
      Height          =   255
      Left            =   120
      TabIndex        =   22
      ToolTipText     =   "Apply a scale along an arbitrary axis"
      Top             =   2640
      Width           =   1095
   End
   Begin VB.CommandButton aRotate 
      Caption         =   "ARotate"
      Height          =   255
      Left            =   1320
      TabIndex        =   21
      ToolTipText     =   "Apply a rotation about an arbitrary axis"
      Top             =   2640
      Width           =   1095
   End
   Begin VB.CommandButton Fix 
      Caption         =   "Fix"
      Height          =   255
      Left            =   2520
      TabIndex        =   20
      ToolTipText     =   "Snaps to integer any matrix value within one billionth of an integer"
      Top             =   3000
      Width           =   1095
   End
   Begin VB.CommandButton Reset 
      Caption         =   "Clear"
      Height          =   255
      Left            =   2520
      TabIndex        =   19
      ToolTipText     =   "Reset matrix to identity"
      Top             =   3360
      Width           =   1095
   End
   Begin VB.CommandButton Matrix 
      Caption         =   "Matrix"
      Height          =   255
      Left            =   2520
      TabIndex        =   18
      ToolTipText     =   "Apply a linear matrix"
      Top             =   2640
      Width           =   1095
   End
   Begin VB.CommandButton ShearYZ 
      Caption         =   "Shear YZ"
      Height          =   255
      Left            =   1320
      TabIndex        =   17
      ToolTipText     =   "Shear Y and Z along X"
      Top             =   2280
      Width           =   1095
   End
   Begin VB.CommandButton ShearXZ 
      Caption         =   "Shear XZ"
      Height          =   255
      Left            =   2520
      TabIndex        =   16
      ToolTipText     =   "Shear X and Z along Y"
      Top             =   2280
      Width           =   1095
   End
   Begin VB.CommandButton ShearXY 
      Caption         =   "Shear XY"
      Height          =   255
      Left            =   120
      TabIndex        =   15
      ToolTipText     =   "Shear X and Y along Z"
      Top             =   2280
      Width           =   1095
   End
   Begin VB.CommandButton Rotate 
      Caption         =   "Rotate"
      Height          =   255
      Left            =   2520
      TabIndex        =   14
      ToolTipText     =   "Apply consecutive rotations about X, Y and Z"
      Top             =   1920
      Width           =   1095
   End
   Begin VB.CommandButton Scale 
      Caption         =   "Scale"
      Height          =   255
      Left            =   1320
      TabIndex        =   13
      ToolTipText     =   "Apply a scale"
      Top             =   1920
      Width           =   1095
   End
   Begin VB.CommandButton Translate 
      Caption         =   "Translate"
      Height          =   255
      Left            =   120
      TabIndex        =   12
      ToolTipText     =   "Apply a translation"
      Top             =   1920
      Width           =   1095
   End
   Begin VB.TextBox Text12 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   2520
      TabIndex        =   11
      Text            =   "0"
      Top             =   1200
      Width           =   1095
   End
   Begin VB.TextBox Text11 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   1320
      TabIndex        =   10
      Text            =   "0"
      Top             =   1200
      Width           =   1095
   End
   Begin VB.TextBox Text10 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   120
      TabIndex        =   9
      Text            =   "0"
      Top             =   1200
      Width           =   1095
   End
   Begin VB.TextBox Text9 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   2520
      TabIndex        =   8
      Text            =   "1"
      Top             =   840
      Width           =   1095
   End
   Begin VB.TextBox Text8 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   1320
      TabIndex        =   7
      Text            =   "0"
      Top             =   840
      Width           =   1095
   End
   Begin VB.TextBox Text7 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   120
      TabIndex        =   6
      Text            =   "0"
      Top             =   840
      Width           =   1095
   End
   Begin VB.TextBox Text6 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   2520
      TabIndex        =   5
      Text            =   "0"
      Top             =   480
      Width           =   1095
   End
   Begin VB.TextBox Text5 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   1320
      TabIndex        =   4
      Text            =   "1"
      Top             =   480
      Width           =   1095
   End
   Begin VB.TextBox Text4 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   120
      TabIndex        =   3
      Text            =   "0"
      Top             =   480
      Width           =   1095
   End
   Begin VB.TextBox Text3 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   2520
      TabIndex        =   2
      Text            =   "0"
      Top             =   120
      Width           =   1095
   End
   Begin VB.TextBox Text2 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   1320
      TabIndex        =   1
      Text            =   "0"
      Top             =   120
      Width           =   1095
   End
   Begin VB.TextBox Text1 
      Alignment       =   1  'Right Justify
      BeginProperty DataFormat 
         Type            =   1
         Format          =   "0.000000"
         HaveTrueFalseNull=   0
         FirstDayOfWeek  =   0
         FirstWeekOfYear =   0
         LCID            =   1033
         SubFormatType   =   1
      EndProperty
      BeginProperty Font 
         Name            =   "Courier New"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   120
      TabIndex        =   0
      Text            =   "1"
      Top             =   120
      Width           =   1095
   End
   Begin VB.Label Label4 
      Alignment       =   1  'Right Justify
      Caption         =   "0"
      Height          =   255
      Left            =   3120
      TabIndex        =   28
      ToolTipText     =   "Number of operations in the redo buffer"
      Top             =   1560
      Width           =   495
   End
   Begin VB.Label Label3 
      Alignment       =   1  'Right Justify
      Caption         =   "0"
      Height          =   255
      Left            =   1200
      TabIndex        =   27
      ToolTipText     =   "Number of operations in the undo buffer"
      Top             =   1560
      Width           =   495
   End
   Begin VB.Label Label2 
      Caption         =   "Redo Levels:"
      Height          =   255
      Left            =   2040
      TabIndex        =   26
      ToolTipText     =   "Number of operations in the redo buffer"
      Top             =   1560
      Width           =   1095
   End
   Begin VB.Label Label1 
      Caption         =   "Undo Levels:"
      Height          =   255
      Left            =   120
      TabIndex        =   25
      ToolTipText     =   "Number of operations in the undo buffer"
      Top             =   1560
      Width           =   1095
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'+---------------------------------------+
'|       POV-Ray Matrix Calculator       |
'|              Version 1.1              |
'|                                       |
'|  Copyright(C) 2000 by David Fontaine  |
'+---------------------------------------+
'
'
' This utility can be found at my website:
'    http://davidf.faricy.net/
' Contact info: email davidf@faricy.net
' Registration is $12US.
' Just kidding.
'
'
'  You may not modify and redistribute
' this application or its source without
' my express permission. You may freely
' distribute the unmodified application
' and source code.
'
'
Dim Result(3, 3) As Double
Dim Transform(3, 3) As Double
Dim tempm(3, 3) As Double
Dim Backup(53, 3, 3) As Double
Public UndoOff As Integer
Public UndoPtr As Integer
Public RedoMax As Integer
Public tvar As Double
Public pass00 As Double
Public pass01 As Double
Public pass02 As Double
Public pass03 As Double
Public pass10 As Double
Public pass11 As Double
Public pass12 As Double
Public pass13 As Double
Public pass20 As Double
Public pass21 As Double
Public pass22 As Double
Public pass23 As Double
Public pass30 As Double
Public pass31 As Double
Public pass32 As Double
Public pass33 As Double
Public Function min(a, b)
If a > b Then min = b Else min = a
End Function
Public Function StoD(BString As String) As Double
Dim SLen As Integer
Dim Val As Double
Dim dist As Integer
Dim pow As Double
Dim i As Integer
Dim Exp As Integer
Dim ExpP As Integer
Dim ExpM As Double
SLen = Len(BString)
If SLen > 0 Then
   dist = SLen
   ExpP = SLen + 1
   pow = 1
   Val = 0
   ExpM = 1
   For i = 1 To SLen
      If Mid(BString, i, 1) = "." Then dist = i
      If Mid(BString, i, 1) = "e" Or Mid(BString, i, 1) = "E" Then ExpP = i
   Next i
   For i = dist To 1 Step -1
      If Asc(Mid(BString, i, 1)) > 47 And Asc(Mid(BString, i, 1)) < 58 Then
         Val = Val + (Asc(Mid(BString, i, 1)) - 48) * pow
         pow = pow * 10
      End If
   Next i
  pow = 0.1
   For i = dist + 1 To min(SLen, ExpP)
      If Asc(Mid(BString, i, 1)) > 47 And Asc(Mid(BString, i, 1)) < 58 Then
         Val = Val + (Asc(Mid(BString, i, 1)) - 48) * pow
         pow = pow * 0.1
      End If
   Next i
   For i = 1 To min(SLen, ExpP)
      If Mid(BString, i, 1) = "-" Then Val = Val * -1
      If Asc(Mid(BString, i, 1)) > 47 And Asc(Mid(BString, i, 1)) < 58 Then i = SLen
   Next i
   If ExpP < SLen Then
      pow = 1
      For i = SLen To ExpP Step -1
         If Asc(Mid(BString, i, 1)) > 47 And Asc(Mid(BString, i, 1)) < 58 Then
            Exp = Exp + (Asc(Mid(BString, i, 1)) - 48) * pow
            pow = pow * 10
         End If
      Next i
      For i = 1 To Exp
         ExpM = ExpM * 10
      Next i
      For i = ExpP To SLen
         If Mid(BString, i, 1) = "-" Then ExpM = 1 / ExpM
         If Asc(Mid(BString, i, 1)) > 47 And Asc(Mid(BString, i, 1)) < 58 Then i = SLen
      Next i
   End If
   Val = Val * ExpM
   StoD = Val
End If
End Function
Sub RefreshText()
Dim temp0 As Integer
Dim temp1 As Integer
Dim temp2 As Integer
temp0 = RedoMax
temp1 = UndoOff
temp2 = UndoPtr
Text1 = Str(Result(0, 0))
Text2 = Str(Result(0, 1))
Text3 = Str(Result(0, 2))
Text4 = Str(Result(1, 0))
Text5 = Str(Result(1, 1))
Text6 = Str(Result(1, 2))
Text7 = Str(Result(2, 0))
Text8 = Str(Result(2, 1))
Text9 = Str(Result(2, 2))
Text10 = Str(Result(3, 0))
Text11 = Str(Result(3, 1))
Text12 = Str(Result(3, 2))
RedoMax = temp0
UndoOff = temp1
UndoPtr = temp2
End Sub
Sub clearpass()
pass00 = 0
pass01 = 0
pass02 = 0
pass03 = 0
pass10 = 0
pass11 = 0
pass12 = 0
pass13 = 0
pass20 = 0
pass21 = 0
pass22 = 0
pass23 = 0
pass30 = 0
pass31 = 0
pass32 = 0
pass33 = 0
End Sub
Sub MatrixMultiply()
For i = 0 To 3
   For j = 0 To 3
      tempm(i, j) = 0
      For k = 0 To 3
         tempm(i, j) = tempm(i, j) + Result(i, k) * Transform(k, j)
      Next k
   Next j
Next i
For i = 0 To 3
   For j = 0 To 3
      Result(i, j) = tempm(i, j)
   Next j
Next i
End Sub
Sub ApplyScale()
For i = 0 To 3
   For j = 0 To 3
      If i = j Then Transform(i, j) = 1
      If i <> j Then Transform(i, j) = 0
   Next j
Next i
Transform(0, 0) = pass00
Transform(1, 1) = pass01
Transform(2, 2) = pass02
Call MatrixMultiply
End Sub
Sub ApplyTranslate()
For i = 0 To 3
   For j = 0 To 3
      If i = j Then Transform(i, j) = 1
      If i <> j Then Transform(i, j) = 0
   Next j
Next i
Transform(3, 0) = pass00
Transform(3, 1) = pass01
Transform(3, 2) = pass02
Call MatrixMultiply
End Sub
Sub ApplyShearXY()
For i = 0 To 3
   For j = 0 To 3
      If i = j Then Transform(i, j) = 1
      If i <> j Then Transform(i, j) = 0
   Next j
Next i
Transform(2, 0) = pass00
Transform(2, 1) = pass01
Call MatrixMultiply
End Sub
Sub ApplyShearXZ()
For i = 0 To 3
   For j = 0 To 3
      If i = j Then Transform(i, j) = 1
      If i <> j Then Transform(i, j) = 0
   Next j
Next i
Transform(1, 0) = pass00
Transform(1, 2) = pass01
Call MatrixMultiply
End Sub
Sub ApplyShearYZ()
For i = 0 To 3
   For j = 0 To 3
      If i = j Then Transform(i, j) = 1
      If i <> j Then Transform(i, j) = 0
   Next j
Next i
Transform(0, 1) = pass00
Transform(0, 2) = pass01
Call MatrixMultiply
End Sub
Sub ApplyRotate()
For i = 0 To 3
   For j = 0 To 3
      If i = j Then Transform(i, j) = 1
      If i <> j Then Transform(i, j) = 0
   Next j
Next i
Transform(1, 1) = Cos(pass00)
Transform(1, 2) = Sin(pass00)
Transform(2, 1) = -Sin(pass00)
Transform(2, 2) = Cos(pass00)
Call MatrixMultiply
For i = 0 To 3
   For j = 0 To 3
      If i = j Then Transform(i, j) = 1
      If i <> j Then Transform(i, j) = 0
   Next j
Next i
Transform(0, 0) = Cos(pass01)
Transform(0, 2) = -Sin(pass01)
Transform(2, 0) = Sin(pass01)
Transform(2, 2) = Cos(pass01)
Call MatrixMultiply
For i = 0 To 3
   For j = 0 To 3
      If i = j Then Transform(i, j) = 1
      If i <> j Then Transform(i, j) = 0
   Next j
Next i
Transform(0, 0) = Cos(pass02)
Transform(0, 1) = Sin(pass02)
Transform(1, 0) = -Sin(pass02)
Transform(1, 1) = Cos(pass02)
Call MatrixMultiply
End Sub
Sub ApplyMatrix()
Transform(0, 0) = pass00
Transform(0, 1) = pass01
Transform(0, 2) = pass02
Transform(0, 3) = pass03
Transform(1, 0) = pass10
Transform(1, 1) = pass11
Transform(1, 2) = pass12
Transform(1, 3) = pass13
Transform(2, 0) = pass20
Transform(2, 1) = pass21
Transform(2, 2) = pass22
Transform(2, 3) = pass23
Transform(3, 0) = pass30
Transform(3, 1) = pass31
Transform(3, 2) = pass32
Transform(3, 3) = pass33
Call MatrixMultiply
End Sub
Sub Copy_Click()
Dim povcode As String
Dim codelen As Integer
povcode = "matrix <"
For i = 0 To 3
   For j = 0 To 2
      povcode = povcode + Str(Int(Result(i, j))) + "."
      For k = 1 To 12
         temp = Int(Result(i, j) * 10 ^ k)
         povcode = povcode + Right(Str(temp), 1)
      Next k
      For k = 0 To 12
         codelen = Len(povcode)
         If Asc(Right(povcode, 1)) > 48 And Asc(Right(povcode, 1)) < 58 Then
            k = 13
         Else
            povcode = Left(povcode, codelen - 1)
         End If
      Next k
      povcode = povcode + ","
   Next j
Next i
codelen = Len(povcode)
povcode = Left(povcode, codelen - 1) + ">"
Clipboard.SetText povcode
End Sub
Sub paste_click()
Dim povcode As String
Dim codelen As Integer
Dim tempread(3, 3) As Double
Dim valid As Integer
Dim numlen As Integer
valid = 1
povcode = Clipboard.GetText
codelen = Len(povcode)
If Left(povcode, 6) = "matrix" Then
   valid = 0
   For i = 7 To codelen
      If Mid(povcode, i, 1) = "<" Then
         povcode = Right(povcode, codelen - i)
         i = codelen + 1
         valid = 1
      End If
   Next i
   If valid = 1 Then
      For i = 0 To 3
         For j = 0 To 2
            valid = 0
            codelen = Len(povcode)
            For k = 1 To codelen
               If (i * 3 + j) < 11 Then
                  If Mid(povcode, k, 1) = "," Then
                     valid = 1
                     numlen = k - 1
                     k = codelen + 1
                  End If
               Else
                  If Mid(povcode, k, 1) = ">" Then
                     valid = 1
                     numlen = k - 1
                     k = codelen + 1
                  End If
               End If
            Next k
            If valid = 1 Then
               tempread(i, j) = StoD(Left(povcode, numlen))
               povcode = Right(povcode, codelen - numlen - 1)
            Else
               j = 4
               i = 4
            End If
         Next j
      Next i
   End If
Else
   valid = 0
End If
If valid = 1 Then
   Call UndoAdd
   For i = 0 To 3
      For j = 0 To 2
         Result(i, j) = tempread(i, j)
      Next j
   Next i
   Result(0, 3) = 0
   Result(1, 3) = 0
   Result(2, 3) = 0
   Result(3, 3) = 1
   Call RefreshText
End If
End Sub
Sub Fix_Click()
Call UndoAdd
For i = 0 To 3
   For j = 0 To 3
      tvar = 0.5 - Abs(Result(i, j) - Int(Result(i, j)) - 0.5)
      If tvar < 0.000000001 Then Result(i, j) = Round(Result(i, j))
   Next j
Next i
Call RefreshText
End Sub
Sub Form_Load()
RedoMax = 0
UndoOff = 0
UndoPtr = 0
For i = 0 To 3
   For j = 0 To 3
      If i = j Then Result(i, j) = 1
      If i <> j Then Result(i, j) = 0
   Next j
Next i
Call RefreshText
End Sub

Sub Refresh_Click()
Call RefreshText
End Sub
Sub Reset_Click()
Call UndoAdd
For i = 0 To 3
   For j = 0 To 3
      If i = j Then Result(i, j) = 1
      If i <> j Then Result(i, j) = 0
   Next j
Next i
Call RefreshText
End Sub
Sub Text1_Change()
Text1 = Str(Result(0, 0))
End Sub
Sub Text2_Change()
Text2 = Str(Result(0, 1))
End Sub
Sub Text3_Change()
Text3 = Str(Result(0, 2))
End Sub
Sub Text4_Change()
Text4 = Str(Result(1, 0))
End Sub
Sub Text5_Change()
Text5 = Str(Result(1, 1))
End Sub
Sub Text6_Change()
Text6 = Str(Result(1, 2))
End Sub
Sub Text7_Change()
Text7 = Str(Result(2, 0))
End Sub
Sub Text8_Change()
Text8 = Str(Result(2, 1))
End Sub
Sub Text9_Change()
Text9 = Str(Result(2, 2))
End Sub
Sub Text10_Change()
Text10 = Str(Result(3, 0))
End Sub
Sub Text11_Change()
Text11 = Str(Result(3, 1))
End Sub
Sub Text12_Change()
Text12 = Str(Result(3, 2))
End Sub
Sub Translate_Click()
Call clearpass
pass33 = 1
TranslateDialog.Text1 = 0
TranslateDialog.Text2 = 0
TranslateDialog.Text3 = 0
TranslateDialog.Show vbModal
If pass33 = 1 Then
   Call UndoAdd
   Call ApplyTranslate
End If
Call RefreshText
End Sub
Sub ShearXY_Click()
Call clearpass
pass33 = 1
ShearXYDialog.Text1 = 0
ShearXYDialog.Text2 = 0
ShearXYDialog.Show vbModal
If pass33 = 1 Then
   Call UndoAdd
   Call ApplyShearXY
End If
Call RefreshText
End Sub
Sub ShearXZ_Click()
Call clearpass
pass33 = 1
ShearXZDialog.Text1 = 0
ShearXZDialog.Text2 = 0
ShearXZDialog.Show vbModal
If pass33 = 1 Then
   Call UndoAdd
   Call ApplyShearXZ
End If
Call RefreshText
End Sub
Sub ShearYZ_Click()
Call clearpass
pass33 = 1
ShearYZDialog.Text1 = 0
ShearYZDialog.Text2 = 0
ShearYZDialog.Show vbModal
If pass33 = 1 Then
   Call UndoAdd
   Call ApplyShearYZ
End If
Call RefreshText
End Sub
Sub Scale_Click()
Call clearpass
pass00 = 1
pass01 = 1
pass02 = 1
pass33 = 1
ScaleDialog.Text1 = 1
ScaleDialog.Text2 = 1
ScaleDialog.Text3 = 1
ScaleDialog.Show vbModal
If pass33 = 1 Then
   Call UndoAdd
   Call ApplyScale
End If
Call RefreshText
End Sub
Sub Rotate_Click()
Call clearpass
pass33 = 1
RotateDialog.Text1 = 0
RotateDialog.Text2 = 0
RotateDialog.Text3 = 0
RotateDialog.Show vbModal
If pass33 = 1 Then
   Call UndoAdd
   Call ApplyRotate
End If
Call RefreshText
End Sub
Sub Matrix_Click()
Call clearpass
pass00 = 1
pass11 = 1
pass22 = 1
pass33 = 1
MatrixDialog.Text1 = 1
MatrixDialog.Text2 = 0
MatrixDialog.Text3 = 0
MatrixDialog.Text4 = 0
MatrixDialog.Text5 = 1
MatrixDialog.Text6 = 0
MatrixDialog.Text7 = 0
MatrixDialog.Text8 = 0
MatrixDialog.Text9 = 1
MatrixDialog.Text10 = 0
MatrixDialog.Text11 = 0
MatrixDialog.Text12 = 0
MatrixDialog.Show vbModal
If pass33 = 1 Then
   Call UndoAdd
   Call ApplyMatrix
End If
Call RefreshText
End Sub
Sub aScale_Click()
Dim temp As Double
Dim store0 As Double
Dim store1 As Double
Dim store2 As Double
Dim store3 As Double
Call clearpass
pass00 = 1
pass03 = 1
pass33 = 1
aScaleDialog.Text1 = 1
aScaleDialog.Text2 = 0
aScaleDialog.Text3 = 0
aScaleDialog.Text4 = 1
aScaleDialog.Show vbModal
If pass33 = 1 Then
   Call UndoAdd
   temp = Sqr(pass00 * pass00 + pass01 * pass01 + pass02 * pass02)
   store0 = pass00 / temp
   store1 = pass01 / temp
   store2 = pass02 / temp
   store3 = pass03 - 1
   pass00 = store3 * store0 * store0 + 1
   pass01 = store3 * store0 * store1
   pass02 = store3 * store0 * store2
   pass03 = 0
   pass10 = store3 * store1 * store0
   pass11 = store3 * store1 * store1 + 1
   pass12 = store3 * store1 * store2
   pass13 = 0
   pass20 = store3 * store2 * store0
   pass21 = store3 * store2 * store1
   pass22 = store3 * store2 * store2 + 1
   pass23 = 0
   pass30 = 0
   pass31 = 0
   pass32 = 0
   pass33 = 1
   Call ApplyMatrix
End If
Call RefreshText
End Sub
Sub aRotate_Click()
Dim store00 As Double
Dim store01 As Double
Dim store02 As Double
Dim store10 As Double
Dim store11 As Double
Dim store12 As Double
Dim store20 As Double
Dim store21 As Double
Dim store22 As Double
Dim storer As Double
Dim temp As Double
Call clearpass
pass00 = 1
pass33 = 1
aRotateDialog.Text1 = 1
aRotateDialog.Text2 = 0
aRotateDialog.Text3 = 0
aRotateDialog.Text4 = 0
aRotateDialog.Show vbModal
If pass33 = 1 Then
   Call UndoAdd
   store00 = pass00
   store01 = pass01
   store02 = pass02
   storer = pass03
   temp = Sqr(store00 * store00 + store01 * store01 + store02 * store02)
   store00 = store00 / temp
   store01 = store01 / temp
   store02 = store02 / temp
   store10 = -store00 * store01 - store02 * store02
   store11 = store00 * store00 + store01 * store02
   store12 = store00 * store02 - store01 * store01
   temp = Sqr(store10 * store10 + store11 * store11 + store12 * store12)
   store10 = store10 / temp
   store11 = store11 / temp
   store12 = store12 / temp
   store20 = store01 * store12 - store02 * store11
   store21 = store02 * store10 - store00 * store12
   store22 = store00 * store11 - store01 * store10
   temp = Sqr(store20 * store20 + store21 * store21 + store22 * store22)
   store20 = store20 / temp
   store21 = store21 / temp
   store22 = store22 / temp
   pass00 = store00
   pass01 = store10
   pass02 = store20
   pass03 = 0
   pass10 = store01
   pass11 = store11
   pass12 = store21
   pass13 = 0
   pass20 = store02
   pass21 = store12
   pass22 = store22
   pass23 = 0
   pass30 = 0
   pass31 = 0
   pass32 = 0
   pass33 = 1
   Call ApplyMatrix
   pass00 = storer
   pass01 = 0
   pass02 = 0
   Call ApplyRotate
   pass00 = store00
   pass01 = store01
   pass02 = store02
   pass03 = 0
   pass10 = store10
   pass11 = store11
   pass12 = store12
   pass13 = 0
   pass20 = store20
   pass21 = store21
   pass22 = store22
   pass23 = 0
   pass30 = 0
   pass31 = 0
   pass32 = 0
   pass33 = 1
   Call ApplyMatrix
End If
Call RefreshText
End Sub
Sub Undo_Click()
If UndoOff > 0 Then
   location = (UndoPtr + UndoOff + 52) Mod 53
   location2 = (UndoPtr + UndoOff) Mod 53
   For i = 0 To 3
      For j = 0 To 3
         Backup(location2, i, j) = Result(i, j)
         Result(i, j) = Backup(location, i, j)
      Next j
   Next i
   RedoMax = RedoMax + 1
   UndoOff = UndoOff - 1
Else
   Beep
End If
Call RefreshText
Label3.Caption = Mid(Str(UndoOff), 2, 2)
Label4.Caption = Mid(Str(RedoMax), 2, 2)
End Sub
Sub Redo_Click()
If RedoMax > 0 Then
   location = (UndoPtr + UndoOff + 1) Mod 53
   For i = 0 To 3
      For j = 0 To 3
         Result(i, j) = Backup(location, i, j)
      Next j
   Next i
   RedoMax = RedoMax - 1
   UndoOff = UndoOff + 1
Else
   Beep
End If
Call RefreshText
Label3.Caption = Mid(Str(UndoOff), 2, 2)
Label4.Caption = Mid(Str(RedoMax), 2, 2)
End Sub
Sub UndoAdd()
RedoMax = 0
location = (UndoPtr + UndoOff) Mod 53
For i = 0 To 3
   For j = 0 To 3
      Backup(location, i, j) = Result(i, j)
   Next j
Next i
If UndoOff = 50 Then
   UndoPtr = UndoPtr + 1
Else
   UndoOff = UndoOff + 1
End If
Label3.Caption = Mid(Str(UndoOff), 2, 2)
Label4.Caption = Mid(Str(RedoMax), 2, 2)
End Sub
