// Persistence of Vision Ray Tracer Scene Description File
// File: sample.pov
// Vers: 3.1
// Desc: Examples of blob_man.inc
// Date: April 1999
// Auth: Peter Houston < houston.graphics@iname.com >
// WWW : http://members.xoom.com/HoustonGraph/

#version 3.1;

global_settings {
        assumed_gamma 2.2
}

// ----------------------------------------
camera {
        location  <0, 100, -150.0>
        direction 1.5*z
        right     4/3*x
        look_at   <5.0, 35.0,  0>
}

background {rgb <0,0,0>}

light_source{<-200,200,-200> rgb<1,.9,.5>}
light_source{<400,400,-200> rgb<.2,.4,.8> shadowless}
light_source{<-200,200,-200> rgb<1,1,1>*.7 shadowless}
light_source{<100,50,-150> color rgb .5 shadowless}
light_source{<100,-50,-150> color rgb .3 shadowless}
light_source{<-100,-50,-150> color rgb .1 shadowless}
// ----------------------------------------

#declare DeBug=off;
#include "blob_man.inc"

// Declare Blob_Man Pose Arrays
// These were all created using Blob_Man_Studio.pov
#declare Pose_1=array[9][13]
   {
     { <0.75,1,1> ,<-15,0,-5> ,<20,20,0> ,<-15,0,5> ,<20,-20,0> ,<0,0,0> ,<0,0,0> ,<0,0,0> ,<0,0,0> ,<0,-15,0> ,<0,15,0>,<0,0,0>,<0,0,0> },
     { <0.75,1,1> ,<0,0,-38> ,<0,0,45> ,<0,0,38> ,<0,0,-45> ,<0,0,0> ,<0,0,0> ,<0,0,0> ,<0,0,0> ,<0,0,-38> ,<0,0,38>,<0,0,0>,<0,0,0> },
     { <0.75,1,1> ,<0,0,-20> ,<60,0,-20> ,<0,0,20> ,<60,0,20> ,<80,45,0> ,<10,0,90> ,<80,-45,0> ,<-5,0,-90> ,<0,90,0> ,<0,-90,0>,<0,0,0>,<-45,90,0> },
     { <0.75,1,1> ,<25,0,-20> ,<90,0,0> ,<25,0,20> ,<90,0,0> ,<90,15,0> ,<0,0,0> ,<90,-15,0> ,<0,0,0> ,<-10,-90,0> ,<10,90,0>,<0,0,0>,<0,0,0> },
     { <0.75,1,1> ,<0,5,-35> ,<0,0,10> ,<0,-5,35> ,<0,0,-10> ,<0,0,-15> ,<0,0,0> ,<0,0,15> ,<0,0,0> ,<0,0,10> ,<0,0,-10>,<0,0,0>,<0,0,0> },
     { <0.75,1,1> ,<25,0,0> ,<145,-45,-35> ,<25,0,0> ,<145,45,35> ,<65,10,0> ,<-90,0,0> ,<65,-10,0> ,<-90,0,0> ,<30,-30,-60> ,<30,30,60>,<-45,0,0> ,<-45,0,0> },
     { <0.75,1,1> ,<145,20,0> ,<210,0,0> ,<145,-20,0> ,<210,0,0> ,<65,10,0> ,<-90,0,0> ,<65,-10,0> ,<-90,0,0> ,<30,-30,-60> ,<30,30,60>,<-45,0,0> ,<-45,0,0> },
     { <0.75,1,1> ,<0,0,-150> ,<0,90,-180> ,<0,0,150> ,<0,-90,180> ,<45,0,-10> ,<-45,0,-10> ,<-5,0,10> ,<-5,0,10> ,<0,0,-90> ,<0,0,90>,<0,0,0>,<0,0,0> },
     { <0.75,1,1> ,<-10,0,-145> ,<0,0,-265> ,<-10,0,145> ,<0,0,265> ,<50,0,0> ,<-30,0,0> ,<0,0,10> ,<0,0,10> ,<0,90,0> ,<0,-90,0>,<-50,0,0> ,<0,-15,0> }
   }  
#declare Pose_2=array[9][6]
   {
     { 0,0,0,0,0,0},
     { 0,0,0,0,0,0},
     { 0,0,0,0,-10,0},
     { 0,0,0,0,0,0},
     { 0,0,0,0,0,0},
     { 0,0,0,0,-15,0},
     { 0,0,0,0,45,0},
     { 0,0,0,0,50,0},
     { 0,0,0,0,-10,0} 
   }
#declare Hair_1=array[5][2]
   {
     { <0,0,0>,<0.5,0.5,0.5>},
     { <0,0,0>,<0.5,0.5,0.5>},
     { <0,0,0>,<0.5,0.5,0.5>},
     { <0,0,0>,<0.5,0.5,0.5>},
     { <0,0,0>,<0.5,0.5,0.5>}
   }
#declare Hair_2=array[5][9]   
   {
     { 0,0,0,0,0,0,0,0,0},                // No Hair
     { 1,0,0.25,5,0.7,0.01,1,10,0.05},    // Standard Hair Settings
     { 1,0,0.25,5,0.7,0.01,1,20,0.1},     // Long Curly Hair
     { 1,0,0.25,5,0.7,0.05,1,6,0},        // Going Bald       
     { 1,0,0.5,5,0,0.005,1,6,0}           // Very Short Hair
   }  
#macro Create_Blob_Man(PoseNo,HairStyle,HairCol)
        #declare Eye_Colour= Pose_1[PoseNo][0];
        #declare RA_S2E=     Pose_1[PoseNo][1];  
        #declare RA_E2W=     Pose_1[PoseNo][2];  
        #declare LA_S2E=     Pose_1[PoseNo][3];  
        #declare LA_E2W=     Pose_1[PoseNo][4];    
        #declare RL_H2K=     Pose_1[PoseNo][5];  
        #declare RL_K2A=     Pose_1[PoseNo][6];  
        #declare LL_H2K=     Pose_1[PoseNo][7]; 
        #declare LL_K2A=     Pose_1[PoseNo][8];    
        #declare RH_Rot=     Pose_1[PoseNo][9];  
        #declare LH_Rot=     Pose_1[PoseNo][10];
        #declare RF_Rot=     Pose_1[PoseNo][11];
        #declare LF_Rot=     Pose_1[PoseNo][12];
        #declare Eye_Lid=    Pose_2[PoseNo][0]; 
        #declare Eye_Rot=    Pose_2[PoseNo][1];  
        #declare Lip_Size=   Pose_2[PoseNo][2];         
        #declare Head_Twist= Pose_2[PoseNo][3];
        #declare Head_Tip=   Pose_2[PoseNo][4];
        #declare Head_Tilt=  Pose_2[PoseNo][5];
        #declare Hair_Rot=   Hair_1[HairStyle][0];
        #declare Hair_Col=   HairCol;              //Hair_1[HairStyle][1];
        #declare Hair_On=    Hair_2[HairStyle][0];
        #declare Hair_Arch=  Hair_2[HairStyle][1];
        #declare Hair_Thck=  Hair_2[HairStyle][2];
        #declare Hair_Line=  Hair_2[HairStyle][3];
        #declare Hair_LDpth= Hair_2[HairStyle][4];
        #declare Hair_Wght=  Hair_2[HairStyle][5];
        #declare Hair_Hght=  Hair_2[HairStyle][6];
        #declare Hair_Length=Hair_2[HairStyle][7];
        #declare Hair_Curl=  Hair_2[HairStyle][8];
   
        #declare Blob_Man= union {
                object { head( Build,Eye_Colour,Eye_Lid,Eye_Rot,Lip_Size,Skin,Head_Twist,Head_Tip,Head_Tilt ) }
                object {torso( Build,Skin,RA_S2E,RA_E2W,LA_S2E,LA_E2W,RL_H2K,RL_K2A,LL_H2K,LL_K2A ) }
                object {hands( Build,Skin,RA_S2E,RA_E2W,LA_S2E,LA_E2W,RH_Rot,LH_Rot ) }
                object { feet( Build,Skin,RL_H2K,RL_K2A,LL_H2K,LL_K2A,RF_Rot,LF_Rot ) }
                object { hair( Hair_On,Hair_Rot,Hair_Col,Hair_Arch,Hair_Thck,Hair_Line,Hair_LDpth,Hair_Wght,Hair_Hght,Hair_Length,Hair_Curl,Head_Twist,Head_Tip,Head_Tilt ) }
        } 
#end

// ----------------------------------------
union {
        plane{y, 0}
        box {<-5,0,5>,<15,18.5,25> rotate y*30 translate <-30,0,70>}        
        pigment {rgb .75}
}
#declare Hair=1; // Set this to 1 to render with hair, INCREASES PARSE TIME

#local Build=0.5;
#local Skin =<.9,.7,.6>;
Create_Blob_Man(0,1*Hair,<0.56,0.42,0.14>) // Pose , Hair Style, Hair Colour
object {Blob_Man translate Origin_RL translate <-60,3,40>}

#local Skin =<.5,.4,.3>;
Create_Blob_Man(1,3*Hair,<0.5,0.5,0.5>) // Pose , Hair Style, Hair Colour
object {Blob_Man translate Origin_RL rotate y*75 translate <40,3,40>}

#local Skin =<.7,.6,.4>;
Create_Blob_Man(6,3*Hair,<0.65,0.50,0.39>) // Pose , Hair Style, Hair Colour
object {Blob_Man translate Origin_RL rotate y*-75 translate <10,0,40>}

#local Skin =<.9,.7,.6>;
Create_Blob_Man(2,2*Hair,<0.91,0.76,0.65>) // Pose , Hair Style, Hair Colour
object {Blob_Man translate Origin_RL rotate y*-15 translate <0,0,5>}

#local Skin =<.9,.7,.6>;
Create_Blob_Man(3,4*Hair,<0.98,0.73,0.68>) // Pose , Hair Style, Hair Colour
object {Blob_Man translate Origin_RL rotate y*30 translate <-30,3.5,70>}

#local Skin =<.7,.6,.4>;
Create_Blob_Man(5,1*Hair,<0.92,0.92,0.68>) // Pose , Hair Style, Hair Colour
object {Blob_Man translate Origin_RL rotate y*0 translate <-45,0,7>}

#local Skin =<.5,.4,.3>;
Create_Blob_Man(7,4*Hair,<0.65,0.50,0.39>) // Pose , Hair Style, Hair Colour
object {Blob_Man translate Origin_RA-<0,11,0> rotate z*180 rotate y*75 translate <95,0,80>}

#local Skin =<.9,.7,.6>;
Create_Blob_Man(8,4*Hair,<0.15,0.15,0.15>) // Pose , Hair Style, Hair Colour
object {Blob_Man translate Origin_LL rotate x*90 rotate y*60 translate <20,4,-30>}

// EOF