Copy blob_man.inc to a directory in your POV-Ray path.
eg. /include

/***************************************************************
Blob Man v1.0                                      09 April 1999
=============
by Peter Houston <houston.graphics@iname.com>
                < http://members.xoom.com/HoustonGraph/ >
based on Blob Man model by Govert Zoethout <zoethout@gmx.net>
                < http://victorian.fortunecity.com/dada/507/ >

These macros evolved from the excellent work of Govert Zoethout, 
who created the original blob man without legs or hands.

I updated the macros to add poseability to the figures, added hands,
legs and feet.

The hands are taken directly from the POV-Ray documentation (why 
re-invent the wheel) but they could do with a little work around 
the wrists.

Blob Man stands approximately 65 units tall

There are five macros in the blob_man.inc file, these are :-
        torso  .. including poseable arms and legs
        head   .. including turning eyes, lifting eyelids, 
                  sizeable lips, and able to Twist, Tip and Tilt.
        hands  .. currently only relaxed position but able to 
                  twist and rotate.
        hair   .. looks good but drastically increases parse time.
        feet   .. able to twist and rotate.

Installation
- - - - - - 
Copy blob_man.inc to a directory in your POV-Ray path. eg. /include

Locating Blob Man
- - - - - - - - - 
Four variables are generated by the torso macro called Origin_RL, 
Origin_LL, Origin_RA and Origin_LA, translate all objects by one of 
these and Blob Man will stand facing towards z(-) with either his 
Right Leg, Left Leg, Right Arm or Left Arm respectively located at <0,0,0>.
When using the Leg Origins, Blob_Man locates at the ankle, when I can 
work out how to calculate the extents of the foot when it's rotated I'll 
correct it, until then you'll have to transalte Blob_Man up slightly 
(<0,3,0> if the feet are in the default position, ie Rotation <0,0,0>).
I have found a slight problem with the Arm Origin variables, if the 
arms are raised above the shoulder you have to adjust the Origin by
-<0,11,0> ie the length of the upper arm segment, when I can figure
out why I will correct this.                                                        

Suggestion on Single Blob Man Usage
- - - - - - - - - - - - - - - - - - 
Include blob_man.inc anywhere as long as it is before you call the 
macros, create a union of all the macros and translate the union via 
the Origin Variables (see above), scale blob man to suit your scene.
Eg.

union {
  object { head( Build,Eye_Colour,Eye_Lid,Eye_Rot,Lip_Size,Skin,
                 Head_Twist,Head_Tip,Head_Tilt ) }
  object {torso( Build,Skin,RA_S2E,RA_E2W,LA_S2E,LA_E2W,RL_H2K,
                 RL_K2A,LL_H2K,LL_K2A ) }
  object {hands( Build,Skin,RA_S2E,RA_E2W,LA_S2E,LA_E2W,RH_Rot,
                 LH_Rot ) }
  object { feet( Build,Skin,RL_H2K,RL_K2A,LL_H2K,LL_K2A,RF_Rot,
                 LF_Rot ) }
  object { hair( Hair_On,Hair_Rot,Hair_Col,Hair_Arch,Hair_Thck,
                 Hair_Line,Hair_LDpth,Hair_Wght,Hair_Hght,Hair_Length,
                 Hair_Curl,Head_Twist,Head_Tip,Head_Tilt ) }
  translate Origin_RL + <0,3,0>//Addition for foot
  scale MyScale
  rotate MyRotation
  translate MyLocation
}

Suggestion on Multiple Blob Men Usage
- - - - - - - - - - - - - - - - - - -
See samples.pov for an example of using arrays with Blob Man, 
Blob_Man_Studio.pov creates a file bm_array.dat for the current pose,
this was used to create the arrays in samples.pov.

Things to come
- - - - - - - 
I have a few ideas for improvements to Blob Man when I get the time.

 * Variable hand positions, possibly poseability of each finger !
 * Blob_Lady, Blob_Kids
 * Variable Limb Segment Lengths (to create those long limbed aliens)
 * Bending and twisting of torso
 * Clothing
 * Windows front end to input settings - I need help with this any offers !?
 * Better documentation :)
 
If you have any suggestions, comments etc. please let me know, and if
you make any impovements, please send me a copy.

History of blob_man.inc
- - - - - - - - - - - - 
v1.0    09 Apr 1999     Initial release.

v0.0    March  1999     Govert Zoethout published his source files.
                        Original Macros had static arms and no 
                        hands or legs, and in his native language 
                        (which I can't speak)

****************************************************************/

#local Blob_Man_Temp_Version = version;
#version 3.1;
#ifndef (DeBug) #declare DeBug=off; #end
#declare LimbLoc1=
        union {
                cylinder {<-8,0,0><8,0,0> .5 pigment {rgb <1,0,0>}}                
                cylinder {<0,0,-8><0,0,8> .5 pigment {rgb <0,1,0>}}
                cylinder {<0,-8,0><0,8,0> .5 pigment {rgb <0,0,1>}}
                torus {5,.4 pigment {rgb <1,1,0>}}
        }
/***************************************************************
Torso Macro
- - - - - - 
Usage :

torso(build , skin , RA_S2E , RA_E2W , LA_S2E , LA_E2W , 
                     RL_H2K , RL_K2A , LL_H2K , LL_K2A  )

build  = Blob Threshold Level                        - standard: 0.5
skin   = Skin color (<r,g,b>)                        - standard: <.9,.7,.6>
RA_S2E = Right Arm Shoulder to Elbow rotation vector - standard: <0,0,0>
RA_E2W = Right Arm Elbow to Wrist rotation vector    - standard: <0,0,0>
LA_S2E = Left Arm Shoulder to Elbow rotation vector  - standard: <0,0,0>
LA_E2W = Left Arm Elbow to Wrist rotation vector     - standard: <0,0,0>
RL_H2K = Right Leg Hip to Knee rotation vector       - standard: <0,0,0>
RL_K2A = Right Leg Knee to Ankle rotation vector     - standard: <0,0,0>
LL_H2K = Right Leg Hip to Knee rotation vector       - standard: <0,0,0>
LL_K2A = Right Leg Knee to Ankle rotation vector     - standard: <0,0,0>

*****************************************************************/

#macro torso(build,skin,RA_S2E,RA_E2W,LA_S2E,LA_E2W,RL_H2K,RL_K2A,LL_H2K,LL_K2A)

    #local R_Shoulder=<0,0,0>;
    #local RE=<0,-11,0>;  // Upper Arm Length
    #local RW=<0,-9,0>;   // Lower Arm Length
    #local R_Elbow=vrotate(RE,RA_S2E);
    #local R_Wrist=vrotate(RW,RA_E2W);

    #local L_Shoulder=<0,0,0>;
    #local LE=<0,-11,0>; // Upper Arm Length
    #local LW=<0,-9,0>;  // Lower Arm Length
    #local L_Elbow=vrotate(LE,LA_S2E);
    #local L_Wrist=vrotate(LW,LA_E2W);

    #local R_Hip=<0,0,0>;
    #local RK=<0,-14,0>; // Thigh Length
    #local RA=<0,-17,0>; // Calf Length
    #local R_Knee =vrotate(RK,RL_H2K);
    #local R_Ankle=vrotate(RA,RL_K2A);

    #local L_Hip=<0,0,0>;
    #local LK=<0,-14,0>; // Thigh Length
    #local LA=<0,-17,0>; // Calf Length
    #local L_Knee =vrotate(LK,LL_H2K);
    #local L_Ankle=vrotate(LA,LL_K2A);

    blob{threshold build-.3          
// Neck & Spine
      #local yy=0;
      #while (yy>-29)
        sphere{0,2,2 translate<0,yy-3,sin((yy+2)*pi/(4+abs(yy)/4))*(.25+abs(yy/15))+1>}             
        #if (mod(yy+2,3)=0)
          sphere{0,1,2 translate<0,yy-3,sin((yy+2)*pi/(4+abs(yy)/4))*(.25+abs(yy/15))+2.1>}             
        #end
        #local yy=yy-1;
      #end

//Shoulders & Neck
      cylinder{<-4,-9,1><-1,-7,1>,1.2,2}
      cylinder{<4,-9,1><1,-7,1>,1.2,2}
      cylinder{<-8,-10,1><8,-10,1>,3.2,2}
//Arms
      cylinder{R_Shoulder,R_Elbow,2.7,2 translate <-9,-11,1>}
      cylinder{R_Elbow,R_Elbow+R_Wrist,2.7,2 translate <-9,-11,1>}
      cylinder{L_Shoulder,L_Elbow,2.7,2 translate <9,-11,1>}
      cylinder{L_Elbow,L_Elbow+L_Wrist,2.7,2 translate <9,-11,1>}
// Upper Chest
      cylinder{<-8,-9,.5><-1,-9.5,-1.25>,1,2 }
      cylinder{<8,-9,.5><1,-9.5,-1.25>,1,2}
      cylinder{<-6,-10.5,-.5><6,-10.5,-.5>,2,2}
// Chest and Shoulder Blades    
      sphere{0,4,2 scale<1.4,2,1.5> rotate x*15 translate<-2.8,-14,0> } // Right
      sphere{0,4,2 scale<1.4,2,1.5> rotate x*15 translate<2.8,-14,0>} // Left
// Side
      sphere{0,3,2 scale<1.5,2,1.2> translate<-2.8,-22.5,0> } // Right
      sphere{0,3,2 scale<1.5,2,1.2> translate<2.8,-22.5,0>}  // Left
// Abdomen
      sphere{0,3,2 scale<1,1,1.2> translate<-1.5,-20,-1>}
      sphere{0,3,2 scale<1,1,1.2> translate<1.5,-20,-1>}
      sphere{0,3,2 scale<1,1.2,1.2> translate<-1.5,-22.5,-1.25>}
      sphere{0,3,2 scale<1,1.2,1.2> translate<1.5,-22.5,-1.25>}
      sphere{0,3,2 scale<1,1,1.2> translate<-1.5,-25,-1>}
      sphere{0,3,2 scale<1,1,1.2> translate<1.5,-25,-1>}
// Pelvis
      sphere{0,5,2 scale<1.2,1.6,1> translate<0,-28,-.5> } //Front & Back
      sphere{0,3,2 scale<1.4,.8,1.5> rotate z*-75 translate<-4,-28,-.5>} // Right
      sphere{0,3,2 scale<1.4,.8,1.5> rotate z*75 translate<4,-28,-.5>}  // Left 

// Buttocks      
      sphere{0,3,2 scale<1.5,2,1.5> rotate x*15 translate<3.5,-29.5,.75> } // Right
      sphere{0,3,2 scale<1.5,2,1.5> rotate x*15 translate<-3.5,-29.5,.75>} // Left
// Legs
      cylinder{R_Hip,R_Knee,4,4 translate <-4,-29,0>}
      cylinder{R_Knee,R_Ankle+R_Knee,3.8,2 translate <-4,-29,0>}
      cylinder{L_Hip,L_Knee,4,4 translate <4,-29,0>}
      cylinder{L_Knee,L_Ankle+L_Knee,3.8,2 translate <4,-29,0>}

// Skin Texture


      pigment{rgb skin}
      finish{phong .3 phong_size 40}
      normal{crackle .2 turbulence .7 scale .7}
    }

    #declare Origin_RL=< 4,31,0>-R_Ankle-R_Knee;
    #declare Origin_LL=<-4,31,0>-L_Ankle-L_Knee;
    #declare Origin_RA=< 9,20,0>-R_Elbow-R_Wrist;
    #declare Origin_LA=<-9,20,0>-L_Elbow-L_Wrist;

#end

/***************************************************************

Head Macro
- - - - - 
Usage :

head( build , eye , lid , EyeRot , lip , skin , Twist , Tip , Tilt )

build   = Blob Threshold Level                                      - standard: .5
eye     = Iris Colour of eye (<r,g,b>) - i.e. <.75,1,1> = Pale Blue
lid     = Eye Lid Position  (range : -0.25 to 0.5)                  - standard: 0
EyeRot  = Eye Rotation Angle left-right                             - standard: 0
lip     = Mouth Size (range: -0.5 to 0.5 )                          - standard: 0
skin    = Skin color (<r,g,b>)                                      - standard: <.9,.7,.6>
Twist   = Head rotation Right to Left (range: -85 to 85)            - standard: 0
Tip     = Head position Front to Back (range: -15 to 50)            - standard: 0
Tilt    = Head position Right Side to Left Side  (range: -25 to 25) - standard: 0

*****************************************************************/                                                                                

#macro head(build,eye,lid,EyeRot,lip,skin,Twist,Tip,Tilt)
  union{
    blob{threshold build
// Skull
      sphere{0,5.6,2  } // Top of Skull
      sphere{0,4.2,2 scale<1,1.4,1> translate <0,-1.4,-.7> } //Lower Jaw
      sphere{0,2.8,2 scale<1,1.4,1> translate <0,-2.8,-1.4>} // Chin
// Nose
      cylinder{<0,1,.5><0,-1,-.5>,1,2 translate <0,-.7,-3.5> } // Nose
      cylinder{<-.7,0,0><.7,0,0>,.5,2 translate<0,-1.75,-3.85> }  // Nostrils
// Eyes Lids
      sphere{0,1.05,2 translate<0,0,-3.85> rotate y*22.5 } // Right Upper Lid
      sphere{0,1.05,2 translate<0,0,-3.85> rotate y*-22.5} // Left Upper Lid
      sphere{0,1,-2 scale<1,.7,1> translate<0,-.35-lid,-4.55> rotate y*21 } //Right Eye Socket
      sphere{0,1,-2 scale<1,.7,1> translate<0,-.35-lid,-4.55> rotate y*-21} // Left Eye Socket
// Lips 
      sphere{0,1.4,2 scale<.85+lip,.35,1> rotate x*21 translate<0,-3.5,-3.05> rotate y*7 } //  Upper Right
      sphere{0,1.4,2 scale<.85+lip,.35,1> rotate x*21 translate<0,-3.5,-3.05> rotate y*-7} // Upper Left
      sphere{0,1.4,-1 scale<1+lip,.21,.5> rotate x*-21 translate<0,-3.675,-3.5>} // Lower Right
      sphere{0,1.4,2 scale<1+lip,.35,.56> rotate x*-42 translate<0,-3.85,-3.15>} // Lower Left   
// Ears
      sphere{0,1,2 scale<1,1.75,.7> rotate y*45 rotate z*15 translate<-4.2,-.85,0> } // Outer Ear Right
      sphere{0,1,-2 scale<1,1.75,.7>*.7 rotate y*45 rotate z*15 translate<-4.2,-.7,-.35>} // Inner Ear Right
      sphere{0,1,2 scale<1,1.75,.7>/3.5 rotate y*45 rotate z*15 translate<-4.025,-.7,-.35> } // Inner Ear Canal Right
      sphere{0,1,2 scale<1,1.75,.7> rotate y*-45 rotate z*-15 translate<4.2,-.85,0> } // Outer Ear Left
      sphere{0,1,-2 scale<1,1.75,.7>*.7 rotate y*-45 rotate z*-15 translate<4.2,-.7,-.35>} // Inner Ear Right
      sphere{0,1,2 scale<1,1.75,.7>/3.5 rotate y*-45 rotate z*-15 translate<4.025,-.7,-.35>} // Inner Ear Canal Right

// Skin Texture
      pigment{rgb skin}
      finish{phong .3 phong_size 40}
      normal{crackle .2 turbulence .7 scale .7}
    }

// Eyes
    union{
      sphere{0,1 pigment{rgb 1}}
      sphere{0,.7 translate z*-.35 rotate y*18 pigment{rgb eye}}
      sphere{0,.2 translate z*-.9  rotate y*18 pigment{rgb 0}}
      rotate x*-7
      rotate y*EyeRot
      translate<0,-.35,-3.5> 
      rotate y*-21
    }
    union{
      sphere{0,1 pigment{rgb 1}}
      sphere{0,.7 translate z*-.35 rotate y*-18 pigment{rgb eye}}
      sphere{0,.2 translate z*-.9  rotate y*-18 pigment{rgb 0}} 
      rotate x*-7
      rotate y*EyeRot
      translate<0,-.35,-3.5> 
      rotate y*21 
    }

// Head Tilt, Tip & Twist    
    scale 1.1
    translate <0,5,-1>
    rotate z*Tilt
    rotate x*Tip
    rotate y*Twist 
    translate <0,-5,1>
  }

#end

/****************************************************************

Hands Macro
- - - - - -
Usage:

hands( build , skin , RH_S2E , RH_E2W , LH_S2E , LH_E2W , RH_Rot , LH_Rot )

build  =  Blob Threshold Level                        - standard: 0.5
skin   =  Skin color (<r,g,b>)                        - standard: <.9,.7,.6>
RH_S2E =* Right Arm Shoulder to Elbow rotation vector - standard: Same as Torso
RH_E2W =* Right Arm Elbow to Wrist rotation vector    - standard: Same as Torso
LH_S2E =* Left Arm Shoulder to Elbow rotation vector  - standard: Same as Torso
LH_E2W =* Left Arm Elbow to Wrist rotation vector     - standard: Same as Torso
RH_Rot =  Right Hand rotation Vector                  - standard: <0,0,0>
LH_Rot =  Left Hand rotation Vector                   - standard: <0,0,0>

* These MUST be the same as the Torso Macro if they are to line up correctly.  

*******************************************************************/

#macro hands(build,skin,RH_S2E,RH_E2W,LH_S2E,LH_E2W,RH_Rot,LH_Rot)
 #local RE=<0,-11,0>;  // Upper Arm Length
 #local RW=<0,-9,0>;   // Lower Arm Length
 #local RH_Elbow=vrotate(RE,RH_S2E);
 #local RH_Wrist=vrotate(RW,RH_E2W);

 #local LE=<0,-11,0>;  // Upper Arm Length
 #local LW=<0,-9,0>;   // Lower Arm Length
 #local LH_Elbow=vrotate(LE,LH_S2E);
 #local LH_Wrist=vrotate(LW,LH_E2W);  

 union {
  blob {
    threshold build
    sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
    sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
    sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    cylinder { <-.65,-.28,0>, <-.65,.28,-.05>, .26, 1 }    //lower pinky
    cylinder { <-.65,.28,-.05>, <-.65, .68,-.2>, .26, 1 }  //upper pinky
    cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 }      //lower ring
    cylinder { <-.3,.44,-.05>, <-.3, .9,-.2>, .26, 1 }     //upper ring
    cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 }     //lower middle
    cylinder { <.05,.49,-.05>, <.05, .95,-.2>, .26, 1 }    //upper middle
    cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }      //lower index
    cylinder { <.4,.512,-.05>, <.4, .85, -.2>, .26, 1 }    //upper index
    cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }  //lower thumb
    cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1 }  //upper thumb
    sphere { <-.65,.28,-.05>, .26, -1 } //counteract pinky knuckle bulge
    sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge
    sphere { <-.3,.44,-.05>, .26, -1 }  //counteract ring knuckle bulge
    sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge
    sphere { <.05,.49,-.05>, .26, -1 }  //counteract middle knuckle bulge
    sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge
    sphere { <.4,.512,-.05>, .26, -1 }  //counteract index knuckle bulge
    sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge
    sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
    sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge
    scale <.8,1,1.75> 
    translate <0,1,0>
    scale 3.8
    rotate y*90
    scale <1,-1,1>
    rotate LH_Rot
    rotate LH_E2W
    translate LH_Elbow+LH_Wrist+<9,-11,1>
  }            

 blob {
    threshold build
    sphere { <-.23,-.32,0>,.43, 1 scale <1.95,1.05,.8> }   //palm
    sphere { <+.12,-.41,0>,.43, 1 scale <1.95,1.075,.8> }  //palm
    sphere { <-.23,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <+.19,-.63,0>, .45, .75 scale <1.78, 1.3,1> } //midhand
    sphere { <-.22,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    sphere { <+.19,-.73,0>, .45, .85 scale <1.4, 1.25,1> } //heel
    cylinder { <-.65,-.28,0>, <-.65,.28,-.05>, .26, 1 }    //lower pinky
    cylinder { <-.65,.28,-.05>, <-.65, .68,-.2>, .26, 1 }  //upper pinky
    cylinder { <-.3,-.28,0>, <-.3,.44,-.05>, .26, 1 }      //lower ring
    cylinder { <-.3,.44,-.05>, <-.3, .9,-.2>, .26, 1 }     //upper ring
    cylinder { <.05,-.28,0>, <.05, .49,-.05>, .26, 1 }     //lower middle
    cylinder { <.05,.49,-.05>, <.05, .95,-.2>, .26, 1 }    //upper middle
    cylinder { <.4,-.4,0>, <.4, .512, -.05>, .26, 1 }      //lower index
    cylinder { <.4,.512,-.05>, <.4, .85, -.2>, .26, 1 }    //upper index
    cylinder { <.41, -.95,0>, <.85, -.68, -.05>, .25, 1 }  //lower thumb
    cylinder { <.85,-.68,-.05>, <1.2, -.4, -.2>, .25, 1 }  //upper thumb
    sphere { <-.65,.28,-.05>, .26, -1 } //counteract pinky knuckle bulge
    sphere { <-.65,-.28,0>, .26, -1 }   //counteract pinky palm bulge
    sphere { <-.3,.44,-.05>, .26, -1 }  //counteract ring knuckle bulge
    sphere { <-.3,-.28,0>, .26, -1 }    //counteract ring palm bulge
    sphere { <.05,.49,-.05>, .26, -1 }  //counteract middle knuckle bulge
    sphere { <.05,-.28,0>, .26, -1 }    //counteract middle palm bulge
    sphere { <.4,.512,-.05>, .26, -1 }  //counteract index knuckle bulge
    sphere { <.4,-.4,0>, .26, -1 }      //counteract index palm bulge
    sphere { <.85,-.68,-.05>, .25, -1 } //counteract thumb knuckle bulge
    sphere { <.41,-.7,0>, .25, -.89 }   //counteract thumb heel bulge
    scale <.8,1,1.75>
    translate <0,1,0>
    scale 3.8
    rotate y*90
    scale <-1,-1,1>
    rotate RH_Rot
    rotate RH_E2W
    translate RH_Elbow+RH_Wrist+<-9,-11,1>
  }            
        #if (DeBug=on)
                object {LimbLoc1
                        rotate LH_Rot
                        rotate LH_E2W
                        translate LH_Elbow+LH_Wrist+<9,-11,1> 
                }
                object {LimbLoc1
                        rotate RH_Rot
                        rotate RH_E2W
                        translate RH_Elbow+RH_Wrist+<-9,-11,1> 
                }
        #end


  pigment{rgb skin}
  finish{phong .3 phong_size 40}
  normal{crackle .2 turbulence .7 scale .7}
}

#end

/****************************************************************

Hair Macro
- - - - -
Usage:

hair( Hair_On, Hair_Rot, Hair_Col, Hair_Arch, Hair_Thck, Hair_Line, Hair_LDpth, Hair_Wght, Hair_Hght, Hair_Length, 
      Hair_Curl, Twist, Tip, Tilt )

Hair_On        = Hair (1) or No Hair (0)
Hair_Rot       = Rotation Vector for Hair (<x,y,z>)            - standard: <0,0,0>
Hair_Col       = Hair Colour (<r,g,b>)
Hair_Arch      = Arch hairline over head inline with ears (1) or Not (0)
Hair_Thck      = Thickness of Hair (Best settings 0.15 to 0.5) - standard: 0.25
Hair_Line      = Height of Hairline (Best settings 3 to 6)     - standard: 5
Hair_LDpth     = Hairline profile Depth (Range: 0 to 1)        - standard: 0.7
Hair_Wght      = Hair Weight (Range 0.005 to 0.05)             - standard: 0.01
Hair_Hght      = Hair Height (Range 1 to 2)                    - Standard: 1
Hair_Length    = Hair Length (Range 1 to 20)                   - standard: 10
Hair_Curl      = Curliness (Range 0-Straight to 0.1-Curly)     - Standard: 0.05
Twist          =* Head Twist Angle                             - Standard: Same as Head
Tip            =* Head Tip Angle                               - Standard: Same as Head  
Tilt           =* Head Tilt Angle                              - Standard: Same as Head  

* These MUST be the same as the Head Macro if it is to line up correctly.  

*******************************************************************/

#macro hair(Hair_On,Hair_Rot,Hair_Col,Hair_Arch,Hair_Thck,Hair_Line,Hair_LDpth,Hair_Wght,Hair_Hght,Hair_Length,Hair_Curl,Twist,Tip,Tilt)
  #if (Hair_On=1)       
  union{
    #local rr=seed(77);
    #local tt=0;
    #while (tt<20)
      #local zz=tt*3+3;   
      #local cc=0;
      #while (cc<zz)
        #local yy=cc*360/zz+rand(rr)*6;
        #local xx=Hair_Line-sin((yy+15)*pi/30)*Hair_LDpth;
        #local hh=vrotate(<0,.8,0>,<tt*xx+rand(rr)*5,yy,45>);
        #local hx=hh.x;
        #local hy=hh.y;
        #local hz=hh.z;
        #local dx=hx/50;
        #local dy=hy/50*Hair_Hght;
        #local dz=hz/50;    
        #if (Hair_Arch=1 & dx>0)
          #local dy=dy+dx;
          #local dx=-dx;
        #end
        #if (hy>-.25)
          blob{threshold .5
          #local ll=0;           
          #local length=Hair_Length-rand(rr)*Hair_Length/5;
          #local vv=rand(rr)*length;
          #while (ll<length) 
            sphere{<hx+Hair_Curl*sin((vv+ll)*pi/3),hy,hz+Hair_Curl*cos((vv+ll)*pi/3)>,Hair_Thck/5,1}
            #local ll=ll+Hair_Thck;
            #local hx=hx+dx;
            #local hy=hy+dy;
            #local hz=hz+dz;
            #local dx=dx*(1-Hair_Wght*2);
            #local dy=dy*(1-Hair_Wght/2)-Hair_Wght/20;
            #local dz=dz*(1-Hair_Wght);
            #if (Hair_Arch=1 & dx>0)
              #local dy=dy+0.001;       
              #if (hx>-.5)
                #local hx=hx+dx;
              #end
            #end
          #end
        pigment{rgb Hair_Col+<rand(rr)/10,rand(rr)/10,rand(rr)/10>}}
        #end
        #local cc=cc+1;
      #end
      #local tt=tt+1;
    #end
    rotate y*90
    rotate Hair_Rot
    scale 4.5
    translate <0,5,-1>
    rotate z*Tilt
    rotate x*Tip
    rotate y*Twist 
    translate <0,-5,1>
    }
  #else
    sphere {<0,0,0>.000000001 pigment{rgb Hair_Col}}
  #end
#end


/****************************************************************

Feet Macro
- - - - -
Usage:

feet( build , skin , RF_H2K , RF_K2A , LF_H2K , LF_K2A , RF_Rot , LF_Rot)

build  =  Blob Threshold Level                        - standard: 0.5
skin   =  Skin color (<r,g,b>)                        - standard: <.9,.7,.6>
RF_H2K =* Right Leg Hip to Knee rotation vector       - standard: As Torso
RF_K2A =* Right Leg Knee to Ankle rotation vector     - standard: As Torso
LF_H2K =* Right Leg Hip to Knee rotation vector       - standard: As Torso
LF_K2A =* Right Leg Knee to Ankle rotation vector     - standard: As Torso
RF_Rot =  Right Foot rotation Vector                  - standard: <0,0,0>
LF_Rot =  Left Foot rotation Vector                   - standard: <0,0,0>

* These MUST be the same as the Torso Macro if they are to line up correctly.  

******************************************************************/

#macro feet(build,skin,RF_H2K,RF_K2A,LF_H2K,LF_K2A,RF_Rot,LF_Rot)

    #local R_Hip=<0,0,0>;
    #local RK=<0,-14,0>; // Thigh Length
    #local RA=<0,-17,0>; // Calf Length
    #local RF_Knee =vrotate(RK,RF_H2K);
    #local RF_Ankle=vrotate(RA,RF_K2A);

    #local L_Hip=<0,0,0>;
    #local LK=<0,-14,0>; // Thigh Length
    #local LA=<0,-17,0>; // Calf Length
    #local LF_Knee =vrotate(LK,LF_H2K);
    #local LF_Ankle=vrotate(LA,LF_K2A);

    union {
 // Right Foot
        blob {  threshold build-0.3
                cylinder{<.5,.25,0><-.3,.25,0>,1,2 scale <1,.75,1>}
                sphere{<1.15,.25,-.75>,.5,1 }     
                sphere{<.5,.25,-1>,.3,1 }
                sphere{<0,.25,-.9>,.3,1 }
                sphere{<-.5,.25,-.85>,.3,1 }
                sphere{<-1,.25,-.65>,.3,1 }
                sphere{<0,.4,3>,1,2}            
                cylinder{<0,.55,3><0,.35,0>,.5,2 }      
                cylinder{<.3,.55,3><.75,.35,0>,.5,2 }
                cylinder{<0,.65,3><.25,.35,0>,.5,2 }
                cylinder{<0,.55,3><.5,.35,0>,.5,2 }
                cylinder{<0,.65,3><-.25,.35,0>,.5,2 }
                cylinder{<0,.55,3><-.5,.35,0>,.5,2 }
                cylinder{<-.3,.55,3><-.5,.35,0>,.5,2 }
                cylinder{<0,.25,3><0,.25,0>,.5,2 }      
                cylinder{<.3,.25,3><.75,.25,0>,.5,2 }
                cylinder{<0,.25,3><.25,.25,0>,.5,2 }
                cylinder{<0,.25,3><.5,.25,0>,.5,2 }
                cylinder{<0,.25,3><-.25,.25,0>,.5,2 }
                cylinder{<0,.25,3><-.5,.25,0>,.5,2 }
                cylinder{<-.3,.25,3><-.75,.25,0>,.5,2 scale <1.25,1,1> }
                cylinder{<1,-2,1><1,2,1>1.5,-4}
                cylinder{<-1.5,-2,.65><-1.5,2,.65>1,-4 scale <1,1,2>}
                sphere  {<0,.75,2.75>,1,2}
                translate <0,-2,-2.75>
                scale <1.25,1.25,1>
                scale 2.25
                rotate RF_Rot
                rotate RF_K2A
                translate RF_Knee+RF_Ankle+<-4,-29,0>
        }       
// Left Foot
        blob {  threshold build-0.3
                cylinder{<.5,.25,0><-.3,.25,0>,1,2 scale <1,.75,1>} 
                sphere{<1.15,.25,-.75>,.5,1 }     
                sphere{<.5,.25,-1>,.3,1 }
                sphere{<0,.25,-.9>,.3,1 }
                sphere{<-.5,.25,-.85>,.3,1 }
                sphere{<-1,.25,-.65>,.3,1 }
                sphere{<0,.4,3>,1,2}            
                cylinder{<0,.55,3><0,.35,0>,.5,2 }      
                cylinder{<.3,.55,3><.75,.35,0>,.5,2 }
                cylinder{<0,.65,3><.25,.35,0>,.5,2 }
                cylinder{<0,.55,3><.5,.35,0>,.5,2 }
                cylinder{<0,.65,3><-.25,.35,0>,.5,2 }
                cylinder{<0,.55,3><-.5,.35,0>,.5,2 }
                cylinder{<-.3,.55,3><-.5,.35,0>,.5,2 }
                cylinder{<0,.25,3><0,.25,0>,.5,2 }      
                cylinder{<.3,.25,3><.75,.25,0>,.5,2 }
                cylinder{<0,.25,3><.25,.25,0>,.5,2 }
                cylinder{<0,.25,3><.5,.25,0>,.5,2 }
                cylinder{<0,.25,3><-.25,.25,0>,.5,2 }
                cylinder{<0,.25,3><-.5,.25,0>,.5,2 }
                cylinder{<-.3,.25,3><-.75,.25,0>,.5,2 scale <1.25,1,1> }
                cylinder{<1,-2,1><1,2,1>1.5,-4}
                cylinder{<-1.5,-2,.65><-1.5,2,.65>1,-4 scale <1,1,2>}
                sphere  {<0,.75,2.75>,1,2}
                translate <0,-2,-2.75>
                scale <-1.25,1.25,1>
                scale 2.25
                rotate LF_Rot
                rotate LF_K2A
                translate LF_Knee+LF_Ankle+<4,-29,0>
        }                 
        
        #if (DeBug=on)
                object {LimbLoc1
                        rotate LF_Rot
                        rotate LF_K2A
                        translate LF_Knee+LF_Ankle+<4,-29,0> 
                }
                object {LimbLoc1
                        rotate RF_Rot
                        rotate RF_K2A
                        translate RF_Knee+RF_Ankle+<-4,-29,0> 
                }
        #end

        pigment{rgb skin}
        finish{phong .3 phong_size 40}
        normal{crackle .2 turbulence .7 scale .7}
}

#end

#version Blob_Man_Temp_Version;

//EOF