/***************************************************************
Blob Man Studio                                    09 April 1999
===============
by Peter Houston <houston.graphics@iname.com>
                < http://members.xoom.com/HoustonGraph/ >
based on Blob Man model by Govert Zoethout <zoethout@gmx.net>
                < http://victorian.fortunecity.com/dada/507/ >

For further information refer to blob_man.inc

****************************************************************

 B L O B   M A N   S A M P L E   P O S E S

Set Pose_Studio to 'no' to see pre-defined 
poses set PoseNo for the pose you wish to try.

  PoseNo
   0 = Standing Relaxed
   1 = Standing Hands on Hips
   2 = Meditation    
   3 = Sitting at Table/Piano etc
   4 = Gunfighter
   5 = Praying on Knees
   6 = "We're Not Worthy"

If you wish to experiment with Blob Man Studio 
(below) set Pose_Studio to 'yes'.
****************************************************************/

#local Pose_Studio=no;
#local PoseNo=0;

/***************************************************************

 B L O B   M A N   S T U D I O

Change the settings below to create your 
own poses.

****************************************************************/

#include "blob_man.inc"

/****************************************************************
 General Settings
*****************************************************************/
#local Build      =0.5;         // Blob Threshold (Low=Fat, High=Thin)
#local Skin       =<.9,.7,.6>;  // Skin Pigment Colour
#declare DeBug    =off;         // Debugging Variable
//***************************************************************

#if (Pose_Studio=yes)
/****************************************************************
 Head Settings
*****************************************************************/
#local Eye_Colour = <.75,1,1>; // Iris Colour of eye (<r,g,b>) - ie. <.75,1,1> = Pale Blue
#local Eye_Lid    = 0;         // Eye Lid Position  (range : -0.25 to 0.5) - standard: 0
#local Eye_Rot    = 0;         // Eye Rotation Angle left-right - standard: 0
#local Lip_Size   = 0;         // Mouth/Lip Size (range: -0.5 to 0.5 ) - standard: 0  
#local Head_Twist = 0;         // Head rotation Left(-) to Right(+) (range: -85 to 85) - standard: 0
#local Head_Tip   = 0;         // Head position Front to Back (range: -15 to 50) - standard: 0
#local Head_Tilt  = 0;         // Head position Right Side to Left Side  (range: -25 to 25) - standard: 0

/****************************************************************
 Torso Settings
   Arm Rotation Vectors <X,Y,Z> 
   <0,0,0> is pointing straight down
   X= Back(-) to Front(+)
   Y= Twist Left(-), Right (+)
   Z= Side to Side Lift Right(-), Left(+)
*****************************************************************/
#local RA_S2E= <0,0,0>;  // Right Arm Shoulder to Elbow rotation vector
#local RA_E2W= <0,0,0>;  // Right Arm Elbow to Wrist rotation vector
#local LA_S2E= <0,0,0>;  // Left Arm Shoulder to Elbow rotation vector
#local LA_E2W= <0,0,0>;  // Left Arm Elbow to Wrist rotation vector
#local RL_H2K= <0,0,0>;  // Right Leg Hip to Knee rotation vector
#local RL_K2A= <0,0,0>;  // Right Leg Knee to Ankle rotation vector
#local LL_H2K= <0,0,0>;  // Left Leg Hip to Knee rotation vector    
#local LL_K2A= <0,0,0>;  // Left Leg Knee to Ankle rotation vector
               
/****************************************************************
 Hand Settings
   Hand Rotation Vectors <X,Y,Z>
   <0,0,0> - fingers pointing down with thumbs foward.
*****************************************************************/
#local RH_Rot= <0,0,0>;  // Right Hand Rotation Vector
#local LH_Rot= <0,0,0>;  // Left Hand Rotation Vector

/****************************************************************
 Foot Settings
   Foot Rotation Vectors <X,Y,Z>
   <0,0,0> - toes pointing forward
*****************************************************************/
#local RF_Rot= <0,0,0>;  // Right Foot Rotation Vector
#local LF_Rot= <0,0,0>;  // Left Foot Rotation Vector

/****************************************************************
 Hair Settings     
   Note: Hair drastically increases the parse time !
*****************************************************************/
#local Hair_On    = 0;          // Hair (1) - No Hair (0)
#local Hair_Rot   = <0,0,0>;    // Hair Rotation - Standard <0,0,0>
#local Hair_Col   = <.6,.5,.4>; // Hair Colour <r,g,b>
#local Hair_Arch  = 0;          // Arch hairline over head in line with ears (1) or Not (0)
#local Hair_Thck  = 0.25;       // Hair Thickness <0.15 to 0.5> - Standard: 0.25
#local Hair_Line  = 5;          // Hair Line Height (Best Settings 3 to 6) - Standard: 5 
#local Hair_LDpth = 0.7;        // Hairline profile Depth (Range: 0-Straight Fringe to 1-Widows Peak) - standard: 0.7
#local Hair_Wght  = 0.01;       // Hair Weight (Range 0.005 to 0.05) - Standard: 0.01
#local Hair_Hght  = 1;          // Hair Height (Range 1 to 2) - Standard: 1
#local Hair_Length= 10;         // Hair Length (1 to 20) - Standard: 10
#local Hair_Curl  = 0.05;       // Curliness (Range 0-Straight to 0.1-Curly) - Standard: 0.05

/****************************************************************
*****************************************************************

*****************************************************************
 Write settings to external file for pasteing into Pose & Pose1 Arrays.
*****************************************************************/
#fopen file "bm_array.dat" write
    #write (file, "These are the arrays found in Blob_Man_Studio.pov\n")
    #write (file, "=================================================\n")
    #write (file, "pose   = { ",Eye_Colour,",",RA_S2E,",",RA_E2W,",",LA_S2E,",",LA_E2W,",",RL_H2K,",",RL_K2A,",",LL_H2K,",",LL_K2A,",",RH_Rot,",",LH_Rot,",",Hair_Rot,",",Hair_Col,",",RF_Rot,",",LF_Rot,"}\n")
    #write (file, "pose1  = { ",Eye_Lid,",",Eye_Rot,",",Lip_Size,",",Head_Twist,",",Head_Tip,",",Head_Tilt,",",Hair_On,",",Hair_Arch,",",Hair_Thck,",",Hair_Line,",",Hair_LDpth,",",Hair_Wght,",",Hair_Hght,",",Hair_Length,",",Hair_Curl,"}\n\n")
    #write (file, "These are the arrays found in sample.pov\n")
    #write (file, "========================================\n")
    #write (file, "Pose_1 = { ",Eye_Colour,",",RA_S2E,",",RA_E2W,",",LA_S2E,",",LA_E2W,",",RL_H2K,",",RL_K2A,",",LL_H2K,",",LL_K2A,",",RH_Rot,",",LH_Rot,",",RF_Rot,",",LF_Rot,"}\n")
    #write (file, "Pose_2 = { ",Eye_Lid,",",Eye_Rot,",",Lip_Size,",",Head_Twist,",",Head_Tip,",",Head_Tilt,"}\n")
    #write (file, "Hair_1 = { ",Hair_Rot,",",Hair_Col,"}\n")
    #write (file, "Hair_2 = { ",Hair_On,",",Hair_Arch,",",Hair_Thck,",",Hair_Line,",",Hair_LDpth,",",Hair_Wght,",",Hair_Hght,",",Hair_Length,",",Hair_Curl,"}\n")
#fclose file

#else        
/****************************************************************
 Define Poses
*****************************************************************/
#local Pose=array[7][15]
   {
     { <0.75,1,1> ,<-15,0,-5> ,<20,20,0> ,<-15,0,5> ,<20,-20,0> ,<0,0,0> ,<0,0,0> ,<0,0,0> ,<0,0,0> ,<0,-15,0> ,<0,15,0>,<0,0,0> ,<1,1,1>,<0,0,0>,<0,0,0> },
     { <0.75,1,1> ,<0,0,-38> ,<0,0,45> ,<0,0,38> ,<0,0,-45> ,<0,0,0> ,<0,0,0> ,<0,0,0> ,<0,0,0> ,<0,0,-38> ,<0,0,38>,<0,0,0> ,<1,1,1>,<0,0,0>,<0,0,0> },
     { <0.75,1,1> ,<0,0,-20> ,<60,0,-20> ,<0,0,20> ,<60,0,20> ,<80,45,0> ,<10,0,90> ,<80,-45,0> ,<-5,0,-90> ,<0,90,0> ,<0,-90,0>,<0,0,0> ,<1,1,1>,<0,0,0>,<-45,90,0> },
     { <0.75,1,1> ,<25,0,-20> ,<90,0,0> ,<25,0,20> ,<90,0,0> ,<90,15,0> ,<0,0,0> ,<90,-15,0> ,<0,0,0> ,<-10,-90,0> ,<10,90,0>,<0,0,0> ,<1,1,1>,<0,0,0>,<0,0,0> },
     { <0.75,1,1> ,<0,5,-35> ,<0,0,10> ,<0,-5,35> ,<0,0,-10> ,<0,0,-15> ,<0,0,0> ,<0,0,15> ,<0,0,0> ,<0,0,10> ,<0,0,-10>,<0,0,0> ,<1,1,1> ,<0,0,0>,<0,0,0>},
     { <0.75,1,1> ,<25,0,0> ,<145,-45,-35> ,<25,0,0> ,<145,45,35> ,<65,10,0> ,<-90,0,0> ,<65,-10,0> ,<-90,0,0> ,<30,-30,-60> ,<30,30,60>,<0,0,0> ,<1,1,1>,<-45,0,0> ,<-45,0,0> },
     { <0.75,1,1> ,<145,20,0> ,<210,0,0> ,<145,-20,0> ,<210,0,0> ,<65,10,0> ,<-90,0,0> ,<65,-10,0> ,<-90,0,0> ,<30,-30,-60> ,<30,30,60>,<0,0,0> ,<1,1,1>,<-45,0,0> ,<-45,0,0> }
   }  
#local Pose1=array[7][15]
   {
     { 0,0,0,0,0,0,0,0,0.15,4,0.7,0.01,1,10,0.05},
     { 0,0,0,0,0,0,0,0,0.15,4,0.7,0.01,1,10,0.05},
     { 0,0,0,0,-10,0,0,0,0.15,4,0.7,0.01,1,10,0.05},
     { 0,0,0,0,0,0,0,0,0.15,4,0.7,0.01,1,10,0.05},
     { 0,0,0,0,0,0,0,0,0.15,4,0.7,0.01,1,10,0.05},
     { 0,0,0,0,-15,0,0,0,0.15,4,0.7,0.01,1,10,0.05},
     { 0,0,0,0,45,0,0,0,0.15,4,0.7,0.01,1,10,0.05} 
   }  

#local Eye_Colour = Pose[PoseNo][0];
#local RA_S2E     = Pose[PoseNo][1];  
#local RA_E2W     = Pose[PoseNo][2];  
#local LA_S2E     = Pose[PoseNo][3];  
#local LA_E2W     = Pose[PoseNo][4];    
#local RL_H2K     = Pose[PoseNo][5];  
#local RL_K2A     = Pose[PoseNo][6];  
#local LL_H2K     = Pose[PoseNo][7]; 
#local LL_K2A     = Pose[PoseNo][8];    
#local RH_Rot     = Pose[PoseNo][9];  
#local LH_Rot     = Pose[PoseNo][10];
#local Hair_Rot   = Pose[PoseNo][11];
#local Hair_Col   = Pose[PoseNo][12];
#local RF_Rot     = Pose[PoseNo][13];
#local LF_Rot     = Pose[PoseNo][14]; 
#local Eye_Lid    = Pose1[PoseNo][0]; 
#local Eye_Rot    = Pose1[PoseNo][1];  
#local Lip_Size   = Pose1[PoseNo][2];         
#local Head_Twist = Pose1[PoseNo][3];
#local Head_Tip   = Pose1[PoseNo][4];
#local Head_Tilt  = Pose1[PoseNo][5];
#local Hair_On    = Pose1[PoseNo][6];
#local Hair_Arch  = Pose1[PoseNo][7];
#local Hair_Thck  = Pose1[PoseNo][8];
#local Hair_Line  = Pose1[PoseNo][9];
#local Hair_LDpth = Pose1[PoseNo][10];
#local Hair_Wght  = Pose1[PoseNo][11];
#local Hair_Hght  = Pose1[PoseNo][12];
#local Hair_Length= Pose1[PoseNo][13];
#local Hair_Curl  = Pose1[PoseNo][14];

#end

#local Blob_Man= union {
        object { head( Build,Eye_Colour,Eye_Lid,Eye_Rot,Lip_Size,Skin,Head_Twist,Head_Tip,Head_Tilt ) }
        object {torso( Build,Skin,RA_S2E,RA_E2W,LA_S2E,LA_E2W,RL_H2K,RL_K2A,LL_H2K,LL_K2A ) }
        object {hands( Build,Skin,RA_S2E,RA_E2W,LA_S2E,LA_E2W,RH_Rot,LH_Rot ) }
        object { feet( Build,Skin,RL_H2K,RL_K2A,LL_H2K,LL_K2A,RF_Rot,LF_Rot ) }
        object { hair( Hair_On,Hair_Rot,Hair_Col,Hair_Arch,Hair_Thck,Hair_Line,Hair_LDpth,Hair_Wght,Hair_Hght,Hair_Length,Hair_Curl,Head_Twist,Head_Tip,Head_Tilt ) }
}      

/****************************************************************
 Lights, Camera and Setting
*****************************************************************/
camera{location <0,-40,-100> orthographic look_at <0,-40,0> }
light_source{<-200,200,-200> rgb <1,.9,.5> }      
light_source{< 400,400,-200> rgb <.2,.4,.8> shadowless }      
light_source{<-200,200,-200> rgb .7         shadowless }      
light_source{< 100, 50,-150> rgb .5         shadowless }
light_source{< 100,-50,-150> rgb .3         shadowless }
light_source{<-100,-50,-150> rgb .1         shadowless }    
background {rgb 0}
 
/****************************************************************
 The Models
****************************************************************/
object {Blob_Man              translate x*-15 }        
object {Blob_Man rotate y*180 translate x* 45 }
object {Blob_Man rotate y* 90 translate x*-45 }                                
object {Blob_Man rotate y*-90 translate x* 15 }                                
object {Blob_Man rotate x*-90 translate y*-75 translate x*-15 }
object {Blob_Man rotate y*180 rotate x*90     translate y*-75 translate x* 45 } 

// EOF