#include "oocore.inc"
#include "collections.inc"

// == class MyClass =========================
#declare MyClass = class
(
    "MyClass", 
    no,
    None,
    array
    {
        array mixed {"property1", TYPES._int_},
        array mixed {"property2", TYPES._string_}
    },
    array 
    {
        "method1",
        "method2"
    }
)

// Define 2 overloaded constructors used through the 'new' macro in "oocore.inc".
// Default constructor, with signature number = 0.
//
// new_MyClass(this, property1, property2)
#macro new_MyClass(this, optional params_dict)
    #ifdef (local.params_array)
        #local this.property1 = check(params_dict.property1, TYPES._int_);
        #local this.property2 = check(params_dict.property2, TYPES._string_);
    #else
        #local this.property1 = 0;
        #local this.property2 = "default string";
    #end
#end

// Overloaded constructor #1, with signature number = 1.
// new_1_MyClass(this, property1, property2, _offset)
#macro new_1_MyClass(this, optional params_dict)
    // By hand : check parameter types, then link methods to the class to get the instance.
    #local p1 = check(params_dict.property1, TYPES._int_);
    #local p2 = check(params_dict.property2, TYPES._string_);
    #local offset_ = check(params_dict.offset_, TYPES._vector_);
    
    #local this.property1 = p1 + vlength(offset_);
    #local this.property2 = concat(p2, " ", vstr(5, offset_, ",", 0, 0));
#end


// Instance dump method, used through the 'dump' macro in "oocore.inc".
#macro MyClass_dump(this, indent_level)
    #debug concat(indent[indent_level], "instance of \"", this.class.classname, "\"\n")
    #debug "{\n"
    #debug concat(indent[indent_level+1], ".class : ", this.class.classname, "\n")
    #debug concat(indent[indent_level+1], ".property1 : ", str(this.property1, 0, 0), "\n")
    #debug concat(indent[indent_level+1], ".property2 : ", this.property2, "\n")
    #debug concat(indent[indent_level+1], ".method1() : ", this.method1, "\n")
    #debug concat(indent[indent_level+1], ".method2() : ", this.method2, "\n")
    #debug "}\n"
#end


// Default 'method1' method, used through the 'call' macro in oocore.inc".
// MyClass_method1(this, p1, p2)
#macro MyClass_method1(this, optional params_dict)
    #local p1 = check(params_dict.property1, TYPES._int_);
    #local p2 = check(params_dict.property2, TYPES._string_);
    
    #debug concat("==> ", this.method1, "(p1 = ", str(p1, 0, 0), " (int), p2 = ", p2, " (string))\n")
    
    #debug "executing ...\n"
    #debug concat("this.property1 = ", str(this.property1, 0, 0), "\n")
    #debug concat("this.property2 = \"", this.property2, "\"\n")
    
    #debug concat("<== ", this.method1, "\n")
#end


// Overloaded 'method1' method #1, used through the 'call' macro in oocore.inc".
// MyClass_method1_1(this, p1, p2, p3)
#macro MyClass_method1_1(this, optional params_dict)
    #local p1 = check(params_dict.property1, TYPES._int_);
    #local p2 = check(params_dict.property2, TYPES._string_);
    #local p3 = check(params_dict.pigment_, TYPES._pigment_);
    
    #debug concat("==> ", this.method1, "_1(p1 = ", str(p1, 0, 0), " (int), p2 = \"", p2, "\" (string), p3 = pigment {})\n")
    
    #debug "executing ...\n"
    #debug concat("this.property1 = ", str(this.property1, 0, 0), "\n")
    #debug concat("this.property2 = \"", this.property2, "\"\n")
    
    #debug concat("<== ", this.method1, "\n")
#end

// Default 'method2' method, used through the 'call' macro in oocore.inc".
// MyClass_method2(this, p1)
#macro MyClass_method2(this, optional params_dict)
    #local p1 = check(params_dict.p1, TYPES._vector_);
    
    #debug concat("==> ", this.method2, "(p1 = <", vstr(3, p1, ", ", 0, 0), "> (vector)\n")
    
    #debug "executing ...\n"
    
    #debug concat("this.property1 = ", str(this.property1, 0, 0), "\n")
    #debug concat("this.property2 = \"", this.property2, "\"\n")
    
    #debug concat("<== ", this.method2, "\n")
#end
// ===========================================

// Using MyClass
describe(MyClass,)

// Get 2 instances of MyClass, using the 2 provided constructors.
#declare my_instance = new(MyClass, 0, dictionary {.property1 : 0, .property2 : "text"});
dump(my_instance,)

#declare my_instance2 = new(MyClass, 1, dictionary {.property1 : 0, .property2 : "text", .offset_ : x + y});
dump(my_instance2, )

// Call all the versions of the overloaded 'method1' method of class 'MyClass'.
call(my_instance.method1,, my_instance, dictionary {.property1 : 0, .property2 : "text"})
call(my_instance.method1, 1, my_instance, dictionary {.property1 : 0, .property2 : "text", .pigment_ : pigment{Yellow}})

// Call all 'method3' method of class 'MyClass'.
call(my_instance.method2,, my_instance, dictionary {.p1 : <0, 1, 3>})



// == class Derived =========================
#declare Derived = class
(
    "Derived",
    yes,
    MyClass,
    array
    {
        array mixed {"property3", TYPES._vector_}
    },
    array 
    {
        "method3"
    }
)

describe(Derived,)

// Instance dump method., used through the 'dump' macro in "oocore.inc".
#macro new_Derived(this, optional params_dict)
    #debug "==> new_Derived()\n"
  
    super(this,, params_dict)
    
    #ifdef (local.params_array)
        #local offset_ = check(params_dict.offset_, TYPES._vector_);
    #else
        #local offset_ = 0;
    #end
    #local this.property1 = this.property1 + vlength(offset_);
    #local this.property2 = concat(this.property2, " ", str(2*vlength(offset_), 0, 4));
    #local this.property3 = offset_;
    
    #debug "<== new_Derived()\n"
#end

#macro Derived_dump(this, indent_level)
    #debug concat(indent[indent_level], "instance of \"", this.class.classname, "\"\n")
    #debug "{\n"
    #debug concat(indent[indent_level+1], ".class : ", this.class.classname, "\n")
    #debug concat(indent[indent_level+1], ".property1 : ", str(this.property1, 0, 0), "\n")
    #debug concat(indent[indent_level+1], ".property2 : ", this.property2, "\n")
    #debug concat(indent[indent_level+1], ".property3 : <", vstr(3, this.property3, ", ", 0, 6), ">\n")
    #debug concat(indent[indent_level+1], ".method1() : ", this.method1, "\n")
    #debug concat(indent[indent_level+1], ".method2() : ", this.method2, "\n")
    #debug concat(indent[indent_level+1], ".method3() : ", this.method3, "\n")
    #debug "}\n"
#end

#macro Derived_method2(this, params_dict)
    #debug "Derived_method2()\n"
#end

#macro Derived_method3(this, params_dict)
    #debug "Derived_method3()\n"
#end
// ===========================================

#declare my_derived_intance = new(Derived,, dictionary {.propery1 : 33, .property2 : "zorg", .offset_ : <0,1,2>});
dump(my_derived_intance,)


// == class Derived2 =========================
#declare Derived2 = class
(
    "Derived2",
    yes,
    Derived,
    array {}, // no more properties
    array {}  // no more methods
)

describe(Derived2,)

// Instance dump method., used through the 'dump' macro in "oocore.inc".
#macro new_Derived2(this, optional params_dict)
    #debug "==> new_Derived2()\n"
  
    super(this,, params_dict)
        
    #debug "<== new_Derived2()\n"
#end

#macro Derived2_dump(this, indent_level)
    #debug concat(indent[indent_level], "instance of \"", this.class.classname, "\"\n")
    #debug "{\n"
    #debug concat(indent[indent_level+1], ".class : ", this.class.classname, "\n")
    #debug concat(indent[indent_level+1], ".property1 : ", str(this.property1, 0, 0), "\n")
    #debug concat(indent[indent_level+1], ".property2 : ", this.property2, "\n")
    #debug concat(indent[indent_level+1], ".property3 : <", vstr(3, this.property3, ", ", 0, 6), ">\n")
    #debug concat(indent[indent_level+1], ".method1() : ", this.method1, "\n")
    #debug concat(indent[indent_level+1], ".method2() : ", this.method2, "\n")
    #debug concat(indent[indent_level+1], ".method3() : ", this.method3, "\n")
    #debug "}\n"
#end

#macro Derived2_method3(this, optional params_dict)
    #debug "Derived2_method3()\n"
#end

// ===========================================

#declare my_derived2_intance = new(Derived2,, dictionary {.property1 : 33, .property2 : "zorg", .offset_ : <0,1,2>});
dump(my_derived2_intance, 0)
call(my_derived2_intance.method3,, my_derived2_intance,)

#debug concat("isinstance(my_derived2_intance, Derived2) : ", str(instanceof(my_derived2_intance, Derived2), 0, 0), "\n")
#debug concat("isinstance(my_derived2_intance, Derived) : ", str(instanceof(my_derived2_intance, Derived), 0, 0), "\n")
#debug concat("isinstance(my_derived2_intance, MyClass) : ", str(instanceof(my_derived2_intance, MyClass), 0, 0), "\n")

// == class Junk =============================
#declare Junk = class
(
    "Junk",
    yes,
    Derived,
    array {}, // no more properties
    array {}  // no more methods
)

#macro Junk_dump(this, indent_level)
    Derived_dump(this, indent_level)
#end

#macro new_Junk(this, optional params_dict)
    super(this,, params_array)
#end

#debug concat("isinstance(my_derived2_intance, Junk) : ", str(instanceof(my_derived2_intance, Junk), 0, 0), "\n")

describe(Junk,)

#declare my_junk = new(Junk,,)
dump(my_junk,)

//#error "============= STOP HERE ================="
