camera {  //  Camera StdCam
  location  <-8, -7, 3.6>
  direction <0.0,     0.0,  2.3576>
  sky       <0.0,     0.0,  1.0>  // Use right handed-system!
  up        <0.0,     0.0,  1.0>  // Where Z is up
  right     <1.33333,  0.0,  0.0>
  look_at   <-1, 0.000, 0.000>
}

plane { z,-100
pigment { color rgb <0,0,0>}
finish { ambient 0 }
}
//background { color rgb <0.1,0.5,0.7>}

#global_settings {
max_trace_level 50 
max_intersections 100
}
// *******  L I G H T S *******

light_source {   // Spotlight SpotL001
  <-4.9, -8.400, 6.000>
  color  rgb <0.97,0.97,1>*1.3
  area_light <2.989, 0.262, -0.013>, <-0.093, 1.144, 1.638>, 10, 10
  adaptive 3
  cylinder
    point_at  <-1, 0, 0>
    falloff   40  // outer radius (in deg)
      radius   30  // inner radius
      tightness 17
} 

#include "de.inc"

#declare CSG001 = intersection {
  box { // Cube001
    <-1, -1, -1>, <1, 1, 1>
  }
  sphere { // Sphere001
    <0,0,0>,1
    scale 1.5
  }
  texture {
    Gold_Texture1
  }
}
#declare CSG3 = union {
  sphere { // Sphere8
    <0,0,0>,1
    scale 0.15
    translate  <-0.5, -1.0, 0.5>
  }
  sphere { // Sphere9
    <0,0,0>,1
    scale 0.15
    translate  <0.0, -1.0, 0.5>
  }
  sphere { // Sphere10
    <0,0,0>,1
    scale 0.15
    translate  <0.5, -1.0, 0.5>
  }
  sphere { // Sphere11
    <0,0,0>,1
    scale 0.15
    translate  <-0.5, -1.0, -0.5>
  }
  sphere { // Sphere12
    <0,0,0>,1
    scale 0.15
    translate  <0.0, -1.0, -0.5>
  }
  sphere { // Sphere13
    <0,0,0>,1
    scale 0.15
    translate  <0.5, -1.0, -0.5>
  }
  rotate -90.0*z
}
#declare CSG4 = union {
  sphere { // Sphere14
    <0,0,0>,1
    scale 0.15
    translate  <-0.5, -1.0, 0.5>
  }
  sphere { // Sphere15
    <0,0,0>,1
    scale 0.15
    translate  <0.0, -1.0, 0.5>
  }
  sphere { // Sphere16
    <0,0,0>,1
    scale 0.15
    translate  <0.5, -1.0, 0.5>
  }
  sphere { // Sphere17
    <0,0,0>,1
    scale 0.15
    translate  <-0.5, -1.0, -0.5>
  }
  sphere { // Sphere18
    <0,0,0>,1
    scale 0.15
    translate  <0.0, -1.0, -0.5>
  }
  sphere { // Sphere19
    <0,0,0>,1
    scale 0.15
    translate  <0.5, -1.0, -0.5>
  }
  rotate -90.0*x
}
#declare CSG002 = union {
  sphere { // Sphere4
    <0,0,0>,1
    scale 0.15
    translate  <-0.5, -1.0, 0.5>
  }
  sphere { // Sphere3
    <0,0,0>,1
    scale 0.15
    translate  <0.0, -1.0, 0.5>
  }
  sphere { // Sphere002
    <0,0,0>,1
    scale 0.15
    translate  <0.5, -1.0, 0.5>
  }
  sphere { // Sphere5
    <0,0,0>,1
    scale 0.15
    translate  <-0.5, -1.0, -0.5>
  }
  sphere { // Sphere6
    <0,0,0>,1
    scale 0.15
    translate  <0.0, -1.0, -0.5>
  }
  sphere { // Sphere7
    <0,0,0>,1
    scale 0.15
    translate  <0.5, -1.0, -0.5>
  }
  object { CSG3 }
  object { CSG4 }
  texture {
    noir
  }
}
#declare de=
difference { // CSG003
  object { CSG001 }
  object { CSG002 }
  texture { noir }
  bounded_by { // Bound00001
    box {
      <-1.0, -1.0, -1.0>, <1.0, 1.0, 1.0>
      
    }
  }
rotate z*-20
}


object { de }
  
#declare surf=
merge { 
        box { <0,0,0.7>,<1,1,1.3> }
        cylinder { <0,0,1>,<1,0,1,>,0.3 }
        cylinder { <1,0,1>,<1,1,1>,0.3 }
        cylinder { <1,1,1>,<0,1,1>,0.3 }
        cylinder { <0,1,1>,<0,0,1>,0.3 }
        sphere { <0,0,1>,0.3 }
        sphere { <1,0,1>,0.3 } 
        sphere { <1,1,1>,0.3 } 
        sphere { <0,1,1>,0.3 } 
pigment { color rgb <0.4,0.1,0.6> }
finish { ambient 0 phong 0.2 phong_size 30 reflection 0.1 }
//finish { reflection 0.1 brilliance 2 }
scale <0.6,0.6,0.6>
translate <0,0,-1.78>
}


#declare suite=union {
#declare xx=-3
#while (xx<15)
object { surf translate <xx,0,0>}
#declare xx=xx+0.8
#end
}

#declare yy=-1
#while (yy<12)
object { suite translate <0,yy,0>}
#declare yy=yy+0.8
#end

#declare zz=0
#while (zz>-3)
object { suite rotate x*-90 translate <0,0.2,-1.28> //0,-0.3,-0.7
        translate <0,0,zz> }
#declare zz=zz-0.8
#end

#include "diam.in1"

object { diamant  scale 0.6 rotate z*-20 translate <-3,-1.78,0>
pigment { color rgbf <0.9,0.9,0.98,0.98>}
finish { refraction on
        ior 1.7
        caustics 1}
}
  
