#version 3.7;

#local UseRadiosity = no;

global_settings {
   assumed_gamma 2.2
   charset utf8
   max_trace_level 20
   #if (UseRadiosity)
      radiosity {
         pretrace_start .08
         pretrace_end .004
         count 200
         error_bound .002
         recursion_limit 2
         normal on
      } //radiosity
   #end //#if
} //global_settings

#include "colors.inc"
#include "BorderChars_Definitions.inc"
#include "BorderChars_Styles.inc"

#local CameraX = 0;
#local CameraY = 0;
#local CameraZ = 5.5;

camera {
   location <CameraX, CameraY, -CameraZ>
   direction <0, 0, 1>
   rotate -60 * x
   look_at <CameraX, CameraY - 1.5, 0>
} //camera

#if (UseRadiosity)
   #local Dome = object {
      difference {
         sphere {0, 20001}
         sphere {0, 20000}
      } //difference
      texture {
         pigment {
            gradient z
            color_map {
               [0, 1 color White * 2.21 color White * .6]
            } //color_map
         } //pigment
         finish {emission 1 diffuse 0}
         scale <1, 1, 20000>
      } //texture
      no_reflection
   } //object
   object {Dome}
#else
   light_source {<60, 80, -200> color White * 1.65 shadowless}
#end //#if

#declare Color1 = color <.3416, .3452, .4411> * 1.05; //Bottom/Outside
#declare Color2 = color <.5732, .8248, .9068> * 1.05; //Top/Inside

#declare TextColor_Outer = texture {pigment {color White}}

#declare TextColor_Inner = texture {
   pigment {
      gradient y
      color_map {
         [0 color Color1]
         [.55 (Color1 + Color2) / 2]
         [1 color Color2]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

#declare TextColor_Back = texture {pigment {color Black}}

#local BackgroundColor = texture {
   pigment {checker color (<96, 56, 13> / 255 * 1.5 + White * 4) / 5 color (<.8193, .7094, .5103> + White * 4) / 5}
   #local S = 1.5;
   scale <S, S, 1>
} //texture

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * THE SCENE                                                                                                       * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#local LeftMargin = -2.25;
#local TopMargin = 1;
#local ZOffset = -.1;

#local DX = 1.5;
#local DY = DX;

#local Grid = object {
   union {
      #local CurChar = 15;
      #local Style = 0;
      #for (I, 0, 3)
         #for (J, 0, 3)
            #if (I < 3 | J = 1 | J = 2)
               #local GridX = J * DX;
               #local GridY = -I * DY;
               #switch (Style)
                  #case (0) //Plain
                     #local TextDepth = .08;
                     #local BorderWidth = 0;
                     Stylize (CurChar, Style, TextDepth, BorderWidth, -999, -999, -999)
                     #break
                  #case (1) //Raised center
                     #local TextDepth = .08;
                     #local BorderWidth = .03;
                     #local BorderHeight = .025;
                     Stylize (CurChar, Style, TextDepth, BorderWidth, BorderHeight, -999, -999)
                     #break
                  #case (2) //Lowered center
                     #local TextDepth = .08;
                     #local BorderWidth = .03;
                     #local BorderDepth = .025;
                     Stylize (CurChar, Style, TextDepth, BorderWidth, BorderDepth, -999, -999)
                     #break
                  #case (3) //Striped
                     #local TextDepth = .08;
                     #local BorderWidth = .03;
                     #local StripeWidth = .02;
                     #local StripeHeight = 0;
                     Stylize (CurChar, Style, TextDepth, BorderWidth, StripeWidth, StripeHeight, -999)
                     #break
                  #case (4) //Color gradient
                     #local TextDepth = .08;
                     #local BorderWidth = .03;
                     #local StripeWidth = .04;
                     #local NSteps = 7;
                     Stylize (CurChar, Style, TextDepth, BorderWidth, StripeWidth, NSteps, -999)
                     #break
                  #case (5) //Hollow stripe
                     #local TextDepth = .08;
                     #local BorderWidth = .03;
                     #local StripeWidth = .02;
                     #local StripeDepth = .015;
                     Stylize (CurChar, Style, TextDepth, BorderWidth, StripeWidth, StripeDepth, -999)
                     #break
                  #case (6) //Hollow inside
                     #local TextDepth = .08;
                     #local BorderWidth = .03;
                     Stylize (CurChar, Style, TextDepth, BorderWidth, -999, -999, -999)
                     #break
                  #case (7) //Angled bevel
                     #local TextDepth = .08;
                     #local BorderHeight = .05;
                     #local NSteps = 5;
                     Stylize (CurChar, Style, TextDepth, BorderHeight, NSteps, -999, -999)
                     #break
                  #case (8) //Rounded bevel
                     #local TextDepth = .08;
                     #local BorderHeight = .05;
                     #local NSteps = 7;
                     Stylize (CurChar, Style, TextDepth, BorderHeight, NSteps, -999, -999)
                     #break
                  #case (9) //Solid hourglass (convex)
                     #local TextDepth = .2;
                     #local EffectWidth = .04;
                     #local NSteps = 17;
                     Stylize (CurChar, Style, TextDepth, EffectWidth, NSteps, -999, -999)
                     #break
                  #case (10) //Hollow hourglass (convex)
                     #local TextDepth = .2;
                     #local EffectWidth = .04;
                     #local WallThickness = .02;
                     #local NSteps = 17;
                     Stylize (CurChar, Style, TextDepth, EffectWidth, WallThickness, NSteps, -999)
                     #break
                  #case (11) //Hollow hourglass (concave)
                     #local TextDepth = .2;
                     #local EffectWidth = .04;
                     #local WallThickness = .02;
                     #local NSteps = 17;
                     Stylize (CurChar, Style, TextDepth, EffectWidth, WallThickness, NSteps, -999)
                     #break
                  #case (12) //Solid half-hourglass (concave)
                     #local TextDepth = .08;
                     #local EffectWidth = .04;
                     #local NSteps = 9;
                     Stylize (CurChar, Style, TextDepth, EffectWidth, NSteps, -999, -999)
                     #break
                  #range (13, 999)
                     #local TextDepth = .08;
                     #local BorderWidth = 0;
                     Stylize (CurChar, 0, TextDepth, BorderWidth, -999, -999, -999)
               #end //#switch
               object {Character translate <GridX - CharacterWidth / 2, GridY, 0>}
               #if (Style < 10)
                  Stylize (Style + 52, 0, .04, 0, -999, -999, -999)
                  object {Character scale <.3, .3, 1> translate <GridX + .05, GridY, 0>}
               #else
                  Stylize (int (Style / 10) + 52, 0, .04, 0, -999, -999, -999)
                  object {Character scale <.3, .3, 1> translate <GridX + .05, GridY, 0>}
                  Stylize (mod (Style, 10) + 52, 0, .04, 0, -999, -999, -999)
                  object {Character scale <.3, .3, 1> translate <GridX + .05 + .18, GridY, 0>}
               #end //#if
               #local Style = Style + 1;
            #end //#if
         #end //#for
      #end //#for
   } //union
} //object

#local Background = object {
   plane {
      z, 0 inverse
      texture {BackgroundColor translate <LeftMargin - S / 2, DY / 2 + .2, 0>}
   } //plane
} //object

object {Grid translate <LeftMargin, TopMargin, ZOffset>}

object {Background}
