#version 3.7;

#local UseRadiosity = no;

global_settings {
   assumed_gamma 2.2
   charset utf8
   max_trace_level 20
   #if (UseRadiosity)
      radiosity {
         pretrace_start .08
         pretrace_end .004
         count 200
         error_bound .002
         recursion_limit 2
         normal on
      } //radiosity
   #end //#if
} //global_settings

#include "colors.inc"
#include "BorderChars_Definitions.inc"
#include "BorderChars_Macros.inc"
#include "BorderChars_Styles.inc"

#local CameraX = 0;
#local CameraY = 0;
#local CameraZ = 9.5;

camera {
   location <CameraX, CameraY, -CameraZ>
   direction <0, 0, 1>
   look_at <CameraX, CameraY, 0>
} //camera

#if (UseRadiosity)
   #local Dome = object {
      difference {
         sphere {0, 20001}
         sphere {0, 20000}
      } //difference
      texture {
         pigment {
            gradient z
            color_map {
               [0, 1 color White * 2.21 color White * .6]
            } //color_map
         } //pigment
         finish {emission 1 diffuse 0}
         scale <1, 1, 20000>
      } //texture
      no_reflection
   } //object
   object {Dome}
#else
   light_source {<60, 80, -200> color White * 1.65 shadowless}
#end //#if

#declare TextColor_Outer = texture {pigment {color White}}

#declare Color1 = color <.3416, .3452, .4411> * 1.05; //Bottom
#declare Color2 = color <.5732, .8248, .9068> * 1.05; //Top

#declare TextColor_Inner = texture {
   pigment {
      gradient y
      color_map {
         [0 color Color1]
         [.55 (Color1 + Color2) / 2]
         [1 color Color2]
      } //color_map
   } //pigment
   finish {emission .1}
   #local YScaleAdd_Bottom = .75 / 2 * .95; //Height of the bottom of the "g"
   #local YScaleAdd_Top = .075; //Height of the top of the "*"
   scale <1, 1 + YScaleAdd_Bottom + YScaleAdd_Top, 1>
   translate -YScaleAdd_Bottom * y
} //texture

#declare TextColor_Back = texture {pigment {color Black}}

#local BackgroundColor = texture {pigment {color (<96, 56, 13> / 255 * 1.5 + White * 4) / 5}}

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * THE SCENE                                                                                                       * */
/* *                                                                                                                 * */
/* *                                                                                                                 * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#declare LEFT = 0;
#declare RIGHT = 1;
#declare CENTERED = 2;
#declare JUSTIFIED = 3;

#local TextScale = 1;

#declare GAP_Width = .06 / TextScale * 1;
#declare SPACE_Width = .2 / TextScale * 1;
#local LineSpacing = 1.5;

#local Style = 2;
#local TextDepth = .08;
#local BorderWidth = .03;
#local BorderDepth = .05;

#for (I, 0, 81)
   Stylize (I, Style, TextDepth, BorderWidth, BorderDepth, -999, -999)
   #local BorderCharacter [I] = object {Character}
#end //#for

#local LineAlignment = LEFT; //Choices are "LEFT," "RIGHT," "CENTERED," or "JUSTIFIED"
#local AlignLastLine = yes; //Only meaningful when LineAlignment = JUSTIFIED

#declare NLines = 6;

#declare LineText = array [NLines]
#declare LineTextObject = array [NLines]
#declare LineNCharacters = array [NLines]
#declare LineNVisibleCharacters = array [NLines]
#declare LineWidth = array [NLines]
#declare ItalicOffset_Beginning = array [NLines]
#declare LineCharacters = array [NLines] [100]
#declare LineKerning = array [NLines] [99]
#declare LineVisibilityCondition = array [NLines] [100]
#declare LineItalicCondition = array [NLines] [100]

//Use   \"   for quote marks.
//Use   ^    for a heart.

#declare LineText [0] = ".,:;-'\"!?/()[]+=%#*^";
#declare LineText [1] = "0123456789";
#declare LineText [2] = "ABCDEFGHIJKLMN";
#declare LineText [3] = "OPQRSTUVWXYZ";
#declare LineText [4] = "abcdefghijklmnopq";
#declare LineText [5] = "rstuvwxyz";

#declare MaxLineWidth = 0;

#for (I, 0, NLines - 1)
   InitializeLine (I)
   MarkInvisibleCharacters (I)
   ComputeLineWidth (I)
   #declare MaxLineWidth = max (MaxLineWidth, LineWidth [I]);
#end //#for

#for (I, 0, NLines - 1)
   CreateLineTextObject (I, LineAlignment, MaxLineWidth)
#end //#for

#local LeftMargin = -MaxLineWidth / 2;
#local TopMargin = 3.35;
#local ZOffset = -.1;

#local Message = object {
   #if (NLines > 1)
      union {
         #for (I, 0, NLines - 1)
            #switch (LineAlignment)
               #case (LEFT)
                  #local XOffset = 0;
               #break
               #case (RIGHT)
                  #local XOffset = MaxLineWidth - LineWidth [I];
               #break
               #case (CENTERED)
                  #local XOffset = MaxLineWidth / 2 - LineWidth [I] / 2;
               #break
               #case (JUSTIFIED)
                  #local XOffset = 0;
               #break
            #end //#switch
            object {LineTextObject [I] translate <XOffset, -LineSpacing * I, 0>}
         #end //#for
      } //union
   #else
      object {LineTextObject [0]}
   #end //#if
   scale <TextScale, TextScale, 1>
   translate <LeftMargin, TopMargin, ZOffset>
} //object

#local Background = object {
   plane {
      z, 0 inverse
      texture {BackgroundColor}
   } //plane
} //object

object {Message}

object {Background}
