#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house5/house51.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.6}
		normal{
			bump_map{
				jpeg "houses/house5/house51b.jpg"
				map_type 0
			}          
			bump_size -3*3
		}
	#end
}

#declare BalconyTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house5/house52.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.6}
		normal{
			bump_map{
				jpeg "houses/house5/house52b.jpg"
				map_type 0
			}          
			bump_size -3*3
		}
	#end
}

#local Pgm = pigment{
	cells
	color_map{
		[0.0 0.2 color rgb<1, 0.6, 0.4> color rgb<0.8, 0.4, 0.2>]
		[0.2 0.4 color rgb<1, 0.7, 0.5> color rgb<1, 0.5, 0.3>]
		[0.4 0.8 color rgb<0.9, 0.6, 0.4> color rgb<0.8, 0.4, 0.3>]
		[0.8 1.0 color rgb<1, 0.65, 0.45> color rgb<0.95, 0.55, 0.35>]
	}	
}

#declare ChimneyTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/tower.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.66}
		translate -y*0.5
		scale<0.15, 0.18, 0.15>
	#end
}

#declare Base = height_field {
	jpeg "houses/house5/base5.jpg"
    smooth  
    rotate -x*90
    texture{
    	pigment{
    		image_map{
				jpeg "houses/house5/base5map.jpg"
				map_type 0
			}
    	}
    	finish{phong 0.1 phong_size 70}
    }
     
    scale<1, 1, 0.004>
    translate z*0.001
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.002, 0.07, 0.03> translate<0.01, 0.01, 0.002>}
	object{E5 scale<0.002, 0.07, 0.03> translate<0.04 - 0.002, 0.01, 0.002>}
	object{E5 scale<0.002, 0.07, 0.03> translate<0.02 - 0.001, 0.01, 0.002>}
	object{E5 scale<0.002, 0.07, 0.03> translate<0.03 - 0.001, 0.01, 0.002>}
	object{E3 scale<0.03, 0.002, 0.03> translate<0.01, 0.01, 0.002>}
	object{E3 scale<0.03, 0.002, 0.03> translate <0.01, 0.02 - 0.001, 0.002>}
	object{E3 scale<0.03, 0.002, 0.03> translate <0.01, 0.03 - 0.001, 0.002>}
	object{E3 scale<0.03, 0.002, 0.03> translate <0.01, 0.04 - 0.001, 0.002>}
	object{E3 scale<0.03, 0.002, 0.03> translate <0.01, 0.05 - 0.001, 0.002>}
	object{E3 scale<0.03, 0.002, 0.03> translate <0.01, 0.06 - 0.001, 0.002>}
	object{E3 scale<0.03, 0.002, 0.03> translate <0.01, 0.07 - 0.001, 0.002>}
	object{E3 scale<0.03, 0.002, 0.03> translate <0.01, 0.08 - 0.002, 0.002>}
		
	object{Glass scale<0.03, 0.07, 1> translate<0.01, 0.01, 0.0025>}
}

#declare Window1 = union {  
	object{E5 scale<0.01, 0.09, 0.03>}
	object{E5 scale<0.01, 0.09, 0.03> translate x*0.04}
	object{E3 scale<0.03, 0.01, 0.03> translate x*0.01}
	object{E3 scale<0.03, 0.01, 0.03> translate <0.01, 0.08, 0>}
	                             
	object{WindowFrame1}
}

#declare WindowFrame2 = union {
	object{E5 scale<0.002, 0.14, 0.03> translate<0.01, 0, 0.003>}
	object{E5 scale<0.002, 0.16, 0.03> translate<0.03 - 0.001, 0, 0.003>}
	object{E5 scale<0.002, 0.14, 0.03> translate<0.05 - 0.002, 0, 0.003>}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.02}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.02 - 0.002}
		plane{y, 0}
		translate<0.03, 0.14, 0.003>
	}
	
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.02 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.04 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.06 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.08 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.10 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.12 - 0.001, 0.003>}
	object{E3 scale<0.04, 0.002, 0.03> translate<0.01, 0.14 - 0.002, 0.003>}
	
	object{Glass scale<0.04, 0.14, 1> translate<0.01, 0, 0.0035>}
	object{
		Glass 
		clipped_by{cylinder{<0.5, 0.5, -1>, <0.5, 0.5, 1>, 0.5}} 
		clipped_by{plane{-y, -0.5}}
		translate -y*0.5
		scale<0.04, 0.04, 1>
		translate<0.01, 0.14, 0.0035>
	}
	
}

#declare Window2 = union {
	object{E5 scale<0.005, 0.14, 0.03>}
	object{E5 scale<0.005, 0.14, 0.03> translate<0.005, 0, -0.001>}
	object{E5 scale<0.005, 0.14, 0.03> translate<0.06 - 0.005, 0, 0>}
	object{E5 scale<0.005, 0.14, 0.03> translate<0.05, 0, -0.001>}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.025}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.02}
		plane{y, 0}
		translate<0.03, 0.14, -0.001>
	}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.03}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.025}
		plane{y, 0}
		translate<0.03, 0.14, 0>
	}
	
	object{WindowFrame2}
}

#declare WindowFrame3 = union {
	object{E5 scale<0.002, 0.03, 0.03> translate<0.005, 0.005, 0.002>} 
	object{E5 scale<0.002, 0.03, 0.03> translate<0.02 - 0.001, 0.005, 0.002>}       
	object{E5 scale<0.002, 0.03, 0.03> translate<0.035 - 0.002, 0.005, 0.002>}
	
	object{E5 scale<0.03, 0.002, 0.03> translate<0.005, 0.005, 0.002>}
	object{E5 scale<0.03, 0.002, 0.03> translate<0.005, 0.02 - 0.001, 0.002>}        
	object{E5 scale<0.03, 0.002, 0.03> translate<0.005, 0.035 - 0.002, 0.002>}
	
	object{Glass scale<0.03, 0.03, 1> translate<0.005, 0.005, 0.0025>}
}

#declare Window3 = union {
	object{E5 scale<0.04, 0.005, 0.03>}
	object{E5 scale<0.04, 0.005, 0.03> translate y*0.035}
	object{E5 scale<0.005, 0.04, 0.03>}
	object{E5 scale<0.005, 0.04, 0.03> translate x*0.035}
	
	object{E5 scale<0.05, 0.05, 0.03> translate<-0.005, -0.005, 0.0026>}
	
	object{WindowFrame3}
}

#declare Column = union {
	sphere{0, 0.005 scale<1, 0.7, 1>}
	sphere{0, 0.005 scale<1, 0.7, 1> translate y*0.035}
	sphere{0, 0.005 translate y*0.008}                 
	difference{
		sphere{0, 0.005 scale<1, 6, 1>}
		plane{y, 0}
		translate y*0.008
	}
}

#declare Balcony = union {
	object{E6 scale<0.502, 0.006, 0.1> translate<-0.001, 0.004, -0.05>}
	object{E6 scale<0.48, 0.004, 0.1> translate<0.01, 0, -0.045>}
	
	object{E6 scale<0.5, 0.005, 0.02> translate<0, 0.045, -0.05>}
	
	object{Column translate<0.01, 0.01, -0.04>}
	object{Column translate<0.01 + 0.01, 0.01, -0.04>}
	object{Column translate<0.01 + 0.02, 0.01, -0.04>}
	object{Column translate<0.01 + 0.03, 0.01, -0.04>}
	object{Column translate<0.01 + 0.04, 0.01, -0.04>}
	object{Column translate<0.01 + 0.05, 0.01, -0.04>}
	object{Column translate<0.01 + 0.06, 0.01, -0.04>}
	
	object{E6 scale<0.02, 0.035, 0.01> translate<0.08, 0.01, -0.045>}
	
	object{Column translate<0.11, 0.01, -0.04>}
	object{Column translate<0.11 + 0.01, 0.01, -0.04>}
	object{Column translate<0.11 + 0.02, 0.01, -0.04>}
	object{Column translate<0.11 + 0.03, 0.01, -0.04>}
	object{Column translate<0.11 + 0.04, 0.01, -0.04>}
	object{Column translate<0.11 + 0.05, 0.01, -0.04>}
	object{Column translate<0.11 + 0.06, 0.01, -0.04>}
	
	object{E6 scale<0.02, 0.035, 0.01> translate<0.18, 0.01, -0.045>}
	
	object{Column translate<0.21, 0.01, -0.04>}
	object{Column translate<0.21 + 0.01, 0.01, -0.04>}
	object{Column translate<0.21 + 0.02, 0.01, -0.04>}
	object{Column translate<0.21 + 0.03, 0.01, -0.04>}
	object{Column translate<0.21 + 0.04, 0.01, -0.04>}
	object{Column translate<0.21 + 0.05, 0.01, -0.04>}
	object{Column translate<0.21 + 0.06, 0.01, -0.04>}
	
	object{E6 scale<0.02, 0.035, 0.01> translate<0.28, 0.01, -0.045>}
	
	object{Column translate<0.31, 0.01, -0.04>}
	object{Column translate<0.31 + 0.01, 0.01, -0.04>}
	object{Column translate<0.31 + 0.02, 0.01, -0.04>}
	object{Column translate<0.31 + 0.03, 0.01, -0.04>}
	object{Column translate<0.31 + 0.04, 0.01, -0.04>}
	object{Column translate<0.31 + 0.05, 0.01, -0.04>}
	object{Column translate<0.31 + 0.06, 0.01, -0.04>}
	
	object{E6 scale<0.02, 0.035, 0.01> translate<0.38, 0.01, -0.045>}
	
	object{Column translate<0.41, 0.01, -0.04>}
	object{Column translate<0.41 + 0.01, 0.01, -0.04>}
	object{Column translate<0.41 + 0.02, 0.01, -0.04>}
	object{Column translate<0.41 + 0.03, 0.01, -0.04>}
	object{Column translate<0.41 + 0.04, 0.01, -0.04>}
	object{Column translate<0.41 + 0.05, 0.01, -0.04>}
	object{Column translate<0.41 + 0.06, 0.01, -0.04>}
	
	object{E6 scale<0.01, 0.035, 0.01> translate<0, 0.01, -0.045>}
	object{E6 scale<0.01, 0.035, 0.01> translate<0.49, 0.01, -0.045>}
	
	object{E6 scale<0.02, 0.005, 0.03> translate<0, 0.045, -0.03>}
	object{Column translate<0.01, 0.01, -0.01>}
	object{Column translate<0.01, 0.01, -0.022>}
	
	object{E6 scale<0.02, 0.005, 0.03> translate<0.48, 0.045, -0.03>}
	object{Column translate<0.49, 0.01, -0.01>}
	object{Column translate<0.49, 0.01, -0.022>}
	
	object{E6 scale<0.02, 0.01, 0.03> translate<0.09, -0.01, -0.03>}
	object{E6 scale<0.02, 0.01, 0.03> translate<0.19, -0.01, -0.03>}
	object{E6 scale<0.02, 0.01, 0.03> translate<0.29, -0.01, -0.03>}
	object{E6 scale<0.02, 0.01, 0.03> translate<0.39, -0.01, -0.03>}
	
	texture{BalconyTxt scale<0.51, 0.51/2, 1> translate<-0.005, 0, 0>}
}

#declare Chimney = union {
	cylinder{0, <0, 0.06, 0>, 0.005}
	cone{<0, -0.01, 0>, 0, <0, 0.02, 0>, 0.01 translate y*0.05}
	cylinder{0, <0, 0.007, 0>, 0.01 hollow clipped_by{plane{y, 0.005}} translate y*0.07}
	
	cone{<0, -0.001, 0>, 0.013, <0, 0.01, 0>, 0 clipped_by{plane{-y, 0}} translate y*0.078}
	cylinder{0, <0, 0.01, 0>, 0.0007 translate<0.008, 0.07, 0>}
	cylinder{0, <0, 0.01, 0>, 0.0007 translate<-0.008, 0.07, 0>}
	cylinder{0, <0, 0.01, 0>, 0.0007 translate<0, 0.07, 0.008>}
	cylinder{0, <0, 0.01, 0>, 0.0007 translate<0, 0.07, -0.008>}
	
	texture{ChimneyTxt}
}

#declare Roof = union {
	difference{
		box{0, <0.1, 0.085, 0.24>}
		plane{z, 0.001 texture{BalconyTxt scale<0.51, 0.51/2, 1> translate<-0.1, 0, 0>}}
		plane{x, 0.001 texture{BalconyTxt scale<0.51, 0.51/2, 1> rotate -y*90 translate<0, 0, -0.1>}}
		plane{x, 0 rotate -z*60 translate y*0.025 texture{BalconyTxt rotate y*90 rotate -z*60}}
		translate z*0.15
	}                       
	
	// tile roof
	#include "houses/tileroof.inc"
	object{
		Roof1(20, 0.75, 0.24, 0.128, 25, 6, 1, Pgm, 114)
		translate -z*0.008 
		rotate 90*y
		rotate z*30
		translate <0, 0.025, 0.15 + 0.24>       
	}
	object{
		Roof1(20, 0.75, 0.24/30, 0.24, 1, 11, 0, Pgm, 116) 
		rotate -45*z
		translate<0.115, 0.004, -0.24>
		rotate z*30
		translate <0, 0.026, 0.15 + 0.24>       
	}
	
	difference{
		object{
			Roof1(20, 0.75, 0.18, 0.13, 20, 6, 1, Pgm, 118)
			translate -z*0.01 
			rotate 90*y
			rotate z*30
			translate <0, 0, 0.15>       
		}
		plane{z, 0 rotate x*60}
		translate -x*0.004          
	}
	
	difference{
		object{
			Roof1(20, 0.75, 0.51, 0.13, 40, 6, 1, Pgm, 120)
			translate -z*0.01 
			rotate -x*30
		}
		plane{x, 0 rotate -z*60}
		plane{-x, 0 rotate z*60 translate x*0.51}
		translate -x*0.006
		translate -x*0.004          
	}
	
	object{
		Roof1(25, 0.75, 0.24/23, 0.173, 1, 9, 0, Pgm, 122)
		translate -x*(0.24/28/2)
		translate -z*0.013 
		rotate -90*x
		rotate y*40
		rotate -z*40 
		rotate x*60
		translate -x*0.004
	}
	
	object{
		Roof1(20, 0.75, 0.24/24, 0.2, 1, 3, 0, Pgm, 124)
		rotate -z*20
		translate<0.103, 0.0614, 0.106>
		translate -x*0.01
	} 
	
	object{Chimney translate<0.12, 0.06, 0.2>}
	object{Chimney translate<0.25, 0.04, 0.15>}
	object{Chimney translate<0.35, 0.04, 0.15>}
}

#declare House5 = union {
	// facade
	difference {
		object{E1 scale<0.5, 0.93, 1> translate -y*0.1}
		box{<0.21, -1, -1>, <0.29, 0.21, 1>}
		cylinder{<0.25, 0.21, -1>, <0.25, 0.21, 1>, 0.04} 
	}
	
	// basement
	difference {
		object{Base scale<0.52, 0.197, 1> translate<-0.01, -0.1, 0>}
		
		plane{-z, 0 translate z*0.002}
		plane{x, 0 rotate y*45}
		plane{-x, 0 rotate -y*45 translate x*0.5}
		box{<0.21, -1, -1>, <0.29, 0.21, 1>}
	}
	difference {
		object{Base scale<0.52, 0.197, 1> rotate y*90 translate<0, -0.1, 0.21>}
		
		plane{-x, 0 translate x*0.002}
		plane{z, 0 rotate -y*45}
	}
	
	// top
	object{E1 scale<0.51, 0.4, 1> rotate x*90 translate<-0.005, 0.83, -0.005>}
	object{E6 scale<0.51, 0.01, 0.005> translate<-0.005, 0.79, -0.005>}
	object{E6 scale<0.51, 0.01, 0.005> translate<-0.005, 0.82, -0.005>}
	#local counter=0;  
    #while (counter < 25)
    	object{E5 scale<0.01, 0.01, 0.03> translate<-0.005, -0.005, 0> rotate z*45 translate<0.01 + counter * 0.02, 0.82, -0.004>}
        #local counter = counter + 1;
    #end
    
    // roof
    object{Roof translate y*0.83}
	
	// left wall
	union {
		object{E1 scale<0.4, 0.93, 1> translate -y*0.1 rotate -y*90}
		object{E1 scale<0.08, 0.31, 1> translate -y*0.1 rotate -y*90 translate x*0.21}
		object{E1 scale<0.08, 0.31, 1> translate -y*0.1 rotate -y*90 translate x*0.29}
		difference{
			cylinder{<0.25, 0.21, 0.08>, <0.25, 0.21, 0.1>, 0.04}
			plane{y, 0.21}
		}

		// top
		object{E6 scale<0.005, 0.01, 0.405> translate<-0.005, 0.79, 0>}
		object{E6 scale<0.005, 0.01, 0.405> translate<-0.005, 0.82, 0>}
		
		union{
			object{Window2}
			object{E5 scale<0.082, 0.006, 0.1> translate<-0.011, -0.006, -0.045>}
			object{E5 scale<0.08, 0.006, 0.1> translate<-0.01, -0.01, -0.04>}
			
			object{E6 scale<0.01, 0.034, 0.01> translate<-0.01, 0, -0.04>}
			object{E6 scale<0.01, 0.034, 0.01> translate<0.06, 0, -0.04>}
			
			object{E6 scale<0.082, 0.006, 0.015> translate<-0.011, 0.04 - 0.006, -0.045>}
			
			object{E5 scale<0.011, 0.006, 0.1> translate<-0.011, 0.04 - 0.006, -0.045 + 0.015>}
			object{E5 scale<0.011, 0.006, 0.1> translate<0.06, 0.04 - 0.006, -0.045 + 0.015>}
			
			object{Column translate<0.01, 0, -0.035>}
			object{Column translate<0.02, 0, -0.035>}
			object{Column translate<0.03, 0, -0.035>}
			object{Column translate<0.04, 0, -0.035>}
			object{Column translate<0.05, 0, -0.035>}
			
			object{Column translate<-0.005, 0, -0.01>}
			object{Column translate<-0.005, 0, -0.02>}
			
			object{Column translate<0.065, 0, -0.01>}
			object{Column translate<0.065, 0, -0.02>}
			
			texture{BalconyTxt scale<0.51, 0.51/2, 1> translate<-0.2, 0, 0>}
			
			rotate y*90 
			translate<-0.005, 0.52, 0.08>
		}
		// attic
		object{Window3 rotate y*90 translate<-0.004, 0.73, 0.075>}
		object{Window3 rotate y*90 translate<-0.004, 0.73, 0.175>}
		
		texture{FacadeTxt scale<0.51, 0.93, 1> rotate -y*90 translate<0, -0.1, 0>}      
	}
	
	// bars
	object{E6 scale<0.21, 0.01, 0.05> translate<0.0025, 0.1, -0.005>}
	object{E6 scale<0.205, 0.015, 0.05> translate<0.005, 0.1 - 0.0025, -0.004>}
	object{E6 scale<0.21, 0.01, 0.05> translate<0.29 - 0.0025, 0.1, -0.005>}
	object{E6 scale<0.205, 0.015, 0.05> translate<0.29 - 0.005, 0.1 - 0.0025, -0.004>} 
	// door
	object{E6 scale<0.01, 0.31, 0.01> translate<0.201, -0.1, -0.004>}
	object{E6 scale<0.01, 0.31, 0.01> translate<0.29 - 0.001, -0.1, -0.004>}
	difference{
		cylinder{0, <0, 0, 0.1>, 0.049}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.039}
		plane{y, 0}
		translate<0.25, 0.21, -0.004>
	}
	object{E6 scale<0.21, 0.01, 0.05> translate<0.0025, 0.2, -0.004>}
	object{E6 scale<0.205, 0.015, 0.05> translate<0.005, 0.2 - 0.0025, -0.003>}
	object{E6 scale<0.21, 0.01, 0.05> translate<0.29 - 0.0025, 0.2, -0.004>}
	object{E6 scale<0.205, 0.015, 0.05> translate<0.29 - 0.005, 0.2 - 0.0025, -0.003>}
		
	object{E5 scale<0.495, 0.01, 0.05> translate<0.0025, 0.47, -0.004>}
	object{E5 scale<0.490, 0.015, 0.05> translate<0.005, 0.47 - 0.0025, -0.003>}
	
	object{E5 scale<0.495, 0.01, 0.05> translate<0.0025, 0.7, -0.004>}
	object{E5 scale<0.490, 0.015, 0.05> translate<0.005, 0.7 - 0.0025, -0.003>}
	
	
	// 1st floor
	object{Window1 translate<0.06, 0.13, -0.007>}
	object{Window1 translate<0.39, 0.13, -0.007>}
	
	// 2nd floor
	object{Window2 translate<0.02, 0.28, -0.004>}
	object{Window2 translate<0.12, 0.28, -0.004>}
	object{Window2 translate<0.22, 0.28, -0.004>}
	object{Window2 translate<0.32, 0.28, -0.004>}
	object{Window2 translate<0.42, 0.28, -0.004>}
	
	// 3rd floor
	object{Window2 translate<0.02, 0.52, -0.004>}
	object{Window2 translate<0.12, 0.52, -0.004>}
	object{Window2 translate<0.22, 0.52, -0.004>}
	object{Window2 translate<0.32, 0.52, -0.004>}
	object{Window2 translate<0.42, 0.52, -0.004>}
	
	// attic
	object{Window3 translate<0.03, 0.73, -0.004>}
	object{Window3 translate<0.13, 0.73, -0.004>}
	object{Window3 translate<0.23, 0.73, -0.004>}
	object{Window3 translate<0.33, 0.73, -0.004>}
	object{Window3 translate<0.43, 0.73, -0.004>}
	
	// Stairway
	union{
		object{E6 scale<0.08, 0.11, 0.08> translate<0.21, -0.1, 0>}
		object{E6 scale<0.08, 0.01, 0.08> translate<0.21, 0.01, 0.01>}
		object{E6 scale<0.08, 0.01, 0.08> translate<0.21, 0.02, 0.02>}
		object{E6 scale<0.08, 0.01, 0.08> translate<0.21, 0.03, 0.03>}
		object{E6 scale<0.08, 0.01, 0.08> translate<0.21, 0.04, 0.04>}
		object{E6 scale<0.08, 0.01, 0.08> translate<0.21, 0.05, 0.05>}
		object{E6 scale<0.08, 0.01, 0.08> translate<0.21, 0.06, 0.06>}
	}
	  
	// Door
	object{E1 scale<0.08, 0.14, 1> translate<0.21, 0.07, 0.08>}
	
	// Balconies
	object{Balcony translate<0, 0.27, 0>}
	object{Balcony translate<0, 0.51, 0>}
	
	texture{FacadeTxt scale<0.51, 0.93, 1> translate<-0.005, -0.1, 1>}
}