#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house3/house31.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.64}
		normal{
			bump_map{
				jpeg "houses/house3/house31b.jpg"
				map_type 0
			}          
			bump_size 3*-3
		}
	#end
}

#declare SideTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house3/house32.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.64}
		normal{
			bump_map{
				jpeg "houses/house3/house32b.jpg"
				map_type 0
			}          
			bump_size 3*3
		}
	#end
}

#declare PostTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/tower.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.66}
		normal{
			bump_map{
				jpeg "houses/towerb.jpg"
				map_type 0
			}          
			bump_size 3*10
		}
		
		translate -y*0.5
		scale<0.02, 0.11, 0.02>
	#end
}

#declare StairwayTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house3/concrete.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.66}
	#end
}

#declare WindowFrameTxt = texture{
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else 
		#local k = 1.3; 
    	pigment{
    		bozo 
    		color_map{
    			[0.0 0.3 color rgb<0.3, 0.25, 0.16>*k color rgb<0.33, 0.25, 0.16>*k] 
    			[0.3 0.6 color rgb<0.33, 0.25, 0.16>*k color rgb<0.36, 0.25, 0.16>*k]
    			[0.6 1.0 color rgb<0.36, 0.25, 0.16>*k color rgb<0.3, 0.25, 0.16>*k]
    		}
    		scale<0.3, 4.3, 1>
   			scale 0.0008
   		} 
   		finish{diffuse 0.6 phong 0.05 phong_size 85}
   		normal{bumps 0.3 scale<0.0001, 0.001, 0.0001>}
   		
  	#end 
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.004, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.09 - 0.007, 0>}
	
	object{E5 scale<0.003, 0.09 - 0.008, 0.03> translate<0.004, 0.004, 0>} 
	object{E5 scale<0.002, 0.09 - 0.008, 0.03> translate<0.02 - 0.001, 0.004, 0>}
	object{E5 scale<0.003, 0.09 - 0.008, 0.03> translate<0.04 - 0.007, 0.004, 0>}
	
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.015 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.025 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.035 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.045 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.055 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.065 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.075 - 0.003/2, 0>} 

	object{Glass scale<0.03, 0.08, 1> translate<0.005, 0.005, 0.0005>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {
	object{E5 scale<0.04, 0.004, 0.03>}
	object{E5 scale<0.04, 0.004, 0.03> translate <0, 0.09 - 0.004, 0>}
	object{E5 scale<0.004, 0.09 - 0.008, 0.03> translate<0, 0.004, 0>}
	object{E5 scale<0.004, 0.09 - 0.008, 0.03> translate<0.04 - 0.004, 0.004, 0>}
  
	object{WindowFrame1 translate z*0.002}
	
	translate -z*0.004
}

#declare WindowFrame2 = union {
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.004, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.06 - 0.007, 0>}
	
	object{E5 scale<0.003, 0.06 - 0.008, 0.03> translate<0.004, 0.004, 0>} 
	object{E5 scale<0.002, 0.06 - 0.008, 0.03> translate<0.02 - 0.001, 0.004, 0>}
	object{E5 scale<0.003, 0.06 - 0.008, 0.03> translate<0.04 - 0.007, 0.004, 0>}
	
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.015 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.025 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.035 - 0.001, 0>}
	object{E5 scale<0.04 - 0.008, 0.002, 0.03> translate<0.004, 0.045 - 0.001, 0>}
	
	object{Glass scale<0.03, 0.05, 1> translate<0.005, 0.005, 0.0005>}
	texture{WindowFrameTxt}
}

#declare Window2 = union {
	object{E5 scale<0.04, 0.004, 0.03>}
	object{E5 scale<0.04, 0.004, 0.03> translate <0, 0.06 - 0.004, 0>}
	object{E5 scale<0.004, 0.06 - 0.008, 0.03> translate<0, 0.004, 0>}
	object{E5 scale<0.004, 0.06 - 0.008, 0.03> translate<0.04 - 0.004, 0.004, 0>}
	
	object{WindowFrame2 translate z*0.002}
}

#declare WindowFrame3 = union {
	object{E5 scale<0.03 - 0.008, 0.003, 0.03> translate<0.004, 0.004, 0>}
	object{E5 scale<0.03 - 0.008, 0.003, 0.03> translate<0.004, 0.05 - 0.007, 0>}
	
	object{E5 scale<0.003, 0.05 - 0.008, 0.03> translate<0.004, 0.004, 0>} 
	object{E5 scale<0.002, 0.05 - 0.008, 0.03> translate<0.015 - 0.001, 0.004, 0>}
	object{E5 scale<0.003, 0.05 - 0.008, 0.03> translate<0.03 - 0.007, 0.004, 0>}
	
	object{E5 scale<0.03 - 0.008, 0.002, 0.03> translate<0.004, 0.015 - 0.001, 0>}
	object{E5 scale<0.03 - 0.008, 0.002, 0.03> translate<0.004, 0.025 - 0.001, 0>}
	object{E5 scale<0.03 - 0.008, 0.002, 0.03> translate<0.004, 0.035 - 0.001, 0>}
	
	object{Glass scale<0.02, 0.04, 1> translate<0.004, 0.002, 0.0005>}
	texture{WindowFrameTxt}
}

#declare Window3 = union {
	object{E5 scale<0.03, 0.004, 0.03>}
	object{E5 scale<0.03, 0.004, 0.03> translate <0, 0.05 - 0.004, 0>}
	object{E5 scale<0.004, 0.05 - 0.008, 0.03> translate<0, 0.004, 0>}
	object{E5 scale<0.004, 0.05 - 0.008, 0.03> translate<0.03 - 0.004, 0.004, 0>}
	
	object{WindowFrame3 translate z*0.002}
}

#declare Belt = union {
	object{E3 scale<0.405, 0.04, 0.305> translate<-0.0025, 0, -0.0025>}
	object{E3 scale<0.407, 0.005, 0.307> translate<-0.0035, 0.03, -0.0035>}
	object{E3 scale<0.407, 0.005, 0.307> translate<-0.0035, 0.005, -0.0035>}
	
	object{E5 scale<0.012, 0.012, 0.03> translate <-0.012/2, -0.012/2, 0> rotate z*45 translate<0.06, 0.012/2 + 0.014, -0.004>}
	object{E5 scale<0.012, 0.012, 0.03> translate <-0.012/2, -0.012/2, 0> rotate z*45 translate<0.13, 0.012/2 + 0.014, -0.004>}
	object{E5 scale<0.012, 0.012, 0.03> translate <-0.012/2, -0.012/2, 0> rotate z*45 translate<0.20, 0.012/2 + 0.014, -0.004>}
	object{E5 scale<0.012, 0.012, 0.03> translate <-0.012/2, -0.012/2, 0> rotate z*45 translate<0.27, 0.012/2 + 0.014, -0.004>}
	object{E5 scale<0.012, 0.012, 0.03> translate <-0.012/2, -0.012/2, 0> rotate z*45 translate<0.34, 0.012/2 + 0.014, -0.004>}
}

#declare BeltSide = union {
	object{E1 scale<0.305, 0.04, 1> rotate -y*90 translate<-0.0025, 0, -0.0025>}
	object{E1 scale<0.307, 0.005, 1> rotate -y*90 translate<-0.0035, 0.03, -0.0035>}
	object{E1 scale<0.307, 0.005, 1> rotate -y*90 translate<-0.0035, 0.005, -0.0035>}
}

#declare Stairway = union {
	// front
	union {
		object{E1 scale<0.34, 0.11, 1> translate<0.03, -0.1, -0.1>}
		object{E1 scale<0.30, 0.01, 1> translate<0.05, 0.01, -0.08>}
		object{E1 scale<0.26, 0.01, 1> translate<0.07, 0.02, -0.06>}
		
		texture{StairwayTxt scale<0.34, 0.34, 1> translate<0.03, -0.1, 0>}
	}
	
	// sides
	union {
		object{E1 scale<0.1, 0.11, 1> rotate -y*90 translate<0.03, -0.1, -0.1>}
		object{E1 scale<0.1, 0.11, 1> rotate -y*90 translate<0.37, -0.1, -0.1>}
		
		object{E1 scale<0.08, 0.01, 1> rotate -y*90 translate<0.05, 0.01, -0.08>}
		object{E1 scale<0.08, 0.01, 1> rotate -y*90 translate<0.35, 0.01, -0.08>}
		
		object{E1 scale<0.06, 0.01, 1> rotate -y*90 translate<0.07, 0.02, -0.06>}
		object{E1 scale<0.06, 0.01, 1> rotate -y*90 translate<0.33, 0.02, -0.06>}
		
		texture{StairwayTxt scale<0.34, 0.34, 1> rotate -y*90 translate<0, -0.1, -0.1>}
	}
	
	// top
	union {
		object{E1 scale<0.34, 0.1, 1> rotate x*90 translate<0.03, 0.01, -0.1>}
		object{E1 scale<0.30, 0.08, 1> rotate x*90 translate<0.05, 0.02, -0.08>}
		object{E1 scale<0.26, 0.06, 1> rotate x*90 translate<0.07, 0.03, -0.06>}
		
		texture{StairwayTxt scale<0.34, 0.34, 1> rotate x*90 translate<0.03, 0, -0.1>}
	}
	
	// posts
	union {
		cylinder{0, <0, 0.04, 0>, 0.001 translate<0.04, 0.01, -0.08>}
		cylinder{0, <0, 0.04, 0>, 0.001 translate<0.04, 0.01, -0.03>}
		cylinder{0, <0, 0.04, 0>, 0.001 translate<0.36, 0.01, -0.08>}
		cylinder{0, <0, 0.04, 0>, 0.001 translate<0.36, 0.01, -0.03>}
		
		sphere{<0, 0.04, 0>, 0.0016 translate<0.04, 0.01, -0.08>}
		sphere{<0, 0.04, 0>, 0.0016 translate<0.04, 0.01, -0.03>}
		sphere{<0, 0.04, 0>, 0.0016 translate<0.36, 0.01, -0.08>}
		sphere{<0, 0.04, 0>, 0.0016 translate<0.36, 0.01, -0.03>}
		
		texture{PostTxt}
	}
}

#declare Door = union {
	// frame
	object{E5 scale<0.01, 0.1, 0.03>}
	object{E5 scale<0.01, 0.1, 0.03> translate x*0.07} 
	object{E3 scale<0.065, 0.01, 0.03> translate <0.01 - 0.0025, 0.1, 0>}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.04}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.03}
		plane{y, 0}              
		
		translate<0.04, 0.1, 0>
	}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.03}
		plane{y, 0}              
		
		translate<0.04, 0.1, 0.005>
	}
	
	object{E5 scale<0.005, 0.1, 0.03> translate<0.01, 0, 0.003>}
	object{E5 scale<0.01, 0.1, 0.03> translate<0.04 - 0.005, 0, 0.003>}
	object{E5 scale<0.005, 0.1, 0.03> translate<0.065, 0, 0.003>} 
	
	object{E3 scale<0.05, 0.005, 0.03> translate<0.015, 0, 0.003>}
	object{E3 scale<0.05, 0.005, 0.03> translate<0.015, 0.04 - 0.005/2, 0.003>}
	object{E3 scale<0.05, 0.005, 0.03> translate<0.015, 0.1 - 0.005, 0.003>}
	
	object{E1 scale<0.06, 0.1, 1> translate<0.01, 0, 0.0038>}
}

#declare House3 = union {
	// facade
	object{E1 scale<0.4, 0.81, 1> translate -y*0.1}
	
	// left wall
	union {
		object{E1 scale<0.3, 0.81, 1> translate -y*0.1 rotate -y*90}
		 
		// belt
		object{BeltSide translate y*0.18}
		object{BeltSide translate y*0.37}
		object{BeltSide translate y*0.55}
		object{BeltSide translate y*0.71}
		
		texture{SideTxt scale<0.4, 0.85, 1> rotate -y*90 translate<0, -0.1, -0.01>}
	}
	
	// right wall
	object{
		E1 
		scale<0.3, 0.85, 1> 
		translate -y*0.1 
		rotate -y*90
		texture{SideTxt scale<0.4, 0.85, 1> rotate -y*90 translate<0, -0.1, -0.01>}
		translate x*0.4
	}

	// belts
	object{Belt translate y*0.55}
	object{Belt translate y*0.37}
	object{Belt translate y*0.18}  
	  
	// 1st floor
	
	object{Window3 translate<0.02, 0.12, -0.0026>}
	object{Window3 translate<0.02 + 0.05, 0.12, -0.0026>}
	object{Window3 translate<0.02 + 0.10, 0.12, -0.0026>}
	object{Window3 translate<0.25, 0.12, -0.0026>}
	object{Window3 translate<0.25 + 0.05, 0.12, -0.0026>}
	object{Window3 translate<0.25 + 0.10, 0.12, -0.0026>}
	
	 
	// 2nd floor
	object{Window1 translate<0.04, 0.23, 0.0014>}
	object{Window1 translate<0.04 + 0.07, 0.23, 0.0014>}
	object{Window1 translate<0.04 + 0.14, 0.23, 0.0014>}
	object{Window1 translate<0.04 + 0.21, 0.23, 0.0014>}
	object{Window1 translate<0.04 + 0.28, 0.23, 0.0014>}
	                                    
	// 3rd floor  
	
	object{Window1 translate<0.04, 0.42, 0.0014>}
	object{Window1 translate<0.04 + 0.07, 0.42, 0.0014>}
	object{Window1 translate<0.04 + 0.14, 0.42, 0.0014>}
	object{Window1 translate<0.04 + 0.21, 0.42, 0.0014>}
	object{Window1 translate<0.04 + 0.28, 0.42, 0.0014>}
	
	// 4th floor  
	
	object{Window2 translate<0.04, 0.62, -0.0026>}
	object{Window2 translate<0.04 + 0.07, 0.62, -0.0026>}
	object{Window2 translate<0.04 + 0.14, 0.62, -0.0026>}
	object{Window2 translate<0.04 + 0.21, 0.62, -0.0026>}
	object{Window2 translate<0.04 + 0.28, 0.62, -0.0026>}
	
	// roof
	object{Belt translate y*0.71}
	
	// columns
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02, 0.41, -0.0026>}
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02 + 0.07, 0.41, -0.0028>}
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02 + 0.14, 0.41, -0.0028>}
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02 + 0.21, 0.41, -0.0028>}
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02 + 0.28, 0.41, -0.0028>}
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02 + 0.35, 0.41, -0.0028>}
	
	object{Stairway}
	
	object{Door translate<0.16, 0.03, -0.003>}
	
	#include "houses/house3/sunshade1.inc"	                
	object{Sunshade scale<0.019, 0.015, 0.016> translate<0.13, 0.51, -0.003>}       
	
	texture{FacadeTxt scale<0.42, 0.85, 1> translate<-0.01, -0.1, 0>}
}