#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house14/house14.jpg"
				map_type 0
			}
		}
		normal{
			bump_map{
				jpeg "houses/house14/house14.jpg"
				map_type 0
			}          
			bump_size 25*-5
		}
		finish{diffuse 0.6}
	#end
}

#declare WindowFrameTxt = texture{
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else 
		#local k = 1.8; 
    	pigment{
    		bozo 
    		color_map{
    			[0.0 0.3 color rgb<0.3, 0.25, 0.16>*k color rgb<0.33, 0.25, 0.16>*k] 
    			[0.3 0.6 color rgb<0.33, 0.25, 0.16>*k color rgb<0.36, 0.25, 0.16>*k]
    			[0.6 1.0 color rgb<0.36, 0.25, 0.16>*k color rgb<0.3, 0.25, 0.16>*k]
    		}
    		scale<0.3, 4.3, 1>
   			scale 0.0008
   		} 
   		finish{diffuse 0.6 phong 0.05 phong_size 85}
   		normal{bumps 0.3 scale<0.0001, 0.001, 0.0001>}
   		
  	#end 
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.004, 0>}
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.12 - 0.006, 0>}
	
	object{E5 scale<0.002, 0.12 - 0.008, 0.03> translate<0.004, 0.004, 0>} 
	object{E5 scale<0.002, 0.12 - 0.008, 0.03> translate<0.02 - 0.001, 0.004, 0>} 
	object{E5 scale<0.002, 0.12 - 0.008, 0.03> translate<0.04 - 0.001, 0.004, 0>}
	object{E5 scale<0.002, 0.12 - 0.008, 0.03> translate<0.06 - 0.006, 0.004, 0>}
	
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.015 - 0.001, 0>}
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.025 - 0.001, 0>}
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.035 - 0.001, 0>}
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.045 - 0.001, 0>}
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.055 - 0.001, 0>}
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.065 - 0.001, 0>}
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.075 - 0.001, 0>}
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.085 - 0.001, 0>}
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.095 - 0.001, 0>}
	object{E5 scale<0.06 - 0.008, 0.002, 0.03> translate<0.004, 0.105 - 0.001, 0>} 

	object{Glass scale<0.05, 0.11, 1> translate<0.005, 0.005, 0.0005>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {
	object{E5 scale<0.06, 0.004, 0.03>}
	object{E5 scale<0.06, 0.004, 0.03> translate <0, 0.12 - 0.004, 0>}
	object{E5 scale<0.004, 0.12 - 0.008, 0.03> translate<0, 0.004, 0>}
	object{E5 scale<0.004, 0.12 - 0.008, 0.03> translate<0.06 - 0.004, 0.004, 0>}
  
	object{WindowFrame1 translate z*0.002}
	
	translate -z*0.004
}

#declare Window3 = union {
	difference{
		cylinder{0, <0, 0, 0.03>, 0.03}
		plane{y, 0}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.026}
	}
    object{E5 scale<0.058, 0.004, 0.02> translate<-0.029, 0, 0>}
    object{E5 scale<0.004, 0.028, 0.02> translate<-0.002, 0.001, 0>}
    object{
    	Glass 
    	translate<-0.5, -0.5, 0> 
    	clipped_by{cylinder{<0, 0, -1>, <0, 0, 1>, 0.027}}
    	clipped_by{plane{-y, 0}} 
    	translate<0, 0, 0.002>
    }
    
	translate<0.02, 0, -0.003>
}

#declare Balcony = union {
	object{E5 scale<0.18, 0.006, 0.06>}
	object{E5 scale<0.01, 0.004, 0.06> translate<0.005, 0.05, 0>}
	object{E5 scale<0.01, 0.004, 0.06> translate<0.165, 0.05, 0>}
	object{E5 scale<0.15, 0.004, 0.01> translate<0.015, 0.05, 0>}
	
	#local counter=0;  
    #while (counter < 9)
   		object{E6 scale<0.008, 0.044, 0.008> translate<0.005 + (0.02*counter), 0.006, 0.002>}
        #local counter = counter + 1;
    #end
    object{E6 scale<0.008, 0.044, 0.008> translate<0.005, 0.006, 0.04 - 0.008>}
    object{E6 scale<0.008, 0.044, 0.008> translate<0.005, 0.006, 0.025 - 0.008>}
    object{E6 scale<0.008, 0.044, 0.008> translate<0.175 - 0.008, 0.006, 0.04 - 0.008>}
    object{E6 scale<0.008, 0.044, 0.008> translate<0.175 - 0.008, 0.006, 0.025 - 0.008>}
	
	translate -z*0.04
}

#declare House14 = union {
	// facade
	object{E1 scale<0.6, 0.57, 1> translate -y*0.1}
	
	// top
	object{E6 scale<0.6, 0.004, 0.4> translate<0, 0.47, -0.004>}
	object{E6 scale<0.6, 0.006, 0.4> translate<0, 0.474, -0.006>}
	
	// bars
  	object{E5 scale<0.6, 0.06, 0.003> translate<0, 0.06, -0.003>}
  	object{E5 scale<0.56, 0.02, 0.003> translate<0.02, 0.45, -0.003>}
  	
  	object{E5 scale<0.02, 0.35, 0.003> translate<0, 0.12, -0.003>}
  	object{E5 scale<0.02, 0.35, 0.003> translate<0.58, 0.12, -0.003>}
  	object{E5 scale<0.02, 0.33, 0.003> translate<0.19, 0.12, -0.003>}
  	object{E5 scale<0.02, 0.33, 0.003> translate<0.39, 0.12, -0.003>}
  	
  	object{E5 scale<0.6, 0.02, 0.002> translate<0, 0.08, -0.005>}
  	object{E5 scale<0.6, 0.02, 0.002> translate<0, 0.32, -0.005>}
  	
  	object{E5 scale<0.17, 0.06, 0.003> translate<0.02, 0.3, -0.003>}
  	object{E5 scale<0.18, 0.06, 0.003> translate<0.21, 0.3, -0.003>}
  	object{E5 scale<0.17, 0.06, 0.003> translate<0.41, 0.3, -0.003>}
 
	// 1st floor
	object{Window1 translate<0.03, 0.15, 0>}
	object{Window1 translate<0.12, 0.15, 0>}
	object{Window1 translate<0.22, 0.15, 0>}
	object{Window1 translate<0.32, 0.15, 0>}
	object{Window1 translate<0.42, 0.15, 0>}
	object{Window1 translate<0.51, 0.15, 0>}
	
	// attic
	object{Window3 translate<0.08, 0.39, 0>}
	object{Window3 translate<0.27, 0.39, 0>}
	object{Window3 translate<0.46, 0.39, 0>} 
   
	texture{FacadeTxt scale<0.6, 0.48, 1> translate<0, -0.1, 0>}
}