#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = 
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}

#declare WindowFrameTxt = 
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}

#declare TowerTxt = 
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}

#local Pgm = 
pigment {color rgb 1}

#declare Glass = object{
	E1
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}
}

#declare Rect = union {
	object{E5 scale<0.01, 0.05, 0.03>}
	object{E5 scale<0.01, 0.05, 0.03> translate x*0.03}
	object{E5 scale<0.02, 0.01, 0.03> translate x*0.01}
	object{E5 scale<0.02, 0.01, 0.03> translate<0.01, 0.04, 0>}
	translate -z*0.002
}

#declare WindowFrame1 = union {
	object{E5 scale<0.004, 0.12, 0.03> translate<0.01, 0.01, 0.002>}
	object{E5 scale<0.004, 0.12, 0.03> translate<0.03 - 0.002, 0.01, 0.002>}
	object{E5 scale<0.004, 0.12, 0.03> translate<0.05 - 0.004, 0.01, 0.002>}
	        
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.01, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.03 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.05 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.07 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.09 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.11 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.13 - 0.004, 0.002>}
		
	object{Glass scale<0.04, 0.12, 1> translate<0.01, 0.01, 0.0025>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {
	object{E5 scale<0.01, 0.14, 0.03>}
	object{E5 scale<0.01, 0.14, 0.03> translate x*0.05}
	object{E3 scale<0.04, 0.01, 0.03> translate x*0.01}
	object{E3 scale<0.04, 0.01, 0.03> translate <0.01, 0.13, 0>}
	
	object{WindowFrame1}
}

#declare WindowFrame2 = union {
	object{E5 scale<0.002, 0.03, 0.03> translate<0.005, 0.005, 0.002>} 
	object{E5 scale<0.002, 0.03, 0.03> translate<0.02 - 0.001, 0.005, 0.002>}       
	object{E5 scale<0.002, 0.03, 0.03> translate<0.035 - 0.002, 0.005, 0.002>}
	
	object{E5 scale<0.03, 0.002, 0.03> translate<0.005, 0.005, 0.002>}
	object{E5 scale<0.03, 0.002, 0.03> translate<0.005, 0.02 - 0.001, 0.002>}        
	object{E5 scale<0.03, 0.002, 0.03> translate<0.005, 0.035 - 0.002, 0.002>}
	
	object{Glass scale<0.03, 0.03, 1> translate<0.005, 0.005, 0.0025>}
	texture{WindowFrameTxt}
}

#declare Window2 = union {
	object{E5 scale<0.04, 0.005, 0.03>}
	object{E5 scale<0.04, 0.005, 0.03> translate y*0.035}
	object{E5 scale<0.005, 0.04, 0.03>}
	object{E5 scale<0.005, 0.04, 0.03> translate x*0.035}
	
	object{WindowFrame2}
}

#declare TowerPart = difference{
	union{
		box{0, <0.03, 0.04, 0.03>}
		box{<-0.003, 0.04, -0.003>, <0.033, 0.043, 0.03>}
		box{<-0.005, 0.043, -0.005>, <0.035, 0.045, 0.03>}
	}
	box{<0.005, -1, -1>, <0.025, 0.035, 0.005>}
	plane{x, 0 rotate y*45}
	plane{-x, 0 rotate -y*45 translate x*0.03}
}

/*
#declare Roof = union {
	difference{
		object{
			E1 
			scale<0.52, 0.2, 1> 
			rotate<55, 0, 0>
			texture{RoofTxt}
		}
		plane{x, 0 rotate -z*55}
		plane{-x, 0 rotate z*55 translate x*0.52}
	}
	difference{
		object{
			E1 
			scale<0.5, 0.2, 1>
			texture{RoofTxt} 
			rotate<55, -90, 0>
		}
		plane{z, 0 rotate x*55}
		translate x*0.52
	}
	
	translate<-0.01, 0.88, -0.01>
}
*/

#declare Roof = union {
	// tile roof
	#include "houses/tileroof_.inc"
	difference{
		object{
			Roof1(20, 0.75, 0.18, 0.14, 20, 6, 1, Pgm, 130)
			translate -z*0.02 
			rotate -90*y
			rotate -z*30
		}
		plane{z, 0 rotate x*60}
		translate<0.52, 0, 0>
	}
	
	difference{
		object{
			Roof1(20, 0.75, 0.52, 0.14, 40, 6, 1, Pgm, 132)
			translate -z*0.02 
			rotate -x*30
		}
		plane{x, 0 rotate -z*60}
		plane{-x, 0 rotate z*60 translate x*0.52}
		translate x*0.011
	}
	
	object{
		Roof1(25, 0.75, 0.24/23, 0.174, 1, 9, 0, Pgm, 134)
		translate -x*(0.24/28/2)
		translate -z*0.013 
		rotate -90*x
		rotate -y*35
		rotate z*40 
		rotate x*60
		translate x*0.524
	}

	translate<-0.005, 0.88, -0.005> 
	texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}
}

#declare Tower = union {
	// front-back
	union{
		object{TowerPart}
		object{TowerPart rotate y*180 translate<0.03, 0, 0.03>}
		object{E1 scale<0.1, 0.1, 1> rotate x*5 clipped_by{plane{-x, 0 rotate -z*5}} clipped_by{plane{x, 0 rotate z*5}}}
		
		// top
		sphere{<0.015, 0.185, 0.015>, 0.002}
		difference {
			sphere{0, 0.002 scale<1, 10, 1>}
			plane{y, 0}	                    
			translate<0.015, 0.185, 0.015>
		}
		sphere{<0.015, 0.18, 0.015>, 0.0025}
		
		texture{TowerTxt}
	}      
	
	// sides
	union{
		object{TowerPart rotate y*90 translate z*0.03}
		object{TowerPart rotate -y*90 translate<0.03, 0, 0>}
		texture{TowerTxt rotate y*90}
	} 
	
	// roof
	difference{
		box{<0, 0.045, 0>, <0.03, 0.2, 0.03>}
		plane{z, 0 rotate x*6 translate<0, 0.045, 0> texture{TowerTxt}}
		plane{-z, 0 rotate -x*6 translate<0, 0.045, 0.03> texture{TowerTxt}}
		plane{x, 0 rotate -z*6 translate<0, 0.045, 0> texture{TowerTxt rotate y*90}}
		plane{-x, 0 rotate z*6 translate<0.03, 0.045, 0> texture{TowerTxt rotate y*90}}
	}
	
	scale 0.8
	scale<0.9, 1, 0.9>
	
	translate -x*0.015
}   

#declare House13 = union {
	// facade
	object{E1 scale<0.5, 0.95, 1> translate -y*0.1}
	
	// right side
	object{E1 scale<0.4, 0.95, 1> rotate -y*90 translate<0.5, -0.1, 0>}
	
	// top
	object{E6 scale<0.52, 0.01, 0.4> translate<-0.01, 0.87, -0.01>}
	object{E6 scale<0.51, 0.02, 0.4> translate<-0.005, 0.85, -0.005>}
	
	// bars
	object{E5 scale<0.01, 0.75, 0.003> translate<0, 0.1, -0.003>}
	object{E5 scale<0.02, 0.75, 0.003> translate<0.09, 0.1, -0.003>}
	object{E5 scale<0.02, 0.75, 0.003> translate<0.19, 0.1, -0.003>}
	object{E5 scale<0.02, 0.75, 0.003> translate<0.29, 0.1, -0.003>}
	object{E5 scale<0.02, 0.75, 0.003> translate<0.39, 0.1, -0.003>}
	object{E5 scale<0.01, 0.75, 0.003> translate<0.49, 0.1, -0.003>}
	
	object{E5 scale<0.5, 0.04, 0.002> translate<0, 0.07, -0.002>}
	object{E5 scale<0.5, 0.04, 0.002> translate<0, 0.29, -0.002>}
	object{E5 scale<0.5, 0.04, 0.002> translate<0, 0.42, -0.002>}
	object{E5 scale<0.5, 0.04, 0.002> translate<0, 0.64, -0.002>}
	object{E5 scale<0.5, 0.04, 0.002> translate<0, 0.73, -0.002>}
	
	object{E5 scale<0.5, 0.02, 0.0005> translate<0, 0.08, -0.0035>}
	object{E5 scale<0.5, 0.02, 0.0005> translate<0, 0.30, -0.0035>}
	object{E5 scale<0.5, 0.02, 0.0005> translate<0, 0.43, -0.0035>}
	object{E5 scale<0.5, 0.02, 0.0005> translate<0, 0.65, -0.0035>}
	object{E5 scale<0.5, 0.02, 0.0005> translate<0, 0.74, -0.0035>}
	
	object{Rect translate<0.03, 0.35, 0>}
	object{Rect translate<0.13, 0.35, 0>}
	object{Rect translate<0.23, 0.35, 0>}
	object{Rect translate<0.33, 0.35, 0>}
	object{Rect translate<0.43, 0.35, 0>}	
	  
	// 1st floor
	object{Window1 translate<0.02, 0.13, -0.003>}
	object{Window1 translate<0.12, 0.13, -0.003>}
	object{Window1 translate<0.22, 0.13, -0.003>}
	object{Window1 translate<0.32, 0.13, -0.003>}
	object{Window1 translate<0.42, 0.13, -0.003>}
	
	  
	// 2nd floor
	object{Window1 translate<0.02, 0.48, -0.003>}
	object{Window1 translate<0.12, 0.48, -0.003>}
	object{Window1 translate<0.22, 0.48, -0.003>}
	object{Window1 translate<0.32, 0.48, -0.003>}
	object{Window1 translate<0.42, 0.48, -0.003>}
	
	// attic
	object{Window2 translate<0.03, 0.79, -0.0026>}
	object{Window2 translate<0.13, 0.79, -0.0026>}
	object{Window2 translate<0.23, 0.79, -0.0026>}
	object{Window2 translate<0.33, 0.79, -0.0026>}
	object{Window2 translate<0.43, 0.79, -0.0026>} 
	
	object{Roof}
	
	object{Tower translate<0.1, 0.89, 0.01>}
	object{Tower translate<0.4, 0.89, 0.01>}
	
	#include "houses/house13/sunshade4_.inc"	                
	object{Sunshade scale<0.03, 0.022, 0.022> translate<0.05, 0.615, -0.003>}

	texture{FacadeTxt scale<0.52, 0.98, 1> translate<-0.01, -0.1, 0>} 
	texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}
}