#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "houses/house12/house12.jpg"
				map_type 0
			}
		}
		normal{
			bump_map{
				jpeg "houses/house12/house12.jpg"
				map_type 0
			}          
			bump_size 25*-5
		}		
		finish{diffuse 0.6}
	#end
}

#declare WindowFrameTxt = texture{
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else 
		#local k = 1.8; 
    	pigment{
    		bozo 
    		color_map{
    			[0.0 0.3 color rgb<0.3, 0.25, 0.16>*k color rgb<0.33, 0.25, 0.16>*k] 
    			[0.3 0.6 color rgb<0.33, 0.25, 0.16>*k color rgb<0.36, 0.25, 0.16>*k]
    			[0.6 1.0 color rgb<0.36, 0.25, 0.16>*k color rgb<0.3, 0.25, 0.16>*k]
    		}
    		scale<0.3, 4.3, 1>
   			scale 0.0008
   		} 
   		finish{diffuse 0.6 phong 0.05 phong_size 85}
   		normal{bumps 0.3 scale<0.0001, 0.001, 0.0001>}
   		
  	#end 
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare Rect = union {
	object{E5 scale<0.01, 0.03, 0.03>}
	object{E5 scale<0.01, 0.03, 0.03> translate x*0.05}
	object{E5 scale<0.04, 0.01, 0.03> translate x*0.01}
	object{E5 scale<0.04, 0.01, 0.03> translate<0.01, 0.02, 0>}
}

#declare Ornament = union {
	object{E5 scale<0.46, 0.01, 0.03>}
	object{E5 scale<0.46, 0.01, 0.03> translate y*0.06}
	object{E5 scale<0.01, 0.05, 0.03> translate y*0.01}
	object{E5 scale<0.01, 0.05, 0.03> translate<0.45, 0.01, 0>}
	
	object{Rect translate<0.05, 0.02, 0>}
	object{Rect translate<0.17, 0.02, 0>}
	object{Rect translate<0.27, 0.02, 0>}
	object{Rect translate<0.37, 0.02, 0>}
	
	translate -z*0.003
}

#declare Column = union {
	sphere{0, 0.005 scale<1, 0.7, 1>}
	sphere{0, 0.005 scale<1, 0.7, 1> translate y*0.035}
	sphere{0, 0.005 translate y*0.008}                 
	difference{
		sphere{0, 0.005 scale<1, 6, 1>}
		plane{y, 0}
		translate y*0.008
	}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.003, 0.1, 0.03> translate<0.01, 0.02, 0.002>}        
	object{E5 scale<0.003, 0.1, 0.03> translate<0.025 - 0.003/2, 0.02, 0.002>}
	object{E5 scale<0.003, 0.1, 0.03> translate<0.04 - 0.003, 0.02, 0.002>}
	
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.02 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.04 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.06 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.08 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.10 - 0.003, 0.002>}
	
	object{Glass scale<0.03, 0.1, 1> translate<0.01, 0.02, 0.003>}
	texture{WindowFrameTxt}
}

#declare Window1 = union {  
	object{E5 scale<0.05, 0.005, 0.04> translate<0, 0.005, -0.002>}
	object{E5 scale<0.07, 0.01, 0.03> translate<-0.01, 0.01, -0.004>}
	object{E5 scale<0.05, 0.01, 0.03> translate y*0.12}
	object{E5 scale<0.01, 0.1, 0.03> translate y*0.02}
	object{E5 scale<0.01, 0.1, 0.03> translate<0.04, 0.02, 0>} 
	                               
	object{E5 scale<0.07, 0.01, 0.03> translate<-0.01, 0.13, 0.003>}
	object{E5 scale<0.01, 0.11, 0.03> translate<-0.01, 0.02, 0.003>}
	object{E5 scale<0.01, 0.11, 0.03> translate<0.05, 0.02, 0.003>}
	object{E5 scale<0.07, 0.005, 0.03> translate<-0.01, 0.135, -0.002>}
	                             
	object{WindowFrame1}
}   

#declare Bars = union {
	object{E5 scale<0.01, 0.22, 0.03>}
	object{E5 scale<0.01, 0.22, 0.03> translate<0.45, 0, 0>}
	object{E5 scale<0.44, 0.01, 0.03> translate<0.01, 0, 0>}
	object{E5 scale<0.44, 0.01, 0.03> translate<0.01, 0.21, 0>}
	
	translate -z*0.003
}

#declare House12 = union {
	// facade
	object{E1 scale<0.5, 0.9, 1> translate -y*0.1}
	
	// top
	object{E6 scale<0.5, 0.01, 0.4> translate<0, 0.76, -0.005>}
	object{E6 scale<0.5, 0.01, 0.4> translate<0, 0.79, -0.005>}	
	
	// 1st floor
	object{Window1 translate<0.065, 0.14, -0.005>}
	object{Window1 translate<0.165, 0.14, -0.005>}
	object{Window1 translate<0.265, 0.14, -0.005>}
	object{Window1 translate<0.365, 0.14, -0.005>}
	  
	// 2nd floor
	object{Window1 translate<0.065, 0.47, -0.005>}
	object{Window1 translate<0.165, 0.47, -0.005>}
	object{Window1 translate<0.265, 0.47, -0.005>}
	object{Window1 translate<0.365, 0.47, -0.005>}
 
   	object{Ornament translate<0.02, 0.01, 0>}
   	object{Ornament translate<0.02, 0.34, 0>}
   	object{Ornament translate<0.02, 0.68, 0>}
   	
   	object{Bars translate<0.02, 0.1, 0>}
   	object{Bars translate<0.02, 0.43, 0>}
  	
	texture{FacadeTxt scale<0.5, 0.9, 1> translate<0, -0.1, 0>}
}