#include "houses/elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = 
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}

#declare BoardTxt = 
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}

#declare GridTxt = 
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}

#declare Glass = object{
	E1
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}
}

#declare Base = height_field {
	jpeg "houses/house1/base1.jpg"
    smooth  
    rotate -x*90
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}
     
    scale<1, 0.2708, 0.0017>
}

#declare WindowFrame1 = union {
	intersection{
		union{
	  		cylinder{<-1, 0, 0>, <1, 0, 0>, 0.0008}
	  		cylinder{<-1, 0.005, 0>, <1, 0.005, 0>, 0.0008}
	  		cylinder{<-1, 0.01, 0>, <1, 0.01, 0>, 0.0008}
	  		cylinder{<-1, 0.015, 0>, <1, 0.015, 0>, 0.0008}
	  		cylinder{<-1, 0.02, 0>, <1, 0.02, 0>, 0.0008}
	  		cylinder{<-1, 0.025, 0>, <1, 0.025, 0>, 0.0008}
	  		cylinder{<-1, 0.03, 0>, <1, 0.03, 0>, 0.0008}
	  		cylinder{<-1, 0.035, 0>, <1, 0.035, 0>, 0.0008}
	  		
	  		rotate z*60
	  		translate x*0.02
	  	}
	  	box{<0.004, 0.004, -1>, <0.03 - 0.004, 0.05 - 0.004, 1>}
	}
	intersection{
		union{
	  		cylinder{<-1, 0, 0>, <1, 0, 0>, 0.0008}
	  		cylinder{<-1, 0.005, 0>, <1, 0.005, 0>, 0.0008}
	  		cylinder{<-1, 0.01, 0>, <1, 0.01, 0>, 0.0008}
	  		cylinder{<-1, 0.015, 0>, <1, 0.015, 0>, 0.0008}
	  		cylinder{<-1, 0.02, 0>, <1, 0.02, 0>, 0.0008}
	  		cylinder{<-1, 0.025, 0>, <1, 0.025, 0>, 0.0008}
	  		cylinder{<-1, 0.03, 0>, <1, 0.03, 0>, 0.0008}
	  		cylinder{<-1, 0.035, 0>, <1, 0.035, 0>, 0.0008}
	  		
	  		rotate -z*60
	  		translate x*0.01
	  	}
	  	box{<0.004, 0.004, -1>, <0.03 - 0.004, 0.05 - 0.004, 1>}
	}
	
	object{Glass scale<0.022, 0.042, 1> translate<0.004, 0.004, 0.001>}
	
	texture{GridTxt}
}

#declare Blinders1 = union {
	object{E6 scale<0.02, 0.07, 0.002>}
	object{E5 scale<0.02, 0.003, 0.002> translate<0, 0.015, -0.002> texture{BoardTxt scale<0.02, 0.09, 1> rotate z*90}}
	object{E5 scale<0.02, 0.003, 0.002> translate<0, 0.06, -0.002> texture{BoardTxt scale<0.02, 0.09, 1> rotate z*90}}
	difference {
		cylinder{0, <0, 0, 0.002>, 0.02}
		plane{y, 0}
		plane{-x, 0}
		translate<0.02, 0.07, 0>
	}
	texture{BoardTxt scale<0.02, 0.09, 1>}
}
#declare Blinders2 = union {
	object{E6 scale<0.02, 0.07, 0.002>}
	object{E5 scale<0.02, 0.003, 0.002> translate<0, 0.015, -0.002> texture{BoardTxt scale<0.02, 0.09, 1> rotate z*90}}
	object{E5 scale<0.02, 0.003, 0.002> translate<0, 0.06, -0.002> texture{BoardTxt scale<0.02, 0.09, 1> rotate z*90}}
	difference {
		cylinder{0, <0, 0, 0.002>, 0.02}
		plane{y, 0}
		plane{x, 0}
		translate<0, 0.07, 0>
	}
	texture{BoardTxt scale<0.02, 0.09, 1>}
}

#declare Window1 = union {
	object{E5 scale<0.036, 0.056, 0.03> translate<-0.003, -0.003, 0.0021>}  
	object{E5 scale<0.004, 0.05, 0.03>}
	object{E5 scale<0.004, 0.05, 0.03> translate<0.03 - 0.004, 0, 0>}
	object{E3 scale<0.022, 0.004, 0.03> translate x*0.004}
	object{E3 scale<0.022, 0.004, 0.03> translate <0.004, 0.05 - 0.004, 0>}
	                             
	object{WindowFrame1 translate z*0.001}
}

#declare WindowFrame2 = union {
	object{E5 scale<0.03, 0.002, 0.03> translate <0.005, 0.005, 0.002>}
	object{E5 scale<0.03, 0.002, 0.03> translate <0.005, 0.07 - 0.002, 0.002>}
	object{E5 scale<0.03, 0.002, 0.03> translate <0.005, 0.05 - 0.002, 0.002>}
	
	object{E5 scale<0.002, 0.065, 0.03> translate <0.005, 0.005, 0.002>} 
	object{E5 scale<0.002, 0.065, 0.03> translate <0.02 - 0.001, 0.005, 0.002>}
	object{E5 scale<0.002, 0.065, 0.03> translate <0.035 - 0.002, 0.005, 0.002>}
	
	difference {
		cylinder{0, <0, 0, 0.03>, 0.015}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.013}
		plane{y, 0}
		translate<0.02, 0.07, 0.002>
	}
	
	intersection {
		object{Glass scale<0.032, 0.09, 1> translate<0.004, 0.004, 0.0025>}
		merge {
			cylinder{<0.02, 0.07, -1>, <0.02, 0.07, 1>, 0.015}
			box{<0.004, 0.004, -1>, <0.036, 0.07, 1>}
		}
	}    
}

#declare Window2 = union {                                 
	object{E5 scale<0.03, 0.004, 0.03> translate<0.005, -0.004, 0.001>}

	object{E5 scale<0.03, 0.005, 0.03> translate<0.005, 0, 0>}
	object{E5 scale<0.005, 0.07, 0.03>}
	object{E5 scale<0.005, 0.07, 0.03> translate x*0.035}
	     
	difference {
		cylinder{0, <0, 0, 0.03>, 0.02}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.015}
		plane{y, 0}
		translate<0.02, 0.07, 0>
	}
	
	object{WindowFrame2}
}

#declare Window3 = union {
	difference{
		box{0, <0.03, 0.03, 0.005>}
		box{<0.005, 0.005, -1>, <0.025, 0.025, 1>}
	}
}

#declare Something = union {
bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0129, 0.0019, 0.0310> <0.0100, 0.0025, 0.0312> <0.0060, 0.0039, 0.0316> <0.0030, 0.0040, 0.0316>
		<0.0130, 0.0016, 0.0263> <0.0100, 0.0023, 0.0265> <0.0046, 0.0042, 0.0262> <0.0015, 0.0043, 0.0262>
		<0.0128, 0.0017, 0.0200> <0.0084, 0.0029, 0.0194> <0.0028, 0.0054, 0.0190> <-0.0019, 0.0057, 0.0191>
		<0.0130, 0.0011, 0.0153> <0.0086, 0.0023, 0.0147> <0.0028, 0.0049, 0.0134> <-0.0019, 0.0051, 0.0135>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0030, 0.0040, 0.0316> <-0.0004, 0.0041, 0.0317> <-0.0048, 0.0028, 0.0313> <-0.0082, 0.0026, 0.0313>
		<0.0015, 0.0043, 0.0262> <-0.0018, 0.0045, 0.0262> <-0.0048, 0.0027, 0.0266> <-0.0082, 0.0026, 0.0266>
		<-0.0019, 0.0057, 0.0191> <-0.0040, 0.0058, 0.0191> <-0.0060, 0.0030, 0.0201> <-0.0082, 0.0027, 0.0203>
		<-0.0019, 0.0051, 0.0135> <-0.0040, 0.0053, 0.0135> <-0.0060, 0.0027, 0.0154> <-0.0082, 0.0024, 0.0157>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0082, 0.0026, 0.0313> <-0.0098, 0.0025, 0.0312> <-0.0120, 0.0034, 0.0315> <-0.0137, 0.0032, 0.0314>
		<-0.0082, 0.0026, 0.0266> <-0.0098, 0.0025, 0.0266> <-0.0113, 0.0036, 0.0264> <-0.0130, 0.0033, 0.0263>
		<-0.0082, 0.0027, 0.0203> <-0.0092, 0.0025, 0.0204> <-0.0101, 0.0041, 0.0196> <-0.0111, 0.0039, 0.0195>
		<-0.0082, 0.0024, 0.0157> <-0.0092, 0.0022, 0.0158> <-0.0102, 0.0038, 0.0144> <-0.0113, 0.0037, 0.0144>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0137, 0.0032, 0.0314> <-0.0161, 0.0028, 0.0313> <-0.0191, 0.0015, 0.0309> <-0.0215, 0.0007, 0.0307>
		<-0.0130, 0.0033, 0.0263> <-0.0154, 0.0030, 0.0262> <-0.0188, 0.0014, 0.0262> <-0.0211, 0.0006, 0.0260>
		<-0.0111, 0.0039, 0.0195> <-0.0139, 0.0035, 0.0194> <-0.0179, 0.0020, 0.0195> <-0.0206, 0.0010, 0.0198>
		<-0.0113, 0.0037, 0.0144> <-0.0141, 0.0032, 0.0142> <-0.0176, 0.0014, 0.0149> <-0.0202, 0.0005, 0.0151>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0130, 0.0011, 0.0153> <0.0086, 0.0023, 0.0147> <0.0028, 0.0049, 0.0134> <-0.0019, 0.0051, 0.0135>
		<0.0131, 0.0010, 0.0141> <0.0086, 0.0022, 0.0135> <0.0028, 0.0045, 0.0098> <-0.0019, 0.0048, 0.0099>
		<0.0136, 0.0005, 0.0122> <0.0104, 0.0010, 0.0097> <0.0062, 0.0036, 0.0064> <0.0022, 0.0039, 0.0056>
		<0.0137, -0.0006, 0.0117> <0.0105, -0.0001, 0.0092> <0.0071, 0.0010, 0.0042> <0.0031, 0.0013, 0.0034>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0019, 0.0051, 0.0135> <-0.0040, 0.0053, 0.0135> <-0.0060, 0.0027, 0.0154> <-0.0082, 0.0024, 0.0157>
		<-0.0019, 0.0048, 0.0099> <-0.0040, 0.0049, 0.0100> <-0.0060, 0.0026, 0.0130> <-0.0082, 0.0022, 0.0132>
		<0.0022, 0.0039, 0.0056> <-0.0013, 0.0042, 0.0050> <-0.0046, 0.0030, 0.0086> <-0.0082, 0.0031, 0.0089>
		<0.0031, 0.0013, 0.0034> <-0.0004, 0.0015, 0.0027> <-0.0046, 0.0010, 0.0071> <-0.0082, 0.0011, 0.0074>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0082, 0.0024, 0.0157> <-0.0092, 0.0022, 0.0158> <-0.0102, 0.0038, 0.0144> <-0.0113, 0.0037, 0.0144>
		<-0.0082, 0.0022, 0.0132> <-0.0092, 0.0021, 0.0133> <-0.0103, 0.0037, 0.0114> <-0.0114, 0.0035, 0.0113>
		<-0.0082, 0.0031, 0.0089> <-0.0102, 0.0031, 0.0091> <-0.0122, 0.0045, 0.0061> <-0.0141, 0.0041, 0.0069>
		<-0.0082, 0.0011, 0.0074> <-0.0102, 0.0011, 0.0076> <-0.0127, 0.0021, 0.0042> <-0.0145, 0.0018, 0.0050>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0113, 0.0037, 0.0144> <-0.0141, 0.0032, 0.0142> <-0.0176, 0.0014, 0.0149> <-0.0202, 0.0005, 0.0151>
		<-0.0114, 0.0035, 0.0113> <-0.0142, 0.0030, 0.0112> <-0.0175, 0.0013, 0.0139> <-0.0202, 0.0004, 0.0141>
		<-0.0141, 0.0041, 0.0069> <-0.0168, 0.0035, 0.0080> <-0.0183, 0.0004, 0.0107> <-0.0199, -0.0006, 0.0129>
		<-0.0145, 0.0018, 0.0050> <-0.0172, 0.0012, 0.0061> <-0.0184, -0.0005, 0.0102> <-0.0201, -0.0014, 0.0125>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0137, -0.0006, 0.0117> <0.0105, -0.0001, 0.0092> <0.0071, 0.0010, 0.0042> <0.0031, 0.0013, 0.0034>
		<0.0139, -0.0029, 0.0106> <0.0107, -0.0023, 0.0081> <0.0080, -0.0018, 0.0018> <0.0040, -0.0015, 0.0010>
		<0.0142, -0.0064, 0.0107> <0.0110, -0.0070, 0.0074> <0.0083, -0.0068, 0.0010> <0.0039, -0.0071, 0.0002>
		<0.0141, -0.0089, 0.0107> <0.0109, -0.0094, 0.0074> <0.0080, -0.0106, 0.0007> <0.0035, -0.0108, -0.0001>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0031, 0.0013, 0.0034> <-0.0004, 0.0015, 0.0027> <-0.0046, 0.0010, 0.0071> <-0.0082, 0.0011, 0.0074>
		<0.0040, -0.0015, 0.0010> <0.0005, -0.0013, 0.0004> <-0.0046, -0.0017, 0.0052> <-0.0082, -0.0016, 0.0055>
		<0.0039, -0.0071, 0.0002> <-0.0002, -0.0073, -0.0005> <-0.0043, -0.0068, 0.0060> <-0.0083, -0.0067, 0.0068>
		<0.0035, -0.0108, -0.0001> <-0.0005, -0.0110, -0.0008> <-0.0042, -0.0101, 0.0060> <-0.0082, -0.0100, 0.0068>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0082, 0.0011, 0.0074> <-0.0102, 0.0011, 0.0076> <-0.0127, 0.0021, 0.0042> <-0.0145, 0.0018, 0.0050>
		<-0.0082, -0.0016, 0.0055> <-0.0102, -0.0016, 0.0057> <-0.0132, -0.0007, 0.0019> <-0.0150, -0.0011, 0.0027>
		<-0.0083, -0.0067, 0.0068> <-0.0103, -0.0066, 0.0072> <-0.0117, -0.0067, 0.0030> <-0.0136, -0.0066, 0.0035>
		<-0.0082, -0.0100, 0.0068> <-0.0101, -0.0099, 0.0072> <-0.0118, -0.0104, 0.0028> <-0.0137, -0.0102, 0.0033>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0145, 0.0018, 0.0050> <-0.0172, 0.0012, 0.0061> <-0.0184, -0.0005, 0.0102> <-0.0201, -0.0014, 0.0125>
		<-0.0150, -0.0011, 0.0027> <-0.0177, -0.0016, 0.0039> <-0.0187, -0.0027, 0.0092> <-0.0204, -0.0036, 0.0114>
		<-0.0136, -0.0066, 0.0035> <-0.0167, -0.0064, 0.0043> <-0.0189, -0.0071, 0.0084> <-0.0213, -0.0067, 0.0105>
		<-0.0137, -0.0102, 0.0033> <-0.0168, -0.0101, 0.0041> <-0.0193, -0.0095, 0.0082> <-0.0217, -0.0092, 0.0103>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0127, -0.0397, 0.0120> <0.0131, -0.0304, 0.0116> <0.0138, -0.0181, 0.0108> <0.0141, -0.0089, 0.0107>
		<0.0088, -0.0385, 0.0084> <0.0092, -0.0293, 0.0080> <0.0107, -0.0187, 0.0075> <0.0109, -0.0094, 0.0074>
		<0.0049, -0.0359, 0.0014> <0.0061, -0.0284, 0.0013> <0.0073, -0.0181, 0.0000> <0.0080, -0.0106, 0.0007>
		<-0.0003, -0.0358, 0.0000> <0.0008, -0.0283, 0.0000> <0.0028, -0.0183, -0.0008> <0.0035, -0.0108, -0.0001>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0003, -0.0358, 0.0000> <0.0008, -0.0283, 0.0000> <0.0028, -0.0183, -0.0008> <0.0035, -0.0108, -0.0001>
		<-0.0032, -0.0357, -0.0007> <-0.0020, -0.0282, -0.0007> <-0.0012, -0.0185, -0.0015> <-0.0005, -0.0110, -0.0008>
		<-0.0034, -0.0397, 0.0066> <-0.0039, -0.0309, 0.0065> <-0.0037, -0.0189, 0.0060> <-0.0042, -0.0101, 0.0060>
		<-0.0062, -0.0392, 0.0072> <-0.0068, -0.0304, 0.0071> <-0.0077, -0.0188, 0.0068> <-0.0082, -0.0100, 0.0068>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0062, -0.0392, 0.0072> <-0.0068, -0.0304, 0.0071> <-0.0077, -0.0188, 0.0068> <-0.0082, -0.0100, 0.0068>
		<-0.0096, -0.0387, 0.0079> <-0.0102, -0.0299, 0.0078> <-0.0097, -0.0187, 0.0071> <-0.0101, -0.0099, 0.0072>
		<-0.0122, -0.0344, 0.0027> <-0.0117, -0.0274, 0.0027> <-0.0120, -0.0173, 0.0025> <-0.0118, -0.0104, 0.0028>
		<-0.0155, -0.0334, 0.0033> <-0.0150, -0.0265, 0.0033> <-0.0139, -0.0172, 0.0030> <-0.0137, -0.0102, 0.0033>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<-0.0155, -0.0334, 0.0033> <-0.0150, -0.0265, 0.0033> <-0.0139, -0.0172, 0.0030> <-0.0137, -0.0102, 0.0033>
		<-0.0188, -0.0325, 0.0039> <-0.0183, -0.0255, 0.0039> <-0.0170, -0.0170, 0.0038> <-0.0168, -0.0101, 0.0041>
		<-0.0219, -0.0338, 0.0083> <-0.0210, -0.0264, 0.0083> <-0.0203, -0.0169, 0.0078> <-0.0193, -0.0095, 0.0082>
		<-0.0246, -0.0340, 0.0105> <-0.0237, -0.0265, 0.0104> <-0.0227, -0.0166, 0.0099> <-0.0217, -0.0092, 0.0103>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0355, 0.0027, 0.0334> <0.0317, 0.0033, 0.0335> <0.0267, 0.0048, 0.0337> <0.0228, 0.0048, 0.0337>
		<0.0359, 0.0026, 0.0299> <0.0321, 0.0033, 0.0300> <0.0268, 0.0052, 0.0298> <0.0229, 0.0052, 0.0298>
		<0.0361, 0.0031, 0.0252> <0.0320, 0.0042, 0.0249> <0.0269, 0.0060, 0.0247> <0.0227, 0.0064, 0.0246>
		<0.0367, 0.0025, 0.0218> <0.0326, 0.0036, 0.0215> <0.0274, 0.0058, 0.0208> <0.0232, 0.0061, 0.0207>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0228, 0.0048, 0.0337> <0.0209, 0.0049, 0.0337> <0.0187, 0.0033, 0.0335> <0.0168, 0.0030, 0.0334>
		<0.0229, 0.0052, 0.0298> <0.0210, 0.0052, 0.0298> <0.0188, 0.0036, 0.0299> <0.0170, 0.0033, 0.0298>
		<0.0227, 0.0064, 0.0246> <0.0208, 0.0065, 0.0245> <0.0188, 0.0048, 0.0248> <0.0170, 0.0043, 0.0250>
		<0.0232, 0.0061, 0.0207> <0.0213, 0.0063, 0.0207> <0.0191, 0.0046, 0.0212> <0.0172, 0.0041, 0.0213>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0168, 0.0030, 0.0334> <0.0157, 0.0028, 0.0334> <0.0141, 0.0032, 0.0335> <0.0130, 0.0030, 0.0335>
		<0.0170, 0.0033, 0.0298> <0.0158, 0.0031, 0.0298> <0.0148, 0.0036, 0.0298> <0.0137, 0.0033, 0.0298>
		<0.0170, 0.0043, 0.0250> <0.0164, 0.0042, 0.0250> <0.0155, 0.0046, 0.0250> <0.0150, 0.0043, 0.0250>
		<0.0172, 0.0041, 0.0213> <0.0166, 0.0040, 0.0214> <0.0157, 0.0044, 0.0213> <0.0152, 0.0041, 0.0213>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0130, 0.0030, 0.0335> <0.0116, 0.0028, 0.0334> <0.0100, 0.0018, 0.0333> <0.0087, 0.0013, 0.0332>
		<0.0137, 0.0033, 0.0298> <0.0123, 0.0031, 0.0298> <0.0104, 0.0017, 0.0297> <0.0091, 0.0012, 0.0296>
		<0.0150, 0.0043, 0.0250> <0.0133, 0.0035, 0.0250> <0.0114, 0.0023, 0.0248> <0.0099, 0.0013, 0.0248>
		<0.0152, 0.0041, 0.0213> <0.0135, 0.0033, 0.0213> <0.0117, 0.0018, 0.0212> <0.0102, 0.0009, 0.0212>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0367, 0.0025, 0.0218> <0.0326, 0.0036, 0.0215> <0.0274, 0.0058, 0.0208> <0.0232, 0.0061, 0.0207>
		<0.0372, 0.0019, 0.0188> <0.0332, 0.0030, 0.0185> <0.0280, 0.0054, 0.0156> <0.0238, 0.0058, 0.0155>
		<0.0382, 0.0014, 0.0139> <0.0344, 0.0026, 0.0113> <0.0303, 0.0062, 0.0081> <0.0257, 0.0068, 0.0071>
		<0.0392, -0.0012, 0.0124> <0.0354, 0.0000, 0.0098> <0.0311, 0.0023, 0.0047> <0.0265, 0.0029, 0.0037>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0232, 0.0061, 0.0207> <0.0213, 0.0063, 0.0207> <0.0191, 0.0046, 0.0212> <0.0172, 0.0041, 0.0213>
		<0.0238, 0.0058, 0.0155> <0.0219, 0.0059, 0.0154> <0.0193, 0.0043, 0.0170> <0.0175, 0.0039, 0.0171>
		<0.0257, 0.0068, 0.0071> <0.0231, 0.0072, 0.0065> <0.0210, 0.0050, 0.0102> <0.0183, 0.0047, 0.0104>
		<0.0265, 0.0029, 0.0037> <0.0239, 0.0032, 0.0031> <0.0212, 0.0018, 0.0075> <0.0185, 0.0015, 0.0077>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0172, 0.0041, 0.0213> <0.0166, 0.0040, 0.0214> <0.0157, 0.0044, 0.0213> <0.0152, 0.0041, 0.0213>
		<0.0175, 0.0039, 0.0171> <0.0169, 0.0037, 0.0172> <0.0160, 0.0041, 0.0163> <0.0155, 0.0038, 0.0163>
		<0.0183, 0.0047, 0.0104> <0.0169, 0.0045, 0.0105> <0.0164, 0.0058, 0.0084> <0.0151, 0.0052, 0.0080>
		<0.0185, 0.0015, 0.0077> <0.0171, 0.0013, 0.0078> <0.0160, 0.0021, 0.0050> <0.0147, 0.0014, 0.0046>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0152, 0.0041, 0.0213> <0.0135, 0.0033, 0.0213> <0.0117, 0.0018, 0.0212> <0.0102, 0.0009, 0.0212>
		<0.0155, 0.0038, 0.0163> <0.0138, 0.0031, 0.0162> <0.0120, 0.0012, 0.0164> <0.0105, 0.0002, 0.0164>
		<0.0151, 0.0052, 0.0080> <0.0137, 0.0044, 0.0076> <0.0121, 0.0027, 0.0080> <0.0110, 0.0016, 0.0082>
		<0.0147, 0.0014, 0.0046> <0.0133, 0.0007, 0.0042> <0.0121, -0.0013, 0.0051> <0.0109, -0.0024, 0.0053>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0392, -0.0012, 0.0124> <0.0354, 0.0000, 0.0098> <0.0311, 0.0023, 0.0047> <0.0265, 0.0029, 0.0037>
		<0.0408, -0.0053, 0.0099> <0.0370, -0.0041, 0.0073> <0.0323, -0.0036, -0.0003> <0.0277, -0.0030, -0.0013>
		<0.0437, -0.0122, 0.0100> <0.0391, -0.0136, 0.0060> <0.0344, -0.0136, 0.0001> <0.0285, -0.0143, -0.0020>
		<0.0444, -0.0173, 0.0100> <0.0397, -0.0187, 0.0060> <0.0348, -0.0213, -0.0011> <0.0289, -0.0220, -0.0033>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0265, 0.0029, 0.0037> <0.0239, 0.0032, 0.0031> <0.0212, 0.0018, 0.0075> <0.0185, 0.0015, 0.0077>
		<0.0277, -0.0030, -0.0013> <0.0251, -0.0026, -0.0019> <0.0215, -0.0034, 0.0030> <0.0189, -0.0038, 0.0032>
		<0.0285, -0.0143, -0.0020> <0.0255, -0.0147, -0.0032> <0.0218, -0.0140, 0.0009> <0.0186, -0.0136, 0.0014>
		<0.0289, -0.0220, -0.0033> <0.0259, -0.0224, -0.0045> <0.0220, -0.0209, -0.0002> <0.0188, -0.0204, 0.0004>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0185, 0.0015, 0.0077> <0.0171, 0.0013, 0.0078> <0.0160, 0.0021, 0.0050> <0.0147, 0.0014, 0.0046>
		<0.0189, -0.0038, 0.0032> <0.0174, -0.0040, 0.0033> <0.0155, -0.0028, 0.0006> <0.0143, -0.0034, 0.0002>
		<0.0186, -0.0136, 0.0014> <0.0168, -0.0133, 0.0017> <0.0145, -0.0133, -0.0009> <0.0129, -0.0132, 0.0001>
		<0.0188, -0.0204, 0.0004> <0.0170, -0.0202, 0.0007> <0.0143, -0.0198, -0.0014> <0.0128, -0.0197, -0.0004>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0147, 0.0014, 0.0046> <0.0133, 0.0007, 0.0042> <0.0121, -0.0013, 0.0051> <0.0109, -0.0024, 0.0053>
		<0.0143, -0.0034, 0.0002> <0.0129, -0.0041, -0.0002> <0.0120, -0.0055, 0.0020> <0.0108, -0.0066, 0.0022>
		<0.0129, -0.0132, 0.0001> <0.0111, -0.0131, 0.0012> <0.0109, -0.0146, 0.0037> <0.0101, -0.0146, 0.0057>
		<0.0128, -0.0197, -0.0004> <0.0110, -0.0196, 0.0007> <0.0108, -0.0198, 0.0042> <0.0099, -0.0198, 0.0062>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0472, -0.0656, 0.0130> <0.0463, -0.0511, 0.0121> <0.0462, -0.0317, 0.0101> <0.0444, -0.0173, 0.0100>
		<0.0420, -0.0640, 0.0071> <0.0411, -0.0495, 0.0062> <0.0415, -0.0331, 0.0061> <0.0397, -0.0187, 0.0060>
		<0.0368, -0.0607, -0.0029> <0.0366, -0.0492, -0.0018> <0.0354, -0.0327, -0.0030> <0.0348, -0.0213, -0.0011>
		<0.0298, -0.0604, -0.0068> <0.0296, -0.0489, -0.0058> <0.0295, -0.0334, -0.0052> <0.0289, -0.0220, -0.0033>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0298, -0.0604, -0.0068> <0.0296, -0.0489, -0.0058> <0.0295, -0.0334, -0.0052> <0.0289, -0.0220, -0.0033>
		<0.0269, -0.0603, -0.0085> <0.0266, -0.0488, -0.0074> <0.0265, -0.0338, -0.0064> <0.0259, -0.0224, -0.0045>
		<0.0236, -0.0643, -0.0033> <0.0231, -0.0510, -0.0026> <0.0224, -0.0340, -0.0021> <0.0220, -0.0209, -0.0002>
		<0.0205, -0.0645, -0.0021> <0.0200, -0.0513, -0.0013> <0.0192, -0.0335, -0.0015> <0.0188, -0.0204, 0.0004>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0205, -0.0645, -0.0021> <0.0200, -0.0513, -0.0013> <0.0192, -0.0335, -0.0015> <0.0188, -0.0204, 0.0004>
		<0.0184, -0.0646, -0.0012> <0.0178, -0.0514, -0.0005> <0.0174, -0.0333, -0.0012> <0.0170, -0.0202, 0.0007>
		<0.0150, -0.0623, -0.0019> <0.0148, -0.0498, -0.0020> <0.0141, -0.0323, -0.0024> <0.0143, -0.0198, -0.0014>
		<0.0136, -0.0615, -0.0003> <0.0134, -0.0490, -0.0003> <0.0126, -0.0322, -0.0014> <0.0128, -0.0197, -0.0004>
	}
	bicubic_patch {
		type 1
		flatness 0
		u_steps 3
		v_steps 3
		<0.0136, -0.0615, -0.0003> <0.0134, -0.0490, -0.0003> <0.0126, -0.0322, -0.0014> <0.0128, -0.0197, -0.0004>
		<0.0112, -0.0603, 0.0024> <0.0110, -0.0477, 0.0023> <0.0108, -0.0321, -0.0002> <0.0110, -0.0196, 0.0007>
		<0.0103, -0.0592, 0.0076> <0.0106, -0.0477, 0.0062> <0.0103, -0.0313, 0.0054> <0.0108, -0.0198, 0.0042>
		<0.0089, -0.0582, 0.0110> <0.0092, -0.0467, 0.0095> <0.0095, -0.0314, 0.0074> <0.0099, -0.0198, 0.0062>
	}
	
texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}
   	
   	scale<0.3, 0.3, 0.3>
}

#declare House1 = union {
	// facade
	difference{
		object{E1 scale<0.24, 0.55, 1> translate -y*0.1}
		box{<0.005, 0.005, -1>, <0.025, 0.025, 1> translate<0.015, 0.37, -0.002>}
		box{<0.005, 0.005, -1>, <0.025, 0.025, 1> translate<0.105, 0.37, -0.002>}
		box{<0.005, 0.005, -1>, <0.025, 0.025, 1> translate<0.195, 0.37, -0.002>}
	}
	
	object{Base scale<0.24, 0.55, 1> translate -y*0.1}
		
	// bars
	object{E5 scale<0.24, 0.006, 0.3> translate<0, 0.45, -0.002>}
	object{E5 scale<0.24, 0.004, 0.3> translate<0, 0.456, -0.003>}	
	
	// 1st floor
	object{Window1 translate<0.02, 0.08, -0.0035>}
	object{Window1 translate<0.105, 0.08, -0.0035>}
	object{Window1 translate<0.19, 0.08, -0.0035>}
	
	// 2nd floor
	object{Window2 translate<0.015, 0.21, -0.0026>}
	object{Window2 translate<0.1, 0.21, -0.0026>}
	object{Window2 translate<0.185, 0.21, -0.0026>}
	cylinder{0, <0, 0.006, 0>, 0.001 translate<0.1895, 0.23, -0.0026>}
	cylinder{0, <0, 0.006, 0>, 0.001 translate<0.1895, 0.26, -0.0026>}
	cylinder{0, <0, 0.006, 0>, 0.001 translate<0.2205, 0.23, -0.0026>}
	cylinder{0, <0, 0.006, 0>, 0.001 translate<0.2205, 0.26, -0.0026>}
	
	// 3rd floor
	object{Window3 translate<0.015, 0.37, -0.002>}
	object{Window3 translate<0.105, 0.37, -0.002>}
	object{Window3 translate<0.195, 0.37, -0.002>}
	 
	// blinders
	object{Blinders1 rotate y*70 translate<0.22, 0.21, -0.004>}
	object{Blinders2 rotate -y*10 translate<0.17, 0.21, -0.008>}       
	object{E6 scale<0.02, 0.02, 0.001> texture{BoardTxt scale<0.02, 0.09, 1>} rotate y*96 translate<0.22, 0.375, -0.0023>}
	
	object{Something translate<0.207, 0.3752, -0.006>}
	  
	texture{FacadeTxt scale<0.24, 0.56, 1> translate<0, -0.1, 0>}  
	texture {pigment {color rgb 1} finish {diffuse 0 ambient 1}}
}