//Persistence of Vision Ray Tracer Scene Description File
//Date: 11/30/07
//Author: Russell Towle
//shows usage of polar zonohedron macros


/************** Changes *************by aQ
macros to declarations for max_extent(), object similar size regardless of N (with irregularity)
 implement centering, area light, gamma, trace, floor control by obj.y radius, etc.
*/

#version 3.61;

#include "colors.inc"
#include "metals.inc"
#include "textures.inc"
//#include "triangulation.inc"
//#include "echo2.inc"

global_settings {
  max_trace_level 15
  assumed_gamma 1.0
}
#default {texture{pigment{color White}finish{phong 0.01 ambient 0.2 diffuse 0.6}}}

#declare SRAD = .045; //radius of spheres
#declare CRAD = .04; //radius of cylinders
#declare T1 = texture{ T_Silver_1A }//texture of spheres
#declare T2 = texture{ T_Silver_1A }//texture of cylinders
#declare N = 7;
#declare Pitch = 5;


#declare _polarzonohedron = mesh {
  #local RISE = sin(radians(Pitch)); 
  #local J = 1; //initialize outer loop
  #while (J <= N)
    #local K = 1;
    #local MARK = <0,0,0>; //a "point of reference" for the triangles
    #local R = <cos(radians(Pitch))*cos(J*2*pi/N), RISE, cos(radians(Pitch))*sin(J*2*pi/N)>;
	#while (K <= N-1)
	#local S = <cos(radians(Pitch))*cos((J+K)*2*pi/N), RISE, cos(radians(Pitch))*sin((J+K)*2*pi/N)>;
	triangle {
		MARK
		MARK+R+S
		MARK+R
	}
	triangle {
		MARK
		MARK+S
		MARK+R+S
	}
	#local MARK = MARK+S;
	#local K = K+1;
	#end
  #local J = J+1;
  #end
}
// (N, PITCH,R1,R2)
#declare _framezonohedron = union {
  #local RISE = sin(radians(Pitch));
  #local TOP = (<0,N*RISE,0>);
  #local BOT = <0,0,0>;
  
    sphere{ TOP SRAD texture{T1}}
    sphere{ BOT SRAD texture{T1}}
	
	#local J = 1; //initialize outer loop
	#while (J <= N)
	#local MARK = BOT; //a "point of reference" for the frame
	#local R = <cos(radians(Pitch))*cos(J*2*pi/N), RISE, cos(radians(Pitch))*sin(J*2*pi/N)>;
	sphere{TOP-R SRAD texture{T1}}
	cylinder{BOT, BOT+R CRAD texture{T2}}
	cylinder{TOP, TOP-R CRAD texture{T2}}
	
		#local K = 1;
		#while (K < N-1)
		#local S = <cos(radians(Pitch))*cos((J+K)*2*pi/N), RISE, cos(radians(Pitch))*sin((J+K)*2*pi/N)>;
		sphere{MARK+R SRAD texture{T1}}
		cylinder{MARK+R, MARK+R+S CRAD texture{T2}}
		cylinder{MARK+S, MARK+R+S CRAD texture{T2}}
		#local MARK = MARK+S;
		#local K = K+1;
		#end
		
	#local J = J+1;
	#end
}
   
object {
   #declare SurfMin=min_extent(_polarzonohedron);
   #declare SurfMax=max_extent(_polarzonohedron);     
   #debug concat("\n SurfMin: <",vstr(3,SurfMin,", ",0,-1),">\n")
   #debug concat(" SurfMax: <",vstr(3,SurfMax,", ",0,-1),">\n")
   //echov(midpoint(SurfMin,SurfMax))
   //echov(midpoint(SurfMin,SurfMax))
   _polarzonohedron
    pigment {rgb <.5,.5,1>}
    translate (SurfMin+SurfMax)/-2
    scale (1/N)*12
}
 
object {
   _framezonohedron
   translate (SurfMin+SurfMax)/-2
   scale (1/N)*12
}
     
#declare lv = <-20, 20, -20>; // <0,1,0> cant work here
#declare arraylen = 10;

#declare _x = vnormalize(vcross(y,lv))*arraylen;
#declare _y = vnormalize(vcross(lv,_x))*arraylen;
#declare arr_light_source = light_source {
   lv
   1
   area_light
   _x,_y,5,5
   circular orient jitter

}

camera {
  location <0,10,-20>
  angle 22
  look_at 0
}



//light_source{ <0, 150, 0>  rgb <1,1,1> }
light_source { arr_light_source }




//#declare _floor = midpoint(SurfMin,SurfMax)*(1/N)*12;
#declare _floor = ((SurfMin+SurfMax)/2)*(1/N)*12;

#declare P_skygranite2 = 
      pigment {
         granite
         scale 0.1
         scale <3,1,1>
         turbulence x*0.9

         pigment_map {
            [0 rgb <0.2,0.3,0.45> ]
            [1 rgb <0.9,0.9,0.9> ]   
         }

}
#declare _spacing = 1.99;
  
#declare floor_width = 24;
#declare floor_depth = 24;
#declare x_i = 0;
#declare z_i = 0;
#declare tile_floor = union {
        #while (x_i < floor_width )
          #while (z_i < floor_depth )
            superellipsoid {
              <.15,.15>

              translate <-x_i*_spacing,0,-z_i*_spacing>
              translate <(floor_width/2)*_spacing-(_spacing*0.5),0,(floor_width/2)*_spacing-(_spacing*0.5)>
              texture { 
                //pigment { color rgb 0.7 } 
                pigment { P_skygranite2 }
                finish { ambient 0 diffuse 1.0 reflection 0.3 }
              }                
            }
            #declare z_i = z_i+1;
          #end
          #declare z_i=0;
          #declare x_i=x_i+1;
        #end                   
        translate 6*z                  
}
object { tile_floor scale <2,0.2,2> translate -y*_floor }

#declare afloor = plane{-y, _floor.y //make plane kiss bottom sphere
pigment { 
//rgb <.8,.8,.8> }
checker rgb 0, rgb 1}
} 