// Persistence of Vision Ray Tracer Scene Description File
// File: ?.pov
// Vers: 3.5
// Desc: Basic Scene Example
// Date: mm/dd/yy
// Auth: ?
//

#version 3.5;

#include "colors.inc"
#include "rope.inc"

global_settings {
  assumed_gamma 1.0
}

// ----------------------------------------

camera {
  location  <0.0, 1.0, -10.0>
  angle 20
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
  pigment {
    gradient y
    color_map {
      [0.0 rgb <0.6,0.7,1.0>]
      [0.7 rgb <0.0,0.1,0.8>]
    }
  }
}

light_source {
  <0, 0, 0>            // light's position (translated below)
  color rgb <1, 1, 1>  // light's color
  translate <-30, 30, -30>
}

// ----------------------------------------

plane {
  y, -1.2
  pigment { ForestGreen }
  normal {bozo 4 scale 0.05}
}


#declare LoopSpline1 = spline
{
	natural_spline
	0,      <0.019381,-0.019381, 0>,
	1/11,   <0.155048,0.213191, 0>,
	2/11,   <0.523286,0.377619, -0.1>,
	3/11,   <0.678334,0.523286, 0>,
	4/11,   <0.706477,0.717096, 0>,
	5/11,   <0.523286,0.852763, 0>,
	6/11,   <0.310096,0.775239, 0>,
	7/11,   <0.251953,0.581429, 0>,
	8/11,   <0.310096,0.407000, 0.1>,
	9/11,   <0.523286,0.271334, 0.1>,
	10/11,  <0.814001,0.213191, 0>,
	11/11,  <1.027192,0.000000, 0>
}

#declare LoopSpline2 = spline
{
	natural_spline
	0,      <0.019350,0.000000, 0>,
	1/14,   <0.116099,0.232198, -0.05>,
	2/14,   <0.320248,0.348947, -0.1>,
	3/14,   <0.599845,0.251548, 0.1>,
	4/14,   <0.773994,0.483746, 0>,
	5/14,   <0.735294,0.735294, 0>,
	6/14,   <0.503096,0.870743, 0>,
	7/14,   <0.251548,0.754644, 0>,
	8/14,   <0.193498,0.561146, 0.05>,
	9/14,   <0.251548,0.348297, 0.1>,
	10/14,  <0.386997,0.232198, -0.1>,
	11/14,  <0.609195,0.358297, 0.1>,
	12/14,  <0.812694,0.309598, 0.05>,
	13/14,  <0.948142,0.193498, 0>,
	14/14,  <1.025542,0.000000, 0>
}


object {MakeRope(LoopSpline2, 6, 6, 0.005, 6, 2, MEDIUM_DENSITY) pigment {Khaki} translate -(x+y)/2 scale 2}

