// ***********************************************
// LINK INCLUDE FILE FOR PERS1ISTENCE OF VISION 3.x
// ***********************************************
//
// Created by Chris Colefax, 20 April 1998
//
// See "Link.txt" for more information.
//
// ***********************************************
// File Modified 28 February 2005 by Tim McMurdo
// to automate the process of creating rope rigging

#ifndef (RigConfig)
        #declare RigConfig = 0;
#end
#ifndef (Point1)
        #declare Point1 = <-1500,0,0,3.0>;
#end
#ifndef (Point2)
        #declare Point2 = <0,0,0,2.0>;
#end
#ifndef (Point3)
        #declare Point3 = <0,-300,0,0.0>;
#end
#ifndef (Point4)
        #declare Point4 = <-0,400,0,2.0>;
#end
#ifndef (R)
        #declare R = 10;
#end
#ifndef (R1)
        #declare R1 = 20;
#end
#ifndef (R2)
        #declare R2 = R1;
#end
#ifndef (R3)
        #declare R3 = R1;
#end
#ifndef (R4)
        #declare R4 = R1;
#end



#ifndef (RS1)
        #declare RS1 = 4*R;
#end
#ifndef (RS2)
        #declare RS2 = RS1;
#end
#ifndef (L1)
        #declare L1 = 400;
#end
#ifndef (L2)
        #declare L2 = 400;
#end
#ifndef (StartAngle1)
        #declare StartAngle1 = -90;
#end
#ifndef (EndAngle1)
        #declare EndAngle1 = 90;
#end
#ifndef (StartAngle2)
        #declare StartAngle2 = -90;
#end
#ifndef (EndAngle2)
        #declare EndAngle2 = 90;
#end
#ifndef (BlockRotate1)
        #declare BlockRotate1 = 0;
#end
#ifndef (BlockRotate2)
        #declare BlockRotate2 = 0;
#end
#ifndef (link_looseness)
        #declare link_looseness = 0.1;
#end








#ifndef (RopeT)


        #declare RopeT =
                texture{
                        pigment{
                                spiral1 25
                                pigment_map{
                                        
                                        [0.0 Bronze*0.15]
                                        [0.05 Orange *0.15]
                                        [0.25 Yellow*.25]
                                        [0.4 Khaki *0.15]
                                        [0.5 Bronze2]
                                        [0.6 Orange *0.25]
                                        [0.7 Bronze2]
                                        [0.8 Orange *0.25]
                                        [1.0 DarkBrown]
                                }
                        
                        
                        }
                        normal { 
                                spiral1 25,
                                bump_size 0.5
                                
                        }
                        
                        
                        finish {
                                specular 0.2
                                roughness 0.05
                        }
                        
                }

#end 

#ifndef (link_object)
        #declare link_object =sphere{<0,0,0>,R scale <1,1,1> texture{RopeT scale R rotate<90,0,0>} scale<1,0.75,1> rotate<0,0,90> rotate<0,-60,0>}
#end

#include "Block_Hardware.inc"

// CHECK THAT BOTH LINK POINTS HAVE BEEN DEFINED
// *********************************************
#declare i = 0;
#declare link_twist  = 0;
#declare link_size = R*0.85;        
#declare _LN_warning = "" 



#macro RiggingCalc ()

        #ifndef (camera_sky) 
                #declare camera_sky = <0, 1, .0000001>; 
        #end
        #ifndef (link_looseness) 
                #declare link_looseness = 0.3; 
        #end

        // CALC GLOBAL ROTATIONS TO CONVERT SKY DIRECTION INTO +Y
        // ******************************************************
        #declare _LN_grotx = degrees(atan2(vlength(camera_sky * <1, 0, 1>), camera_sky.y));
        #declare _LN_groty = degrees(atan2(camera_sky.x, camera_sky.z));
        #declare _LN_link_point2 = vrotate(vrotate(link_point2 - link_point1, -y * _LN_groty), -x * _LN_grotx);
        
        // CALC TRANSFORMATIONS TO CONVERT POINTS INTO XY PLANE
        // ****************************************************
        #declare _LN_grotax = -degrees(atan2(_LN_link_point2.z, _LN_link_point2.x));
        #declare _LN_link_point2 = vrotate(_LN_link_point2, -y * _LN_grotax);
        #if (_LN_link_point2.x = 0) 
                #declare _LN_link_point2 = _LN_link_point2.y * <1/100, 1, 0>; 
        #end
        
        // DETERMINE HIGHEST POINT AND THIRD POINT (WITH RESPECT TO LOOSENESS)
        // *******************************************************************
        #declare _LN_X1 = 0;
        #declare _LN_Y1 = 0;
        #declare _LN_X2 = _LN_link_point2.x ;
        #declare _LN_Y2 = _LN_link_point2.y ;
        #if (_LN_Y2 <= 0)
                #declare _LN_X3 = 2 * _LN_X2;
                #declare _LN_Y3 = (2 * _LN_Y2) + (link_looseness * abs(_LN_X2));
        #else
                #declare _LN_X3 = -_LN_X2;
                #declare _LN_Y3 = -_LN_Y2 + (link_looseness * abs(_LN_X2));
        #end

        // DETERMINE QUADRATIC FUNCTION THAT FITS THREE POINTS
        // ***************************************************
        #declare _LN_A = ((_LN_Y1-_LN_Y3)/((_LN_X1*_LN_X1)-(_LN_X3*_LN_X3))+((_LN_Y2-_LN_Y3)*(_LN_X3-_LN_X1))/(((_LN_X1*_LN_X1)-(_LN_X3*_LN_X3))*(_LN_X2-_LN_X3)))/(1-(((_LN_X3*_LN_X3)-(_LN_X2*_LN_X2))*(_LN_X3-_LN_X1))/(((_LN_X1*_LN_X1)-(_LN_X3*_LN_X3))*(_LN_X2-_LN_X3)));
        #declare _LN_B = ((_LN_Y2-_LN_Y3)+(_LN_A*((_LN_X3*_LN_X3)-(_LN_X2*_LN_X2))))/(_LN_X2-_LN_X3);
        #declare _LN_C = _LN_Y3-(_LN_A*(_LN_X3*_LN_X3))-(_LN_B*_LN_X3);
        
        // CALCULATE LENGTH OF QUADRATIC
        // *****************************
        #if (_LN_A = 0) 
                #declare _LN_length = vlength(<_LN_X2, _LN_Y2, 0>);
        #else 
                #declare _LN_length = (((_LN_X2/4)+(_LN_B/(8*_LN_A)))*sqrt(4+(16*_LN_A*_LN_A*_LN_X2*_LN_X2)+(16*_LN_A*_LN_X2*_LN_B)+(4*_LN_B*_LN_B))+(log(((_LN_X2+(_LN_B/(2*_LN_A)))+sqrt((_LN_X2*_LN_X2)+_LN_X2*_LN_B/_LN_A+(_LN_B*_LN_B/(4*_LN_A*_LN_A))+(1/(4*_LN_A*_LN_A))))/(1/(2*_LN_A)))/(4*_LN_A)));
                #declare _LN_length = _LN_length - (((_LN_X1/4)+(_LN_B/(8*_LN_A)))*sqrt(4+(16*_LN_A*_LN_A*_LN_X1*_LN_X1)+(16*_LN_A*_LN_X1*_LN_B)+(4*_LN_B*_LN_B))+(log(((_LN_X1+(_LN_B/(2*_LN_A)))+sqrt((_LN_X1*_LN_X1)+_LN_X1*_LN_B/_LN_A+(_LN_B*_LN_B/(4*_LN_A*_LN_A))+(1/(4*_LN_A*_LN_A))))/(1/(2*_LN_A)))/(4*_LN_A)));
        #end

        // CHECK LINK OPTIONS AND ASSIGN DEFAULTS
        // **************************************
        #ifndef (link_object)
                #declare link_object = sphere{<0,0,0>,R scale x*1.2 texture{RopeT scale R rotate<90,0,0>} scale<1,0.75,1> rotate<0,0,90> rotate<0,-60,0>}
        #end
        #ifdef (link_count) 
                #declare _LN_count = link_count;
        #else 
                #ifdef (link_size) 
                        #declare _LN_count = int(_LN_length / link_size);
                #else 
                        #declare _LN_count = 20;
                #end 
        #end
        #if (_LN_count < 4) 
                #declare _LN_count = 4; 
        #end
        #ifdef (link_twist) 
                #declare _LN_rotinc = link_twist * (abs(link_twist) < 1 ? 180 : 1);
        #else 
                #ifdef (total_link_twist) 
                        #declare _LN_rotinc = total_link_twist / _LN_count;
                #else 
                        #declare _LN_rotinc = 0; 
                #end 
        #end
        #ifndef (link_seed) 
                #declare _LN_rand = seed(0); 
        #else 
                #declare _LN_rand = seed(link_seed); 
        #end
        #ifndef (link_size_turb) 
                #declare link_size_turb = 0; 
        #end
        #ifndef (link_twist_turb) 
                #declare link_twist_turb = 0; 
        #end
        #ifndef (scale_links) 
                #declare scale_links = true; 
        #end
        #ifndef (rotate_links) 
                #declare rotate_links = true; 
        #end

                #declare _LN_cpoint = <0, 0, 0>;
                #declare _LN_lrotx = 0;
                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                
                #declare _LN_X = _LN_X1;
                #declare L1Flag = 0;
                #declare L2Flag = 0;
                #declare RigCount = 0;
                #declare Distance = VDist(link_point1,link_point2);

#end 

#macro LoopMacro (LOD,R,R1)
        union{
                #declare n=0;
                #while (n< 360)
                        sphere{<0,0,0>, R scale <1,1,1.2> texture{RopeT scale R rotate<0,0,-n*30>}scale<0.75,1,1> rotate<0,-60,0> translate<0,R1,0.75*R + n*R/360> rotate<0,0,StartAngle1+n>}
                        sphere{<0,0,0>, R scale <1,1,1.2> texture{RopeT scale R rotate<0,0,-n*30>}scale<0.75,1,1> rotate<0,-60,0> translate<0,R1,-0.75*R - n*R/360> rotate<0,0,StartAngle1+n>}
                        #declare n=n+0.75*(R/(R1*.01745)); 
                #end
                union{
                        #declare n=0;
                        #while (n< 180)
                                sphere{<0,0,0>, R scale <1,1,1.2> texture{RopeT scale R rotate<0,0,-n*30>}scale<0.75,1,1> rotate<0,-60,0> translate<0,2*R,0> rotate<0,0,StartAngle1+n>}
                                #declare n=n+0.75*(R/(2*R*.01745)); 
                        #end
                        rotate<0,90,0>
                        translate<R1,0,0>
                }
        }

#end

#macro LoopMacro2 (LOD,R,R1)
        union{
                #declare n=0;
                #while (n< 360)
                        sphere{<0,0,0>, R scale <1,1,1.2> texture{RopeT scale R rotate<0,0,-n*30>}scale<0.75,1,1> rotate<0,-60,0> translate<0,R1,0> rotate<0,0,StartAngle1+n>}
                        #declare n=n+1*(R/(R1*.01745)); 
                #end
        }

#end

#macro SeizeMacro (LOD,R)
        union{
                #declare n=0;
                #while (n<link_size)
                        
                        #declare SD = seed(1234+n );
                        #declare RM =RRand(1, 1.05, SD);
                        #declare RopeSect =
                                union{
                                        cylinder{<-1.1*R,0,-0.75*R,>,<-1.1*R,0,0.75*R>0.15*R}
                                        cylinder{<1.1*R,0,-0.75*R>,<1.1*R,0,0.75*R>0.15*R}
                                        torus{1.1*R,0.15*R translate<0,0,-0.75*R>}
                                        torus{1.1*R,0.15*R translate<0,0,0.75*R>}
                                        scale<1,1,0.875>
                                }
                        
                        object{RopeSect texture{RopeT scale R rotate<90,n*12.23*RM,0>} scale RM rotate<2.5*RM,0,7.5*RM>translate<0,0.125*n*R,0> }
                        #declare n=n+2.5;
                        //#declare i=i+1;
                #end
        }

#end

        #ifndef (Point4) 
                #declare Point4 = <0,0,0,0>; 
        #end


// Converting point color vector into a dimensional vector
#declare link_point1 = <Point1.x,Point1.y,Point1.z>;
#declare link_point2 = <Point2.x,Point2.y,Point2.z>;
#declare link_point3 = <Point3.x,Point3.y,Point3.z>;
#declare link_point4 = <Point4.x,Point4.y,Point4.z>; 
// the t portion of the color vector dewscribes the end of the rope and the rotation of the end of the rope.
#declare P1T = Point1.t;
#declare P2T = Point2.t;
#declare P3T = Point3.t;
#declare P4T = Point4.t;                                   
// The integer of the t value describes the end of the rope.
#declare End1 = int(P1T);
#declare End2 = int(P2T);
#declare End3 = int(P3T);
#declare End4 = int(P4T);

// The decimal protion of the t value determines the rotation of the rope end.
#declare EndRot1 = mod(P1T,1)*100;
#declare EndRot2 = mod(P2T,1)*100;
#declare EndRot3 = mod(P3T,1)*100;
#declare EndRot4 = mod(P4T,1)*100;


#switch (End1)
        #case (0)
                #declare EndObject1 = sphere{<0,0,0>,R scale <1.2,1,1> texture{RopeT scale R rotate<90,0,0>} scale<1,0.75,1> rotate<0,0,90> rotate<0,-60,0>}
                #declare Offset = 0.75*R;
        
        #break
        #case (1)
                #declare EndObject1 = object{LoopMacro (3,R,R1) rotate<EndRot1,0,0>}
                #declare Offset = 0.75*R;
        #break
        #case (2)
                #declare EndObject1 = object{LoopMacro (3,R,R1) rotate<EndRot1,0,0>}
                #declare Offset = 0.75*R;
        #break
        #case (3)
                #declare EndObject1 = object{LoopMacro2 (3,R,R1) rotate<90 + EndRot1,0,0>}
                #declare Offset = 0.75*R;
        
        
        #break
#end

#switch (End2)
        #case (0)
                #declare EndObject2 = sphere{<0,0,0>,R scale <1.2,1,1> texture{RopeT scale R rotate<90,0,0>} scale<1,0.75,1> rotate<0,0,90> rotate<0,-60,0>}
                #declare Offset = 0.75*R;
        #break
        #case (1)
                #declare EndObject2 = object{LoopMacro (3,R,R2) rotate<EndRot2,0,0>}
                #declare Offset = 0.75*R;
        
        #break
        #case (2)
        
                #declare EndObject2 = object{LoopMacro (3,R,R2) rotate<EndRot2,0,0>}
                #declare Offset = 0.75*R;
        #break
        #case (3)
                #declare EndObject2 = object{LoopMacro2 (3,R,R2) rotate<90+ EndRot2,0,0>}
                #declare Offset = 0.75*R;
        
        
        #break
        #case (4)
                #declare EndObject2 =                                           
                        union{                
                                
                                
                                torus{2*R,R rotate<0,0,90>}
                                
                                union{
                                        cylinder{<0,-2*R,0>,<0,-10*R,0>,R }
                                        #declare n=0;
                                        #while (n<270)
                                                sphere{<0,4*R,0>, R-n/150 rotate<0,0,n> translate<0,-14*R,0>}
                                                #declare n=n+1;
                                        #end        
                                
                                        rotate<0,EndRot2,0>
                                        
                                }
                                texture{RustyPaint}
                                translate<0,15*R,0>
                                rotate<0,180,-90>
                                
                        }
        
                #declare L2 = 24*R;
        #break
        
        
#end        
#switch (End3)
        #case (0)
                #declare EndObject3 = sphere{<0,0,0>,R scale <1.2,1,1> texture{RopeT scale R rotate<90,0,0>} scale<1,0.75,1> rotate<0,0,90> rotate<0,-60,0>}
                #declare Offset = 0.75*R;
        #break
        #case (1)
                #declare EndObject3 = object{LoopMacro (3,R,R3)  rotate<EndRot3,180,0> }
        #break
        #case (2)
        
                #declare EndObject3 = object{LoopMacro (3,R,R3)  rotate<EndRot3,180,0> }
                #declare Offset = 0.75*R;
        #break
        #case (3)
                #declare EndObject3 = object{LoopMacro2 (3,R,R3) rotate<90+ EndRot3,0,0>}
                #declare Offset = 0.75*R;
        
        
        #break
#end        
#switch (End4)
        #case (0)
                #declare EndObject4 = sphere{<0,0,0>,R scale <1.2,1,1> texture{RopeT scale R rotate<90,0,0>} scale<1,0.75,1> rotate<0,0,90> rotate<0,-60,0>}
                #declare Offset = 0.75*R;
        #break
        #case (1)
                #declare EndObject4 = object{LoopMacro (3,R,R4)  rotate<EndRot4,180,0> }
        #break
        #case (2)
        
                #declare EndObject4 = object{LoopMacro (3,R,R4)  rotate<EndRot4,180,0> }
                #declare Offset = 0.75*R;
        #break
        #case (3)
                #declare EndObject4 = object{LoopMacro2 (3,R,R4) rotate<90+ EndRot4,0,0>}
                #declare Offset = 0.75*R;
        
        
        #break
#end        

#switch(RigConfig)
        
        #case(0)
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        
                        
                        
                        union {
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        #if(RigCount =1)
                                                object {
                                                        EndObject1
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        //translate _LN_cpoint
                                                }
                                        
                                        #end

                                        #if(RigCount*link_size < L1)

                                        
                                                #switch (End1)
                                                
                                                        case (0)
                                                        
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset*RigCount*link_size/L1>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        #case (1)
                                                                
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size & RigCount*link_size > R1+2*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  >= L1-3*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                                
                                                                
                                                        
                                                        #break
                                                        #range (2,3)
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size & RigCount*link_size  > R1+2*link_size)// 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < 20*link_size & RigCount*link_size  > R1+2*link_size)//3*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end

                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+5*link_size & RigCount*link_size  > R1+2*link_size)// 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        
                                                        
                                                        
                                                        
                                                #end        
                                        
                                        
                                        
                                        #end                                        
                                        #if(RigCount*link_size >= L1-2*R & L1Flag = 0)
                                        
                                                #declare L1Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS1,11,StartAngle1,EndAngle1,-90,90)
                                                        rotate<0,0,90>
                                                        rotate<BlockRotate1,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA = 
                                                        transform{
                                                                translate<0,-5*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                        
                                                #declare TransformB =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,StartAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                
                                                        
                                                #declare TransformC = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                        
                                                
                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end


                #declare PointA = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = <Point2.x,Point2.y,Point2.z>;

                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        
                                        #if (End2=1)
                                                #declare End2 = 0;
                                        #end
                                        #switch (End2)
                                                #case(0)
                                                
                                                
                                                        object {link_object
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                #break
                                                #range(2,3)
                                                        #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-R2-2*link_size)// & RigCount*link_size > R2+2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size & RigCount*link_size  < Distance-15*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-R2-6*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                #break
                                                #case(4)
                                                        #if(RigCount*link_size  >= Distance-20*link_size -19*R & RigCount*link_size  < Distance-3*link_size -19*R)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-3*link_size -19*R)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size -19*R & RigCount*link_size  < Distance-15*link_size -19*R)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        
                                                        
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-8*link_size -19*R & RigCount*link_size  < Distance-5*link_size -19*R)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-5*link_size -16*R & RigCount*link_size  < Distance-4*link_size -16*R)
                                                                
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        
                                                                        rotate<0,0,90>
                                                                        rotate<0,90,0>
                                                                        translate<2*R,0,-0.5*R>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                                
                                                                object{LoopMacro2 (3,R,2*R) 
                                                                        
                                                                        
                                                                        rotate<90,0,0>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                
                                                                
                                                                }
                                                        
                                                        #end
                                                
                                                #break
                                        #end                
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                       
                        object {
                                EndObject2
                                rotate<0,180,0>
                                //rotate<0,0,-90>
                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                translate <Point2.x,Point2.y,Point2.z>
                        }        
        
        
        

                #end

                #declare PointA = vtransform(<0,0,0>,TransformC);
                #declare link_point1 = PointA;
                #declare link_point2 = <Point3.x,Point3.y,Point3.z>;

                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        
                                        
                                        #switch (End3)
                                                #range(0,1)
                                                
                                                
                                                        object {link_object
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                #break
                                                #range(2,3)
                                                        #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size & RigCount*link_size  < Distance-15*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-8*link_size & RigCount*link_size  < Distance-R3-1*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                #break
                                                
                                        #end                
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                       
                        object {
                                EndObject3
                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                translate _LN_cpoint
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                
               #end
        #break
        #case(1) 
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;

                                        #if(RigCount =1)
                                                object {
                                                        EndObject1
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        //translate _LN_cpoint
                                                }
                                        
                                        #end

                                        #if(RigCount*link_size < L1)

                                        
                                                #switch (End1)
                                                
                                                        case (0)
                                                        
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset*RigCount*link_size/L1>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        
                                                        #break
                                                        #case (1)
                                                                
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  >= L1-3*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                                
                                                                
                                                        
                                                        #break
                                                        #range (2,3)
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size & RigCount*link_size  > R1+2*link_size)// 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < 20*link_size & RigCount*link_size  > R1+2*link_size)//3*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end

                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+5*link_size & RigCount*link_size  > R1+2*link_size)// 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        
                                                        
                                                        
                                                        
                                                #end        
                                        
                                        
                                        
                                        #end

                                        
                                        #if(RigCount*link_size >= L1-2*R & L1Flag = 0)
                                        
                                                #declare L1Flag = 1;
                                                object {
                                                        
                                                        BlockMacroA(3,R,RS1,12,StartAngle1,EndAngle1,-90,90)
                                                        
                                                        rotate<0,0,90>
                                                        rotate<BlockRotate1,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA = //Bottom of Block
                                                        transform{
                                                                translate<0,-3.5*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformD =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,StartAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                
                                                        
                                                #declare TransformE = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                        
                                                
                                        #end
                                        #if(RigCount*link_size >= Distance-L2 & L2Flag != 1)
                                                #declare L2Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS2,11,-90,90,-90,90)
                                                        
                                                        rotate<0,0,-90>
                                                        rotate<BlockRotate2,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                        
                                                #declare TransformB = 
                                                        transform{
                                                                translate<RS2,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformB1 = 
                                                        transform{
                                                                translate<RS2,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                #declare TransformC = 
                                                        transform{
                                                                translate<-RS2,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformC1 = 
                                                        transform{
                                                                //translate<-RS1,0,0.5*RS1>
                                                                translate<0,RS2,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                        #end
                                        #if(RigCount*link_size >= Distance-L2)
                                        
                                                #switch (End2)
                                                
                                                        case (0)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  )
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset+Offset*(RigCount*link_size - Distance +L2)/L2>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end                                                        
                                                        #break
                                                        #case (1)
                                                                #if(RigCount*link_size  <Distance-L2 + 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                        
                                                                #end
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size < Distance -R2 -2*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                #end

                                                        #break
                                                        #range(2,3)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                               
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                               
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > Distance-16.5*link_size & RigCount*link_size  < Distance-14*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  > Distance-R2-4.5*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance - R2-2*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  < Distance - R2-2*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        #break
                                                        #case(4)
                                                        
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end

                                                        
                                                        
                                                        #break
                                                #end        
                                                
 
                                                #if(RigCount*link_size  >= Distance-2*link_size)
                                                        object {
                                                                EndObject2
                                                                rotate<0,180,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                        
                                                #end

                                        #end
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end


                #declare PointA = vtransform(<0,0,0>,TransformE);
                #declare link_point1 = PointA;
                #declare link_point2 = <Point3.x,Point3.y,Point3.z>;

                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        
                                        
                                        #switch (End3)
                                                #range(0,1)
                                                
                                                
                                                        object {link_object
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                #break
                                                #range(2,3)
                                                        #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-3*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size & RigCount*link_size  < Distance-15*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-R3-6*link_size & RigCount*link_size  < Distance-R3-1*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                #break
                                                
                                        #end                
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                       
                        object {
                                EndObject3
                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                translate _LN_cpoint
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }


                #end


                #declare PointA = vtransform(<0,0,0>,TransformC);
                #declare PointB = vtransform(<0,0,0>,TransformD);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #switch(RigConfig)
                                        case(1) 
                                                #while (_LN_X <= _LN_X2)
                                                        #declare _LN_opoint = _LN_cpoint;
                                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                                        #declare RigCount = RigCount+1;
                                                        object {link_object
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                        
                                                        
                                                        
                                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                                #end
                                        #break
                                         
                                         
                                #end         
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end



                #declare PointA = vtransform(<0,0,0>,TransformA);
                #declare PointB = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                       
                                        #if(RigCount*link_size  < 6*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end
                                        
                                        #if(RigCount*link_size < 9.5*link_size & RigCount*link_size  > 8*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        
                                                        rotate<0,0,90>
                                                        rotate<0,90,0>
                                                        translate<0,0,-0.5*R>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end 
                                        
                                        
                                        
                                        
                                        #if(RigCount*link_size  < 16*link_size & RigCount*link_size  > 13*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        //translate<0,0,0.75*R>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA1 = //Bottom of Block
                                                        transform{
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate<-0.75*R,0,0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                        #end
                                                                
                                        #if(RigCount*link_size < 9.5*link_size & RigCount*link_size  > 8*link_size)
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                                
                                                
                                        
                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        

                #end 
                
                #declare PointA = vtransform(<0,0,0>,TransformA1);
                #declare PointB = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        object {
                                                link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        #if(RigCount*link_size  < 10*link_size)
                                                object {
                                                        link_object
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,1.5*R>
                                                        
                                                        translate _LN_cpoint
                                                }
                                        #end
                                        #if(RigCount*link_size < 8.5*link_size & RigCount*link_size  > 7*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        
                                                        rotate<0,0,90> 
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,0.75*R> 
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end 
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        

                #end 



        #break
        
        #case(2)
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                       
                                       
                                       
                                        #if(RigCount =1)
                                                object {
                                                        EndObject1
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        //translate _LN_cpoint
                                                }
                                        
                                        #end

                                        #if(RigCount*link_size < L1)

                                        
                                                #switch (End1)
                                                
                                                        case (0)
                                                        
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset*RigCount*link_size/L1>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        
                                                        #break
                                                        #case (1)
                                                                
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  >= L1-3*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                                
                                                                
                                                        
                                                        #break
                                                        #range (2,3)
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size & RigCount*link_size  > R1+2*link_size)// 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < 20*link_size & RigCount*link_size  > R1+2*link_size)//3*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end

                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+5*link_size & RigCount*link_size  > R1+2*link_size)// 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        
                                                        
                                                        
                                                #end        
                                        
                                        
                                        
                                        #end
                                       
                                        #if(RigCount*link_size >= L1-2*R & L1Flag = 0)
                                        
                                                #declare L1Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS1,11,StartAngle1,EndAngle1,-90,90)
                                                        rotate<0,0,90>
                                                        rotate<BlockRotate1,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformB = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle1>
                                                                rotate<BlockRotate1,0,0>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformA = 
                                                        transform{
                                                                translate<-0,RS1,0>
                                                                rotate<0,0,StartAngle1>
                                                                rotate<BlockRotate1,0,0>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                        
                                                
                                        #end
                                       
                                       
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }

                #end
                
                #declare PointB = <Point2.x, Point2.y, Point2.z>;
                #declare PointA = vtransform(<0,0,0>,TransformA);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;

                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        
                                        
                                        #switch (End2)
                                                #case(0)
                                                
                                                
                                                        object {link_object
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                #break
                                                #case(1)
                                              
                                                        #if(RigCount*link_size < Distance-R2-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                #break
                                                
                                                #range(2,3)
                                                        #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-R2-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size & RigCount*link_size  < Distance-15*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-8*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                #break
                                                
                                        #end                
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                       
                        object {
                                EndObject2
                                rotate<0,180,-0>
                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                translate _LN_cpoint
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                
               #end










                #declare PointA =  <Point3.x,Point3.y,Point3.z>;
                #declare PointB = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;




                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                       
                                       
                                       
                                        #if(RigCount =1)
                                                object {
                                                        EndObject3
                                                        rotate<0,180,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        //translate _LN_cpoint
                                                }
                                        
                                        #end

                                        #if(RigCount*link_size < L2)

                                        
                                                #switch (End3)
                                                
                                                        case (0)
                                                        
                                                                #if(RigCount*link_size  < L2-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset*RigCount*link_size/L2>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L2-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L2-24*link_size & RigCount*link_size  < L2-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  >= L2-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L2-13.5*link_size & RigCount*link_size  < L2-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L2-18.5*link_size & RigCount*link_size  < L2-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L2-8.5*link_size & RigCount*link_size  < L2-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L2-8.5*link_size & RigCount*link_size  < L2-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        
                                                        #break
                                                        #case (1)
                                                                
                                                                
                                                                #if(RigCount*link_size  < L2-12.5*link_size & RigCount*link_size> R3 + 2*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  > L2-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  >= L2-3*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L2-13.5*link_size & RigCount*link_size  < L2-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size >= L2-8.5*link_size & RigCount*link_size  < L2-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L2-8.5*link_size & RigCount*link_size  < L2-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                                
                                                                
                                                        
                                                        #break
                                                        #range (2,3)
                                                                
                                                                #if(RigCount*link_size  < L2-12.5*link_size & RigCount*link_size  > R3+2*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < 20*link_size & RigCount*link_size  > R3+2*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end

                                                                #if(RigCount*link_size  > L2-24*link_size & RigCount*link_size  < L2-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R3+6*link_size & RigCount*link_size  > R3+1*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > L2-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L2-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L2-13.5*link_size & RigCount*link_size  < L2-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L2-18.5*link_size & RigCount*link_size  < L2-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L2-8.5*link_size & RigCount*link_size  < L2-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L2-8.5*link_size & RigCount*link_size  < L2-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        
                                                        
                                                        
                                                        
                                                #end        
                                        
                                        
                                        
                                        #end
                                       
                                        #if(RigCount*link_size >= L2-2*R & L2Flag = 0)
                                        
                                                #declare L2Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS2,11,StartAngle2,EndAngle2,-90,90)
                                                        rotate<0,0,90>
                                                        rotate<BlockRotate2,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformC = 
                                                        transform{
                                                                translate<0,RS2,0>
                                                                rotate<0,0,StartAngle2>
                                                                translate<0,2*RS2,0>
                                                                
                                                                
                                                                
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformD = 
                                                        transform{
                                                                translate<0,RS2,0>
                                                                rotate<0,0,EndAngle2>
                                                                translate<0,2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                        
                                                
                                        #end
                                       
                                       
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }

                #end



                #declare PointA = vtransform(<0,0,0>,TransformB);
                #declare PointB = vtransform(<0,0,0>,TransformC);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
                #end
        
                #declare PointA = vtransform(<0,0,0>,TransformD);
                #declare PointB = <Point4.x,Point4.y,Point4.z>;
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;

                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        
                                        
                                        #switch (End4)
                                                #range(0,1)
                                                
                                                
                                                        object {link_object
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                #break
                                                #range(2,3)
                                                        #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R4-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-R4-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size & RigCount*link_size  < Distance-15*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-R4-6*link_size & RigCount*link_size  < Distance-R4-1*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                #break
                                                
                                        #end                
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                       
                        object {
                                EndObject4
                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                translate _LN_cpoint
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                
               #end


/*                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
                #end
*/        
        #break 
        #case(3) 
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;

                                        #if(RigCount =1)
                                                object {
                                                        EndObject1
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        //translate _LN_cpoint
                                                }
                                        
                                        #end

                                        #if(RigCount*link_size < L1)

                                        
                                                #switch (End1)
                                                
                                                        case (0)
                                                        
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset*RigCount*link_size/L1>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        
                                                        #break
                                                        #case (1)
                                                                
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  >= L1-3*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                                
                                                                
                                                        
                                                        #break
                                                        #range (2,3)
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size & RigCount*link_size  > R1+2*link_size)// 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < 20*link_size & RigCount*link_size  > R1+2*link_size)//3*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end

                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+5*link_size & RigCount*link_size  > R1+2*link_size)// 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        
                                                        
                                                        
                                                #end        
                                        
                                        
                                        
                                        #end
                                        
                                        
                                        
                                        
                                        
                                        
                                        #if(RigCount*link_size >= L1-2*R & L1Flag = 0)
                                        
                                                #declare L1Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS1,12,StartAngle1,EndAngle1,-90,90)
                                                        rotate<0,0,90>
                                                        rotate<BlockRotate1,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA = //Bottom of Block
                                                        transform{
                                                                translate<0,-3.5*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformD =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,StartAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                
                                                        
                                                #declare TransformE = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                        
                                                
                                        #end
                                        
                                        
                                        
                                        
                                        
                                        #if(RigCount*link_size >= Distance-L2-4*RS1 & L2Flag != 1)
                                                #declare L2Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS2,11,-90,90,-90,90)
                                                        rotate<0,0,-90>
                                                        rotate<BlockRotate2,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        translate<R,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                object {
                                                        BlockMacroA(3,R,RS1,11,StartAngle2,EndAngle2,-90,90)
                                                        
                                                        rotate<0,0,-90>
                                                        rotate<BlockRotate2,0,0>
                                                        translate<2*RS2+1.5*RS1,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformB = 
                                                        transform{
                                                                translate<RS2,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformB1 = 
                                                        transform{
                                                                translate<RS2,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                #declare TransformC = 
                                                        transform{
                                                                translate<-RS2,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformC1 = 
                                                        transform{
                                                                //translate<-RS1,0,0.5*RS1>
                                                                translate<0,RS2,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                        
                                                #declare TransformF = 
                                                        transform{
                                                                //translate<RS1,-2*RS1+15*R,0>
                                                                
                                                                translate<0,RS1,0>
                                                                rotate<0,0,StartAngle2>
                                                                translate<0,1.5*RS2,0>
                                                                
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformG = 
                                                        transform{
                                                                //translate<-RS1,-2*RS1+15*R,0>
                                                                
                                                                
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle2>
                                                                translate<0,1.5*RS2,0>
                                                                
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                        
                                        
                                        
                                        
                                        
                                       
                                        
                                        
                                        #end
                                       
                                       
                                       
                                       
                                       
                                       
                                       
                                        #if(RigCount*link_size >= Distance-L2)
                                        
                                                #switch (End2)
                                                
                                                        case (0)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size )
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset+Offset*(RigCount*link_size - Distance +L2)/L2>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end                                                        
                                                        #break
                                                        #case (1)
                                                                #if(RigCount*link_size  <Distance-L2 + 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                        
                                                                #end
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size < Distance-R2-2*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                #end

                                                        #break
                                                        #range(2,3)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > Distance-16.5*link_size & RigCount*link_size  < Distance-14*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  > Distance-R2-6.5*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance - R2-2*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  < Distance - R2-2*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        #break
                                                        #case(4)
                                                        
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end

                                                        
                                                        
                                                        #break
                                                #end        
                                                
 
                                                #if(RigCount*link_size  >= Distance-2*link_size)
                                                        object {
                                                                EndObject2
                                                                rotate<0,180,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                        
                                                #end

                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end




                #declare PointA = vtransform(<0,0,0>,TransformA);
                #declare PointB = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        #if(RigCount*link_size  < 6*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end
                                        
                                        #if(RigCount*link_size < 9.5*link_size & RigCount*link_size  > 8*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        
                                                        rotate<0,0,90>
                                                        rotate<0,90,0>
                                                        translate<0,0,-0.5*R>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end 
                                        
                                        
                                        
                                        
                                        #if(RigCount*link_size  < 16*link_size & RigCount*link_size  > 13*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        //translate<0,0,0.75*R>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA1 = //Bottom of Block
                                                        transform{
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate<-0.75*R,0,0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                        #end
                                                                
                                        #if(RigCount*link_size < 9.5*link_size & RigCount*link_size  > 8*link_size)
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                                
                                                
                                        
                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        

                #end 
                
                #declare PointA = vtransform(<0,0,0>,TransformA1);
                #declare PointB = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        object {
                                                link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        #if(RigCount*link_size  < 10*link_size)
                                                object {
                                                        link_object
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,1.5*R>
                                                        
                                                        translate _LN_cpoint
                                                }
                                        #end
                                        #if(RigCount*link_size < 8.5*link_size & RigCount*link_size  > 7*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        
                                                        rotate<0,0,90> 
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,0.75*R> 
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end 
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        

                #end 






                #declare PointA = vtransform(<0,0,0>,TransformE);
                #declare link_point1 = PointA;
                #declare link_point2 = <Point3.x,Point3.y,Point3.z>;

                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        
                                        
                                        #switch (End3)
                                                #range(0,1)
                                                
                                                
                                                        object {link_object
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                #break
                                                #range(2,3)
                                                        #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size & RigCount*link_size  < Distance-15*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-R3-6*link_size & RigCount*link_size  < Distance-R3-1*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                #break
                                                
                                        #end                
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                       
                        object {
                                EndObject3
                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                translate _LN_cpoint
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }


                #end




                #declare PointA = vtransform(<0,0,0>,TransformC);
                #declare PointB = vtransform(<0,0,0>,TransformD);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end

                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end
             
             
//sphere{vtransform(<0,0,0>, TransformF), 25 pigment{Red}}
//sphere{vtransform(<0,0,0>, TransformG), 25 pigment{Green}}
             
             
        #break

        #case(4) 
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                        
                        
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        #if(RigCount =1)
                                                object {
                                                        EndObject1
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        //translate _LN_cpoint
                                                }
                                        
                                        #end



                                        #if(RigCount*link_size < L1)
                                        
                                        
                                                #switch (End1)
                                                
                                                        case (0)
                                                        
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset*RigCount*link_size/L1>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        
                                                        #break
                                                        #case (1)
                                                                
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  >= L1-3*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                                
                                                                
                                                        
                                                        #break
                                                        #range (2,3)
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size & RigCount*link_size  > R1+2*link_size)// 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < 20*link_size & RigCount*link_size  > R1+2*link_size)//3*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end

                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+5*link_size & RigCount*link_size  > R1+2*link_size)// 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        
                                                        
                                                        
                                                        
                                                #end        
                                        
                                        
                                        
                                        #end
                                        
                                        
                                        #if(RigCount*link_size >= L1-2*R & L1Flag = 0)
                                        
                                                #declare L1Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS1,12,StartAngle1,EndAngle1,-90,90)
                                                        rotate<0,0,90>
                                                        rotate<BlockRotate1,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA = //Bottom of Block
                                                        transform{
                                                                translate<0,-3.5*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformD =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,StartAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                
                                                        
                                                #declare TransformE = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                        
                                                
                                        #end
                                        #if(RigCount*link_size >= Distance-L2 & L2Flag != 1)
                                                #declare L2Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS2,21,-90,EndAngle1,-90,90)
                                                        
                                                        rotate<0,0,-90>
                                                        rotate<BlockRotate2,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                        
                                                #declare TransformB = 
                                                        transform{
                                                                translate<RS2,-2*RS2,-0.5*RS2>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformB1 = 
                                                        transform{
                                                                translate<RS2,-2*RS2,0.5*RS2>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                #declare TransformC = 
                                                        transform{
                                                                translate<-RS2,-2*RS2,-0.5*RS2>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformC1 = 
                                                        transform{
                                                                //translate<-RS1,0,0.5*RS1>
                                                                translate<0,RS2,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS2,0.5*RS2>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                        #end
                                        #if(RigCount*link_size >= Distance-L2)
                                        
                                                #switch (End2)
                                                
                                                        case (0)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  )
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset+Offset*(RigCount*link_size - Distance +L2)/L2>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        #break
                                                        #case (1)
                                                                #if(RigCount*link_size  <Distance-L2 + 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                        
                                                                #end
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size< Distance-R2-2*link_size )
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                #end

                                                        #break
                                                        #range(2,3)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > Distance-16.5*link_size & RigCount*link_size  < Distance-14*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  > Distance-R2-6.5*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance - R2-2*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size < Distance - R2-2*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        #break
                                                        #case(4)
                                                        
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end

                                                        
                                                        
                                                        #break
                                                #end        
                                                
 
                                                #if(RigCount*link_size  >= Distance-1.5*link_size)
                                                        object {
                                                                EndObject2
                                                                rotate<0,180,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                        
                                                #end
                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end



                #declare PointA = vtransform(<0,0,0>,TransformA);
                #declare PointB = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        #if(RigCount*link_size  < 6*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end
                                        
                                        #if(RigCount*link_size < 9.5*link_size & RigCount*link_size  > 8*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        
                                                        rotate<0,0,90>
                                                        rotate<0,90,0>
                                                        translate<0,0,-0.5*R>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end 
                                        
                                        
                                        
                                        
                                        #if(RigCount*link_size  < 16*link_size & RigCount*link_size  > 13*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        //translate<0,0,0.75*R>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA1 = //Bottom of Block
                                                        transform{
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate<-0.75*R,0,0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                        #end
                                                                
                                        #if(RigCount*link_size < 9.5*link_size & RigCount*link_size  > 8*link_size)
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                                
                                                
                                        
                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        

                #end 
                
                #declare PointA = vtransform(<0,0,0>,TransformA1);
                #declare PointB = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        object {
                                                link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        #if(RigCount*link_size  < 10*link_size)
                                                object {
                                                        link_object
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,1.5*R>
                                                        
                                                        translate _LN_cpoint
                                                }
                                        #end
                                        #if(RigCount*link_size < 8.5*link_size & RigCount*link_size  > 7*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        
                                                        rotate<0,0,90> 
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,0.75*R> 
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end 
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        

                #end 
                
               

                #declare PointA = vtransform(<0,0,0>,TransformE);
                #declare PointB = vtransform(<0,0,0>,TransformB1);

                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        
        

                #end


               
                #declare PointA = vtransform(<0,0,0>,TransformC);
                #declare PointB = vtransform(<0,0,0>,TransformD);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;

                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end 
                
                
                #declare PointA = vtransform(<0,0,0>,TransformC1);
                #declare PointB = <Point3.x,Point3.y,Point3.z>;
                
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        
                                        
                                        #switch (End3)
                                                #range(0,1)
                                                
                                                
                                                        object {link_object
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                #break
                                                #range(2,3)
                                                        #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size & RigCount*link_size  < Distance-15*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-R3-6*link_size & RigCount*link_size  < Distance-R3-1*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                #break
                                                
                                        #end                
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                       
                        object {
                                EndObject3
                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                translate _LN_cpoint
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }

                        
                        
                
                #end
        #break

        #case(5)
        
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;

                                        #if(RigCount =1)
                                                object {
                                                        EndObject1
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        //translate _LN_cpoint
                                                }
                                        
                                        #end

                                        #if(RigCount*link_size < L1)

                                        
                                                #switch (End1)
                                                
                                                        case (0)
                                                        
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset*RigCount*link_size/L1>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        
                                                        #break
                                                        #case (1)
                                                                
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  >= L1-3*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                                
                                                                
                                                        
                                                        #break
                                                        #range (2,3)
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size & RigCount*link_size  > R1+2*link_size)// 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < 20*link_size & RigCount*link_size  > R1+2*link_size)//3*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end

                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+5*link_size & RigCount*link_size  > R1+2*link_size)// 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break

                                                        
                                                        
                                                        
                                                        
                                                #end        
                                        
                                        
                                        
                                        #end
                                        
                                        
                                        
                                        
                                        
                                        
                                        #if(RigCount*link_size >= L1-2*R & L1Flag = 0)
                                        
                                                #declare L1Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS1,12,StartAngle1,EndAngle1,-90,90)
                                                        rotate<0,0,90>
                                                        rotate<BlockRotate1,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA = //Bottom of Block
                                                        transform{
                                                                translate<0,-3.5*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformD =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,StartAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                
                                                        
                                                #declare TransformE = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                        
                                                
                                        #end
                                        
                                        
                                        
                                        
                                        
                                        #if(RigCount*link_size >= Distance-L2 & L2Flag != 1)
                                                #declare L2Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS2,11,StartAngle2,EndAngle2,-90,90)
                                                        
                                                        rotate<0,0,-90>
                                                        rotate<BlockRotate2,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformB = 
                                                        transform{
                                                                translate<RS2,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformB1 = 
                                                        transform{
                                                                translate<RS2,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                #declare TransformC = 
                                                        transform{
                                                                translate<0,-3.8*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformC1 = 
                                                        transform{
                                                                //translate<-RS1,0,0.5*RS1>
                                                                translate<0,RS2,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                        
                                                #declare TransformF = 
                                                        transform{
                                                                //translate<RS1,-2*RS1+15*R,0>
                                                                
                                                                translate<0,RS2,0>
                                                                rotate<0,0,StartAngle2>
                                                                translate<0,-2*RS2,0>
                                                                
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformG = 
                                                        transform{
                                                                //translate<-RS1,-2*RS1+15*R,0>
                                                                
                                                                
                                                                translate<0,RS2,0>
                                                                rotate<0,0,EndAngle2>
                                                                translate<0,-2*RS2,0>
                                                                
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                        
                                        
                                        
                                        
                                        
                                       
                                        
                                        
                                        #end
                                       
                                       
                                       
                                       
                                       
                                       
                                       
                                        #if(RigCount*link_size >= Distance-L2)
                                        
                                                #switch (End2)
                                                
                                                        case (0)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size )
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset+Offset*(RigCount*link_size - Distance +L2)/L2>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end                                                        
                                                        #break
                                                        #case (1)
                                                                #if(RigCount*link_size  <Distance-L2 + 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                        
                                                                #end
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  < Distance-R2 -2*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                #end

                                                        #break
                                                        #range(2,3)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > Distance-16.5*link_size & RigCount*link_size  < Distance-14*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  > Distance-R2-6.5*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        #break
                                                        #case(4)
                                                        
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end

                                                        
                                                        
                                                        #break
                                                #end        
                                                
 
                                                #if(RigCount*link_size  >= Distance-1.5*link_size)
                                                        object {
                                                                EndObject2
                                                                rotate<0,180,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                        
                                                #end

                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end



                #declare PointA = vtransform(<0,0,0>,TransformE);
                #declare link_point1 = PointA;
                #declare link_point2 = <Point3.x,Point3.y,Point3.z>;

                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        
                                        
                                        #switch (End3)
                                                #range(0,1)
                                                
                                                
                                                        object {link_object
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                #break
                                                #range(2,3)
                                                        #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size & RigCount*link_size  < Distance-15*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-R3-6*link_size & RigCount*link_size  < Distance-R3-1*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                #break
                                                
                                        #end                
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                       
                        object {
                                EndObject3
                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                translate _LN_cpoint
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }


                #end




                #declare PointB = vtransform(<0,0,0>,TransformC);
                #declare PointA = vtransform(<0,0,0>,TransformD);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;

                                        #if(RigCount*link_size  < Distance-12.5*link_size)
                                                object {link_object
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,-Offset*RigCount*link_size/Distance>
                                                        translate _LN_cpoint
                                                }
                                                
                                        
                                        #end
                                        #if(RigCount*link_size  > Distance-1.5*link_size)
                                                object {link_object
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,-Offset>
                                                        translate _LN_cpoint
                                                }
                                                object {link_object
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,Offset>
                                                        translate _LN_cpoint
                                                } 
                                                
                                        
                                        #end
                                        #if(RigCount*link_size  > Distance-24*link_size & RigCount*link_size  < Distance-12*R)

                                                object {link_object
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,Offset>
                                                        translate _LN_cpoint
                                                } 
                                                
                                        
                                        #end
                                        #if(RigCount*link_size  >= Distance-4*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end
                                        #if(RigCount*link_size  >= Distance-13.5*link_size & RigCount*link_size  < Distance-11.5*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end
                                        
                                        #if(RigCount*link_size  >= Distance-18.5*link_size & RigCount*link_size  < Distance-16.5*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end
                                        
                                        
                                        
                                        #if(RigCount*link_size >= Distance-8.5*link_size & RigCount*link_size  < Distance-7.5*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        
                                                        rotate<0,0,90>
                                                        rotate<0,90,0>
                                                        translate<0,0,-0.5*R>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end 
                                        
                                        
                                        
                                        #if(RigCount*link_size >= Distance-8.5*link_size & RigCount*link_size  < Distance-7.5*link_size)
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                        
                                        #end
                                                       
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end

                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end
             
            
//sphere{vtransform(<0,0,0>, TransformF), 25 pigment{Red}}
//sphere{vtransform(<0,0,0>, TransformG), 25 pigment{Green}}
             
        
        
        
        
        #break
        #case(6)
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                                #switch (End1)
                                                
                                                        #case (0)
                                                                #if(RigCount =1)
                                                                        object {
                                                                                EndObject1
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                
                                                                                //translate _LN_cpoint
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        #case (1)


                                                        #break
                                                        #range (2,3)
                                                                #if(RigCount =1)
                                                                        object {
                                                                                EndObject1
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                
                                                                                //translate _LN_cpoint
                                                                        }
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+12*link_size & RigCount*link_size  > R1+2*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+5*link_size & RigCount*link_size  > R1+2*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                        #break
                                                        
                                                        
                                                        
                                                        
                                                #end        
                                        #declare E2Rot = <0,0,0>;
                                        #switch (End2)
                                                #range(0,1)
                                                        
                                                        #switch (End1)
                                                                #range(0,1)
                                                                         object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #break
                                                                #range(2,3)
                                                                         object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate <0,0,Offset*(1-(RigCount*link_size/Distance))>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                #break        
                                                
                                                        #end
                                                #break
                                                #range(2,3)
                                                        #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-R2-2*link_size & RigCount*link_size>R2+2*link_size )
                                                                #switch (End1)
                                                                        #range(0,1)
                                                                                object {link_object
                                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                        translate<0,0,Offset*RigCount*link_size/Distance>
                                                                                        translate _LN_cpoint
                                                                                }
                                                                        #break
                                                                        #range(2,3)
                                                                                object {link_object
                                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                        translate<0,0,Offset>
                                                                                        translate _LN_cpoint
                                                                                }
                                                                        #break
                                                                #end
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size & RigCount*link_size  < Distance-15*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-R2-6*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                #break
                                                #case(4)
                                                
                                                        #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        
                                                                        rotate<0,0,90>
                                                                        rotate<0,90,0>
                                                                        translate<0,0,-0.5*R>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end 
                                                        
                                                        
                                                        #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                        
                                                                        
                                                                        rotate<90,0,0>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                
                                                                
                                                                }
                                                                
                                                                
                                                        
                                                        #end

                                                        #declare E2Rot = <0,0,0>;
                                                
                                                #break
                                        #end
                                        
                                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                       
                        object {
                                EndObject2
                                rotate<0,0,0>
                                rotate<0,180,-0> 
                                rotate E2Rot
                                //rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                translate <Point2.x,Point2.y,Point2.z>
                        }


                #end
        #break

        #case(7)
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        
                        
                        
                        union {
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        #if(RigCount =1)
                                                object {
                                                        EndObject1
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        //translate _LN_cpoint
                                                }
                                        
                                        #end

                                        #if(RigCount*link_size < L1)

                                        
                                                #switch (End1)
                                                
                                                        case (0)
                                                        
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset*RigCount*link_size/L1>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        #case (1)
                                                                
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  >= L1-3*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                                
                                                                
                                                        
                                                        #break
                                                        #range (2,3)
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size & RigCount*link_size  > R1+2*link_size)// 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < 20*link_size & RigCount*link_size  > R1+2*link_size)//3*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end

                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+5*link_size & RigCount*link_size  > R1+2*link_size)// 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        
                                                        
                                                        
                                                        
                                                #end        
                                        
                                        
                                        
                                        #end                                        
                                        #if(RigCount*link_size >= L1-2*R & L1Flag = 0)
                                        
                                                #declare L1Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS1,11,StartAngle1,EndAngle1,-90,90)
                                                        rotate<0,0,90>
                                                        rotate<BlockRotate1,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA = 
                                                        transform{
                                                                translate<0,-5*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                        
                                                #declare TransformB =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,StartAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                
                                                        
                                                #declare TransformC = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                        
                                                
                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end

        #break
        #case(8)
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        
                        
                        
                        union {
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        #if(RigCount =1)
                                                object {
                                                        EndObject1
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        //translate _LN_cpoint
                                                }
                                        
                                        #end

                                        #if(RigCount*link_size < L1)

                                        
                                                #switch (End1)
                                                
                                                        case (0)
                                                        
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset*RigCount*link_size/L1>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        #case (1)
                                                                
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  >= L1-3*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                                
                                                                
                                                        
                                                        #break
                                                        #range (2,3)
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size & RigCount*link_size  > R1+2*link_size)// 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < 20*link_size & RigCount*link_size  > R1+2*link_size)//3*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end

                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+5*link_size & RigCount*link_size  > R1+2*link_size)// 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        
                                                        
                                                        
                                                        
                                                #end        
                                        
                                        
                                        
                                        #end                                        
                                        #if(RigCount*link_size >= L1-2*R & L1Flag = 0)
                                        
                                                #declare L1Flag = 1;
                                                object {
                                                        
                                                        BlockMacroA(3,R,RS1,21,StartAngle1,EndAngle1,-90,90)
                                                        
                                                        rotate<0,0,90>
                                                        rotate<BlockRotate1,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA = 
                                                        transform{
                                                                translate<0,-5*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                        
                                                #declare TransformB =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,StartAngle2>
                                                                translate<0,-2*RS1,0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                

                                                        
                                                #declare TransformC = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle2>
                                                                translate<0,-2*RS1,0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                       
                                               
                                                #declare TransformB1 =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,StartAngle2>
                                                                translate<0,-2*RS1,-0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                        
                                                #declare TransformC1 = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle2>
                                                                translate<0,-2*RS1,-0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                        

                                        #end 
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end

        #break 
        
        #case(9) 
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                        
                        
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        #if(RigCount =1)
                                                object {
                                                        EndObject1
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        //translate _LN_cpoint
                                                }
                                        
                                        #end



                                        #if(RigCount*link_size < L1)
                                        
                                        
                                                #switch (End1)
                                                
                                                        case (0)
                                                        
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset*RigCount*link_size/L1>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        
                                                        #break
                                                        #case (1)
                                                                
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  >= L1-3*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                                
                                                                
                                                        
                                                        #break
                                                        #range (2,3)
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size & RigCount*link_size  > R1+2*link_size)// 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < 20*link_size & RigCount*link_size  > R1+2*link_size)//3*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end

                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+5*link_size & RigCount*link_size  > R1+2*link_size)// 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        
                                                        
                                                        
                                                        
                                                #end        
                                        
                                        
                                        
                                        #end
                                        
                                        
                                        #if(RigCount*link_size >= L1-2*R & L1Flag = 0)
                                        
                                                #declare L1Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS1,22,-90,EndAngle1,-90,90)
                                                        rotate<0,0,90>
                                                        rotate<BlockRotate1,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA = //Bottom of Block
                                                        transform{
                                                                translate<0,-3.5*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformD =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,-90>
                                                                translate<0,-2*RS1,-0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                #declare TransformD1 =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,-90>
                                                                translate<0,-2*RS1,0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                        
                                                #declare TransformE = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,90>
                                                                translate<0,-2*RS1,-0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformE1 = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS1,0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                        #end
                                        #if(RigCount*link_size >= Distance-L2 & L2Flag != 1)
                                                #declare L2Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS2,21,-90,90,-90,90)
                                                        
                                                        rotate<0,0,-90>
                                                        rotate<BlockRotate2,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                        
                                                #declare TransformB = 
                                                        transform{
                                                                translate<RS2,-2*RS2,-0.5*RS2>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformB1 = 
                                                        transform{
                                                                translate<RS2,-2*RS2,0.5*RS2>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                #declare TransformC = 
                                                        transform{
                                                                translate<-RS2,-2*RS2,-0.5*RS2>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformC1 = 
                                                        transform{
                                                                //translate<-RS1,0,0.5*RS1>
                                                                translate<0,RS2,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS2,0.5*RS2>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                        #end
                                        #if(RigCount*link_size >= Distance-L2)
                                        
                                                #switch (End2)
                                                
                                                        case (0)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  )
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset+Offset*(RigCount*link_size - Distance +L2)/L2>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        #break
                                                        #case (1)
                                                                #if(RigCount*link_size  <Distance-L2 + 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                        
                                                                #end
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size< Distance-R2-2*link_size )
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                #end

                                                        #break
                                                        #range(2,3)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > Distance-16.5*link_size & RigCount*link_size  < Distance-14*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  > Distance-R2-6.5*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance - R2-2*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size < Distance - R2-2*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        #break
                                                        #case(4)
                                                        
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end

                                                        
                                                        
                                                        #break
                                                #end        
                                                
 
                                                #if(RigCount*link_size  >= Distance-1.5*link_size)
                                                        object {
                                                                EndObject2
                                                                rotate<0,180,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                        
                                                #end
                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end



                #declare PointA = vtransform(<0,0,0>,TransformA);
                #declare PointB = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        #if(RigCount*link_size  < 6*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end
                                        
                                        #if(RigCount*link_size < 9.5*link_size & RigCount*link_size  > 8*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        
                                                        rotate<0,0,90>
                                                        rotate<0,90,0>
                                                        translate<0,0,-0.5*R>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end 
                                        
                                        
                                        
                                        
                                        #if(RigCount*link_size  < 16*link_size & RigCount*link_size  > 13*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        //translate<0,0,0.75*R>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA1 = //Bottom of Block
                                                        transform{
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate<-0.75*R,0,0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                        #end
                                                                
                                        #if(RigCount*link_size < 9.5*link_size & RigCount*link_size  > 8*link_size)
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                                
                                                
                                        
                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        

                #end 
                
                #declare PointA = vtransform(<0,0,0>,TransformA1);
                #declare PointB = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        object {
                                                link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        #if(RigCount*link_size  < 10*link_size)
                                                object {
                                                        link_object
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,1.5*R>
                                                        
                                                        translate _LN_cpoint
                                                }
                                        #end
                                        #if(RigCount*link_size < 8.5*link_size & RigCount*link_size  > 7*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        
                                                        rotate<0,0,90> 
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,0.75*R> 
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end 
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        

                #end 
                
               

                #declare PointA = vtransform(<0,0,0>,TransformE);
                #declare PointB = vtransform(<0,0,0>,TransformB1);

                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        
        

                #end


               
                #declare PointA = vtransform(<0,0,0>,TransformC);
                #declare PointB = vtransform(<0,0,0>,TransformD);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;

                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end 
                
                #declare PointA = vtransform(<0,0,0>,TransformC1);
                #declare PointB = vtransform(<0,0,0>,TransformD1);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;

                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end 


                #declare PointA = vtransform(<0,0,0>,TransformE1);
                #declare PointB = <Point3.x,Point3.y,Point3.z>;
                
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        
                                        
                                        #switch (End3)
                                                #range(0,1)
                                                
                                                
                                                        object {link_object
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                #break
                                                #range(2,3)
                                                        #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size & RigCount*link_size  < Distance-15*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-R3-6*link_size & RigCount*link_size  < Distance-R3-1*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                #break
                                                
                                        #end                
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                       
                        object {
                                EndObject3
                                
                                
                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                translate _LN_cpoint
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                                
                        }

                        
                        
                
                #end
        #break        
        
        #case(10) 
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                        
                        
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        #if(RigCount =1)
                                                object {
                                                        EndObject1
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        //translate _LN_cpoint
                                                }
                                        
                                        #end



                                        #if(RigCount*link_size < L1)
                                        
                                        
                                                #switch (End1)
                                                
                                                        case (0)
                                                        
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset*RigCount*link_size/L1>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        
                                                        #break
                                                        #case (1)
                                                                
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  >= L1-3*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                                
                                                                
                                                        
                                                        #break
                                                        #range (2,3)
                                                                
                                                                #if(RigCount*link_size  < L1-12.5*link_size & RigCount*link_size  > R1+2*link_size)// 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < 20*link_size & RigCount*link_size  > R1+2*link_size)//3*link_size)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end

                                                                #if(RigCount*link_size  > L1-24*link_size & RigCount*link_size  < L1-12*R)

                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < R1+5*link_size & RigCount*link_size  > R1+2*link_size)// 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  < 18*link_size & RigCount*link_size  > 15*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > L1-1.5*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        } 
                                                                        
                                                                
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  >= L1-13.5*link_size & RigCount*link_size  < L1-11.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= L1-18.5*link_size & RigCount*link_size  < L1-16.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                
                                                                #if(RigCount*link_size >= L1-8.5*link_size & RigCount*link_size  < L1-7.5*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                
                                                                #end
                                                        #break
                                                        
                                                        
                                                        
                                                        
                                                #end        
                                        
                                        
                                        
                                        #end
                                        
                                        
                                        #if(RigCount*link_size >= L1-2*R & L1Flag = 0)
                                        
                                                #declare L1Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS1,22,-90,EndAngle1,-90,90)
                                                        rotate<0,0,90>
                                                        rotate<BlockRotate1,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA = //Bottom of Block
                                                        transform{
                                                                translate<0,-3.5*RS1,0>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformD =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,-90>
                                                                translate<0,-2*RS1,-0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                #declare TransformD1 =
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,-90>
                                                                translate<0,-2*RS1,0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                        
                                                #declare TransformE = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,90>
                                                                translate<0,-2*RS1,-0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformE1 = 
                                                        transform{
                                                                translate<0,RS1,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS1,0.5*RS1>
                                                                rotate<0,0,90>
                                                                rotate<BlockRotate1,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                        #end
                                        #if(RigCount*link_size >= Distance-L2 & L2Flag != 1)
                                                #declare L2Flag = 1;
                                                object {
                                                        BlockMacroA(3,R,RS2,31,-90,EndAngle1,-90,90)
                                                        
                                                        rotate<0,0,-90>
                                                        rotate<BlockRotate2,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                        
                                                #declare TransformB = 
                                                        transform{
                                                                translate<RS2,-2*RS2,-1*RS2>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformB1 = 
                                                        transform{
                                                                translate<RS2,-2*RS2,0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                #declare TransformC = 
                                                        transform{
                                                                translate<-RS2,-2*RS2,-1*RS2>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                #declare TransformC1 = 
                                                        transform{
                                                                translate<-RS2,-2*RS2,-0>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                        
                                                #declare TransformB2 = 
                                                        transform{
                                                                translate<RS2,-2*RS2,1*RS2>
                                                                rotate<0,0,-90>
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                                
                                                
                                                
                                                
                                                
                                                
                                                #declare TransformC2 = 
                                                        transform{
                                                        
                                                        
                                                        
                                                                translate<0,RS2,0>
                                                                rotate<0,0,EndAngle1>
                                                                translate<0,-2*RS2,1*RS2>
                                                                rotate<0,0,-90>
                                                        
                                                                rotate<BlockRotate2,0,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate link_point1
                                                        
                                                        }
                                                        
                                                        
                                                        
                                                        
                                        #end
                                        #if(RigCount*link_size >= Distance-L2)
                                        
                                                #switch (End2)
                                                
                                                        case (0)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  )
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset+Offset*(RigCount*link_size - Distance +L2)/L2>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        #break
                                                        #case (1)
                                                                #if(RigCount*link_size  <Distance-L2 + 3*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                        
                                                                #end
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size< Distance-R2-2*link_size )
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                #end

                                                        #break
                                                        #range(2,3)
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end
                                                                
                                                                
                                                                #if(RigCount*link_size  < Distance-L2 +14*link_size & RigCount*link_size  > Distance-L2 +11*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                #if(RigCount*link_size  > Distance-16.5*link_size & RigCount*link_size  < Distance-14*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  > Distance-R2-6.5*link_size & RigCount*link_size  < Distance-R2-2*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance - R2-2*link_size)
                                                                        object {link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                
                                                                
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size < Distance - R2-2*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,-Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +12*link_size & RigCount*link_size  <Distance-L2 +22*link_size)
                                                                        object {
                                                                                link_object
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate<0,0,Offset>
                                                                                translate _LN_cpoint
                                                                        }
                                                                #end
                                                                #if(RigCount*link_size  > Distance-L2 +17*link_size & RigCount*link_size  <Distance-L2 +19*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                //translate<0,0,0.75*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                        #break
                                                        #case(4)
                                                        
                                                                #if(RigCount*link_size  <Distance-L2 + 4*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                rotate<0,0,90>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object {
                                                                                SeizeMacro(3,R)
                                                                                
                                                                                rotate<0,0,90>
                                                                                rotate<0,90,0>
                                                                                translate<0,0,-0.5*R>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        }
                                                                        
                                                                #end 
                                                                
                                                                
                                                                #if(RigCount*link_size < Distance-L2 +7.5*link_size & RigCount*link_size  > Distance-L2 +6*link_size)
                                                                        object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                                                
                                                                                
                                                                                rotate<90,0,0>
                                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                                translate _LN_cpoint
                                                                        
                                                                        
                                                                        }
                                                                        
                                                                        
                                                                
                                                                #end

                                                        
                                                        
                                                        #break
                                                #end        
                                                
 
                                                #if(RigCount*link_size  >= Distance-1.5*link_size)
                                                        object {
                                                                EndObject2
                                                                rotate<0,180,0>
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                        
                                                #end
                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end



                #declare PointA = vtransform(<0,0,0>,TransformA);
                #declare PointB = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        #if(RigCount*link_size  < 6*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end
                                        
                                        #if(RigCount*link_size < 9.5*link_size & RigCount*link_size  > 8*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        
                                                        rotate<0,0,90>
                                                        rotate<0,90,0>
                                                        translate<0,0,-0.5*R>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end 
                                        
                                        
                                        
                                        
                                        #if(RigCount*link_size  < 16*link_size & RigCount*link_size  > 13*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        rotate<0,0,90>
                                                        //translate<0,0,0.75*R>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                }
                                                #declare TransformA1 = //Bottom of Block
                                                        transform{
                                                                translate _LN_cpoint
                                                                rotate y * _LN_grotax
                                                                rotate <_LN_grotx, _LN_groty, 0>
                                                                translate<-0.75*R,0,0>
                                                                translate link_point1
                                                        
                                                        }
                                                
                                        #end
                                                                
                                        #if(RigCount*link_size < 9.5*link_size & RigCount*link_size  > 8*link_size)
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<-2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                                object{LoopMacro2 (3,R,2*R) rotate<0,0,0>translate<2*link_size,0,0>
                                                        
                                                        
                                                        rotate<90,0,0>
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate _LN_cpoint
                                                
                                                
                                                }
                                                
                                                
                                        
                                        #end
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        

                #end 
                
                #declare PointA = vtransform(<0,0,0>,TransformA1);
                #declare PointB = vtransform(<0,0,0>,TransformB);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        object {
                                                link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        #if(RigCount*link_size  < 10*link_size)
                                                object {
                                                        link_object
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,1.5*R>
                                                        
                                                        translate _LN_cpoint
                                                }
                                        #end
                                        #if(RigCount*link_size < 8.5*link_size & RigCount*link_size  > 7*link_size)
                                                object {
                                                        SeizeMacro(3,R)
                                                        
                                                        rotate<0,0,90> 
                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                        translate<0,0,0.75*R> 
                                                        translate _LN_cpoint
                                                }
                                                
                                        #end 
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        

                #end 
                
               

                #declare PointA = vtransform(<0,0,0>,TransformE);
                #declare PointB = vtransform(<0,0,0>,TransformB1);

                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
        
        
        
        

                #end


               
                #declare PointA = vtransform(<0,0,0>,TransformC);
                #declare PointB = vtransform(<0,0,0>,TransformD);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;

                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end 
                
                #declare PointA = vtransform(<0,0,0>,TransformC1);
                #declare PointB = vtransform(<0,0,0>,TransformD1);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;

                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end 



                #declare PointA = vtransform(<0,0,0>,TransformE1);
                #declare PointB = vtransform(<0,0,0>,TransformB2);
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;

                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        object {link_object
                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                translate _LN_cpoint
                                        }
                                        
                                        
                                        
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                        
                        
                        
                        
                
                #end 



                #declare PointA = vtransform(<0,0,0>,TransformC2);
                #declare PointB = <Point3.x,Point3.y,Point3.z>;
                
                #declare link_point1 = PointA;
                #declare link_point2 = PointB;
                
                
                #if (strcmp(_LN_warning, "")!=0) 
                        #warning _LN_warning 
                #else
                
                        RiggingCalc()
                        // POSITION LINK OBJECTS
                        // *********************
                        union {
                                #declare _LN_cpoint = <0, 0, 0>;
                                #declare _LN_lrotx = 0;
                                #declare _LN_lscale = _LN_length / (_LN_count - 1);
                                
                                #declare _LN_X = _LN_X1;
                                #while (_LN_X <= _LN_X2)
                                        #declare _LN_opoint = _LN_cpoint;
                                        #declare _LN_cpoint = <_LN_X, _LN_A*_LN_X*_LN_X + _LN_B*_LN_X + _LN_C, 0>;
                                        #declare _LN_lrotz = degrees(atan2(2*_LN_A*_LN_X + _LN_B, 1));
                                        #declare _LN_cscale = _LN_lscale * (1 + (rand(_LN_rand) - .5) * link_size_turb);
                                        #declare RigCount = RigCount+1;
                                        
                                        
                                        
                                        
                                        
                                        #switch (End3)
                                                #range(0,1)
                                                
                                                
                                                        object {link_object
                                                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                translate _LN_cpoint
                                                        }
                                                #break
                                                #range(2,3)
                                                        #if(RigCount*link_size  >= Distance-20*link_size & RigCount*link_size  < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,-(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size < Distance-R3-2*link_size)
                                                                object {link_object
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate<0,0,(Offset*RigCount*link_size/Distance)>
                                                                        translate _LN_cpoint
                                                                }
                                                        
                                                        
                                                        #end
                                                        
                                                        #if(RigCount*link_size  >= Distance-18*link_size & RigCount*link_size  < Distance-15*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        #if(RigCount*link_size  >= Distance-R3-6*link_size & RigCount*link_size  < Distance-R3-1*link_size)
                                                                object {
                                                                        SeizeMacro(3,R)
                                                                        rotate<0,0,90>
                                                                        rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                                                        translate _LN_cpoint
                                                                }
                                                                
                                                        #end
                                                        
                                                #break
                                                
                                        #end                
                                        #declare _LN_lrotx = _LN_lrotx + _LN_rotinc + (rand(_LN_rand) - .5) * link_twist_turb * 360;
                                        #declare _LN_X = (_LN_cpoint + vrotate(x * _LN_cscale, z * _LN_lrotz)).x;
                                #end
                                // MOVE UNIONED LINKS INTO POSITION
                                // ********************************
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                        }
                       
                        object {
                                EndObject3
                                
                                
                                rotate <_LN_lrotx, 0, (rotate_links = false ? 0 :_LN_lrotz)>
                                translate _LN_cpoint
                                rotate y * _LN_grotax
                                rotate <_LN_grotx, _LN_groty, 0>
                                translate link_point1
                                
                        }

                        
                        
                
                #end
        #break        
        
        
        
        
        
        
        
        
        
        
        
        
        
#end         


