/*

2 PASS RADIOSITY SEQUENCE

*/

#if (Radiosity_Pass > 0)
#if (Radiosity_Pass = 1)
sphere {<0,-640000,0>,642000
	pigment {rgb <1,.8891,.6152>}
	finish {ambient .2}
	double_illuminate 
	no_shadow
}
#end
global_settings {
  radiosity {
    pretrace_start 0.04           // start pretrace at this size
    pretrace_end   0.02           // end pretrace at this size
    count 35                      // higher -> higher quality (1..1600) [35]
    nearest_count 5               // higher -> higher quality (1..10) [5]
    error_bound 1.8               // higher -> smoother, less accurate [1.8]
    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
    low_error_factor .5           // reduce error_bound during last pretrace step
    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
    brightness .5                  // brightness of radiosity effects (0..1) [1]
    adc_bailout 0.01/2
	normal on                     // take surface normals into account [off]
    media off                    // take media into account [off] 
    #if (Radiosity_Pass = 1)
    	save_file "rad_data.dat"       // save radiosity data 
    #else
    	load_file "rad_data.dat"       // load saved radiosity data
    	always_sample off           // turn sampling in final trace off [on]
    	max_sample 1.0              // maximum brightness of samples
    #end
  }
} 
#end