/* halton_example.pov 1.0
 * Persistence of Vision Ray Tracer scene description file
 *
 * An example scene that uses halton.inc to generate Halton sequences.
 *
 * Copyright © 2020 Richard Callwood III.  Some rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Along with this scene file, you should have received a copy of the
 * GNU General Public License in the file gpl-v3.0.txt.  If not, see:
 *   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * Vers  Date         Notes
 * ----  ----         -----
 * 1.0   2020-Mar-26  Created.
 */
#version 3.5;

#include "halton.inc"

global_settings { assumed_gamma 1 }

camera
{ orthographic
  location <2/3, 0.5, -1>
  right 1.4 * x
  up 1.05 * y
}

background { rgb 1 }

light_source { <-1, 1, -2> * 1000, rgb 1 parallel point_at 0 }

union
{ #declare I = 1;
  #while (I <= 100)
    sphere { <Halton (2, I) * 4/3, Halton (3, I), 0>, 0.025 }
    #declare I = I + 1;
  #end
  pigment { red 1 }
}
