/* halton.inc 1.0
 * Persistence of Vision Ray Tracer include file
 *
 * Creates Halton sequences.  For more information, see:
 *   https://en.wikipedia.org/wiki/Halton_sequence
 *
 * Copyright © 2020 Richard Callwood III.  Some rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * Along with this include file, you should have received a copy of the
 * GNU General Public License in the file gpl-v3.0.txt.  If not, see:
 *   https://www.gnu.org/licenses/gpl-3.0.html
 *
 * Vers  Date         Notes
 * ----  ----         -----
 * 1.0   2020-Mar-26  Created.
 */
#ifndef (Halton_Inc_Temp) #declare Halton_Inc_Temp = version;
#version 3.5;
#ifdef (View_POV_Include_Stack)
  #debug "#include \"halton.inc\" //version 1.0\n"
#end

/* Returns a number from a Halton sequence.
 * Arguments:
 *   Base  - the base integer of the sequence: one of the co-prime numbers.
 *   Index - the index into the sequence.  The index is one-based; that is, the
 *           first number in the sequence has Index = 1.
 */
#macro Halton (Base, Index)
  Halton__Check ("Base", Base, 2)
  Halton__Check ("Index", Index, 1)
  #local Halton_i = Index;
  #local Halton_f = 1;
  #local Halton_r = 0;
  #while (Halton_i > 0)
    #local Halton_f = Halton_f / Base;
    #local Halton_r = Halton_r + Halton_f * (mod (Halton_i, Base));
    #local Halton_i = floor (Halton_i / Base);
  #end
  Halton_r
#end

#macro Halton__Check (s_Param, Value, Min)
  #if (Value < Min | floor (Value) != Value)
    #error concat
    ( "Halton(): ", s_Param, " must be an integer ", str (Min, 0, 0),
      " or greater, but ", str (Value, 0, -1), " was used."
    )
  #end
#end

#version Halton_Inc_Temp;
#end
