/*
 
 OTOTest.pov
 
 An example showing how to use custom bricks and also a
 method for overriding the texture passed to the macro
 for per-brick materials.
 
 With custom objects, you can do things like randomly
 offset each brick, use isosurfaces or sprinkle in
 special objects like windows, or whatever.
 
*/
#version 3.7;
#default{ finish{ ambient 0 } }

// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

#include "OTOc.inc"

/* making a new brick type between <0,0,0>-<1,1,1> */
#macro OTO_Object(C1, C2, Bev)
 union{
  
  /* This object will take the texture given
     to the OTO macro and make it go away (it's
     wasteful, but the other options are ugly). */
  sphere{0,0 no_image no_shadow no_reflection}
  
  superellipsoid{
   .2*<1,1>
   rotate x*90
   translate 1 scale 1/2
   
   // per-brick material settings
   pigment{
    boxed scale 1.1 translate 1 scale 1/2
    pigment_map{
     [.07 rgb 1]
     [.125
      granite
      color_map{[0 rgb 1][1 rgb 0]}
      scale<1/(C1.x-C2.x),1/(C1.y-C2.y),1/(C1.z-C2.z)>
      translate z*rand(OTO_Seed)*100
     ]
    }
   }
   
   /* this scales/translates the new brick correctly */
   OTO_Transform_Brick()
  }
  
 }
#end

#declare OTO_Seed = seed(1001);

// calling the macro
OTO(
 <-8,-5,-1>,
 <8,5,1>,
 0.1,
 texture{}
)

// sanity test
//box{<-8,-5,-1>,<8,5,1> pigment{rgb x transmit .5}}

// -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=

light_source{ <-.5,1,-.3>*1e8, rgb <1.5,1.3,1.0> }

camera{
 location<-20,40,-50>
 look_at 0
 angle 15
}

global_settings{ assumed_gamma 1.0 }