//------ Fin Head .......... 6/4/92 Mike Miller
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#include "Tex.inc"
#include "Pipe1.inc"
#include "Pipe2.inc"

#declare FIN = box { -1, 1 scale <1, 55, 35> }

#declare DIFF1 = 
union {
  difference {
    sphere { 0, 1 scale <22, 33, 21> }
    plane { y, 0 }
  }
  cylinder { y, -y, 1 scale <22, 10, 21> translate y*-10 }
}		 

//----- Head Section
#declare HEAD =
union {
  object {
    union {
      difference {
        union {
          object { Cylinder_Z scale <15.5, 5.5, 1> translate y*-5 }
          object { Cylinder_Z scale <15.5, 5.5, 1> translate y*-12 }
          object { Cylinder_Z scale <4.5, 6.5, 1> translate <-12, -8.5, 0> }
          object { Cylinder_Z scale <4.5, 6.5, 1> translate <12, -8.5, 0> }
          union {
            object { FIN rotate 0 }
            object { FIN rotate z*22.5 }
            object { FIN rotate z*45 }  
            object { FIN rotate z*67.5 }
            object { FIN rotate z*90 }
            object { FIN rotate z*112.5 }
            object { FIN rotate z*135 }
            object { FIN rotate z*157.5 }
            translate y*-10
          }
        }
        object { DIFF1 inverse translate -z }
        plane { y, -20 }
        object { Cylinder_Z scale <14, 4, 1> translate y*-5 }
        object { Cylinder_Z scale <14, 4, 1> translate y*-12 }
        object { Cylinder_Z scale <3, 5, 1> translate <-12, -8.5, 0> }
        object { Cylinder_Z scale <3, 5, 1> translate <12, -8.5, 0> }
      }
      sphere { 0, 20 }
      cylinder { y, -y, 1 scale <20, 10, 20> translate y*-10 }
    }
    texture { GOLD_M }
  }

  //----Lens
  sphere { 0, 1
    scale <18, 15, 25>
    translate y*-8.5
    texture {
      pigment { color Black }
      finish { reflection { 0.2 } phong 1 ambient 0.1 phong_size 75 }
    }
    interior { ior 1.5 }
  }
  bounded_by { sphere { 0, 40 } }
}

//------ Air Filter
#declare FILTER =
object {
  union {
    cylinder { x, -x, 1 scale <7, 4, 4> }
    cylinder { x, -x, 1 scale <4, 5, 5> }
    cylinder { y, -y, 1 scale <2, 3, 2> translate y*-5 }
    cylinder { z, -z, 1 scale <1.5, 1.5, 10> translate z*10 rotate x*-24 }
    cylinder { z, -z, 1 scale <1.5, 1.5, 10> translate <5, 0, 10> rotate x*-24 }
    cylinder { z, -z, 1 scale <1.5, 1.5, 10> translate <-5, 0, 10> rotate x*-24 }
    intersection {
      object { Cone_Y scale <6, 10, 6> }
      plane { -y, 10 }
      plane { y, 0 }
      translate y*-6 
    }
    cylinder { y, -y, 1 scale <7, 0.5, 7> translate y*-16.5 }
    intersection {
      sphere { y*-17, 6 }
      plane { y, -17 }
    }
  }
  texture { GOLD_M }
  bounded_by { sphere { <0, -9, 4>, 24 } }
}

#declare EAR =
object {
  union {
    cylinder { x, -x, 1 scale <4, 6, 6> translate x*-4 }
    cylinder { x, -x, 1 scale <1, 7, 7> translate x*-8 }
    sphere { 0, 1 scale <2, 6, 6> translate x*-9 }
    sphere { 0, 1 scale <2, 3, 3> translate x*-11 }
  }
  texture { BLUE_M }
  bounded_by { sphere { x*-5, 11 } }
}

//---- Neck Disk
#declare D1 = cylinder { y, -y, 1 scale <10, 0.7, 10> }
#declare C1 = object { Cylinder_X scale <1, 5, 5> translate z*-15 }

//-------- Chest Plate
#declare CHEST =
object {
  union {
    union {
      cylinder { y, -y, 1 scale <8, 10, 8> translate 0 }
      box { -1, 1 scale <10, 20, 20> translate y*-40 }
      cylinder { y, -y, 1 scale 10 translate < 10, -30, 0> }
      cylinder { y, -y, 1 scale 10 translate <-10, -30, 0> }
      object { D1 translate y*-2 }
      object { D1 translate y }
      object { D1 translate y*4 }
      object { D1 translate y*7 }
      sphere { 0, 10 translate <-10, -20, 0> }
      sphere { 0, 10 translate < 10, -20, 0> }
    }
    difference {
      union {
        object { C1 }
        object { C1 rotate x*22.5 }
        object { C1 rotate x*45 }
        object { C1 rotate x*67.5 }
        object { C1 rotate x*90 }
      }
      plane { x, -10 }
      plane { x, 10 inverse }
      translate y*-20
    }
  }
  texture { GRAY_M }
  bounded_by { sphere { y*-20, 40 } }
}

//----- Air Tank
#declare TANK =
object {
  union {
    cylinder { y, -y, 1 scale <13, 40, 13> translate y*-40 }
    cylinder { y, -y, 1 scale <4, 3, 4> translate y*13 }
    sphere { 0, 13 }
  }
  texture { GOLD_M }
}

//------ Neck Rods
#declare ROD =
object {
  union {
    cylinder { y, -y, 1 scale <1, 25, 1> translate <-13, -45, -13> }
    cylinder { y, -y, 1 scale <1, 25, 1> translate < 13, -45, -13> }
  }
  texture { BLUE_M }
}

//------ Build The Aquadius Fin Head 
#declare FIN_HEAD =
union {
  object { HEAD }                                        //----- fin head & lens
  object { P1 translate <0, -27, -30> }                  //----- inner pipe
  object { P2 translate <0, -27, -30> }                  //----- pipe ribs
  object { FILTER translate <0, -27, -30> }              //----- Filter
  object { EAR              translate <-16, -13, 0> }    //----- L Ear
  object { EAR rotate y*180 translate < 16, -13, 0> }    //----- R Ear
  object { CHEST translate y*-30 }                       //----- Chest Plate
  object { TANK translate <-29, -40, 19> }               //----- L Tank
  object { TANK translate < 29, -40, 19> }               //----- R Tank
  object { ROD }                                         //----- Neck Rods
}