// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

#declare UCone = /*---------CONE POINT UP /POINT at 000--------*/
intersection {
  object { Cone_Y scale 1 }
  plane { y, 0 }
  plane { y, -1 inverse }
}

//------- rail & dentile Molding
//--------post
#declare post = 
object {
  union {
    object { UCone scale <3, 13, 3> translate y*17 }
    object { Disk_Y scale <3, 1, 3> translate y*12 }
    object { Disk_Y scale <2.5, 1, 2.5> translate y*11 }
    object { Disk_Y scale <3, 1, 3> }
    difference {
      sphere { 0, 3 }
      plane { y, 0 inverse }
      translate y*4
    }
  }
  texture { Stone8 finish { phong 1.0 } scale 10 }
  bounded_by { sphere { 0, 10 translate y*7 } }
}

#declare rail =
union {
  //---- cross rails
  object {
    difference {
      union {
        box { -1, 1 scale <20, 5, 5> }
        box { -1, 1 scale <20, 3, 4> translate y*3 }
        box { -1, 1 scale <20, 2.5, 3> translate y*21.5 }
      }
      object { Disk_X scale <40, 1.5, 1.5> translate <-20, 21.5, -3> }
    }
    texture { Stone8 finish { phong 1.0 } scale 10 }
    bounded_by { box { -1, 1 scale <22, 15, 7> translate y*12 } }
  }
  object { post translate y*6 }
  object { post translate <-10, 6, 0> }
  object { post translate < 10, 6, 0> }
}