// Persistence of Vision Raytracer
//
//  Original file by Mike Miller
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//
//--------- declares

//------- capital section
#declare cap_s =
object {
  union {
    sphere { 0, 1.5 }
    sphere { 0, 2 translate <-3, 8.5, 0> }
    object { Disk_Y scale <1.5, 10, 1.5> rotate z*20 translate x*1.5 }
  }
  texture { Stone8 scale <8, 12, 9> }
  bounded_by { sphere { 0, 8 translate <-2, 5, 0> } }
  translate x*-7
}

//----------- liquid 
#declare lq =
texture { 
  pigment { color rgb <0, 0.07, 0> }
  finish { reflection { 0.55 } ambient 0.15 diffuse 0.6 phong 1.0 phong_size 40  }
  normal { ripples 0.05 frequency 0.08 scale <30, 1, 2.5> translate <100, 0, -100> }
}

#declare glass =
texture {
  pigment { color Clear }
  finish { ambient 0.1 diffuse 0 reflection { 0.2 } phong 0.3 phong_size 90 }
}
//-------glass balls
#declare g_ball =
sphere { 0, 12
  texture { glass }
  interior { ior 1.5 }
}