// Persistence of Vision Raytracer
//---------- marble walls & columns to test stone textures
//----------------------------------   m. miller 5/13/91
//
//  Modified for POV-Ray version 3.x by
//  Colin Fleming, cj_fleming@btinternet.com
//

global_settings {
  //assumed_gamma 1
  //ambient_light 0.5
  max_trace_level 20
}

#version 3.1;

#include "colors.inc"
#include "shapes.inc"
//#include "mmshape.inc"
#include "stoneold.inc"
#include "stones.inc"
#include "Declares.INC"
#include "Tri.INC"
#include "Ceil.INC"
#include "World30.INC"
#include "Floor.INC"  
#include "Rail.INC"   
#include "Walls.INC" 
#include "Column.INC"

camera {
  location <130, 80, -300>
  direction z*1.9
  up y 
  right x*image_width/image_height
  look_at <10, 33, 0>
}

//----- light
light_source { <-1000, 20, -400> color rgb 1 }
light_source { <300, 80, -1500> color rgb 1 }

//--------- build scene
union {

  object { column1 translate <-35, 0, -16> }
  object { column1 translate <35, 0, -16> }
  object { column1 translate <-105, 0, -16> }
  object { column1 translate <105, 0, -16> }
  object { column1 translate <-35, 0, 100> }
  object { column1 translate <35, 0, 100> }

  object { s_wall translate x*-35 }
  object { s_wall translate x*35 }
  object { s_wall translate x*-105 }
  object { s_wall translate x*105 }

  object { a_wall }
  object { a_wall translate x*70 }
  object { a_wall translate x*-70 }
  object { a_wall translate x*-140 }
  object { a_wall translate x*140 }

  object { rail translate x*-70 }
  object { rail translate x*70 }
  object { footer translate x*-35 }
  object { footer translate x*35 }

  object { walk translate <-19, -4, -160> }

  object { stoop translate <-70, -6, -14> }
  object { stoop translate <70, -6, -14> }
  object { water translate <-252, -6, -160> }
  object { water translate <53, -6, -160> }

  object { ceiling translate <-117, 100, -76> }
  object { ceiling translate <-47, 100, -76> }
  object { ceiling translate <23, 100, -76> }
  object { ceiling translate <93, 100, -76> }

  object { ceiling translate <-117, 100, -118> }
  object { ceiling translate <-47, 100, -118> }
  object { ceiling translate <23, 100, -118> }
  object { ceiling translate <93, 100, -118> }

  object { ceiling translate <-117, 100, -160> }
  object { ceiling translate <-47, 100, -160> }
  object { ceiling translate <23, 100, -160> }
  object { ceiling translate <93, 100, -160> }

  object { c1 translate <-200, 100, -30> }

  object { g_ball translate <0, 8, -80> }
  object { g_ball scale 1.2 translate <75, 10, -70> }

  object { world30 }
}