// Persistence of Vision Raytracer
// Persistence of Vision Raytracer
//---------- shapes made with triangles 
//---------- triangle { shapes with <0 0 0> at left/front/bottom corner

/*

QUICK LIST :     // ALL ARE UNIONS OF TRIANGLES

X_TRI
Y_TRI 
Z_TRI
TRI_BOX
X_SLOPE
Y_SLOPE
Z_SLOPE
X_CUP
Y_CUP
YD_CUP
Z_CUP

*/


#declare z_tri = union { //--------- z trianle plane {
triangle { <0 0 0> <0 1 0> <1 0 0>  }
triangle { <0 1 0> <1 1 0> <1 0 0>  }
 }

#declare y_tri = union { //--------- y trianle plane {
triangle { <0 0 0> <1 0 0> <0 0 1>  }
triangle { <0 0 1> <1 0 1> <1 0 0>  }
 }

#declare x_tri = union { //----------x trianle plane {
triangle { <0 0 0> <0 0 1> <0 1 0>  }
triangle { <0 1 0> <0 1 1> <0 0 1>  }
 }

#declare tri_box = union { //-------6 sided trianle cube
triangle { <0 0 0> <0 1 0> <1 0 0>  } //...
triangle { <0 1 0> <1 1 0> <1 0 0>  } //...Front face
triangle { <0 0 0> <1 0 0> <0 0 1>  } //...
triangle { <0 0 1> <1 0 1> <1 0 0>  } //...Bottom
triangle { <0 0 0> <0 0 1> <0 1 0>  } //...
triangle { <0 1 0> <0 1 1> <0 0 1>  } //...Left Side
triangle { <0 0 1> <0 1 1> <1 0 1>  } //...
triangle { <0 1 1> <1 1 1> <1 0 1>  } //...Back face
triangle { <0 1 0> <1 1 0> <0 1 1>  } //...
triangle { <0 1 1> <1 1 1> <1 1 0>  } //...Top
triangle { <1 0 0> <1 0 1> <1 1 0>  } //...
triangle { <1 1 0> <1 1 1> <1 0 1>  } //...Right Side
 }


#declare z_slope = union { //---------5 sided slope
triangle { <0 0 0> <0 1 0> <1 0 0>  } //...face
triangle { <0 0 0> <1 0 0> <0 0 1>  } //...
triangle { <0 0 1> <1 0 1> <1 0 0>  } //...Bottom
triangle { <0 0 0> <0 0 1> <0 1 0>  } //...
triangle { <0 1 0> <0 1 1> <0 0 1>  } //...Left Side
triangle { <0 0 1> <0 1 1> <1 0 1>  } //...back
triangle { <1 0 0> <0 1 0> <0 1 1>  } //...
triangle { <1 0 0> <1 0 1> <0 1 1>  } //...hypot
 }

#declare y_slope = union { //---------5 sided slope
triangle { <0 0 0> <0 1 0> <1 0 0>  } //...
triangle { <0 1 0> <1 1 0> <1 0 0>  } //...Front face
triangle { <0 0 0> <1 0 0> <0 0 1>  } //...bottom
triangle { <0 0 0> <0 0 1> <0 1 0>  } //...
triangle { <0 1 0> <0 1 1> <0 0 1>  } //...Left Side
triangle { <0 1 0> <1 1 0> <0 1 1>  } //...top
triangle { <1 0 0> <1 1 0> <0 1 0>  } //...
triangle { <0 1 0> <1 1 0> <0 1 1>  } //...hypot
 }


#declare x_slope = union { //-------5 sided slope
triangle { <0 0 0> <0 1 0> <1 0 0>  } //...
triangle { <0 1 0> <1 1 0> <1 0 0>  } //...Front face
triangle { <0 0 0> <0 1 0> <0 1 1>  } //...
triangle { <0 1 0> <1 1 0> <0 1 1>  } //...
triangle { <0 1 1> <1 1 1> <1 1 0>  } //...Top
triangle { <1 0 0> <1 1 0> <1 1 1>  } //...
triangle { <0 0 0> <1 0 0> <0 1 1>  } //...
triangle { <1 0 0> <1 1 1> <0 1 1>  } //...Top
 }



#declare z_cup = union { //-------5 sided cup
triangle { <0 0 0> <1 0 0> <0 0 1>  } //...
triangle { <0 0 1> <1 0 1> <1 0 0>  } //...Bottom
triangle { <0 0 0> <0 0 1> <0 1 0>  } //...
triangle { <0 1 0> <0 1 1> <0 0 1>  } //...Left Side
triangle { <0 0 1> <0 1 1> <1 0 1>  } //...
triangle { <0 1 1> <1 1 1> <1 0 1>  } //...Back face
triangle { <0 1 0> <1 1 0> <0 1 1>  } //...
triangle { <0 1 1> <1 1 1> <1 1 0>  } //...Top
triangle { <1 0 0> <1 0 1> <1 1 0>  } //...
triangle { <1 1 0> <1 1 1> <1 0 1>  } //...Right Side
 }

#declare x_cup = union { //-------5 sided cup
triangle { <0 0 0> <0 1 0> <1 0 0>  } //...
triangle { <0 1 0> <1 1 0> <1 0 0>  } //...Front face
triangle { <0 0 0> <1 0 0> <0 0 1>  } //...
triangle { <0 0 1> <1 0 1> <1 0 0>  } //...Bottom
triangle { <0 0 0> <0 0 1> <0 1 0>  } //...
triangle { <0 1 0> <0 1 1> <0 0 1>  } //...Left Side
triangle { <0 0 1> <0 1 1> <1 0 1>  } //...
triangle { <0 1 1> <1 1 1> <1 0 1>  } //...Back face
triangle { <0 1 0> <1 1 0> <0 1 1>  } //...
triangle { <0 1 1> <1 1 1> <1 1 0>  } //...Top
 }


#declare y_cup = union { //-------5 sided cube
triangle { <0 0 0> <0 1 0> <1 0 0>  } //...
triangle { <0 1 0> <1 1 0> <1 0 0>  } //...Front face
triangle { <0 0 0> <1 0 0> <0 0 1>  } //...
triangle { <0 0 1> <1 0 1> <1 0 0>  } //...Bottom
triangle { <0 0 0> <0 0 1> <0 1 0>  } //...
triangle { <0 1 0> <0 1 1> <0 0 1>  } //...Left Side
triangle { <0 0 1> <0 1 1> <1 0 1>  } //...
triangle { <0 1 1> <1 1 1> <1 0 1>  } //...Back face
triangle { <1 0 0> <1 0 1> <1 1 0>  } //...
triangle { <1 1 0> <1 1 1> <1 0 1>  } //...Right Side
 }

#declare yd_cup = union { //-------5 sided cup - opening down
triangle { <0 0 0> <0 1 0> <1 0 0>  } //...
triangle { <0 1 0> <1 1 0> <1 0 0>  } //...Front face
triangle { <0 0 0> <0 0 1> <0 1 0>  } //...
triangle { <0 1 0> <0 1 1> <0 0 1>  } //...Left Side
triangle { <0 0 1> <0 1 1> <1 0 1>  } //...
triangle { <0 1 1> <1 1 1> <1 0 1>  } //...Back face
triangle { <0 1 0> <1 1 0> <0 1 1>  } //...
triangle { <0 1 1> <1 1 1> <1 1 0>  } //...Top
triangle { <1 0 0> <1 0 1> <1 1 0>  } //...
triangle { <1 1 0> <1 1 1> <1 0 1>  } //...Right Side
 }

#declare y_tube = union { //-------4 sided tube
triangle { <0 0 0> <0 1 0> <1 0 0>  } //...
triangle { <0 1 0> <1 1 0> <1 0 0>  } //...Front face
triangle { <0 0 0> <0 0 1> <0 1 0>  } //...
triangle { <0 1 0> <0 1 1> <0 0 1>  } //...Left Side
triangle { <0 0 1> <0 1 1> <1 0 1>  } //...
triangle { <0 1 1> <1 1 1> <1 0 1>  } //...Back face
triangle { <1 0 0> <1 0 1> <1 1 0>  } //...
triangle { <1 1 0> <1 1 1> <1 0 1>  } //...Right Side
 }



