// *********************************************************
// ILLUSION INCLUDE FILE FOR PERSISTENCE OF VISION 3.5
// *********************************************************
// 
// Created by Rune S. Johansen, October 1999 - March 2002
// 
// See "illution.txt" for more information.
// 
// *********************************************************
   
// CHECK DECLARED VARIABLES AND SET DEFAULT VALUES
// ***********************************************
   #ifndef (illusion_location)  #declare illusion_location  = <0,0,0>;                   #end
   #ifndef (illusion_right)     #declare illusion_right     = 4/3*x;                     #end
   #ifndef (illusion_up)        #declare illusion_up        = y;                         #end
   #ifndef (illusion_direction) #declare illusion_direction = z;                         #end
   #ifndef (illusion_sky)       #declare illusion_sky       = y;                         #end
   #ifndef (illusion_angle)     #declare illusion_angle     = degrees(atan2(vlength(illusion_right)/2/vlength(illusion_direction),1))*2; #end
   #ifndef (illusion_look_at)   #declare illusion_look_at   = illusion_location+illusion_direction; #end
   
   #ifndef (transmit_all)       #declare transmit_all       = 0; #end
   #ifndef (filter_all)         #declare filter_all         = 0; #end
   #ifndef (image_offset)       #declare image_offset       = 0; #end
   
   
   #ifndef (illusion_image)     #debug "\n\n--> you must specify 'illusion_image'!\n\n"  #end
   
   #declare illusion_format = strlwr(substr(illusion_image,strlen(illusion_image)-3,4))
   #if ( strcmp(illusion_format,".png")!=0 & strcmp(illusion_format,".tga")!=0 )
      #debug concat(
         "\n\n--> extension of illusion_image: ",
         strlwr(substr(illusion_image,strlen(illusion_image)-3,4)),
         "\n--> illution_image must be a .png or .tga file!\n\n"
      )
   #end
   
// CREATE THE IMAGE MAP USED IN THE ILLUSION
// *****************************************
   #ifdef(illusion_image_function)
      #undef illusion_image_function
   #end
   #declare hdr_switch=0;
   #declare illusion_image_function =
   function {
      /*
      #if (strcmp(illusion_format,".png")=0)
         pigment {image_map {png illusion_image once transmit all transmit_all filter all filter_all interpolate 0 }warp{repeat x flip x}warp{repeat y flip y} translate -0.5+<image_offset,image_offset,0>}
      #else
         pigment {image_map {tga illusion_image once transmit all transmit_all filter all filter_all interpolate 0 }warp{repeat x flip x}warp{repeat y flip y} translate -0.5+<image_offset,image_offset,0>}
      #end
      */
      
      #if (strcmp(illusion_format,".png")=0)
         pigment {image_map {png illusion_image once transmit all transmit_all filter all filter_all interpolate 0 once }warp{repeat x flip x}warp{repeat y flip y} translate -0.5+<image_offset,image_offset,0>}
      #end
      #if (strcmp(illusion_format,".tga")=0)
         pigment {image_map {tga illusion_image once transmit all transmit_all filter all filter_all interpolate 0 once}warp{repeat x flip x}warp{repeat y flip y} translate -0.5+<image_offset,image_offset,0>}
      #end
      #if (strcmp(illusion_format,".hdr")=0)
         #declare hdr_switch=1;
         pigment {image_map {hdr illusion_image once transmit all transmit_all filter all filter_all interpolate 0 once}warp{repeat x flip x}warp{repeat y flip y} translate -0.5+<image_offset,image_offset,0>}
      #end
   }
   
// CREATE THE RAW ILLUSION ALIGNED ALONG Z AXIS
// ********************************************
   #declare illusion_raw =
   pigment {
      average
      pigment_map {
         #if(hdr_switch=0)
         [function{illusion_image_function(x/z,y/z,z).red}     color_map {[0,rgb 0][1,rgb <4,0,0>]}]
         [function{illusion_image_function(x/z,y/z,z).green}   color_map {[0,rgb 0][1,rgb <0,4,0>]}]
         [function{illusion_image_function(x/z,y/z,z).blue}    color_map {[0,rgb 0][1,rgb <0,0,4>]}]
         [function{illusion_image_function(x/z,y/z,z).transmit}color_map {[0,rgb 0][1,transmit 4 ]}]
         #else
         //select(illusion_image_function(x,y,z).-1,illusion_image_function(x,y,z).,1)
         #declare hdr_mult=256;
         #declare fx=function{select(illusion_image_function(x/z,y/z,z).red-hdr_mult,illusion_image_function(x/z,y/z,z).red,hdr_mult)}
         #declare fy=function{select(illusion_image_function(x/z,y/z,z).green-hdr_mult,illusion_image_function(x/z,y/z,z).green,hdr_mult)}
         #declare fz=function{select(illusion_image_function(x/z,y/z,z).blue-hdr_mult,illusion_image_function(x/z,y/z,z).blue,hdr_mult)}
         #declare ft=function{select(illusion_image_function(x/z,y/z,z).transmit-hdr_mult,illusion_image_function(x/z,y/z,z).transmit,hdr_mult)}
         
         
         [function{fx(x,y,z)/hdr_mult}     color_map {[0,rgb 0][1,rgb <4*hdr_mult,0,0>]}]
         [function{fy(x,y,z)/hdr_mult}   color_map {[0,rgb 0][1,rgb <0,4*hdr_mult,0>]}]
         [function{fz(x,y,z)/hdr_mult}    color_map {[0,rgb 0][1,rgb <0,0,4*hdr_mult>]}]
         [function{ft(x,y,z)/hdr_mult}color_map {[0,rgb 0][1,transmit 4*hdr_mult ]}]
         #end
      }
   }
   
// ALIGNMENT CALCULATIONS
// **********************
   #declare illusion_t = illusion_location;
   #declare illusion_z = vnormalize(illusion_look_at-illusion_location);
   #declare illusion_x = vnormalize(vcross(illusion_sky,illusion_z))*tan(radians(illusion_angle/2))*2;
   #declare illusion_y = vnormalize(vcross(illusion_z,illusion_x))  *tan(radians(illusion_angle/2))*2*vlength(illusion_up)/vlength(illusion_right);
   
// CREATE AND ALIGN THE ILLUSION
// *****************************
   #declare illusion =
   pigment {
      illusion_raw
      
      matrix <
         illusion_x.x,illusion_x.y,illusion_x.z,
         illusion_y.x,illusion_y.y,illusion_y.z,
         illusion_z.x,illusion_z.y,illusion_z.z,
         illusion_t.x,illusion_t.y,illusion_t.z
      >
   }
   