/*

 hexPattern_test.pov
 
 2008 Sam Benge stbenge@hotmail.com 
 
 +a0.1 +r3 +w900 +h600
 
 Description: All eleven patterns from "stbHexPatterns.inc" are displayed,
 with numbers :)
 
 Dependencies:
  - stbHexPatterns.inc
  - POV-Ray 3.6 and above
  - numbers.png

*/

#default{finish{ ambient 0 } }

camera{
 orthographic 
 right x*1.2 up y*0.8
 location<0,22,-11>
 look_at y
 angle 60
}

#declare res=5;
light_source{
 <1,1,0>*100000,2
 area_light x*4000,z*4000,res,res
 jitter adaptive 2 circular orient
}
light_source{
 <.5,1,-.5>*100000,.4
 area_light x*120000,z*120000,res,res
 jitter adaptive 2 circular orient
 area_illumination
}

#include"stbHexPatterns.inc"

#declare myHexPatterna=
pigment{
 gradient x translate x/2 scale 1 rotate y*30 triangle_wave frequency 2
}

// numbers from number file
#declare numbers=
pigment{
 pigment_pattern{
  image_map{png"numbers.png" interpolate 2}
  scale<11,-1,1>*1.5
  rotate x*270
 }
 pigment_map{
  [0
   gradient x
   scale 1.5
   color_map{
    [0 rgb x transmit 1]
    [1 rgb x ]
   }
  ]
  [.5 rgb<1,1,0>]
  [1 rgb 1]
 }
}
#macro numeralBox(xo)
 box{<0,2.5,0>,<1.5,2.5,1.5>
  pigment{numbers translate -(xo-1)*1.5}
  translate<-2.5,0,1>
 }
#end

// 11 samples
#declare xv=5;
#declare zv=6.5;
#declare test_object=
union{
 cylinder{-y*4,y*4,5}
 torus{5,1 translate y*3}
 torus{5,1 translate -y*3}
 cylinder{-y*3,y*3,6}
 scale 1/2
}
union{
 object{test_object}
 object{numeralBox(1) }
 pigment{
  hexGrad()
  color_map{
   [0 rgb 0]
   [1 rgb<1,.9,.3>]
  }
 }
 translate<-xv*2,0,zv>
}
union{
 object{test_object}
 object{numeralBox(2) }
 pigment{
  hexGradGrouped()
  color_map{
   [0 rgb 0]
   [.5 rgb<1,.125,.75>]
   [1 rgb 1]
  }
 }
 translate<-xv/1.5,0,zv>
}
union{
 object{test_object}
 object{numeralBox(3) }
 pigment{
  randomHexCells()
  color_map{
   [0 rgb 1]
   [.25 rgb x]
   [.375 rgb 0]
   [.5 rgb y]
   [.625 rgb 1]
   [.75 rgb z]
   [1 rgb 0]
  }
 }
 translate<xv/1.5,0,zv>
}
union{
 object{test_object}
 object{numeralBox(4) }
 pigment{
  hexPattern(2)
  color_map{
   [0 rgb 0]
   [.5 rgb<0,.5,1>]
   [1 rgb 1]
  }
 }
 translate<xv*2,0,zv>
}
//----
union{
 object{test_object}
 object{numeralBox(5) }
 pigment{
  hexPatternGrouped()
  color_map{
   [0 rgb 0]
   [.5 rgb<0,.5,0>]
   [1 rgb<1,1,.5>]
  }
 }
 translate<-xv*2,0,0>
}
union{
 object{test_object}
 object{numeralBox(6) }
 pigment{
  triAngle()
  color_map{
   [0 rgb<1,1,0>/100]
   [1 rgb<1,1,0>]
  }
 }
 translate<-xv/1.5,0,0>
}
union{
 object{test_object}
 object{numeralBox(7) }
 pigment{
  triAngle2()
  color_map{
   [0 rgb<1,.01,.01>/100]
   [1 rgb<1,.01,.01>]
  }
 }
 translate<xv/1.5,0,0>
}
union{
 object{test_object}
 object{numeralBox(8) }
 pigment{
  triTessellation()
  color_map{
   [0 rgb<1,.5,0>]
   [1 rgb<1,0,0>]
  }
 }
 translate<xv*2,0,0>
}
//----
union{
 object{test_object}
 object{numeralBox(9) }
 #declare myHexPattern=
 pigment{crackle scale .4 metric 1}
 pigment{
  kaleidoscope()
  color_map{
   [0 rgb 1]
   [.25 rgb x]
   [.375 rgb 0]
   [.5 rgb y]
   [.625 rgb 1]
   [.75 rgb z]
   [1 rgb 0]
  }
 }
 translate<-xv*2,0,-zv>
}
union{
 object{test_object}
 object{numeralBox(10) }
 pigment{
  skewedGrid()
  color_map{
   [0 rgb 0]
   [.5 rgb<0,1,1>]
  }
 }
 translate<-xv/1.5,0,-zv>
}
union{
 object{test_object}
 object{numeralBox(11) }
 pigment{
  randomTriCells()
  color_map{
   [0 rgb 0]
   [1/3 rgb<1,0,0>]
   [2/3 rgb<1,1,0>]
   [1 rgb 1]
  }
 }
 translate<xv/1.5,0,-zv>
}
// Star of David
// ht2(x,y) example
sphere_sweep{
 linear_spline
 13,
 ht2(-1,2),.2
 ht2(0,1),.2
 ht2(1,1),.2
 ht2(1,0),.2
 ht2(2,-1),.2
 ht2(1,-1),.2
 
 ht2(1,-2),.2
 ht2(0,-1),.2
 ht2(-1,-1),.2
 ht2(-1,0),.2
 ht2(-2,1),.2
 ht2(-1,1),.2
 ht2(-1,2),.2
 pigment{rgb<1,1,0>}
 translate<xv*2,0,-zv>
}

// ground

plane{y,-2.1
 #declare ground_pigment=
 pigment{granite scale 15 warp{turbulence .5 lambda 2.2} }
 pigment{ground_pigment color_map{[0 rgb .25][1 rgb .75]}}
 normal{pigment_pattern{ground_pigment} 1 accuracy .001 cubic_wave}
}