/*
 * @file 	test_truchet
 * @desc 	Landscapes generated with a Truchet pattern
 * @auth	Paolo Gibellini
 * @date	17/01/2007
 * @note	Inspired by excellent Lightbeam works on zoologique newsgroup
 * @note	After Paul Bourke works I was stimulated to resume my wip
 *
 * @wip		The water has artifact due to the junction of the tiles. Let's try to use a box. 
 */

// ToDo: a better sky and light
// ToDo: true grass?

#include "colors.inc"
#include "woods.inc"

#include "truchet10.inc"
#declare rad_on=0;

#if (rad_on)
	global_settings {
	  radiosity {
	    pretrace_start 0.08           // start pretrace at this size
	    pretrace_end   0.04           // end pretrace at this size
	    count 35                      // higher -> higher quality (1..1600) [35]
	    nearest_count 5               // higher -> higher quality (1..10) [5]
	    error_bound 1.8               // higher -> smoother, less accurate [1.8]
	    recursion_limit 3             // how much interreflections are calculated (1..5+) [3]
	    low_error_factor .5           // reduce error_bound during last pretrace step
	    gray_threshold 0.0            // increase for weakening colors (0..1) [0]
	    minimum_reuse 0.015           // reuse of old radiosity samples [0.015]
	    brightness 1                  // brightness of radiosity effects (0..1) [1]
	
	    adc_bailout 0.01/2
	    //normal on                   // take surface normals into account [off]
	    //media on                    // take media into account [off]
	    //save_file "file_name"       // save radiosity data
	    //load_file "file_name"       // load saved radiosity data
	    //always_sample off           // turn sampling in final trace off [on]
	    //max_sample 1.0              // maximum brightness of samples
	  }
	}
#else
	global_settings {
	  assumed_gamma 1.0
	}
#end
// ----------------------------------------

camera {
  location  <0.0, 5.5, -4.0>
//  location  <2.5, 3.5, -6.0>
  direction 1.5*z
  right     x*image_width/image_height
  look_at   <0.0, 0.0,  0.0>
}

sky_sphere {
	pigment {p_sky}
}

// sun
light_source{<1500,2500,-2500> color rgb 1}
// ----------------------------------------

plane { y, 0 
	texture {t_sabbia}
}

// Scene ----------------------------------
#declare r_seed=3;

// Grass
#declare R1 = seed(r_seed);
#declare nx=20;
#declare nz=20;

#local ix=-nx;

#while(ix<nx)
	#local iz=-nz;
	#while(iz<nz)
		#local na=int(rand(R1)*4);
		// Truchet
		object {tru_pattern
			rotate 90*na*y
			translate <ix,0,iz>
			//texture {t_grass}
		}
		// Boat
		// #if (random visible)
		object {boat
			translate <0.5,0,0>
			rotate <0,45,0>
		
			/*
			scale 0.5
			translate <0.5,0,0>
			rotate <0,45,0>
			*/
			rotate 90*na*y
			translate <ix,0,iz>
		}
		// #end
		#local iz=iz+1;
	#end
	#local ix=ix+1;
#end

// The water
//#declare R1 = seed(r_seed);
#declare nx=20;
#declare nz=20;

#local ix=-nx;

#declare the_water = union {
	#while(ix<nx)
		#local iz=-nz;
		#while(iz<nz)
			//#local na=int(rand(R1)*4);
			object {tru_water
				//rotate 90*na*y
				translate <ix,0,iz>
			}
			#local iz=iz+1;
		#end
		#local ix=ix+1;
	#end
};

object {the_water material {m_water}}
