#version 3.5;
global_settings {  assumed_gamma 1.0 }

#include "colors.inc"
#include "functions.inc"

camera { location <-60.0, -40.5, -135>
         right     x*image_width/image_height
         look_at <-60.0, -37.5, 0.0> }

light_source{< -1500, 3000, -1500> color White}

sky_sphere {
   pigment {
      gradient <0,1,0>
      color_map {
         [0.00 rgb <0.6,0.7,1.0>*1.5]
         [0.35 rgb <0.0,0.1,0.8>*1.5]
         [0.65 rgb <0.0,0.1,0.8>*1.5]
         [1.00 rgb <0.6,0.7,1.0>*1.5] 
      } 
      scale 2         
   }
}


#declare F2=function{pigment{
  bumps
  //turbulence 0.01
  color_map { [0 rgb 0.475] [1 rgb 0.525] }
  scale <0.075,0.1,0.075>
  }
}

// Sand -- some sine waves added together with noise to make it look less regular
isosurface {
  function { y - f_sine_wave( x+pi/3, 2, 0.15 ) - f_sine_wave( x+(f_noise3d( x, y, z)-0.5) *0.2, 0.75, 0.6 ) - f_sine_wave( x+(f_noise3d( x, y, z)-0.5) *0.3, 0.005, 1.5 ) - f_sine_wave(x*z + pi/2 ,0.55,0.75) - F2(x,y,z).grey * 0.75}
  max_gradient 7
  contained_by{box{<-100,-4,-100><100,4,15>}}
  pigment {rgb .9}
  texture {
  pigment {
    granite
    turbulence 0.99
    color_map {
      [0.000, 0.179 color rgb <0.8, 0.65, 0.45>*1.05
                    color rgb <0.8, 0.65, 0.45>*1.25]
      [0.179, 0.368 color rgb <0.8, 0.65, 0.45>*1.25
                    color rgb <0.8, 0.65, 0.45>*1.15]
      [0.368, 0.538 color rgb <0.8, 0.65, 0.45>*1.15
                    color rgb <0.8, 0.65, 0.45>*1.00]
      [0.538, 0.846 color rgb <0.8, 0.65, 0.45>*1.00
                    color rgb <0.8, 0.65, 0.45>*0.95]
      [0.846, 0.983 color rgb <0.8, 0.65, 0.45>*0.95
                    color rgb <0.8, 0.65, 0.45>*1.10]
      [0.983, 0.997 color rgb <0.8, 0.65, 0.45>*1.10
                    color rgb <0.8, 0.65, 0.45>*1.30]
      [0.997, 1.001 color rgb <0.8, 0.65, 0.45>*1.30
                    color rgb <0.8, 0.65, 0.45>*1.05]
    }
    scale <1/(24*1500), 1/1500, 1/(37.5*1500)> 
  }
  }
  finish {ambient 0.1 diffuse 0.85 specular 0.2 roughness 0.04}
  scale <25, 2.0, 25>
  translate <-89, -50, -35>
}
 

// Isosurface function for pyramid blocks
#declare fn_Pigm=function {
    pigment {
      agate
      color_map {
        [0 color rgb 0]
        [1 color rgb 1]
      }
    }
  } // end of function fn_Pigm 


union {

#declare Roundness = seed( 402 );            // Will add randomness to roundness of blocks
#declare Pigmentness = seed( 13384 );        // Will add randomness to pigmentation from fn_Pigm
#declare Xrand = seed( 4517 );               // Will add randomness to placement of blocks to prevent too much order
#declare Yrand = seed( 416 );                // Ditto
#declare Zrand = seed( 918 );                // Ditto
#declare XLength = 1.0;                      // Used to scale blocks if desired
#declare YLength = 1.0;                      // Ditto
#declare ZLength = 1.0;                      // Ditto
#declare InitXOffset = 0.0;                  // Initial offset for placing blocks if changing starting location
#declare InitZOffset = 0.0;                  // Ditto
#declare InitYOffset = 0.0;                  // Ditto
#declare XOffsetIncrement = XLength*2.0;     // Increment  to add to initial offset for placing blocks
#declare ZOffsetIncrement = -ZLength*2.0;    // Ditto
#declare YOffsetIncrement = YLength*2.0;     // Ditto
#declare RGBRand = seed( 386 );              // Will add randomness to pigmentation of each block

// Iterate through each layer
#declare CurLayerCount = 0;      // First layer
#declare MaxLayerCount = 99;     // Max count
#while( CurLayerCount < MaxLayerCount )

  // Iterate through each row    
  #declare CurRowCount = 0;      // First row
  #declare MaxRowCount = MaxLayerCount - 2.0*CurLayerCount;        // Calculated Row Count based on current layer
  #local curYOffset = InitYOffset + (CurLayerCount * YOffsetIncrement );  // Calculated layer offset (see above)
  #while( CurRowCount < MaxRowCount )
  
    // Iterate through each block
    #declare CurBlockCount = 0;  // First Block
    #declare MaxBlockCount = MaxRowCount;
    #local curZOffset = InitZOffset + ( CurRowCount * ZOffsetIncrement ) + ( CurLayerCount * ZOffsetIncrement );  // Calculated row offset (see above)
    #while( CurBlockCount < MaxBlockCount )
    
      // Place only outer shell of blocks, and next inward shell to reduce rendering time
      #if( CurRowCount = 0 | CurRowCount = MaxRowCount-1 | CurBlockCount = 0 | CurBlockCount = MaxBlockCount-1 
         | CurRowCount = 1 | CurRowCount = MaxRowCount-2 | CurBlockCount = 1 | CurBlockCount = MaxBlockCount-2 )
         
        #local curXOffset = InitXOffset + ( CurBlockCount * XOffsetIncrement ) + ( CurLayerCount * XOffsetIncrement ); // Calculated Block offset (see above)
        #local curRoundness = 0.1+(rand(Roundness)*0.05);     // Roundess factor for current block, with randomness built in
        #local curPigmentness = 0.05 + 0.05*rand( Pigmentness );   // Pigment factor for current block with randomness built in
        
        // Place current block
        isosurface {
           function{
                    // The way the function is used is to allow for the look of concurrent weathering of adjacent blocks,
                    // with some randomness to (otherwise) distinguish each block
                    f_rounded_box(x,y,z,curRoundness,1.0,1.0,1.0)-fn_Pigm((x+curXOffset)/2, (y+curYOffset)/2, (z+curZOffset)/2).gray*curPigmentness
           }
        
           threshold 0
           contained_by {box {<-1.2,-1.2,-1.2>,<1.2,1.2,1.2>}}
           max_gradient 2.0
           accuracy 0.01
           #local RGBModifier = rand( RGBRand ); // Used to give each block a slighly discting coloration
           texture{
             pigment{color rgb<0.8+RGBModifier*0.2,0.65+RGBModifier*0.65*0.25,0.45+RGBModifier*0.45*0.25>*1.2}
             finish {ambient 0.1 diffuse 0.85 specular 0.2 roughness 0.02 }
           }

           scale <XLength,YLength,ZLength>  // Scale based on desired size of blocks (see above)
           translate <curXOffset, curYOffset, curZOffset>   // Move to currently calculated position
        } // end of current block
        #end  // end of if
        #declare CurBlockCount = CurBlockCount + 1;  // Next Block
     #end
     #declare CurRowCount = CurRowCount + 1;   // Next Row
  #end
  #declare CurLayerCount = CurLayerCount + 1;  // Next Layer
#end
  translate <(-MaxLayerCount*XLength),-MaxLayerCount*YLength*0.5,(MaxLayerCount*ZLength)>  // Translation of overall position
  rotate y*-20  // Just for framing effect
}