#include "elements.inc"

#declare TestTxt = 1;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "imagemap/house41.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.8}
	#end
}

#declare SideTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "imagemap/house42.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.8}
	#end
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.004, 0.06, 0.03> translate<0.01, 0.01, 0.002>}
	object{E5 scale<0.004, 0.06, 0.03> translate<0.03 - 0.002, 0.01, 0.002>}
	object{E5 scale<0.004, 0.06, 0.03> translate<0.05 - 0.004, 0.01, 0.002>}
	        
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.01, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.07 - 0.004, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.03 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.05 - 0.002, 0.002>}
		
	object{Glass scale<0.04, 0.06, 1> translate<0.01, 0.01, 0.0025>}
}

#declare Window1 = union {  
	object{E5 scale<0.01, 0.08, 0.03>}
	object{E5 scale<0.01, 0.08, 0.03> translate x*0.05}
	object{E3 scale<0.04, 0.01, 0.03> translate x*0.01}
	object{E3 scale<0.04, 0.01, 0.03> translate <0.01, 0.07, 0>}
	
	object{E5 scale<0.06, 0.01, 0.03> translate<0, -0.01, 0.0015>}
	object{E5 scale<0.06, 0.01, 0.03> translate<0, -0.02, 0.003>}
	                             
	object{WindowFrame1}
}

#declare WindowFrame2 = union {
	object{E5 scale<0.004, 0.12, 0.03> translate<0.01, 0.01, 0.002>}
	object{E5 scale<0.004, 0.12, 0.03> translate<0.03 - 0.002, 0.01, 0.002>}
	object{E5 scale<0.004, 0.12, 0.03> translate<0.05 - 0.004, 0.01, 0.002>}
	        
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.01, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.03 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.05 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.07 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.09 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.11 - 0.002, 0.002>}
	object{E3 scale<0.04, 0.004, 0.03> translate<0.01, 0.13 - 0.004, 0.002>}
		
	object{Glass scale<0.04, 0.12, 1> translate<0.01, 0.01, 0.0025>}
}

#declare Window2 = union {
	object{E5 scale<0.01, 0.14, 0.03>}
	object{E5 scale<0.01, 0.14, 0.03> translate x*0.05}
	object{E3 scale<0.04, 0.01, 0.03> translate x*0.01}
	object{E3 scale<0.04, 0.01, 0.03> translate <0.01, 0.13, 0>}
	
	object{WindowFrame2}
}

#declare Window3 = union {
	object{E5 scale<0.04, 0.04, 0.03>}
	object{E5 scale<0.01, 0.03, 0.03> translate <0.005, 0.005, -0.002>}
	object{E5 scale<0.01, 0.03, 0.03> translate <0.04 - 0.015, 0.005, -0.002>}
	
	object{E3 scale<0.01, 0.01, 0.03> translate<0.015, 0.005, -0.002>}
	object{E3 scale<0.01, 0.01, 0.03> translate<0.015, 0.04 - 0.015, -0.002>}
}

#declare Bar = union {
	object{E5 scale<0.5, 0.01, 0.02> rotate x*45 translate -z*0.005}
	object{E5 scale<0.5, 0.005, 0.02> rotate x*45 translate<0, 0.004, -0.003>}
	object{E5 scale<0.5, 0.005, 0.02> rotate x*45 translate<0, -0.004, -0.003>}
}

#declare House4 = union {
	// facade
	object{E1 scale<0.5, 0.93, 1> translate -y*0.1}
	
	// top
	object{E6 scale<0.51, 0.01, 0.41> translate<-0.005, 0.83, -0.005>}
	object{E6 scale<0.52, 0.01, 0.42> translate<-0.01, 0.84, -0.01>}
	
	// left wall
	object{
		E1
		texture{SideTxt scale<0.4, 0.73, 1>}
		scale<0.4, 0.93, 1>
		translate -y*0.1
		rotate -y*90
	}
	
	// bars
	object{Bar translate y*0.29}
	object{Bar translate y*0.33}
	object{Bar translate y*0.52}
	object{Bar translate y*0.56}
	object{Bar translate y*0.74}
	
	// 1st floor
	object{Window1 translate<0.04, 0.18, -0.005>}
	object{Window1 translate<0.04 + 0.09, 0.18, -0.005>}
	object{Window1 translate<0.04 + 0.18, 0.18, -0.005>}
	object{Window1 translate<0.04 + 0.27, 0.18, -0.005>}
	object{Window1 translate<0.04 + 0.36, 0.18, -0.005>}
	
	// 2nd floor
	object{Window2 translate<0.04, 0.35, -0.004>}
	object{Window2 translate<0.04 + 0.09, 0.35, -0.004>}
	object{Window2 translate<0.04 + 0.18, 0.35, -0.004>}
	object{Window2 translate<0.04 + 0.27, 0.35, -0.004>}
	object{Window2 translate<0.04 + 0.36, 0.35, -0.004>}
	
	// 3rd floor
	object{Window2 translate<0.04, 0.58, -0.004>}
	object{Window2 translate<0.04 + 0.09, 0.58, -0.004>}
	object{Window2 translate<0.04 + 0.18, 0.58, -0.004>}
	object{Window2 translate<0.04 + 0.27, 0.58, -0.004>}
	object{Window2 translate<0.04 + 0.36, 0.58, -0.004>}
	
	// attic
	object{Window3 translate<0.04, 0.77, -0.003>}
	object{Window3 translate<0.04 + 0.09, 0.77, -0.003>}
	object{Window3 translate<0.04 + 0.18, 0.77, -0.003>}
	object{Window3 translate<0.04 + 0.27, 0.77, -0.003>}
	object{Window3 translate<0.04 + 0.36, 0.77, -0.003>}
	
	texture{FacadeTxt scale<0.52, 0.85, 1> translate<-0.01, -0.1, 1>}
}