#include "elements.inc"

#declare TestTxt = 1;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "imagemap/house21.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.8}
	#end
}

#declare SideTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "imagemap/house22.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.8}
	#end
}

#declare StairwayTxt = texture {
	#if(TestTxt)
		pigment{color rgb 0.8}
	#else
		pigment{
			image_map{
				jpeg "imagemap/stw2.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.8}
	#end
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.004, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.09 - 0.007, 0>}
	
	object{E5 scale<0.003, 0.09 - 0.008, 0.03> translate<0.004, 0.004, 0>} 
	object{E5 scale<0.003, 0.09 - 0.008, 0.03> translate<0.02 - 0.003/2, 0.004, 0>}
	object{E5 scale<0.003, 0.09 - 0.008, 0.03> translate<0.04 - 0.007, 0.004, 0>}
	
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.015 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.025 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.035 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.045 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.055 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.065 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.075 - 0.003/2, 0>} 

	object{Glass scale<0.03, 0.08, 1> translate<0.005, 0.005, 0.0005>}
}

#declare Window1 = union {
	object{E5 scale<0.04, 0.004, 0.03>}
	object{E5 scale<0.04, 0.004, 0.03> translate <0, 0.09 - 0.004, 0>}
	object{E5 scale<0.004, 0.09 - 0.008, 0.03> translate<0, 0.004, 0>}
	object{E5 scale<0.004, 0.09 - 0.008, 0.03> translate<0.04 - 0.004, 0.004, 0>}
  
	object{WindowFrame1 translate z*0.002}
	
	translate -z*0.004
}

#declare WindowFrame2 = union {
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.004, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.06 - 0.007, 0>}
	
	object{E5 scale<0.003, 0.06 - 0.008, 0.03> translate<0.004, 0.004, 0>} 
	object{E5 scale<0.003, 0.06 - 0.008, 0.03> translate<0.02 - 0.003/2, 0.004, 0>}
	object{E5 scale<0.003, 0.06 - 0.008, 0.03> translate<0.04 - 0.007, 0.004, 0>}
	
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.015 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.025 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.035 - 0.003/2, 0>}
	object{E5 scale<0.04 - 0.008, 0.003, 0.03> translate<0.004, 0.045 - 0.003/2, 0>}
	
	object{Glass scale<0.03, 0.05, 1> translate<0.005, 0.005, 0.0005>}
}

#declare Window2 = union {
	object{E5 scale<0.04, 0.004, 0.03>}
	object{E5 scale<0.04, 0.004, 0.03> translate <0, 0.06 - 0.004, 0>}
	object{E5 scale<0.004, 0.06 - 0.008, 0.03> translate<0, 0.004, 0>}
	object{E5 scale<0.004, 0.06 - 0.008, 0.03> translate<0.04 - 0.004, 0.004, 0>}
	
	object{WindowFrame2 translate z*0.002}
}

#declare WindowFrame3 = union {
	object{E5 scale<0.03 - 0.008, 0.003, 0.03> translate<0.004, 0.004, 0>}
	object{E5 scale<0.03 - 0.008, 0.003, 0.03> translate<0.004, 0.05 - 0.007, 0>}
	
	object{E5 scale<0.003, 0.05 - 0.008, 0.03> translate<0.004, 0.004, 0>} 
	object{E5 scale<0.003, 0.05 - 0.008, 0.03> translate<0.015 - 0.003/2, 0.004, 0>}
	object{E5 scale<0.003, 0.05 - 0.008, 0.03> translate<0.03 - 0.007, 0.004, 0>}
	
	object{E5 scale<0.03 - 0.008, 0.003, 0.03> translate<0.004, 0.015 - 0.003/2, 0>}
	object{E5 scale<0.03 - 0.008, 0.003, 0.03> translate<0.004, 0.025 - 0.003/2, 0>}
	object{E5 scale<0.03 - 0.008, 0.003, 0.03> translate<0.004, 0.035 - 0.003/2, 0>}
	
	object{Glass scale<0.02, 0.04, 1> translate<0.004, 0.002, 0.0005>}
}

#declare Window3 = union {
	object{E5 scale<0.03, 0.004, 0.03>}
	object{E5 scale<0.03, 0.004, 0.03> translate <0, 0.05 - 0.004, 0>}
	object{E5 scale<0.004, 0.05 - 0.008, 0.03> translate<0, 0.004, 0>}
	object{E5 scale<0.004, 0.05 - 0.008, 0.03> translate<0.03 - 0.004, 0.004, 0>}
	
	object{WindowFrame3 translate z*0.002}
}

#declare Belt = union {
	object{E3 scale<0.405, 0.04, 0.305> translate<-0.0025, 0, -0.0025>}
	object{E3 scale<0.407, 0.005, 0.307> translate<-0.0035, 0.03, -0.0035>}
	object{E3 scale<0.407, 0.005, 0.307> translate<-0.0035, 0.005, -0.0035>}
	
	object{E5 scale<0.012, 0.012, 0.03> translate <-0.012/2, -0.012/2, 0> rotate z*45 translate<0.06, 0.012/2 + 0.014, -0.004>}
	object{E5 scale<0.012, 0.012, 0.03> translate <-0.012/2, -0.012/2, 0> rotate z*45 translate<0.13, 0.012/2 + 0.014, -0.004>}
	object{E5 scale<0.012, 0.012, 0.03> translate <-0.012/2, -0.012/2, 0> rotate z*45 translate<0.20, 0.012/2 + 0.014, -0.004>}
	object{E5 scale<0.012, 0.012, 0.03> translate <-0.012/2, -0.012/2, 0> rotate z*45 translate<0.27, 0.012/2 + 0.014, -0.004>}
	object{E5 scale<0.012, 0.012, 0.03> translate <-0.012/2, -0.012/2, 0> rotate z*45 translate<0.34, 0.012/2 + 0.014, -0.004>}
}

#declare BeltSide = union {
	object{E1 scale<0.305, 0.04, 1> rotate -y*90 translate<-0.0025, 0, -0.0025>}
	object{E1 scale<0.307, 0.005, 1> rotate -y*90 translate<-0.0035, 0.03, -0.0035>}
	object{E1 scale<0.307, 0.005, 1> rotate -y*90 translate<-0.0035, 0.005, -0.0035>}
}

#declare Stairway = union {
	// front
	union {
		object{E1 scale<0.28, 0.11, 1> translate<0.06, -0.1, -0.07>}
		object{E1 scale<0.26, 0.01, 1> translate<0.07, 0.01, -0.06>}
		object{E1 scale<0.24, 0.01, 1> translate<0.08, 0.02, -0.05>}
		
		texture{StairwayTxt scale<0.28, 0.13, 1> translate<0.06, -0.1, 0>}
	}
	
	// sides
	union {
		object{E1 scale<0.07, 0.11, 1> rotate -y*90 translate<0.06, -0.1, -0.07>}
		object{E1 scale<0.07, 0.11, 1> rotate -y*90 translate<0.34, -0.1, -0.07>}
		
		object{E1 scale<0.06, 0.01, 1> rotate -y*90 translate<0.07, 0.01, -0.06>}
		object{E1 scale<0.06, 0.01, 1> rotate -y*90 translate<0.33, 0.01, -0.06>}
		
		object{E1 scale<0.05, 0.01, 1> rotate -y*90 translate<0.08, 0.02, -0.05>}
		object{E1 scale<0.05, 0.01, 1> rotate -y*90 translate<0.32, 0.02, -0.05>}
		
		texture{StairwayTxt scale<0.28, 0.13, 1> rotate -y*90 translate<0.06, -0.1, 0>}
	}
	
	// top
	union {
		object{E1 scale<0.28, 0.07, 1> rotate x*90 translate<0.06, 0.01, -0.07>}
		object{E1 scale<0.26, 0.06, 1> rotate x*90 translate<0.07, 0.02, -0.06>}
		object{E1 scale<0.24, 0.05, 1> rotate x*90 translate<0.08, 0.03, -0.05>}
		
		texture{StairwayTxt scale<0.28, 0.13, 1> rotate x*90 translate<0.06, 0, -0.07>}
	}
	
	// posts
	union {
		cylinder{0, <0, 0.04, 0>, 0.001 translate<0.065, 0.01, -0.06>}
		cylinder{0, <0, 0.04, 0>, 0.001 translate<0.065, 0.01, -0.03>}
		cylinder{0, <0, 0.04, 0>, 0.001 translate<0.335, 0.01, -0.06>}
		cylinder{0, <0, 0.04, 0>, 0.001 translate<0.335, 0.01, -0.03>}
		
		sphere{<0, 0.04, 0>, 0.0016 translate<0.065, 0.01, -0.06>}
		sphere{<0, 0.04, 0>, 0.0016 translate<0.065, 0.01, -0.03>}
		sphere{<0, 0.04, 0>, 0.0016 translate<0.335, 0.01, -0.06>}
		sphere{<0, 0.04, 0>, 0.0016 translate<0.335, 0.01, -0.03>}
	}
}

#declare Door = union {
	// frame
	object{E5 scale<0.01, 0.1, 0.03>}
	object{E5 scale<0.01, 0.1, 0.03> translate x*0.07} 
	object{E3 scale<0.065, 0.01, 0.03> translate <0.01 - 0.0025, 0.1, 0>}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.04}
		cylinder{<0, 0, -1>, <0, 0, 1>, 0.03}
		plane{y, 0}              
		
		translate<0.04, 0.1, 0>
	}
	
	difference{
		cylinder{0, <0, 0, 0.03>, 0.03}
		plane{y, 0}              
		
		translate<0.04, 0.1, 0.005>
	}
	
	object{E5 scale<0.005, 0.1, 0.03> translate<0.01, 0, 0.003>}
	object{E5 scale<0.01, 0.1, 0.03> translate<0.04 - 0.005, 0, 0.003>}
	object{E5 scale<0.005, 0.1, 0.03> translate<0.065, 0, 0.003>} 
	
	object{E3 scale<0.05, 0.005, 0.03> translate<0.015, 0, 0.003>}
	object{E3 scale<0.05, 0.005, 0.03> translate<0.015, 0.04 - 0.005/2, 0.003>}
	object{E3 scale<0.05, 0.005, 0.03> translate<0.015, 0.1 - 0.005, 0.003>}
	
	object{E1 scale<0.06, 0.1, 1> translate<0.01, 0, 0.0038>}
}

#declare House2 = union {
	// facade
	object{E1 scale<0.4, 0.81, 1> translate -y*0.1}
	
	// left wall
	union {
		object{E1 scale<0.3, 0.81, 1> translate -y*0.1 translate -x*0.3 rotate y*90}
		 
		// belt
		object{BeltSide translate y*0.18}
		object{BeltSide translate y*0.37}
		object{BeltSide translate y*0.55}
		object{BeltSide translate y*0.71}
		
		texture{SideTxt scale<0.54, 0.81, 1> translate<-0.02, -0.1, 1>}
	}

	// belts
	object{Belt translate y*0.55}
	object{Belt translate y*0.37}
	object{Belt translate y*0.18}  
	  
	// 1st floor
	
	object{Window3 translate<0.02, 0.12, -0.005>}
	object{Window3 translate<0.02 + 0.05, 0.12, -0.005>}
	object{Window3 translate<0.02 + 0.10, 0.12, -0.005>}
	object{Window3 translate<0.25, 0.12, -0.005>}
	object{Window3 translate<0.25 + 0.05, 0.12, -0.005>}
	object{Window3 translate<0.25 + 0.10, 0.12, -0.005>}
	
	 
	// 2nd floor
	object{Window1 translate<0.04, 0.23, -0.003>}
	object{Window1 translate<0.04 + 0.07, 0.23, -0.003>}
	object{Window1 translate<0.04 + 0.14, 0.23, -0.003>}
	object{Window1 translate<0.04 + 0.21, 0.23, -0.003>}
	object{Window1 translate<0.04 + 0.28, 0.23, -0.003>}
	                                    
	// 3rd floor  
	
	object{Window1 translate<0.04, 0.42, -0.003>}
	object{Window1 translate<0.04 + 0.07, 0.42, -0.003>}
	object{Window1 translate<0.04 + 0.14, 0.42, -0.003>}
	object{Window1 translate<0.04 + 0.21, 0.42, -0.003>}
	object{Window1 translate<0.04 + 0.28, 0.42, -0.003>}
	
	// 4th floor  
	
	object{Window2 translate<0.04, 0.62, -0.003>}
	object{Window2 translate<0.04 + 0.07, 0.62, -0.003>}
	object{Window2 translate<0.04 + 0.14, 0.62, -0.003>}
	object{Window2 translate<0.04 + 0.21, 0.62, -0.003>}
	object{Window2 translate<0.04 + 0.28, 0.62, -0.003>}
	
	// roof
	object{Belt translate y*0.71}
	
	// columns
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02, 0.41, -0.0026>}
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02 + 0.07, 0.41, -0.0028>}
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02 + 0.14, 0.41, -0.0028>}
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02 + 0.21, 0.41, -0.0028>}
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02 + 0.28, 0.41, -0.0028>}
	object{E3 scale<0.01, 0.3, 0.01> translate<0.02 + 0.35, 0.41, -0.0028>}
	
	object{Stairway}
	
	object{Door translate<0.16, 0.03, -0.006>}       
	
	texture{FacadeTxt scale<0.54, 0.81, 1> translate<-0.02, -0.1, 1>}
}