#include "elements.inc"

#declare TestTxt = 0;

#declare FacadeTxt = texture {
	#if(TestTxt)
		pigment{color rgb 1}
	#else
		pigment{
			image_map{
				jpeg "imagemap/house11.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.65}
	#end
}

#declare SideTxt = texture {
	#if(TestTxt)
		pigment{color rgb 1}
	#else
		pigment{
			image_map{
				jpeg "imagemap/house12.jpg"
				map_type 0
			}
		}
		finish{diffuse 0.65}
	#end
}

#declare Glass = object{
	E1
	pigment{color rgb<0.5, 0.58, 0.6>}
	finish{diffuse 0.7 phong 0.5 reflection 0.2}
}

#declare WindowFrame1 = union {
	object{E5 scale<0.003, 0.1, 0.03> translate<0.01, 0.02, 0.002>}        
	object{E5 scale<0.003, 0.1, 0.03> translate<0.025 - 0.003/2, 0.02, 0.002>}
	object{E5 scale<0.003, 0.1, 0.03> translate<0.04 - 0.003, 0.02, 0.002>}
	
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.02 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.04 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.06 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.08 - 0.003, 0.002>}
	object{E5 scale<0.03, 0.003, 0.03> translate<0.01, 0.02 + 0.10 - 0.003, 0.002>}
	
	object{Glass scale<0.03, 0.1, 1> translate<0.01, 0.02, 0.003>}
}

#declare Window1 = union {  
	object{E5 scale<0.05, 0.005, 0.03>}
	object{E5 scale<0.05, 0.005, 0.04> translate<0, 0.005, -0.002>}
	object{E5 scale<0.07, 0.01, 0.03> translate<-0.01, 0.01, -0.004>}
	object{E5 scale<0.05, 0.01, 0.03> translate y*0.12}
	object{E5 scale<0.01, 0.1, 0.03> translate y*0.02}
	object{E5 scale<0.01, 0.1, 0.03> translate<0.04, 0.02, 0>} 
	                               
	object{E5 scale<0.07, 0.01, 0.03> translate<-0.01, 0.13, 0.003>}
	object{E5 scale<0.01, 0.11, 0.03> translate<-0.01, 0.02, 0.003>}
	object{E5 scale<0.01, 0.11, 0.03> translate<0.05, 0.02, 0.003>}
	                             
	object{WindowFrame1}
}

#declare WindowFrame2 = union {
	object{E5 scale<0.004, 0.03, 0.03> translate<0.005, 0.005, 0.002>} 
	object{E5 scale<0.004, 0.03, 0.03> translate<0.02 - 0.002, 0.005, 0.002>}       
	object{E5 scale<0.004, 0.03, 0.03> translate<0.035 - 0.004, 0.005, 0.002>}
	
	object{E5 scale<0.03, 0.004, 0.03> translate<0.005, 0.005, 0.002>}        
	object{E5 scale<0.03, 0.004, 0.03> translate<0.005, 0.035 - 0.004, 0.002>}
	
	object{Glass scale<0.03, 0.03, 1> translate<0.005, 0.005, 0.0025>}
}

#declare Window2 = union {
	object{E5 scale<0.04, 0.005, 0.03>}
	object{E5 scale<0.04, 0.005, 0.03> translate y*0.035}
	object{E5 scale<0.005, 0.04, 0.03>}
	object{E5 scale<0.005, 0.04, 0.03> translate x*0.035}
	
	object{WindowFrame2}
}

#declare WindowFrame3 = union {
	object{E5 scale<0.004, 0.055, 0.03> translate<0.005, 0, 0.002>}        
	object{E5 scale<0.004, 0.055, 0.03> translate<0.04 - 0.004, 0, 0.002>}
	object{E5 scale<0.004, 0.055, 0.03> translate<0.021, 0, 0.002>}
	
	object{E5 scale<0.04, 0.004, 0.03> translate<0.005, 0.01, 0.002>}        
	object{E5 scale<0.04, 0.004, 0.03> translate<0.005, 0.055 - 0.004, 0.002>}
	
	object{Glass scale<0.04, 0.05, 1> translate<0.004, 0.002, 0.0025>}
}

#declare Window3 = union {
	object{E5 scale<0.045, 0.01, 0.03> translate<0, 0, -0.004>}
	object{E5 scale<0.045, 0.005, 0.03> translate y*0.055}
	object{E5 scale<0.005, 0.045, 0.03> translate y*0.01}
	object{E5 scale<0.005, 0.045, 0.03> translate <0.04, 0.01, 0>}
	
	object{WindowFrame3}
}

#declare House1 = union {
	// facade
	object{E1 scale<0.5, 0.8, 1> translate -y*0.1}
	
	// left wall
	union {
		object{E1 scale<0.3, 0.8, 1> translate -y*0.1}
		
		// bars
		object{E3 scale<0.31, 0.01, 0.01> translate<-0.005, 0.12, -0.005>}
		object{E3 scale<0.31, 0.01, 0.01> translate<-0.005, 0.2, -0.005>}
		object{E3 scale<0.31, 0.01, 0.01> translate<-0.005, 0.41, -0.005>}
		object{E3 scale<0.31, 0.01, 0.01> translate<-0.005, 0.59, -0.005>}
		object{E3 scale<0.31, 0.01, 0.01> translate<-0.005, 0.69, -0.005>}
		
		texture{SideTxt scale<0.54, 0.81, 1> translate<-0.02, -0.1, 1>}
		
		translate -x*0.3
		rotate y*90
	}
	
	// basement
	object{Window2 translate<0.07, 0.06, -0.003>}
	object{Window2 translate<0.07 + 0.11, 0.06, -0.003>}
	object{Window2 translate<0.07 + 0.21, 0.06, -0.003>}
	object{Window2 translate<0.07 + 0.32, 0.06, -0.003>}
	
	// bars
	object{E3 scale<0.51, 0.01, 0.01> translate<-0.005, 0.12, -0.005>}
	object{E3 scale<0.51, 0.01, 0.01> translate<-0.005, 0.2, -0.005>}
	object{E3 scale<0.51, 0.01, 0.01> translate<-0.005, 0.41, -0.005>}
	object{E3 scale<0.51, 0.01, 0.01> translate<-0.005, 0.59, -0.005>}
	object{E3 scale<0.51, 0.01, 0.01> translate<-0.005, 0.69, -0.005>}  
	
	// 1st floor
	object{Window1 translate<0.06, 0.19, -0.005>}
	object{Window1 translate<0.06 + 0.11, 0.19, -0.005>}
	object{Window1 translate<0.06 + 0.22, 0.19, -0.005>}
	object{Window1 translate<0.06 + 0.33, 0.19, -0.005>}
	
	// 2nd floor
	object{Window1 translate<0.06, 0.4, -0.005>}
	object{Window1 translate<0.06 + 0.11, 0.4, -0.005>}
	object{Window1 translate<0.06 + 0.22, 0.4, -0.005>}
	object{Window1 translate<0.06 + 0.33, 0.4, -0.005>}
	
	// 3rd floor
	object{Window3 translate<0.06, 0.59, -0.003>}
	object{Window3 translate<0.06 + 0.11, 0.59, -0.003>}
	object{Window3 translate<0.06 + 0.22, 0.59, -0.003>}
	object{Window3 translate<0.06 + 0.33, 0.59, -0.003>}
	
	// roof
	object{E6 scale<0.52, 0.32, 0.01> rotate x*90 translate<-0.01, 0.71, -0.01>}       
	
	texture{FacadeTxt scale<0.54, 0.81, 1> translate<-0.02, -0.1, 1>}
}