
/*

Entrance to St. Paul's

Bob Hughes
omniverse@charter.net
March 31, 2003

*/


#declare Column=
difference {
cylinder {
	-y,y,1
}
#local C=360;
#while (C>0)
cylinder {
	-y,y,1
	scale <.1,1,.2>
	translate x
	rotate C*y
}
#local C=C-18;
#end
}

#declare Columns=
union {
object {
	Column
	scale <.3,2.25,.3>
	translate -.5*x
}
object {
	Column
	scale <.3,2.25,.3>
	translate .5*x
}
torus {
	.27,.09
	translate <-.5,-2.125,0>
}
torus {
	.3,.1
	scale <1,1.25,1>
	translate <-.5,-2.25,0>
}
torus {
	.27,.09
	translate <.5,-2.125,0>
}
torus {
	.3,.1
	scale <1,1.25,1>
	translate <.5,-2.25,0>
}
//
torus {
	.27,.09
	pigment {
		rgb <.99,.92,.9>
		}
	normal {
		radial .5 frequency 12 scallop_wave
	}
	translate <-.5,1.8,0>
}
torus {
	.3,.1
	scale <1,1.25,1>
	pigment {
		rgb <.99,.92,.9>
		}
	normal {
		radial .5 frequency 12 scallop_wave
	}
	translate <-.5,1.9,0>
}
torus {
	.27,.09
	pigment {
		rgb <.99,.92,.9>
		}
	normal {
		radial .5 frequency 12 scallop_wave
	}
	translate <.5,1.8,0>
}
torus {
	.3,.1
	scale <1,1.25,1>
	pigment {
		rgb <.99,.92,.9>
		}
	normal {
		radial .5 frequency 12 scallop_wave
	}
	translate <.5,1.9,0>
}
}

#declare Entrance=
union {
difference {
// cap
box {
	-1,1
	rotate 45*z
	clipped_by {box {<-1.77,0,-1.77>,<1.77,1.77,1.77> scale 1.01}}
	scale <5,2.5,.5>/1.25
	translate <0,11.5,0>
}
box {
	-1,1
	rotate 45*z
	clipped_by {box {<-1.77,0,-1.77>,<1.77,1.77,1.77> scale 1.01}}
	scale <5,2.5,.25>/1.25*.75
	translate <0,11.5,-.333>
	pigment {
		rgb <.99,.92,.9>
	}
	normal {
		bozo 3 turbulence .5 scale .5
	}
}
	translate -.5*z
}
// statues
sphere {
	0,1
	pigment {
		rgb <.99,.92,.9>
	}
	normal {
		wrinkles .75 scale <.15,.25,.2> rotate <10,20,0>
	}
	scale <1/3,1.3,1/3>
	translate <0,15,-.25>
}
sphere {
	0,1
	pigment {
		rgb <.99,.92,.9>
	}
	normal {
		wrinkles .75 scale <.15,.25,.2> rotate <10,20,0>
	}
	scale <1/3,1.3,1/3>
	translate <-5,13,-.25>
}
sphere {
	0,1
	pigment {
		rgb <.99,.92,.9>
	}
	normal {
		wrinkles .75 scale <.15,.25,.2> rotate <10,20,0>
	}
	scale <1/3,1.3,1/3>
	translate <5,13,-.25>
}
// lower cap edge
box {
	-1,1
	scale <5,.25,.5>
	translate <0,11.5,-.25>
}
// upper level
box {
	-1,1
	scale <5,.5,1>
	translate <0,11.25,0>
}
// upper (side) overhangs
box {
	-1,1
	scale <.75,.5,.5>
	translate <-6.5,11.25,.5>
}
box {
	-1,1
	scale <.75,.5,.5>
	translate <6.5,11.25,.5>
}
// mid-level
box {
	-1,1
	scale <7,.5,1>
	translate <0,6,0>
} // lower level
box {
	-1,1
	scale <7,.5,1>
	translate <0,.5,0>
}
// main building
difference {
box {
	-1,1
	scale <12,6,15>
	translate <0,6,15.5>
}
box { // enclave
	-1,1
	scale <4,5,2>
	translate <0,5.5,2>
}
// windows
union {
box {
	-1,1
	scale <.75,1.5,.67>
	translate <-9.5,8,0>
}
box {
	-1,1
	scale <.75,1.5,.67>
	translate <9.5,8,0>
}
box {
	-1,1
	scale <.75,1.5,.67>
	translate <-9.5,2.5,0>
}
box {
	-1,1
	scale <.75,1.5,.67>
	translate <9.5,2.5,0>
}
	pigment {
		rgbt <.9,.9,.9,.9>
	}
	finish {
		specular .3 roughness .002
		reflection {
			.05,.95
			fresnel
		}
	}
	interior {
		ior 1.5
	}
} // union
} // difference
#local C=0;
#while (C<10)
object {
	Columns
	translate <(-4+C),8.75,-.5>
}
#local C=C+2.5;
#end
object {
	Columns
	translate <-6.5,8.75,.5>
}
object {
	Columns
	translate <6.5,8.75,.5>
}
#local C=0;
#while (C<14)
object {
	Columns
	translate <(-6.5+C),3.25,-.5>
}
#local C=C+2.5;
#end
// towers
union {
// left base
difference {
box {
	-1,1
	scale <1.75,1.5,1.75>
}
cylinder {
	-z,z,1
	scale <.67,.67,.25>
	translate <0,.3,-1.75>
}
	translate <-10,13.25,2.5>
} // difference
union {
#local C=360;
#while (C>0)
object {
	Columns
	scale .67
	translate -1.5*z
	rotate (45+C)*y
}
#local C=C-90;
#end
#local C=360;
#while (C>0)
object {
	Columns
	scale .67
	translate -1*z
	rotate (22.5+C)*y
}
#local C=C-45;
#end
	translate <-10,16.5,2.5>
} // union
cylinder {
	-y,y,1
	scale <1.75,.25,1.75>
	translate <-10,18.25,2.5>
}
// spire
cylinder {
	-y,y,1
	scale <1,1,1>
	translate <-10,19.5,2.5>
}
cone {
	-y,1.5,y,0
	scale <.5,1.25,.5>
	translate <-10,21.25,2.5>
}
// right base
difference {
box {
	-1,1
	scale <1.75,1.5,1.75>
}
cylinder {
	-z,z,1
	scale <.67,.67,.25>
	translate <0,.3,-1.75>
}
	translate <10,13.25,2.5>
} // difference
union {
#local C=360;
#while (C>0)
object {
	Columns
	scale .67
	translate -1.5*z
	rotate (45+C)*y
}
#local C=C-90;
#end
#local C=360;
#while (C>0)
object {
	Columns
	scale .67
	translate -1*z
	rotate (22.5+C)*y
}
#local C=C-45;
#end
	translate <10,16.5,2.5>
} // union
cylinder {
	-y,y,1
	scale <1.75,.25,1.75>
	translate <10,18.25,2.5>
}
// spire
cylinder {
	-y,y,1
	scale <1,1,1>
	translate <10,19.5,2.5>
}
cone {
	-y,1.5,y,0
	scale <.5,1.25,.5>
	translate <10,21.25,2.5>
}
} // union
	pigment {
		rgb <.99,.92,.9>
	}
	finish {
		ambient .15 diffuse .55
	}
	scale 4 translate <0,-60,-55> //rotate -40*y translate <-20,0,400>
}

/*
// preview

Entrance

camera {
  location  <0, 36, -90>
  look_at   <0, 40,  0>
  right     x*image_width/image_height
  angle 60
}

light_source {
	<-50,100,-100>,1
}
*/
