/*	aspect ratio of this image is 1.24
	you can use the following sizes:
	cmd://+w300 +h372 +a0.3 +r2 +am1
	cmd://+w450 +h558 +a0.3 +r3 +am1
	cmd://+w600 +h744 +a0.2 +r2 +am2
	cmd://+w900 +h1116 +a0.1 +r4 +am1
*/

/*******************************************************************

  modifications:

    - 03-27-2003:
        Christoph Hormann: added water
                           added radiosity
                           added some dummy shapes
                           changed scale
                           changed light
                           changed sky

    - 03-27-2003
        Matti Karnaattu:   changed sky colors to match more with
                             original image
                           added sky.inc for light adjustments
                           
    - 03-28-2003
        Gena Obukhov:      added House1

    - 04-01-2003
        Bob Hughes:        added building front (to St. Paul's)
                           changed lighting, sky, some textures
                           moved buildings (houses) a little
                           scaled St. Paul's down and moved closer by half
                           added clouds (not very usable)
                           
	- 04-01-2003
		Gena Obukhov:      added House2, House3, House4 (without textures)
    
    - 04-04-2003
		Jim Charter:    added figure standing on slip, 
		                modified righthand building placers
		                added rough version of slip and steps
		                lower water level 1 unit
    
*******************************************************************/

#version 3.5;


/************************************* Flags ****************************************/
#declare showDome = 1;
#declare showHouse1 = 1;
#declare showHouse2 = 1;
#declare showHouse3 = 1;
#declare showHouse4 = 1;
#declare showEntrance = 1;

#declare showWater = 1;
#declare showSky = 1;
#declare showFog = 1;
#declare showClouds = 0; // shadows cause much slower render-time, impractical

#declare showTestObjects1 = 1;
#declare showTestObjects2 = 1;  
#declare showManOnSlip = 1;

#declare use_Rad = true;
#declare use_area_light = false;


// Sun flags 
#declare useSun = 1;
#declare sunZenithAngle = 30;             // 0 - 90
#declare sunAzimuthAngle = 75; // changed // 0 is north (direction <0, 0, 1>)
#declare sunLightColor = <1.9,1.75,1.5>*1.5;  // <2.0, 1.7, 1.3> * 0.8;
#declare sunSize = 10;                    // Angle
#declare sunLightShadowMinimumDetail = 0; // 0 - 9
#declare sunLightShadowMaximumDetail = 9; // 0 - 9

// sunLightShadowMinimumDetail must be less or equal than
// sunLightShadowMaximumDetail. If sunLightShadowMaximumDetail is
// greater than zero then sunLightShadowMinimumDetail must be greater
// than zero.

#declare sunLightInteractWithMedia = false;
#declare sunPhotonsRefraction = off;
#declare sunPhotonsReflection = off;
#declare sunPhotonsAreaLight = off;


/********************************* global_settings **********************************/

global_settings {
   max_trace_level 10
  // assumed_gamma 1 // commented

   #if (use_Rad)
   ambient_light -0.2 // added
     radiosity {
       pretrace_start 0.08
       pretrace_end   0.02
       count 99 // 60 // changed

       nearest_count 5
       error_bound 0.9 // 1.0 // changed
       recursion_limit 3 // 1 // changed

       low_error_factor 0.5
       gray_threshold 0.2 // 0.0 // changed
       minimum_reuse 0.015
       brightness 1.2 // 0.6 // changed

       normal on
       media on
     }
   #end
}

#if (use_Rad)
  #default { finish { ambient 0 } }
#end


/************************************* Camera ***************************************/
camera {
    location <0, 2, -60>  
    right x*image_width/image_height
    up y
    look_at <0, 8, 0>
    angle 24
}


/************************************* Lights ***************************************/
#if(useSun)
	#include "sun.inc"
#else
	light_source {
		<10, 8, 3>*10000
		color rgb <1.9,1.75,1.5> // <2.0, 1.6, 1.3>*0.8 // changed

		#if (use_area_light)
			area_light 200*x 200*y  3,3
			adaptive 1 // added
			jitter orient circular
		#end
	}	
#end


/*********************************** Test Objects ***********************************/
#if(showTestObjects1)
	// sphere{<0, 1, 0>, 1 pigment{color rgb<1, 0, 0>}} // commented

union {
  
 // box { <-2, -2, -10>,<2,13, 10>                  translate < 2,0,0>   } // changed //<4, -2, -10> <8, 8, 10>      
  box { <-2, -2, -10>, <2,14.00, 10> rotate y*-12 translate < 3.7,0,20>  } // changed //<4, -2, 10>,<8, 8.75, 20>    
  box { <-2, -2, -10>, <2,12.55,  5> rotate y*-12 translate < 1.3,0,30>  } // changed //<4, -2, 20>,<8, 7.75, 35>    
  box { <-2, -2, -10>, <2,12.50,  5> rotate y*-22 translate < 1.4,0,40>  } // changed //<4, -2, 35>,<8, 7.25, 50>    
  box { <-2, -2, -10>, <2,14.00, 10> rotate y*-1  translate <   0,0,65>  } // added //<4, -2, 50>,<8, 8.25, 100>     
  box { <-2, -2, -10>, <2, 5.70, 10> rotate y*-15 translate < 1.5,0,75>  } // added //<4, -2, 50>,<8, 8.25, 100>     
  box { <-2, -2, -10>, <2, 4.70, 10> rotate y*-25 translate < 2.0,0,85>  } // added //<4, -2, 50>,<8, 8.25, 100>     

  rotate 4*y // -4 // changed
  translate <8.3, 0, -35> // changed <3, 0, -35>

  texture {
    pigment { color rgb <.75,.7,.6> } // changed?
    finish { ambient 0.15 diffuse 0.5 } // changed? 
    
  }
}
 //slip
union {
  box { <-3,   -2, -12>, <3, 0.2, 12> }  
  box { <-3.25,   -2, -12.25>, <3.25, 0.2, 12.25> translate y*-.25 } 
  box { <-3.5,   -2, -12.5>, <3.5, 0.2, 12.5> translate y*-.5 }     
  box { <-3.75,   -2, -12.75>, <3.75, 0.2, 12.75> translate y*-.75 }
  box { <-4,   -2, -13>, <4, 0.2, 13> translate y*-1 } 
  rotate -32*y  
  translate <11.0, 0, -39> 
  pigment { color rgb <.75,.7,.6> }  finish { ambient 0.15 diffuse 0.5 }  
}

#end


/*************************************** Dome ***************************************/
union {

#if(showDome)
	#include "colors.inc"
	#include "glass_old.inc"
	#include "metals.inc"
	#include "Stpaul.inc"

	object{StPauls scale 0.035}
#end

// added
#if(showEntrance)
	#include "entrance.inc"
	object {Entrance}
#end

 scale .5 rotate -35*y translate <-12, 60, 420>/2 // changed
}


/**************************************** Sky ***************************************/
#if(showSky)
	sky_sphere {
		pigment {
			gradient y
			color_map {
				[0.0 rgb <212, 191, 189> / 255]       
				[0.03 rgb <189, 226, 255> / 255] // <176, 226, 255>
				[0.15 rgb <  63, 136, 212> / 255]
				[0.5 rgb <  15, 112, 191> / 255] // <  0, 104, 139>
				[0.5 rgb 0]
			}
			scale 2
		}
	}
#end	


/***************************************** Fog **************************************/
#if(showFog)
	fog {
		fog_type 2
		distance 700
		color <.6,.75,.9>
		fog_alt 30
		fog_offset 0
	}          
#end


/**************************************** Clouds ***********************************/
#if(showClouds)
	#declare ClearSky=pigment {rgbf 1}

	#declare CloudySky=pigment {
		bumps
		color_map {
			[0 rgbf <1,1,1,0>]
			[0.5 rgbf <1,1,1,0.1>]
			[0.8 rgbf <1,1,1,0.9>]
			[0.9 rgbf 1]
		}
		turbulence 0.1 scale 0.1
	}

	// clouds added
	sphere {
		-5000*y,6000
		pigment {
			granite
			pigment_map {
				[0.3 ClearSky]
				[0.5 CloudySky]
			}
			frequency 1 scale 300
		}
		finish {
			ambient 0.75 diffuse 0.9
		}
		hollow
	}
#end


/*************************************** Water **************************************/
#if(showWater)
  #include "water.inc"
#end 


/********************************* Houses. Left Side ********************************/ 
union {
	#if(showHouse1)
		#include "house1.inc"
		object {House1 scale 10}
	#end
	
	#if(showHouse2)
		#include "house2.inc"
		object {House2 scale 10 translate <9.2, 0, 0.3>}
	#end
	
	#if(showHouse3)
		#include "house3.inc"
		object {House3 scale 10 translate <5.2, 0, 0.5>}
	#end
	
	#if(showHouse4)
		#include "house4.inc"
		object {House4 scale 10 translate <13.2, 0, 0.2>}
	#end
	
	#if(showTestObjects2)
		union {
  			box { <0, -2, 0>, <4, 8, 4> translate <-4.4, 0, 0.4>}
  			box { <0, -2, 0>, <5, 7, 4> translate <18.2, 0, 0.3>} // added
  			box { <0, -2, 0>, <4.5, 6.5, 4> translate <24, 0, 0.3>} // added

  			texture {
    			pigment { color rgb<0.7, 0.67, 0.6> }
    			finish { ambient 0 diffuse 0.4 }
  			}
		}
	#end
	
	rotate -y*82 // 78 // changed
	translate <-5.5, 0, -28> // changed?
}

/*************************************** Figures **************************************/
#if(showManOnSlip)

        #include "manOnSlip.inc"
        
        #local reverse = transform { matrix <  -1,0,0,
                                                0,1,0,
                                                0,0,1,
                                                0,0,0 >  
                        }              
                            
        
        object{ manOnSlip transform { reverse } rotate y*-30 scale 1/5.5 translate < 3.3,  0.2, -32 > }
       

#end