/************************************************************************* 

snowflakes3D.pov

Author: Gennady Obukhov 
obukhov@mail.com 
http://propro.ru/go/
date: November 3 2002
Walnut Creek, California

*************************************************************************/ 

#include "functions.inc"
#include "snowflakes.inc"

#declare Model = object{Snowflakes[5] scale 0.8 translate<(4/3)/2, 0.5, 0>}

// step 1
#declare makeModel = 1;	// use +FT +UA then rename snowflakes3D.tga to model.tga
// step 2
#declare make3D = 0;

camera{
	location <(4/3)/2, 0.5, -1> 
	look_at <(4/3)/2, 0.5, 0> 
}

#macro Pollock (pigm, strokesX, strokesY)
	#local widthX = 4/3;
	#local heightY = 1;
	#local cntX = 0;
	#local cntY = 0;     
	#local lseed = seed(1000);       
	#local incrX = widthX/strokesX;
	#local incrY = heightY/strokesY;
	
	blob {
		threshold 0.65
		#while(cntX < strokesX)
			#local cntY = 0;           
			#while(cntY < strokesY)
				#local currentPoint = <incrX*cntX, incrY*cntY, 0>;   
				#local P = eval_pigment(pigm, <currentPoint.x, currentPoint.y, 0>);
    			#if(P.transmit != 1)   
    				cylinder {<-1, 0, 0>, <1, 0, 0>, 1, 2 
						scale <2.5 * incrX, 0.6 * incrX, (0.6 * incrX) + (0.04 * rand(lseed))>
						rotate z*360*rand(lseed)
						translate<currentPoint.x + (incrX*rand(lseed)), currentPoint.y + (incrY*rand(lseed)), 0>
					}
				#end   			
				#local cntY = cntY + 1;
			#end
			#local cntX = cntX + 1;
		#end
		scale <1, 1, 0.1>
	}
#end

#if(makeModel)
	object{Model}
#end

#if(make3D)
	#local skyTxt = pigment {
		image_map{    
			tga "model.tga" 
			map_type 0
			interpolate 0
			once
		} 
		scale <4/3, 1, 1>
	}

	// 1 
	light_group { 
		light_source {<-3, 3, -10> color rgb 1}
		object {
			Pollock(skyTxt, 80, 60)
			texture {
				pigment {color rgbt<1, 1, 1, 0.6>}
				finish {
					specular 0.7
					roughness 0.005
					ambient 0
					diffuse 1
				}
			}
			translate<-(4/3)/2, -0.5, 0>
			scale 0.4
		}
		global_lights off                 
		translate<((4/3)/4)*1, (1/4)*3, 0>
	} 
 
	// 2
	light_group { 
		light_source {<3, 3, -10> color rgb 1}
		object {
			Pollock(skyTxt, 120, 90)
			texture {
				pigment {color rgbt<1, 1, 1, 0.6>}
				finish {
					specular 1
					roughness 0.005
					ambient 0
					diffuse 1
				}
			}
			translate<-(4/3)/2, -0.5, 0>
			scale 0.4
		}
		global_lights off                 
		translate<((4/3)/4)*3, (1/4)*3, 0>
	}   

	// 3
	light_group { 
		light_source {<-3, -2, -10> color rgb 1}
		object {
			Pollock(skyTxt, 160, 120)
			texture {
				pigment {color rgbt<1, 1, 1, 0.5>}
				finish {
					specular 1
					roughness 0.01
					ambient 0
					diffuse 1
				}
			}
			translate<-(4/3)/2, -0.5, 0>
			scale 0.4
		}
		global_lights off                  
		translate<((4/3)/4)*1, 1/4, 0>
	}   

	// 4
	light_group { 
		light_source {<3, -2, -10> color rgb 1}
		object {
			Pollock(skyTxt, 200, 150)
			texture {
				pigment {color rgbt<1, 1, 1, 0.4>}
				finish {
					specular 1
					roughness 0.01
					ambient 0
					diffuse 1
				}
			}
			translate<-(4/3)/2, -0.5, 0>
			scale 0.4
		}
		global_lights off                 
		translate<((4/3)/4)*3, 1/4, 0>
	}

	object{Snowflakes[5] scale 0.3 translate<(4/3)/2, 0.5, 0>}
	background{color rgb <0, 0.4, 0.7>}
#end
