/************************************************************************* 

snowflakes.inc
v.1.0  

Author: Gennady Obukhov 
obukhov@mail.com 
http://propro.ru/go/
date: November 1 2002
Walnut Creek, California

*************************************************************************/     

#macro Snowflake(pigmType, turb, resize, turn)
	#local pigm = pigment{
		#switch (pigmType)
			#case (0)
				agate
				#break
			#case (1) 
				granite
				#break
			#case (2) 
				bozo
				#break
			#case (3)
				wrinkles
				#break
			#case (4) 
				wood
				#break
			#case (5) 
				radial
				#break
			#case (6) 
				gradient x
				#break
			#case (7) 
				gradient y
				#break
			#case (8) 
				marble
				#break
		#end
		
		color_map{
			[0.0 0.5 color rgbt<0, 0, 0, 1> color rgbt<0, 0, 0, 1>]
			[0.5 1.0 color rgb 1 color rgb 1]
		} 
		turbulence turb
		rotate z*turn
		scale resize
	}
	#local SubSection = triangle {
		<0, 0>, <0, 0.5>, <0.35, 0.6>
		pigment{pigm}
		finish{ambient 2 phong 0}
	}
	#local Section = union{
		object{SubSection}
		object{SubSection rotate y*180}
	}
	union{
		object{Section}
		object{Section rotate z*60}
		object{Section rotate z*120}
		object{Section rotate z*180}
		object{Section rotate z*240}
		object{Section rotate z*300}
     }                      
#end

#declare Snowflakes = array[108];

//------------------------ agate -----------------------
// variable turbulence                             
#declare Snowflakes[0] = object{Snowflake(0, 0.0, 0.1, 0)};
#declare Snowflakes[1] = object{Snowflake(0, 0.3, 0.1, 0)};
#declare Snowflakes[2] = object{Snowflake(0, 0.6, 0.1, 0)};
#declare Snowflakes[3] = object{Snowflake(0, 1.0, 0.1, 0)};
// variable size
#declare Snowflakes[4] = object{Snowflake(0, 0.0, 0.06, 0)};
#declare Snowflakes[5] = object{Snowflake(0, 0.0, 0.12, 0)};
#declare Snowflakes[6] = object{Snowflake(0, 0.0, 0.16, 0)};
#declare Snowflakes[7] = object{Snowflake(0, 0.0, 0.20, 0)};
// variable angle
#declare Snowflakes[8] = object{Snowflake(0, 0.0, 0.1, 30)};
#declare Snowflakes[9] = object{Snowflake(0, 0.0, 0.1, 60)};
#declare Snowflakes[10] = object{Snowflake(0, 0.0, 0.1, 90)};
#declare Snowflakes[11] = object{Snowflake(0, 0.0, 0.1, 120)};	
	
//---------------------- granite -----------------------
// variable turbulence
#declare Snowflakes[12] = object{Snowflake(1, 0.0, 0.3, 0)};	
#declare Snowflakes[13] = object{Snowflake(1, 0.3, 0.3, 0)};	
#declare Snowflakes[14] = object{Snowflake(1, 0.6, 0.3, 0)};	
#declare Snowflakes[15] = object{Snowflake(1, 1.0, 0.3, 0)};
// variable size	
#declare Snowflakes[16] = object{Snowflake(1, 0.0, 0.1, 0)};	
#declare Snowflakes[17] = object{Snowflake(1, 0.0, 0.2, 0)};	
#declare Snowflakes[18] = object{Snowflake(1, 0.0, 0.4, 0)};	
#declare Snowflakes[19] = object{Snowflake(1, 0.0, 0.5, 0)};
// variable angle	
#declare Snowflakes[20] = object{Snowflake(1, 0.0, 0.3, 15)};	
#declare Snowflakes[21] = object{Snowflake(1, 0.0, 0.3, 40)};	
#declare Snowflakes[22] = object{Snowflake(1, 0.0, 0.3, 60)};	
#declare Snowflakes[23] = object{Snowflake(1, 0.0, 0.3, 90)};

//------------------------ bozo ------------------------
// variable turbulence	
#declare Snowflakes[24] = object{Snowflake(2, 0.0, 0.03, 0)};	
#declare Snowflakes[25] = object{Snowflake(2, 0.3, 0.03, 0)};	
#declare Snowflakes[26] = object{Snowflake(2, 0.6, 0.03, 0)};	
#declare Snowflakes[27] = object{Snowflake(2, 1.0, 0.03, 0)};	
// variable size
#declare Snowflakes[28] = object{Snowflake(2, 0.0, 0.02, 0)};	
#declare Snowflakes[29] = object{Snowflake(2, 0.0, 0.04, 0)};	
#declare Snowflakes[30] = object{Snowflake(2, 0.0, 0.05, 0)};	
#declare Snowflakes[31] = object{Snowflake(2, 0.0, 0.06, 0)};	
// variable angle
#declare Snowflakes[32] = object{Snowflake(2, 0.0, 0.04, 15)};	
#declare Snowflakes[33] = object{Snowflake(2, 0.0, 0.04, 40)};	
#declare Snowflakes[34] = object{Snowflake(2, 0.0, 0.04, 60)};	
#declare Snowflakes[35] = object{Snowflake(2, 0.0, 0.04, 90)};	

//---------------------- wrinkles ---------------------
// variable turbulence
#declare Snowflakes[36] = object{Snowflake(3, 0.0, 0.05, 0)};	
#declare Snowflakes[37] = object{Snowflake(3, 0.3, 0.05, 0)};	
#declare Snowflakes[38] = object{Snowflake(3, 0.6, 0.05, 0)};	
#declare Snowflakes[39] = object{Snowflake(3, 1.0, 0.05, 0)};	
// variable size
#declare Snowflakes[40] = object{Snowflake(3, 0.0, 0.02, 0)};	
#declare Snowflakes[41] = object{Snowflake(3, 0.0, 0.03, 0)};	
#declare Snowflakes[42] = object{Snowflake(3, 0.0, 0.04, 0)};	
#declare Snowflakes[43] = object{Snowflake(3, 0.0, 0.06, 0)};	
// variable angle
#declare Snowflakes[44] = object{Snowflake(3, 0.0, 0.05, 15)};	
#declare Snowflakes[45] = object{Snowflake(3, 0.0, 0.05, 40)};	
#declare Snowflakes[46] = object{Snowflake(3, 0.0, 0.05, 60)};	
#declare Snowflakes[47] = object{Snowflake(3, 0.0, 0.05, 90)};	

//------------------------ wood -----------------------
// variable turbulence
#declare Snowflakes[48] = object{Snowflake(4, 0.25, 0.1, 0)};	
#declare Snowflakes[49] = object{Snowflake(4, 0.3, 0.1, 0)};	
#declare Snowflakes[50] = object{Snowflake(4, 0.4, 0.1, 0)};	
#declare Snowflakes[51] = object{Snowflake(4, 0.5, 0.1, 0)};	
// variable size
#declare Snowflakes[52] = object{Snowflake(4, 0.3, 0.1, 0)};	
#declare Snowflakes[53] = object{Snowflake(4, 0.3, 0.15, 0)};	
#declare Snowflakes[54] = object{Snowflake(4, 0.3, 0.2, 0)};	
#declare Snowflakes[55] = object{Snowflake(4, 0.3, 0.25, 0)};	
// variable angle
#declare Snowflakes[56] = object{Snowflake(4, 0.3, 0.1, 15)};	
#declare Snowflakes[57] = object{Snowflake(4, 0.3, 0.1, 40)};	
#declare Snowflakes[58] = object{Snowflake(4, 0.3, 0.1, 60)};	
#declare Snowflakes[59] = object{Snowflake(4, 0.3, 0.1, 90)};	

//------------------------ radial ----------------------
// variable turbulence
#declare Snowflakes[60] = object{Snowflake(5, 0.1, 0.02, 0)};	
#declare Snowflakes[61] = object{Snowflake(5, 0.3, 0.03, 0)};	
#declare Snowflakes[62] = object{Snowflake(5, 0.6, 0.04, 20)};	
#declare Snowflakes[63] = object{Snowflake(5, 1.0, 0.05, 50)};	
// variable size
#declare Snowflakes[64] = object{Snowflake(5, 0.3, 0.04, 0)};	
#declare Snowflakes[65] = object{Snowflake(5, 0.3, 0.05, 0)};	
#declare Snowflakes[66] = object{Snowflake(5, 0.3, 0.06, 0)};	
#declare Snowflakes[67] = object{Snowflake(5, 0.3, 0.08, 0)};	
// variable angle
#declare Snowflakes[68] = object{Snowflake(5, 0.3, 0.06, 15)};	
#declare Snowflakes[69] = object{Snowflake(5, 0.3, 0.06, 30)};	
#declare Snowflakes[70] = object{Snowflake(5, 0.3, 0.06, 60)};	
#declare Snowflakes[71] = object{Snowflake(5, 0.3, 0.06, 90)};	

//---------------------- gradient x ---------------------
// variable turbulence
#declare Snowflakes[72] = object{Snowflake(6, 0.7, 0.05, 0)};	
#declare Snowflakes[73] = object{Snowflake(6, 0.8, 0.05, 0)};	
#declare Snowflakes[74] = object{Snowflake(6, 0.9, 0.05, 0)};	
#declare Snowflakes[75] = object{Snowflake(6, 1.0, 0.05, 0)};	
// variable size
#declare Snowflakes[76] = object{Snowflake(6, 0.8, 0.04, 0)};	
#declare Snowflakes[77] = object{Snowflake(6, 0.8, 0.05, 0)};	
#declare Snowflakes[78] = object{Snowflake(6, 0.8, 0.06, 0)};	
#declare Snowflakes[79] = object{Snowflake(6, 0.8, 0.07, 0)};	
// variable angle
#declare Snowflakes[80] = object{Snowflake(6, 0.8, 0.06, 15)};	
#declare Snowflakes[81] = object{Snowflake(6, 0.8, 0.06, 30)};	
#declare Snowflakes[82] = object{Snowflake(6, 0.8, 0.06, 45)};	
#declare Snowflakes[83] = object{Snowflake(6, 0.8, 0.06, 120)};	

//---------------------- gradient y ---------------------
// variable turbulence
#declare Snowflakes[84] = object{Snowflake(7, 0.7, 0.06, 10)};	
#declare Snowflakes[85] = object{Snowflake(7, 0.8, 0.06, 20)};	
#declare Snowflakes[86] = object{Snowflake(7, 0.9, 0.06, 30)};	
#declare Snowflakes[87] = object{Snowflake(7, 1.0, 0.06, 40)};	
// variable size
#declare Snowflakes[88] = object{Snowflake(7, 1.0, 0.05, 0)};	
#declare Snowflakes[89] = object{Snowflake(7, 1.0, 0.06, 0)};	
#declare Snowflakes[90] = object{Snowflake(7, 1.0, 0.07, 0)};	
#declare Snowflakes[91] = object{Snowflake(7, 1.0, 0.08, 0)};	
// variable angle
#declare Snowflakes[92] = object{Snowflake(7, 0.8, 0.06, 15)};	
#declare Snowflakes[93] = object{Snowflake(7, 0.8, 0.06, 30)};	
#declare Snowflakes[94] = object{Snowflake(7, 0.8, 0.06, 45)};	
#declare Snowflakes[95] = object{Snowflake(7, 0.8, 0.06, 120)};	

//------------------------ marble -----------------------
// variable turbulence
#declare Snowflakes[96] = object{Snowflake(8, 0.7, 0.05, 10)};	
#declare Snowflakes[97] = object{Snowflake(8, 0.8, 0.05, 20)};	
#declare Snowflakes[98] = object{Snowflake(8, 0.9, 0.05, 30)};	
#declare Snowflakes[99] = object{Snowflake(8, 1.0, 0.05, 40)};	
// variable size
#declare Snowflakes[100] = object{Snowflake(8, 1.0, 0.05, 0)};	
#declare Snowflakes[101] = object{Snowflake(8, 1.0, 0.06, 0)};	
#declare Snowflakes[102] = object{Snowflake(8, 1.0, 0.07, 0)};	
#declare Snowflakes[103] = object{Snowflake(8, 1.0, 0.08, 0)};	
// variable angle
#declare Snowflakes[104] = object{Snowflake(8, 0.8, 0.06, 15)};	
#declare Snowflakes[105] = object{Snowflake(8, 0.8, 0.06, 45)};	
#declare Snowflakes[106] = object{Snowflake(8, 0.8, 0.06, 90)};	
#declare Snowflakes[107] = object{Snowflake(8, 0.8, 0.06, 120)};	

#macro RandomSnowflake(rseed) 
	#local lseed = seed(1000 + rseed);
	#local arraySize = dimension_size(Snowflakes, 1);
	object{Snowflakes[arraySize * rand(lseed)]}
#end
