// Fountain by Kevin W. Ellis 2000

#version unofficial MegaPov 0.5;

#declare SceneSeed=seed(28383);
#macro SceneRand()
  int(1000000*rand(SceneSeed))
#end
 
global_settings{
  max_trace_level 30
}

default {
  pigment {rgb <1,1,0.9>*1.3}
}

light_source {
  <10000000,10000000,-10000000>
  color rgb <1,1,0.97>

} 

camera {
  location <0,3,-3>
  look_at <0,1,0>
}

#declare SquareWaterSw=1;
#declare SquareTexSw=1;

#declare SquareFountainWaterMat=
material {
  texture {
    pigment {rgbf <0.97,0.98,0.99,0.99>}
    finish {
      ambient 0.0
      diffuse 0.65
      brilliance 3.16
      reflection_type 1
      reflection_max 0.312
      reflection_min 0.1
      reflection_falloff 2
      conserve_energy
    }
    normal {granite 0.5 scale 0.1}
  }
  interior {
    ior 1.33
    fade_distance 6
    fade_color rgb <0.95,0.99,0.97>
    fade_power 10002
  }
}

#declare SquareFountainMortarUnderTex=
texture {
  pigment {
    granite
    color_map {
      [0 rgb <0.8,0.8,0.6>]
      [0.5 rgb <0.9,0.9,0.8>]
      [1 rgb <1,1,0.7>]
    }
    scale 0.1
  }
  normal {
    granite 0.3
    scale 0.01
  }
  finish {
    diffuse 0.6
  }
}

#declare SquareFountainMortarMossTex=
texture {
  pigment {
    granite
    color_map {
      [0 rgb <0.8,0.8,0.6>]
      [0.5 rgb <0.9,0.9,0.8>]
      [1 rgb <1,1,0.7>]
    }
    scale 0.1
  }
  normal {
    granite 0.3
    scale 0.01
  }
  finish {
    diffuse 0.4
  }
}
texture {
  pigment {
    bozo
    color_map {
      [0 rgbf 1]
      [0.2 rgbf 1]
      [0.3 rgbf <0.8,0.8,0.8,0.8>]
      [0.5 rgbf<0.7,0.6,0.1,0.6>]
      [0.8 rgbf <0,0.4,0,0.3>]
      [0.9 rgbf <0.7,0.4,0,0.1>]
      [1 rgbf <0.7,0.4,0,0.05>]
    }
    turbulence 0.5
    lambda 3.6
    octaves 9
    omega 0.4    
    scale 0.03
  }
  normal {
    average
    normal_map {
      [1 bumps 1 scale 0.01]
      [1 granite 1 scale 0.05]
    }
  }
  finish {
    diffuse 0.5
    reflection 0.02
    specular 1
    roughness 0.006
  }
}

#declare SquareFountainMortarMat=
material {
  texture {
    cylindrical
    texture_map {
      [0 SquareFountainMortarUnderTex]
      [0.06 SquareFountainMortarUnderTex]
      [0.09 SquareFountainMortarMossTex]
      [1 SquareFountainMortarMossTex]
    }
    scale <1.61,1,1.61>
  }
}

#declare SquareFountainBrickUnderTex=
texture {
  pigment {
    granite
    color_map {
      [0 rgb <0.8,0.8,0.8>]
      [0.5 rgb <0.9,0.9,0.9>]
      [1 rgb <1,1,1>]
    }
    scale 0.1
  }
  normal {
    granite 0.3
    scale 0.01
  }
  finish {
    diffuse 0.6
    specular 0.1
    roughness 0.008
  }
}

#declare SquareFountainBrickMossTex=
texture {
  pigment {
    granite
    color_map {
      [0 rgb <0.8,0.8,0.8>]
      [0.5 rgb <0.9,0.9,0.9>]
      [1 rgb <1,1,1>]
    }
    scale 0.1
  }
  normal {
    granite 0.3
    scale 0.01
  }
  finish {
    diffuse 0.4
  }
}
texture {
  pigment {
    bozo
    color_map {
      [0 rgbf 1]
      [0.2 rgbf 1]
      [0.3 rgbf <0.8,0.8,0.8,0.8>]
      [0.5 rgbf<0.7,0.6,0.1,0.6>]
      [0.8 rgbf <0,0.4,0,0.3>]
      [0.9 rgbf <0.7,0.4,0,0.1>]
      [1 rgbf <0.7,0.4,0,0.05>]
    }
    turbulence 0.5
    lambda 3.6
    octaves 9
    omega 0.4    
    scale 0.03
  }
  normal {
    average
    normal_map {
      [1 bumps 1 scale 0.01]
      [1 granite 1 scale 0.05]
    }
  }
  finish {
    diffuse 0.5
    reflection 0.02
    specular 1
    roughness 0.006
  }
}

#declare SquareFountainBrickMat=
material {
  texture {
    cylindrical
    texture_map {
      [0 SquareFountainBrickUnderTex]
      [0.08 SquareFountainBrickUnderTex]
      [0.1 SquareFountainBrickMossTex]
      [1 SquareFountainBrickMossTex]
    }
    turbulence 0.02
    scale <1.61,1,1.61>
  }
}

#declare SquareFountainPlainTex=
texture {
  pigment {
    bozo
    color_map {
      [0 rgb <1,1,0.9>*1.1]
      [0.5 rgb <0.95,0.95,0.9>*1.1]
      [1 rgb <1,0.9,0.6>*1.1]
    }
    scale 0.01
  }
  normal {
    average
    normal_map {
      [1 bumps 0.5 scale 0.01]
      [0.75 granite 0.6 scale 0.02]
    }
  }
  finish {diffuse 0.6 specular 0.1 roughness 0.003}
}

#declare SquareFountainMossTex=
texture {
  pigment {
    bozo
    color_map {
      [0 rgb <1,1,0.9>*1.1]
      [0.5 rgb <0.95,0.95,0.9>*1.1]
      [1 rgb <1,0.9,0.6>*1.1]      
    }
    scale 0.01
  }
  normal {
    average
    normal_map {
      [1 bumps 0.5 scale 0.01]
      [0.75 granite 0.6 scale 0.02]
    }
  }
  finish {diffuse 0.5 specular 1 roughness 0.006 reflection 0.02}
}

texture {
  pigment {
    bozo
    color_map {
      [0 rgbf 1]
      [0.2 rgbf 1]
      [0.3 rgbf <0.8,0.8,0.8,0.8>]
      [0.5 rgbf<0.7,0.6,0.1,0.6>]
      [0.8 rgbf <0,0.4,0,0.3>]
      [0.9 rgbf <0.7,0.4,0,0.1>]
      [1 rgbf <0.7,0.4,0,0.05>]
    }
    turbulence 0.5
    lambda 3.6
    octaves 9
    omega 0.4    
    scale 0.03
  }
  normal {
    average
    normal_map {
      [1 bumps 1 scale 0.01]
      [1 granite 1 scale 0.05]
    }
  }
  finish {
    diffuse 0.5
    reflection 0.02
    specular 1
    roughness 0.006
  }
}

#declare SquareFountainNoiseFn=
function {
  pigment {
    granite
    color_map {
      [0 rgb 0.9]
      [1 rgb 0.1]
    }
  }
}

#macro Drips1(Seed) // Upper Drips
isosurface {
  #local R1=seed(Seed);
  #local X=1*rand(R1);
  #local Z=1*rand(R1);
  function {
    ((x)^2+(z)^2)
    +0.0023*noise3d((x+X)*40,y*20,(Z+z)*40)-0.0009
  }
  contained_by {
    box {
      <-0.05,0,-0.05>
      <0.05,1.05,0.05>
    }
  }
  translate <0.47,1.25,0>
}
#end

#macro Drips2(Seed) // Lower Drips
isosurface {
  #local R1=seed(Seed);
  #local X=1*rand(R1);
  #local Z=1*rand(R1);
  function {
    ((x)^2+(z)^2)
    +0.0023*noise3d((x+X)*40,y*20,(Z+z)*40)-0.0009
  }
  contained_by {
    box {
      <-0.05,0,-0.05>
      <0.05,1.05,0.05>
    }
  }
  translate <0.87,0.24,0>
}
#end

#macro SquareFountainFount()
union {
  #if(SquareWaterSw)
    merge {
      intersection { // Bottom Water
        isosurface {
          function {
            y
            +0.09*noise3d(4*x,0,4*y)
            +0.09*SquareFountainNoiseFn(4*x,y,4*z)-0.2
          }
          contained_by {
            box {
              <-1.5,-0.5,-1.5>
              <1.5,0.2,1.5>
            }
          }
        }
        cylinder {
          <0,-0.5,0>
          <0,0.3,0>
          1.455
        }
        scale <1/0.88889,1,1/0.88889>
        translate <0,0.3,0>
      }
      intersection { // Middle Water
        isosurface {
          function {
            y
            +0.02*noise3d(2*x,0,2*y)
            +0.06*SquareFountainNoiseFn(2*x,0,2*z)-0.1
          }
          contained_by {
            box {
              <-0.8,-0.4,-0.8>
              <0.8,0.2,0.8>
            }
          }
        }
        sphere {
          <0,0,0>
          0.8
          scale <1,0.5,1>
        }
        bounded_by {
          sphere {
            <0,0,0>
            0.78
            scale <1,0.5,1>
          }
        }
        translate <0,1.22,0>
      }
      intersection { // Top Water
        isosurface {
          function {
            y*(x*x+y*y+z*z-0.05)
            +0.04*noise3d(1*x,0,1*y)
            +0.12*SquareFountainNoiseFn(1*x,y,1*z)-0.1
          }
          contained_by {
            box {
              <-0.8,-0.4,-0.8>
              <0.8,0.8,0.8>
            }
          }
        }
        sphere {
          <0,0,0>
          0.78
          scale <1,0.5,1>
        }
        bounded_by {
          sphere {
            <0,0,0>
            0.78
            scale <1,0.5,1>
          }
        }
        scale 0.55
        translate <0,2.295,0>
      }
      isosurface { // Water Spurt
        function {
          x^2+z^2-0.09
          +0.15*noise3d(x*9,y*9,z*9)
        }
        contained_by {
          sphere {
            <0,0,0>
            0.5
          }
        }
        scale <0.4,0.85,0.4>
        translate <0,2.2,0>
      }
      #local i=360/40;
      #while(i<360)
        object {
          Drips1(SceneRand())
          rotate <0,i,0>
        }
        #local i=i+360/20;
      #end
      #local i=360/40;
      #while(i<360)
        object {
          Drips2(SceneRand())
          rotate <0,i,0>
        }
        #local i=i+360/20;
      #end
      #if(SquareTexSw) material {SquareFountainWaterMat} #end
    }
  #end  // Water
  union {  // Base Stand
    cylinder {
      <0,0.021,0>
      <0,0.45,0>
      0.3
    }
    #local i=0;
    #while (i<360)
      cylinder {
        <0,0.021,0>
        <0,0.45,0>
        0.05
        scale <1,1,0.5>
        translate <0,0,0.3>
        rotate <0,i,0>
      }
      #local i=i+360/20;
    #end
    difference {
      union {
        #local i=0;
        #while(i<360)
          torus {
            0.27,0.05
            rotate <90,0,0>
            rotate <0,i,0>
          }
          #local i=i+360/20;
        #end
        translate <0,0.451,0>
      }
      cylinder {
        <0,0.3,0>
        <0,0.451,0>
        0.4
      }
    }
    torus {
      0.2,0.05
      translate <0,0.65,0>
    }
    #if (SquareTexSw)
      texture {
        gradient y
        texture_map {
          [0 SquareFountainMossTex]
          [0.5 SquareFountainMossTex]
          [0.65 SquareFountainPlainTex]
          [1 SquareFountainPlainTex]
        }
      }              
    #end
  }   // End of Base Stand
  union {  // Middle Bowl
    difference {
      union {
        #local i=0;
        #while(i<360)
          torus {
            0.7,0.15
            rotate <90,0,0>
            rotate <0,i,0>
          }
          #local i=i+360/20;
        #end
        sphere {
          <0,0,0>
          0.7
        }
        scale <1,0.6,1>
        translate <0,1.25,0>
      }
      cylinder {
        <0,1.25,0>
        <0,2.2,0>
        1
      }
      sphere {
        <0,0,0>
        0.76
        scale <1,0.15,1>
        translate <0,1.25,0>
      }
    }
    difference {
      union {
        torus {
          0.78,0.02
          translate <0,1.25,0>
        }
        #local i=0;
        #while(i<360)
          sphere {
            <0,0,0>
            0.15
            scale <1,0.3,0.4>
            translate <0,1.25,0.86>
            rotate <0,i,0>
          }
          #local i=i+360/20;
        #end        
      }
      cylinder {
        <0,1.22,0>
        <0,-1,0>
        1
      }
    }
    #if(SquareTexSw)
      texture {
        spherical
        texture_map {
          [0 SquareFountainPlainTex]
          [0.16 SquareFountainPlainTex]
          [0.25 SquareFountainMossTex]
          [1 SquareFountainMossTex]
        }
        scale <1,0.8,1>
        translate <0,1.25,0>
      }
    #end
  } // MiddleBowl End
  union{  // fancy bit Holder-upper
    difference {
      cylinder {
        <0,1.1,0>
        <0,1.2,0>
        0.2
      }
      torus {
        0.2,0.05
        translate <0,1.2,0>
      }
    }
    difference {
      union {
        #local i=0;
        #while(i<360)
          torus {
            0.15,0.03
            rotate <90,0,0>
            rotate <0,i,0>
          }
          #local i=i+360/20;
        #end
        translate <0,1.2,0>
      }
      cylinder {
        <0,1,0>
        <0,1.2,0>
        0.5
      }
    }
    #if(SquareTexSw) texture {SquareFountainMossTex} #end
  } // fancybit Holderupper End
  union {   // fancy bit
    #local i=0;
    #while(i<360)
      union {
        cylinder {
          <-0.06,0,0>
          <0.06,0,0>
          0.1
        }
        torus {
          0.1-0.02,0.02
          rotate <0,0,90>
          translate <0.06,0,0>
        }
        torus {
          0.1-0.02,0.02
          rotate <0,0,90>
          translate <-0.06,0,0>
        }
        sphere {
          <0.06,0,0>
          0.02
        }
        sphere {
          <-0.06,0,0>
          0.02
        }
        box {
          <-0.06,-0.1,0>
          <0.06,0.1,0.25>
        }
        cylinder {
          <0.06,0.1-0.02,0>
          <0.06,0.1-0.02,0.25>
          0.02
        }
        cylinder {
          <-0.06,0.1-0.02,0>
          <-0.06,0.1-0.02,0.25>
          0.02
        }
        rotate <-60,0,0>
        translate <0,0,-0.15>
        rotate <0,i,0>
        scale 1.2
        translate <0,1.4,0>
      }
      #local i=i+360/5;
    #end
    #local i=0;
    #while(i<360)
      union {
        cylinder {
          <-0.06,0,0>
          <0.06,0,0>
          0.1
        }
        torus {
          0.1-0.02,0.02
          rotate <0,0,90>
          translate <0.06,0,0>
        }
        torus {
          0.1-0.02,0.02
          rotate <0,0,90>
          translate <-0.06,0,0>
        }
        sphere {
          <0.06,0,0>
          0.02
        }
        sphere {
          <-0.06,0,0>
          0.02
        }
        box {
          <-0.06,-0.1,0>
          <0.06,0.1,0.25>
        }
        cylinder {
          <0.06,0.1-0.02,0>
          <0.06,0.1-0.02,0.25>
          0.02
        }
        cylinder {
          <-0.06,0.1-0.02,0>
          <-0.06,0.1-0.02,0.25>
          0.02
        }
        rotate <-60,0,0>
        translate <0,0,-0.15>
        rotate <0,i+360/10,0>
        scale 1
        translate <0,1.8,0>
      }
      #local i=i+360/5;
    #end
    #if(SquareTexSw)
      texture {
        gradient y
        texture_map {
          [0 SquareFountainMossTex]
          [0.05 SquareFountainMossTex]
          [0.15 SquareFountainPlainTex]
          [0.65 SquareFountainPlainTex]
          [0.8 SquareFountainMossTex]
          [1 SquareFountainMossTex]
        }
        turbulence 0.6
        translate 1.4
      }
    #end
  }  // Fancy Bit end
  union {
    difference {
      union {
        #local i=0;
        #while(i<360)
          torus {
            0.7,0.15
            rotate <90,0,0>
            rotate <0,i,0>
          }
          #local i=i+360/20;
        #end
        sphere {
          <0,0,0>
          0.7
        }
        scale <1,0.6,1>
        translate <0,1.25,0>
      }
      cylinder {
        <0,1.25,0>
        <0,2.2,0>
        1
      }
      sphere {
        <0,0,0>
        0.76
        scale <1,0.15,1>
        translate <0,1.25,0>
      }
    }
    difference {
      union {
        torus {
          0.78,0.02
          translate <0,1.25,0>
        }
        #local i=0;
        #while(i<360)
          sphere {
            <0,0,0>
            0.15
            scale <1,0.3,0.4>
            translate <0,1.25,0.86>
            rotate <0,i,0>
          }
          #local i=i+360/20;
        #end        
      }
      cylinder {
        <0,1.22,0>
        <0,-1,0>
        1
      }
    }
    #if(SquareTexSw)
      texture {
        spherical
        texture_map {
          [0 SquareFountainPlainTex]
          [0.16 SquareFountainPlainTex]
          [0.25 SquareFountainMossTex]
          [1 SquareFountainMossTex]
        }
        scale <1,0.8,1>
        translate <0,1.25,0>
      }
    #end
    translate <0,-1,0>
    scale 0.55
    translate <0,2.15,0>
  }
  union {
    cylinder {
      <0,2,0>
      <0,2.25,0>
      0.14
    }
    #local i=0;
    #while (i<360)
      torus {
        0.14,0.02
        rotate <90,0,0>
        rotate <0,i,0>
        translate <0,2.25,0>
      }
      #local i=i+360/18;
    #end
    texture {SquareFountainMossTex}
  }
  scale 0.9
}
#end

#macro SquareFountain()
union {
  SquareFountainFount() 
  difference {
    cylinder {
      <0,0,0>
      <0,0.49,0>
      1.6
    }
    cylinder {
      <0,0.02,0>
      <0,0.5001,0>
      1.45
    }
    #if(SquareTexSw) material {SquareFountainMortarMat} #end
  }
  #local BrickNum=40;
  #local i=0;
  #local Width=(2*1.45*pi)/BrickNum;
  #while(i<360)
    box {
      <-Width/2+0.005,0.015,-0.015>
      <Width/2-0.005,0.155,0.15+0.015>
      translate <0,0,1.45>
      rotate <0,i,0>
      #if(SquareTexSw) material {SquareFountainBrickMat} #end
    }
    #local i=i+360/BrickNum;
  #end    
  #local i=360/(2*BrickNum);
  #local Width=(2*1.45*pi)/BrickNum;
  #while(i<360)
    box {
      <-Width/2+0.01,0.01,-0.015>
      <Width/2-0.01,0.16,0.15+0.015>
      translate <0,0.17,1.45>
      rotate <0,i,0>
      #if(SquareTexSw) material {SquareFountainBrickMat} #end
    }
    #local i=i+360/BrickNum;
  #end    
  #local i=0;
  #local Width=(2*1.45*pi)/BrickNum;
  #while(i<360)
    box {
      <-Width/2+0.01,0.01,-0.015>
      <Width/2-0.01,0.16,0.15+0.015>
      translate <0,0.34,1.45>
      rotate <0,i,0>
      #if(SquareTexSw) material {SquareFountainBrickMat} #end
    }
    #local i=i+360/BrickNum;
  #end    
}
#end  

object {SquareFountain()}

box {
  <-100,-1,-100>
  <100,0,100>
  pigment {rgb <1,0.95,0.9>*1.3}
}

sky_sphere {
  pigment {rgb <0.4,0.6,0.8>*0.7}
}