
#version 3.8;
#macro MACRO_GRAPH_1D(F_FUNC, S_XMIN, S_XMAX, S_YMIN, S_YMAX, S_SAMPLES)
  #local S_N = max(2, S_SAMPLES);
  box {<-1.25,-0.9,4.99>, <1.25,0.9,4.98> texture {pigment {rgb <1,1,1>}}}
  #local S_G = 5; #local S_i = 0; #while (S_i <= S_G)
    #local S_t = S_i/S_G;
    cylinder {<(-1.25), (-0.9 + 1.8*S_t), 4.97>, <(1.25), (-0.9 + 1.8*S_t), 4.97>, 0.003 texture {pigment {rgb <0.85,0.85,0.85>}}}
    cylinder {<(-1.25 + 2.5*S_t), (-0.9), 4.97>, <(-1.25 + 2.5*S_t), (0.9), 4.97>, 0.003 texture {pigment {rgb <0.85,0.85,0.85>}}}
    #local S_i = S_i + 1; #end
  #local S_k = 0; #local V_prev = <0,0,0>;
  #while (S_k < S_N)
    #local S_xt = S_XMIN + (S_XMAX-S_XMIN)*S_k/(S_N-1);
    #local S_yt = F_FUNC(S_xt);
    #local V_currT = <(-1.25) + 2.5*(S_xt-S_XMIN)/(S_XMAX-S_XMIN), (-0.9) + 1.8*(S_yt-S_YMIN)/(S_YMAX-S_YMIN), 4.96>;
    #if (S_k > 0) cylinder {V_prev, V_currT, 0.01 texture {pigment {rgb <0.2,0.2,0.2>}}} #end
    #local V_prev = V_currT; #local S_k = S_k + 1; #end
#end
#macro MACRO_HEATMAP_2D(F_FUNC2, S_XMIN, S_XMAX, S_YMIN, S_YMAX)
  box {<-1.25,-0.9,4.96>, <1.25,0.9,4.95> texture {pigment {function {F_FUNC2( S_XMIN + (x+1.25)/2.5*(S_XMAX-S_XMIN), S_YMIN + (y+0.9)/1.8*(S_YMAX-S_YMIN), 0)} color_map {[0 rgb <0.1,0.1,0.5>] [0.5 rgb <0.9,0.9,0.9>] [1 rgb <0.7,0.1,0.1>]}}}}
#end
// ***end of code***
