
# POV-Ray 3.8 Keyword Examples — Pack v4 (2D heatmaps + default INIs)

## New in v4
- **2D heatmaps for all function plots** (single-arg functions get a replicated y dimension; multi-arg functions like `atan2(y,x)` get true 2D heatmaps + a 1D slice).
- **Default render size** in generated `.ini` files: `Width=960` and `Height=540` (plus AA defaults), in both the **pre-pass** and the **single-run inline** index.

## Two ways to embed the keyword in output filenames
1. **Pre-pass generator** (automation/WRITE_INIS.pov):
   ```
   povray +Iautomation/WRITE_INIS.pov +KFI0 +KFF10 +KI0 +KF1 +KC +W1 +H1
   ```
   Then render each frame of `INDEX_Keywords.pov` with `+INIout_000n_NAME.ini`.

2. **Single-run with inline INI**: use `INDEX_SingleRun_WithInlineINI.pov` and animate:
   ```
   povray +IINDEX_SingleRun_WithInlineINI.pov +KFI0 +KFF10 +KI0 +KF1 +KC +FN
   ```
   The scene writes `inline_<frame>_<keyword>.ini` per frame (Width/Height included) and renders the chosen keyword.

## Notes
- Formatting: compact `keyword {next ...}`; no `color`, use `rgb` only.
- Default camera; checker floor + single light via `ZZ_KW_Tools.inc`.
- Function plots and heatmaps via `ZZ_GraphTools.inc`.

// This v4 pack focuses on functions + automation upgrades; primitives/patterns/modifiers/media/photons remain included from earlier packs for context. A full pass to include **every single keyword** from the official list is in progress and will ship as the next update with a master manifest.
