
#version 3.8;
#include "include/ZZ_KW_Tools.inc"
#ifndef(S_SCENE) #declare S_SCENE = "sphere"; #end
#declare A1D_LIST = array[11] {"sphere","height_field","turbulence_panel","open_compare","acos","media","photons","box","blob","superellipsoid","functions"};
#if (defined(clock)) #declare S_SCENE = A1D_LIST[int(clamp(clock,0,1)*(dimension_size(A1D_LIST,1)-1)+0.5)]; #end
#declare S_OUT = concat("inline_", str(frame_number,0,0), "_", S_SCENE, ".ini");
#fopen H S_OUT write
#write (H, "Output_File_Name=", S_SCENE, "_example\nWidth=960\nHeight=540\nAntialias=On\nSampling_Method=2\nOutput_Alpha=off\n")
#fclose H
MACRO_SCENE_PREAMBLE(concat("INDEX — ", S_SCENE))
#if (strcmp(S_SCENE,"sphere")=0)       sphere {<0,0,5>, 1 texture {T_DEFAULT}} #end
#if (strcmp(S_SCENE,"box")=0)          box {<-1,-1,4>, <1,1,6> texture {T_DEFAULT}} #end
#if (strcmp(S_SCENE,"height_field")=0) #declare F_H = function(u,v){ 0.5 + 0.5*sin(6.28318*u)*cos(6.28318*v) }; height_field {function 128,128 {F_H(x,y)} texture {T_DEFAULT} translate <-0.5,-1,4.5> scale <1,0.4,1>} MACRO_CAPTION("height_field (function variant)") #end
#if (strcmp(S_SCENE,"turbulence_panel")=0)
    #declare A1D_T = array[4] {0, 0.4, 0.8, 1.2};
    #declare A1D_O = array[4] {0, 2, 4, 8};
    #declare S_i = 0; #while (S_i < 4)
      #local V_P = <(S_i-1.5)*1.5, 0, 5>;
      box {<-0.6,-0.6,4.4>, <0.6,0.6,5.6> texture {pigment {granite turbulence A1D_T[S_i] octaves A1D_O[S_i] color_map {[0 rgb <0.2,0.2,0.6>] [1 rgb <0.8,0.2,0.2>]}} finish {diffuse 0.9}} translate V_P}
      #declare S_i = S_i + 1;
    #end
    MACRO_CAPTION("granite: turbulence/octaves")
#end
#if (strcmp(S_SCENE,"open_compare")=0) cone {<-1.0,-0.6,5>, 0.8, <-1.0,0.8,5>, 0 texture {T_DEFAULT}} cone {<1.0,-0.6,5>, 0.8, <1.0,0.8,5>, 0 open texture {T_DEFAULT}} MACRO_CAPTION("cone: closed vs open") #end
#if (strcmp(S_SCENE,"acos")=0) #include "functions/plots/acos.pov" #end
#if (strcmp(S_SCENE,"media")=0) light_source {<0,5,0> color rgb <1,1,1> spotlight point_at <0,0,5> radius 6 falloff 12 tightness 10} #declare O_BEAM = cylinder {<0,5,0>, <0,0,5>, 1.5 open hollow texture {pigment {rgbt <1,1,1,1>}} interior {media {scattering {1, rgb <0.7,0.8,1>} samples 8 method 3}}}; object {O_BEAM} sphere {<0,0,5>, 1 texture {T_CHROME}} MACRO_CAPTION("media: volumetric spotlight") #end
#if (strcmp(S_SCENE,"photons")=0) #declare O_GLASS = sphere {<0,0,5>, 1 texture {pigment {rgbt <1,1,1,0.9>} finish {conserve_energy specular 0.4}} interior {ior 1.5 caustics 1}}; light_source {<-20,40,-20> color rgb <1,1,1> photons {area_light}} global_settings {photons {spacing 0.06 gather 20,40 media 100}} object {O_GLASS photons {target reflection on refraction on}} MACRO_CAPTION("photons: glass caustics") #end
#if (strcmp(S_SCENE,"functions")=0) #include "functions/INDEX_Functions.pov" #end
// ***end of code***
