
# POV-Ray 3.8 Keyword Examples — Pack v3 (primitives+functions+prepass)

## What’s new
- **Primitives**: added `blob`, `superellipsoid`, plus additional `lathe` and `prism` variants.
- **Functions**: added a large set of function plots under `functions/plots/` and `functions/INDEX_Functions.pov`.
- **Pre-pass INI writer**: `automation/WRITE_INIS.pov` emits per-frame `.ini` files that set `Output_File_Name=<keyword>_example`.

## Pre-pass workflow to embed keyword in filenames
1. Generate per-frame INIs:
   - `povray +Iautomation/WRITE_INIS.pov +KFI0 +KFF10 +KI0 +KF1 +KC +W1 +H1`
   - This creates `out_0000_<name>.ini`, `out_0001_<name>.ini`, ... for each entry.
2. Render the index animation using those INIs (one run per frame):
   - For frame `n` with keyword `NAME`, run:
     - `povray +IINDEX_Keywords.pov +KFI0 +KFF10 +KI0 +KF1 +KC +FN +W800 +H600 +INIout_000n_NAME.ini`
   - The output will use `NAME_example_####.png` (POV-Ray appends frame numbers automatically). You can also set `+SF +EF` to restrict frames.

> Tip: You can script this loop in a batch/shell file to iterate frames and apply matching INIs.

## Style/Conventions
- No explicit camera. Compact spacing. `rgb` only. Defaults in `include/ZZ_KW_Tools.inc`.
- Captions via `MACRO_CAPTION*` macros. All files end with `// ***end of code***`.

## Extending
- Add more functions to `functions/plots/` by copying an existing file and changing `F_*` and the domain/range.
- Expand `INDEX_Keywords.pov` and `automation/WRITE_INIS.pov` arrays to include every keyword scene you add.
