
#version 3.8;
#include "include/ZZ_KW_Tools.inc"
#ifndef(S_SCENE) #declare S_SCENE = "sphere"; #end
#declare A1D_LIST = array[11] {"sphere","height_field","turbulence_panel","open_compare","acos","media","photons","box","blob","superellipsoid","functions"};
#if (defined(clock)) #declare S_SCENE = A1D_LIST[int(clamp(clock,0,1)*(dimension_size(A1D_LIST,1)-1)+0.5)]; #end
MACRO_SCENE_PREAMBLE(concat("INDEX — ", S_SCENE))
#if (strcmp(S_SCENE,"sphere")=0)       sphere {<0,0,5>, 1 texture {T_DEFAULT}} #end
#if (strcmp(S_SCENE,"box")=0)          box {<-1,-1,4>, <1,1,6> texture {T_DEFAULT}} #end
#if (strcmp(S_SCENE,"height_field")=0) #include "snippets/height_field_fn.inc" MACRO_CAPTION("height_field (function) — see primitives/height_field_variants for more") #end
#if (strcmp(S_SCENE,"turbulence_panel")=0) #include "snippets/turbulence_panel.inc" #end
#if (strcmp(S_SCENE,"open_compare")=0) #include "snippets/open_compare.inc" #end
#if (strcmp(S_SCENE,"acos")=0)         #include "snippets/acos_demo.inc" #end
#if (strcmp(S_SCENE,"media")=0)        #include "snippets/media_vol_spot.inc" #end
#if (strcmp(S_SCENE,"photons")=0)      #include "snippets/photons_demo.inc" #end
#if (strcmp(S_SCENE,"blob")=0)         blob {threshold 0.6 sphere {<-0.6,0,5>, 0.8, 1} sphere {<0.6,0,5>, 0.8, 1} texture {T_DEFAULT}} #end
#if (strcmp(S_SCENE,"superellipsoid")=0) superellipsoid {<0.4, 1.0> texture {T_DEFAULT} translate <0,0,5>} #end
#if (strcmp(S_SCENE,"functions")=0)    #include "functions/INDEX_Functions.pov" #end
// ***end of code***
